/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.UTF16ByteArraySource;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.json.JSONByteArrayParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONStringWriter;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.options.Options;
import io.github.wycst.wast.json.options.ReadOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONDefaultParser
extends JSONGeneral {
    public static Object parse(String json, ReadOption ... readOptions) {
        json.getClass();
        if (StringCoder) {
            byte code = UnsafeHelper.getStringCoder(json);
            if (code == 0) {
                byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
                return JSONByteArrayParser.parse(json, bytes, readOptions);
            }
            char[] chars = JSONDefaultParser.getChars(json);
            return JSONDefaultParser.parse((CharSource)UTF16ByteArraySource.of(json, chars), chars, null, readOptions);
        }
        return JSONDefaultParser.parse(JSONDefaultParser.getChars(json), readOptions);
    }

    public static Object parse(char[] buf, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(null, buf, null, readOptions);
    }

    public static Object parseBytes(byte[] bytes, ReadOption[] readOptions) {
        return JSONByteArrayParser.parse(bytes, readOptions);
    }

    static Map parseMap(String json, Class<? extends Map> mapCls, ReadOption ... readOptions) {
        json.getClass();
        if (StringCoder) {
            byte code = UnsafeHelper.getStringCoder(json);
            if (code == 0) {
                byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
                return (Map)JSONByteArrayParser.parse(json, bytes, JSONDefaultParser.createMapInstance(mapCls), readOptions);
            }
            char[] chars = JSONDefaultParser.getChars(json);
            return (Map)JSONDefaultParser.parse((CharSource)UTF16ByteArraySource.of(json, chars), chars, JSONDefaultParser.createMapInstance(mapCls), readOptions);
        }
        return (Map)JSONDefaultParser.parse(JSONDefaultParser.getChars(json), JSONDefaultParser.createMapInstance(mapCls), readOptions);
    }

    static Collection parseCollection(String json, Class<? extends Collection> listCls, ReadOption ... readOptions) {
        json.getClass();
        if (StringCoder) {
            byte code = UnsafeHelper.getStringCoder(json);
            if (code == 0) {
                byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
                return (Collection)JSONByteArrayParser.parse(json, bytes, JSONDefaultParser.createCollectionInstance(listCls), readOptions);
            }
            char[] chars = JSONDefaultParser.getChars(json);
            return (Collection)JSONDefaultParser.parse((CharSource)UTF16ByteArraySource.of(json, chars), chars, JSONDefaultParser.createCollectionInstance(listCls), readOptions);
        }
        return (Collection)JSONDefaultParser.parse(JSONDefaultParser.getChars(json), JSONDefaultParser.createCollectionInstance(listCls), readOptions);
    }

    static Object parse(char[] buf, Object defaultValue, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(null, buf, defaultValue, readOptions);
    }

    static Object parse(CharSource source, char[] buf, Object defaultValue, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(source, buf, 0, buf.length, defaultValue, readOptions);
    }

    static Object parse(CharSource source, char[] buf, int fromIndex, int toIndex, Object defaultValue, ReadOption ... readOptions) {
        char beginChar = '\u0000';
        while (fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' ') {
            ++fromIndex;
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        Options.readOptions(readOptions, jsonParseContext);
        try {
            Object result;
            boolean allowComment = jsonParseContext.isAllowComment();
            if (allowComment && beginChar == '/') {
                fromIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, fromIndex + 1, toIndex, jsonParseContext);
                beginChar = buf[fromIndex];
            }
            switch (beginChar) {
                case '{': {
                    result = JSONDefaultParser.parseJSONObject(source, buf, fromIndex, toIndex, defaultValue == null ? new LinkedHashMap() : (Map)defaultValue, jsonParseContext);
                    break;
                }
                case '[': {
                    result = JSONDefaultParser.parseJSONArray(source, buf, fromIndex, toIndex, defaultValue == null ? new ArrayList() : (Collection)defaultValue, jsonParseContext);
                    break;
                }
                case '\"': {
                    result = JSONDefaultParser.parseJSONString(source, buf, fromIndex, toIndex, beginChar, jsonParseContext);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginChar + "'");
                }
            }
            int endIndex = jsonParseContext.getEndIndex();
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, endIndex + 1, toIndex, jsonParseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, endIndex + 1);
                throw new JSONException("Syntax error, at pos " + endIndex + ", context text by '" + errorContextTextAt + "', extra characters found, '" + new String(buf, endIndex + 1, wordNum) + " ...'");
            }
            Object object = result;
            Object var14_16 = null;
            jsonParseContext.clear();
            return object;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof JSONException) {
                    throw (JSONException)ex;
                }
                if (ex instanceof IndexOutOfBoundsException) {
                    String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, toIndex);
                    throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.");
                }
                throw new JSONException("Error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                jsonParseContext.clear();
                throw throwable;
            }
        }
    }

    static Collection parseJSONArray(CharSource source, char[] buf, int fromIndex, int toIndex, Collection list, JSONParseContext jsonParseContext) throws Exception {
        int beginIndex;
        int i = beginIndex = fromIndex + 1;
        while (true) {
            block18: {
                char ch;
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (jsonParseContext.isAllowComment() && ch == '/') {
                    i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (list.size() > 0) {
                        throw new JSONException("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return list;
                }
                switch (ch) {
                    case '{': {
                        Object value = JSONDefaultParser.parseJSONObject(source, buf, i, toIndex, new LinkedHashMap(), jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case '[': {
                        Object value = JSONDefaultParser.parseJSONArray(source, buf, i, toIndex, new ArrayList(), jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        Object value = JSONDefaultParser.parseJSONString(source, buf, i, toIndex, ch, jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case 'n': {
                        Object value = JSONTypeDeserializer.NULL.deserialize(null, buf, i, toIndex, null, null, '\u0000', jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    case 't': {
                        Object value = JSONTypeDeserializer.BOOLEAN.deserializeTrue(buf, i, toIndex, null, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    case 'f': {
                        Object value = JSONTypeDeserializer.BOOLEAN.deserializeFalse(buf, i, toIndex, null, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    default: {
                        Object value = JSONTypeDeserializer.NUMBER.deserialize(source, buf, i, toIndex, jsonParseContext.isUseBigDecimalAsDefault() ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, ']', jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        char next = buf[++i];
                        if (next == ']') {
                            jsonParseContext.setEndIndex(i);
                            return list;
                        }
                        break block18;
                    }
                }
                while ((ch = buf[++i]) <= ' ') {
                }
                if (jsonParseContext.isAllowComment() && ch == '/') {
                    i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ',') {
                    if (ch == ']') {
                        jsonParseContext.setEndIndex(i);
                        return list;
                    }
                    String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or ']'");
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map parseJSONObject(CharSource source, char[] buf, int fromIndex, int toIndex, Map instance, JSONParseContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        boolean empty = true;
        boolean allowomment = jsonParseContext.isAllowComment();
        boolean disableCacheMapKey = jsonParseContext.isDisableCacheMapKey();
        int i = beginIndex;
        while (true) {
            block33: {
                String key;
                char ch;
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (allowomment && ch == '/') {
                    i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                int fieldKeyFrom = i;
                if (ch == '\"') {
                    key = disableCacheMapKey ? JSONDefaultParser.parseMapKey(buf, i, toIndex, '\"', jsonParseContext) : JSONDefaultParser.parseMapKeyByCache(buf, i, toIndex, '\"', jsonParseContext);
                    i = jsonParseContext.getEndIndex();
                    empty = false;
                    ++i;
                } else {
                    if (ch == '}') {
                        if (!empty) {
                            throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.setEndIndex(i);
                        return instance;
                    }
                    if (ch == '\'') {
                        if (!jsonParseContext.isAllowSingleQuotes()) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                        while (i + 1 < toIndex && (buf[++i] != '\'' || buf[i - 1] == '\\')) {
                        }
                        empty = false;
                        key = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                    } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        empty = false;
                        key = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                        if (key.equals("null")) {
                            key = null;
                        }
                    } else {
                        int j = i++;
                        boolean isNullKey = false;
                        key = null;
                        if (ch == 'n' && buf[i] == 'u' && buf[++i] == 'l' && buf[++i] == 'l') {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                        }
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowomment && ch == '/') {
                    i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ':') throw new JSONException("Syntax error, at pos " + i + ", unexpected token character '" + ch + "', Colon character ':' is expected.");
                while ((ch = buf[++i]) <= ' ') {
                }
                if (jsonParseContext.isAllowComment() && ch == '/') {
                    i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                switch (ch) {
                    case '{': {
                        Object value = JSONDefaultParser.parseJSONObject(source, buf, i, toIndex, new LinkedHashMap(), jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case '[': {
                        Object value = JSONDefaultParser.parseJSONArray(source, buf, i, toIndex, new ArrayList(), jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        Object value = JSONDefaultParser.parseJSONString(source, buf, i, toIndex, ch, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case 'n': {
                        Object value = JSONTypeDeserializer.NULL.deserialize(null, buf, i, toIndex, null, null, '\u0000', jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case 't': {
                        Object value = JSONTypeDeserializer.BOOLEAN.deserializeTrue(buf, i, toIndex, null, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case 'f': {
                        Object value = JSONTypeDeserializer.BOOLEAN.deserializeFalse(buf, i, toIndex, null, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    default: {
                        Object value = JSONTypeDeserializer.NUMBER.deserialize(source, buf, i, toIndex, jsonParseContext.isUseBigDecimalAsDefault() ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, '}', jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        char next = buf[++i];
                        if (next == '}') {
                            jsonParseContext.setEndIndex(i);
                            return instance;
                        }
                        break block33;
                    }
                }
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowomment && ch == '/') {
                    i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ',') {
                    if (ch == '}') {
                        jsonParseContext.setEndIndex(i);
                        return instance;
                    }
                    String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String parseJSONString(CharSource source, char[] buf, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        JSONStringWriter writer = null;
        if (source != null && JDK_9_ABOVE) {
            int endIndex = source.indexOf(endCh, beginIndex);
            source.setCharAt(endIndex, '\\');
            int escapeIndex = source.indexOf('\\', beginIndex);
            source.setCharAt(endIndex, endCh);
            if (escapeIndex == endIndex) {
                jsonParseContext.setEndIndex(endIndex);
                int len = endIndex - beginIndex;
                return len < 1024 ? new String(buf, beginIndex, len) : source.substring(beginIndex, endIndex);
            }
            writer = JSONDefaultParser.getContextWriter(jsonParseContext);
            char prev = buf[endIndex - 1];
            if (prev == '\\') {
                while ((prev = buf[(endIndex = source.indexOf(endCh, endIndex + 1)) - 1]) == '\\') {
                }
            }
            try {
                source.setCharAt(endIndex, '\\');
                while ((escapeIndex = source.indexOf('\\', beginIndex = JSONDefaultParser.escapeNext(buf, buf[escapeIndex + 1], escapeIndex, beginIndex, writer, jsonParseContext))) != endIndex) {
                }
                Object var12_15 = null;
                source.setCharAt(endIndex, endCh);
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                source.setCharAt(endIndex, endCh);
                throw throwable;
            }
            jsonParseContext.setEndIndex(endIndex);
            writer.writeString(source.input(), beginIndex, escapeIndex - beginIndex);
            return writer.toString();
        }
        char ch = '\u0000';
        char next = '\u0000';
        int i = beginIndex;
        boolean escape = false;
        while (true) {
            if ((ch = buf[i]) != '\\' && ch != endCh) {
                ++i;
                continue;
            }
            if (ch == '\\') {
                next = buf[i + 1];
                if (writer == null) {
                    writer = JSONDefaultParser.getContextWriter(jsonParseContext);
                    escape = true;
                }
            } else {
                jsonParseContext.setEndIndex(i);
                int len = i - beginIndex;
                if (escape) {
                    writer.write(buf, beginIndex, len);
                    return writer.toString();
                }
                return len == 0 ? "" : new String(buf, beginIndex, len);
            }
            beginIndex = JSONDefaultParser.escapeNext(buf, next, i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.getEndIndex();
            ++i;
        }
    }

    static String parseMapKey(char[] buf, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        char ch = '\u0000';
        char next = '\u0000';
        int i = beginIndex;
        JSONStringWriter writer = null;
        boolean escape = false;
        while (true) {
            if ((ch = buf[i]) != '\\' && ch != endCh) {
                ++i;
                continue;
            }
            if (ch == '\\') {
                next = buf[i + 1];
                if (writer == null) {
                    writer = JSONDefaultParser.getContextWriter(jsonParseContext);
                }
            } else {
                jsonParseContext.setEndIndex(i);
                int len = i - beginIndex;
                if (escape) {
                    writer.write(buf, beginIndex, len);
                    return writer.toString();
                }
                return len == 0 ? "" : new String(buf, beginIndex, len);
            }
            escape = true;
            beginIndex = JSONDefaultParser.escapeNext(buf, next, i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.getEndIndex();
            ++i;
        }
    }

    static String parseMapKeyByCache(char[] buf, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        char ch = '\u0000';
        char next = '\u0000';
        int i = beginIndex;
        JSONStringWriter writer = null;
        boolean escape = false;
        while (true) {
            int hashValue = 0;
            while ((ch = buf[i]) != '\\' && ch != endCh) {
                ++i;
                hashValue = hashValue * 31 + ch;
            }
            if (ch == '\\') {
                if (i < toIndex - 1) {
                    next = buf[i + 1];
                }
                if (writer == null) {
                    writer = JSONDefaultParser.getContextWriter(jsonParseContext);
                }
            } else {
                jsonParseContext.setEndIndex(i);
                int len = i - beginIndex;
                if (escape) {
                    writer.write(buf, beginIndex, len);
                    return writer.toString();
                }
                return len == 0 ? "" : jsonParseContext.getCacheKey(buf, beginIndex, len, hashValue);
            }
            escape = true;
            beginIndex = JSONDefaultParser.escapeNext(buf, next, i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.getEndIndex();
            ++i;
        }
    }

    static String parseKeyOfMap(char[] buf, int from, int to, boolean isUnquotedFieldName) {
        if (isUnquotedFieldName) {
            while (from < to && buf[from] <= ' ') {
                ++from;
            }
            while (to > from && buf[to - 1] <= ' ') {
                --to;
            }
            return new String(buf, from, to - from);
        }
        int len = to - from - 2;
        return new String(buf, from + 1, len);
    }
}

