/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.options.Options;
import io.github.wycst.wast.json.options.ReadOption;

public class JSONValidator
extends JSONGeneral {
    private char[] buf;
    private int fromIndex;
    private int toIndex;
    private int offset;
    private char current;
    private boolean result = true;
    private boolean showMessage;
    private String message;
    private JSONParseContext parseContext;

    public JSONValidator(String json) {
        this(JSONValidator.getChars(json));
    }

    public JSONValidator(char[] buf) {
        this.buf = buf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean validate(boolean showMessage, ReadOption ... readOptions) {
        JSONParseContext parseContext;
        block20: {
            boolean bl;
            block21: {
                boolean bl2;
                block19: {
                    if (this.buf == null || this.buf.length == 0) {
                        if (!this.showMessage) return false;
                        this.setValidateMessage("Empty json to validate ");
                        return false;
                    }
                    this.init();
                    parseContext = new JSONParseContext();
                    Options.readOptions(readOptions, parseContext);
                    this.parseContext = parseContext;
                    this.showMessage = showMessage;
                    try {
                        try {
                            boolean allowComment = parseContext.isAllowComment();
                            if (allowComment && this.current == '/') {
                                this.fromIndex = JSONValidator.clearCommentAndWhiteSpaces(this.buf, this.fromIndex + 1, this.toIndex, parseContext);
                                this.current = this.buf[this.fromIndex];
                            }
                            switch (this.current) {
                                case '{': {
                                    this.validateJSONObject(this.fromIndex);
                                    break;
                                }
                                case '[': {
                                    this.validateJSONArray(this.fromIndex);
                                    break;
                                }
                                case '\"': {
                                    this.validateJSONString(this.fromIndex, this.current);
                                    break;
                                }
                                default: {
                                    if (showMessage) {
                                        this.setValidateMessage("Unsupported for begin character with '" + this.current + "' pos 0 ");
                                    }
                                    boolean bl3 = false;
                                    Object var8_9 = null;
                                    parseContext.clear();
                                    return bl3;
                                }
                            }
                            if (!this.result) {
                                bl2 = false;
                                break block19;
                            }
                            if (allowComment && this.offset < this.toIndex - 1) {
                                int commentStart = 0;
                                while (this.offset + 1 < this.toIndex && (commentStart = this.buf[++this.offset]) <= 32) {
                                }
                                if (commentStart == 47) {
                                    this.offset = JSONValidator.clearCommentAndWhiteSpaces(this.buf, this.offset + 1, this.toIndex, parseContext);
                                }
                            }
                            if (this.offset == this.toIndex - 1) break block20;
                            int wordNum = Math.min(50, this.buf.length - this.offset - 1);
                            if (showMessage) {
                                this.setValidateMessage("Syntax error, at pos " + this.offset + " extra characters found, '" + new String(this.buf, this.offset + 1, wordNum) + " ...'");
                            }
                            bl = false;
                            break block21;
                        }
                        catch (Exception ex) {
                            if (!(ex instanceof JSONException)) throw new JSONException("Error: " + ex.getMessage(), ex);
                            throw (JSONException)ex;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        parseContext.clear();
                        throw throwable;
                    }
                }
                Object var8_10 = null;
                parseContext.clear();
                return bl2;
            }
            Object var8_11 = null;
            parseContext.clear();
            return bl;
        }
        Object var8_12 = null;
        parseContext.clear();
        return this.result;
    }

    public final boolean validate(ReadOption ... readOptions) {
        return this.validate(false, readOptions);
    }

    private void init() {
        this.fromIndex = 0;
        this.toIndex = this.buf.length;
        while (this.fromIndex < this.toIndex && (this.current = this.buf[this.fromIndex]) <= ' ') {
            ++this.fromIndex;
        }
        while (this.toIndex > this.fromIndex && this.buf[this.toIndex - 1] <= ' ') {
            --this.toIndex;
        }
        this.result = true;
        this.message = null;
    }

    private void validateJSONArray(int fromIndex) throws Exception {
        int beginIndex = fromIndex + 1;
        char ch = '\u0000';
        int size = 0;
        for (int i = beginIndex; i < this.toIndex; ++i) {
            boolean isEnd;
            while ((ch = this.buf[i]) <= ' ') {
                ++i;
            }
            if (ch == ']') {
                if (size > 0) {
                    this.result = false;
                    if (this.showMessage) {
                        this.setValidateMessage("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                    }
                    return;
                }
                this.offset = i;
                return;
            }
            ++size;
            this.validateValue(ch, i, ']');
            i = this.offset;
            if (!this.result) {
                return;
            }
            while ((ch = this.buf[++i]) <= ' ') {
            }
            boolean bl = isEnd = ch == ']';
            if (ch == ',' || isEnd) {
                if (!isEnd) continue;
                this.offset = i;
                return;
            }
            this.result = false;
            if (this.showMessage) {
                this.setValidateMessage("Syntax error, at pos " + i + ", unexpected token character '" + ch + "', expected ',' or ']'");
            }
            return;
        }
        this.result = false;
        if (this.showMessage) {
            this.setValidateMessage("Syntax error, cannot find closing symbol ']' matching '['");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateJSONObject(int fromIndex) throws Exception {
        int beginIndex = fromIndex + 1;
        boolean empty = true;
        int i = beginIndex;
        while (true) {
            block29: {
                char ch;
                block28: {
                    if (i >= this.toIndex) {
                        this.result = false;
                        this.message = "Syntax error, the closing symbol '}' is not found ";
                        return;
                    }
                    while ((ch = this.buf[i]) <= ' ') {
                        ++i;
                    }
                    int simpleToIndex = -1;
                    if (ch == '\"') {
                        while (i + 1 < this.toIndex && (this.buf[++i] != '\"' || this.buf[i - 1] == '\\')) {
                        }
                        if (ch != '\"') {
                            this.result = false;
                            if (this.showMessage) {
                                String errorContextTextAt = JSONValidator.createErrorContextText(this.buf, i);
                                this.setValidateMessage("Syntax error, util pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '\"' is not found ");
                            }
                            return;
                        }
                        empty = false;
                        ++i;
                    } else {
                        if (ch == '}') {
                            if (empty) {
                                this.offset = i;
                                return;
                            }
                            this.result = false;
                            if (this.showMessage) {
                                String errorContextTextAt = JSONValidator.createErrorContextText(this.buf, i);
                                this.setValidateMessage("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                            }
                            return;
                        }
                        if (ch == '\'') {
                            if (this.parseContext.isAllowSingleQuotes()) {
                                while (i + 1 < this.toIndex && this.buf[++i] != '\'') {
                                }
                                empty = false;
                                ++i;
                                break block28;
                            } else {
                                this.result = false;
                                if (this.showMessage) {
                                    String errorContextTextAt = JSONValidator.createErrorContextText(this.buf, i);
                                    this.setValidateMessage("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', the single quote symbol ' is not allowed here.");
                                }
                                return;
                            }
                        }
                        if (this.parseContext.isAllowUnquotedFieldNames()) {
                            while (i + 1 < this.toIndex && this.buf[++i] != ':') {
                            }
                            empty = false;
                        }
                    }
                }
                while ((ch = this.buf[i]) <= ' ') {
                    ++i;
                }
                if (ch == ':') {
                    boolean isClosingSymbol;
                    while ((ch = this.buf[++i]) <= ' ') {
                    }
                    this.validateValue(ch, i, '}');
                    i = this.offset;
                    if (!this.result) {
                        return;
                    }
                    while ((ch = this.buf[++i]) <= ' ') {
                    }
                    boolean bl = isClosingSymbol = ch == '}';
                    if (ch == ',' || isClosingSymbol) {
                        if (isClosingSymbol) {
                            this.offset = i;
                            return;
                        }
                        break block29;
                    } else {
                        this.result = false;
                        if (this.showMessage) {
                            String errorContextTextAt = JSONValidator.createErrorContextText(this.buf, i);
                            this.setValidateMessage("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
                        }
                        return;
                    }
                }
                this.result = false;
                if (this.showMessage) {
                    String errorContextTextAt = JSONValidator.createErrorContextText(this.buf, i);
                    this.setValidateMessage("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', Colon character ':' is expected.");
                }
                return;
            }
            ++i;
        }
    }

    private void validateValue(char ch, int i, char endChar) throws Exception {
        switch (ch) {
            case '{': {
                this.validateJSONObject(i);
                break;
            }
            case '[': {
                this.validateJSONArray(i);
                break;
            }
            case '\"': 
            case '\'': {
                this.validateJSONString(i, ch);
                break;
            }
            case 'n': {
                this.validateNULL(i);
                break;
            }
            case 't': {
                this.validateTrue(i);
                break;
            }
            case 'f': {
                this.validateFalse(i);
                break;
            }
            default: {
                this.validateNumber(i, '}');
            }
        }
    }

    private void validateJSONString(int from, char endCh) {
        int i;
        int beginIndex = from + 1;
        int ch = 0;
        int prev = 0;
        for (i = beginIndex; i < this.toIndex && (ch = this.buf[i]) != 34 || prev == 92; ++i) {
            prev = ch;
        }
        this.offset = i;
        if (i == this.toIndex) {
            this.result = false;
            if (this.showMessage) {
                this.setValidateMessage("Syntax error, the closing symbol '" + endCh + "' is not found ");
            }
        }
    }

    private void validateNULL(int fromIndex) {
        int beginIndex = fromIndex + 1;
        if (fromIndex + 3 < this.toIndex && this.buf[beginIndex++] == 'u' && this.buf[beginIndex++] == 'l' && this.buf[beginIndex] == 'l') {
            this.offset = beginIndex;
            return;
        }
        this.result = false;
        if (this.showMessage) {
            int len = Math.min(4, this.toIndex - fromIndex);
            this.setValidateMessage("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(this.buf, fromIndex, len) + "'");
        }
    }

    private void validateTrue(int fromIndex) {
        int beginIndex = fromIndex + 1;
        if (fromIndex + 3 < this.toIndex && this.buf[beginIndex++] == 'r' && this.buf[beginIndex++] == 'u' && this.buf[beginIndex] == 'e') {
            this.offset = beginIndex;
            return;
        }
        this.result = false;
        if (this.showMessage) {
            int len = Math.min(4, this.toIndex - fromIndex);
            this.setValidateMessage("Syntax error, at pos " + fromIndex + ", expected 'true' because it starts with 't', but found text '" + new String(this.buf, fromIndex, len) + "'");
        }
    }

    private void validateFalse(int fromIndex) {
        int beginIndex = fromIndex + 1;
        if (fromIndex + 4 < this.toIndex && this.buf[beginIndex++] == 'a' && this.buf[beginIndex++] == 'l' && this.buf[beginIndex++] == 's' && this.buf[beginIndex] == 'e') {
            this.offset = beginIndex;
            return;
        }
        this.result = false;
        if (this.showMessage) {
            int len = Math.min(4, this.toIndex - fromIndex);
            this.setValidateMessage("Syntax error, at pos " + fromIndex + ", expected 'false' because it starts with 'f', but found text '" + new String(this.buf, fromIndex, len) + "'");
        }
    }

    private void validateNumber(int fromIndex, char endChar) throws Exception {
        block2: {
            try {
                JSONTypeDeserializer.NUMBER.deserializeDefault(this.buf, fromIndex, this.toIndex, endChar, this.parseContext);
                this.offset = this.parseContext.getEndIndex();
            }
            catch (Throwable throwable) {
                this.result = false;
                if (!this.showMessage) break block2;
                this.setValidateMessage(throwable.getMessage());
            }
        }
    }

    void setValidateMessage(String text) {
        this.result = false;
        this.message = text;
    }

    public String getValidateMessage() {
        return this.message;
    }
}

