/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.options;

import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.options.JsonConfig;
import io.github.wycst.wast.json.options.ReadOption;
import io.github.wycst.wast.json.options.WriteOption;
import io.github.wycst.wast.json.util.FixedNameValueMap;
import java.util.Arrays;
import java.util.HashSet;

public class Options {
    public static final String writeFormatOutSymbol = "\n\t\t\t\t\t\t\t\t\t\t";
    private static FixedNameValueMap<String> keyValueMap = new FixedNameValueMap(4096);
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalKeys(String ... keys) {
        Object object = lock;
        synchronized (object) {
            HashSet<String> keySet = new HashSet<String>(Arrays.asList(keys));
            for (String key : keySet) {
                if (key == null || key.trim().length() == 0) continue;
                keyValueMap.putValue(key, key);
            }
        }
    }

    public static void setGlobalKeys(String ... keys) {
        Options.clearGlobalKeys();
        Options.addGlobalKeys(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearGlobalKeys() {
        Object object = lock;
        synchronized (object) {
            keyValueMap.reset();
        }
    }

    static String getCacheKey(char[] buf, int offset, int len, int hashCode) {
        String value = keyValueMap.getValue(buf, offset, offset + len, hashCode);
        if (value == null) {
            value = new String(buf, offset, len);
            keyValueMap.putValue(value, value);
        }
        return value;
    }

    static String getCacheKey(byte[] bytes, int offset, int len, int hashCode) {
        String value = keyValueMap.getValue(bytes, offset, offset + len, hashCode);
        if (value == null) {
            value = new String(bytes, offset, len);
            keyValueMap.putValue(value, value);
        }
        return value;
    }

    private static void setWriteOption(WriteOption option, JsonConfig jsonConfig) {
        if (jsonConfig != null) {
            switch (option) {
                case FormatOut: {
                    jsonConfig.setFormatOut(true);
                    break;
                }
                case FullProperty: {
                    jsonConfig.setFullProperty(true);
                    break;
                }
                case DateFormat: {
                    jsonConfig.setDateFormat(true);
                    jsonConfig.setDateFormatPattern("yyyy-MM-dd HH:mm:ss");
                    break;
                }
                case WriteDateAsTime: {
                    jsonConfig.setWriteDateAsTime(true);
                    break;
                }
                case WriteEnumAsOrdinal: {
                    jsonConfig.setWriteEnumAsOrdinal(true);
                    break;
                }
                case SkipCircularReference: {
                    jsonConfig.setSkipCircularReference(true);
                    break;
                }
                case BytesArrayToNative: {
                    jsonConfig.setBytesArrayToNative(true);
                    break;
                }
                case DisableEscapeValidate: {
                    jsonConfig.setDisableEscapeValidate(true);
                    break;
                }
                case BytesArrayToHex: {
                    jsonConfig.setBytesArrayToHex(true);
                    break;
                }
                case SkipGetterOfNoneField: {
                    jsonConfig.setSkipGetterOfNoneField(true);
                    break;
                }
                case KeepOpenStream: {
                    jsonConfig.setAutoCloseStream(false);
                    break;
                }
                case AllowUnquotedMapKey: {
                    jsonConfig.setAllowUnquotedMapKey(true);
                    break;
                }
                case UseFields: {
                    jsonConfig.setUseFields(true);
                    break;
                }
                case CamelCaseToUnderline: {
                    jsonConfig.setCamelCaseToUnderline(true);
                }
            }
        }
    }

    private static void setParseContextOption(ReadOption option, JSONParseContext parseContext) {
        if (parseContext != null) {
            switch (option) {
                case ByteArrayFromHexString: {
                    parseContext.setByteArrayFromHexString(true);
                    break;
                }
                case DisableEscapeValidate: {
                    parseContext.setDisableEscapeMode(true);
                    break;
                }
                case UnknownEnumAsNull: {
                    parseContext.setUnknownEnumAsNull(true);
                    break;
                }
                case AllowSingleQuotes: {
                    parseContext.setAllowSingleQuotes(true);
                    break;
                }
                case AllowUnquotedFieldNames: {
                    parseContext.setAllowUnquotedFieldNames(true);
                    break;
                }
                case AllowComment: {
                    parseContext.setAllowComment(true);
                    break;
                }
                case UseDefaultFieldInstance: {
                    parseContext.setUseDefaultFieldInstance(true);
                    break;
                }
                case UseBigDecimalAsDefaultNumber: {
                    parseContext.setUseBigDecimalAsDefault(true);
                    break;
                }
                case UseNativeDoubleParser: {
                    parseContext.setUseNativeDoubleParser(true);
                    break;
                }
                case DisableCacheMapKey: {
                    parseContext.setDisableCacheMapKey(true);
                }
            }
        }
    }

    public static void writeOptions(WriteOption[] options, JsonConfig jsonConfig) {
        if (options == null) {
            return;
        }
        for (WriteOption option : options) {
            Options.setWriteOption(option, jsonConfig);
        }
    }

    public static void readOptions(ReadOption[] options, JSONParseContext parseContext) {
        if (options == null) {
            return;
        }
        for (ReadOption option : options) {
            Options.setParseContextOption(option, parseContext);
        }
    }
}

