/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.options.JsonConfig;
import io.github.wycst.wast.json.reflect.ObjectStructureWrapper;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;
import java.io.IOException;
import java.io.Writer;

public class TemporalZonedDateTimeSerializer
extends JSONTemporalSerializer {
    public TemporalZonedDateTimeSerializer(ObjectStructureWrapper objectStructureWrapper, JsonProperty property) {
        super(objectStructureWrapper, property);
    }

    protected void checkClass(ObjectStructureWrapper objectStructureWrapper) {
        Class<?> sourceClass = objectStructureWrapper.getSourceClass();
        if (sourceClass != TemporalAloneInvoker.zonedDateTimeClass) {
            throw new UnsupportedOperationException("Not Support for class temporal type " + sourceClass);
        }
    }

    protected void writeTemporalWithTemplate(Object value, Writer writer, JsonConfig jsonConfig) throws Exception {
        int year = TemporalAloneInvoker.invokeZonedDateTimeYear(value).intValue();
        int month = TemporalAloneInvoker.invokeZonedDateTimeMonth(value).intValue();
        int day = TemporalAloneInvoker.invokeZonedDateTimeDay(value).intValue();
        int hour = TemporalAloneInvoker.invokeZonedDateTimeHour(value).intValue();
        int minute = TemporalAloneInvoker.invokeZonedDateTimeMinute(value).intValue();
        int second = TemporalAloneInvoker.invokeZonedDateTimeSecond(value).intValue();
        int nano = TemporalAloneInvoker.invokeZonedDateTimeNano(value).intValue();
        int millisecond = nano / 1000000;
        writer.append('\"');
        this.dateFormatter.formatTo(year, month, day, hour, minute, second, millisecond, writer);
        String zoneId = TemporalAloneInvoker.invokeZonedDateTimeZone(value).toString();
        this.writeZoneId(writer, zoneId);
        writer.append('\"');
    }

    private void writeZoneId(Writer writer, String zoneId) throws IOException {
        if (zoneId.length() > 0) {
            char c = zoneId.charAt(0);
            if (c == '+' || c == '-' || c == 'Z') {
                writer.write(zoneId);
            } else {
                writer.write(91);
                writer.write(zoneId);
                writer.write(93);
            }
        }
    }

    protected void writeDefault(Object value, Writer writer, JsonConfig jsonConfig, int indent) throws Exception {
        int year = TemporalAloneInvoker.invokeZonedDateTimeYear(value).intValue();
        int month = TemporalAloneInvoker.invokeZonedDateTimeMonth(value).intValue();
        int day = TemporalAloneInvoker.invokeZonedDateTimeDay(value).intValue();
        int hour = TemporalAloneInvoker.invokeZonedDateTimeHour(value).intValue();
        int minute = TemporalAloneInvoker.invokeZonedDateTimeMinute(value).intValue();
        int second = TemporalAloneInvoker.invokeZonedDateTimeSecond(value).intValue();
        int nano = TemporalAloneInvoker.invokeZonedDateTimeNano(value).intValue();
        writer.append('\"');
        this.writeYYYY_MM_dd_T_HH_mm_ss_SSS(writer, year, month, day, hour, minute, second, nano / 1000000);
        String zoneId = TemporalAloneInvoker.invokeZonedDateTimeZone(value).toString();
        this.writeZoneId(writer, zoneId);
        writer.append('\"');
    }
}

