/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.yaml;

import io.github.wycst.wast.yaml.YamlGeneral;
import io.github.wycst.wast.yaml.YamlParseException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class YamlJSON
extends YamlGeneral {
    public static final String stringify(Object obj) {
        StringBuilder builder = new StringBuilder();
        YamlJSON.writeObjectTo(builder, obj);
        return builder.toString();
    }

    private static void writeObjectTo(StringBuilder builder, Object obj) {
        if (obj instanceof Map) {
            YamlJSON.writeMapTo(builder, (Map)obj);
        } else if (obj instanceof List) {
            YamlJSON.writeListTo(builder, (List)obj);
        } else {
            builder.append(obj);
        }
    }

    private static void writeMapTo(StringBuilder builder, Map obj) {
        builder.append("{");
        int size = obj.size();
        int i = 0;
        for (Object key : obj.keySet()) {
            builder.append(key);
            builder.append(":");
            Object value = obj.get(key);
            YamlJSON.writeObjectTo(builder, value);
            if (++i >= size) continue;
            builder.append(",");
        }
        builder.append("}");
    }

    private static void writeListTo(StringBuilder builder, List list) {
        builder.append("[");
        int size = list.size();
        int i = 0;
        for (Object value : list) {
            YamlJSON.writeObjectTo(builder, value);
            if (++i >= size) continue;
            builder.append(",");
        }
        builder.append("]");
    }

    public static final Object parse(String json) {
        Object result;
        if (json == null) {
            return null;
        }
        json = json.trim();
        char[] buf = YamlJSON.getChars(json);
        int fromIndex = 0;
        int toIndex = buf.length;
        char beginChar = buf[0];
        AtomicInteger endIndexHolder = new AtomicInteger();
        switch (beginChar) {
            case '{': {
                result = YamlJSON.parseJSONObject(fromIndex, toIndex, buf, endIndexHolder);
                break;
            }
            case '[': {
                result = YamlJSON.parseJSONArray(fromIndex, toIndex, buf, endIndexHolder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported for begin character with '" + beginChar + "'");
            }
        }
        int endIndex = endIndexHolder.get();
        if (endIndex != toIndex - 1) {
            int wordNum = Math.min(100, buf.length - endIndex - 1);
            throw new YamlParseException("Syntax error, extra characters found, '" + new String(buf, endIndex + 1, wordNum) + "', at col " + endIndex);
        }
        return result;
    }

    private static List parseJSONArray(int fromIndex, int toIndex, char[] buf, AtomicInteger endIndexHolder) {
        ArrayList<Object> list = new ArrayList<Object>();
        int beginIndex = fromIndex + 1;
        char ch = '\u0000';
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isEnd;
            while (i < toIndex && (ch = buf[i]) <= ' ') {
                ++i;
            }
            int simpleFromIndex = i;
            int simpleToIndex = -1;
            if (ch == ']') {
                if (list.size() > 0) {
                    throw new YamlParseException("Syntax error, not allowed ',' followed by ']', pos " + i);
                }
                endIndexHolder.set(i);
                return list;
            }
            boolean isSimpleElement = false;
            Object value = null;
            if (ch == '{') {
                value = YamlJSON.parseJSONObject(i, toIndex, buf, endIndexHolder);
                list.add(value);
                i = endIndexHolder.get();
            } else if (ch == '[') {
                value = YamlJSON.parseJSONArray(i, toIndex, buf, endIndexHolder);
                list.add(value);
                i = endIndexHolder.get();
            } else if (ch == '\"' || ch == '\'') {
                value = YamlJSON.parseJSONString(i, toIndex, buf, ch, endIndexHolder);
                list.add(value);
                i = endIndexHolder.get();
            } else {
                isSimpleElement = true;
                while (i + 1 < toIndex && (ch = buf[i + 1]) != ',' && ch != ']') {
                    ++i;
                }
            }
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (simpleToIndex == -1) {
                simpleToIndex = i;
            }
            boolean bl = isEnd = ch == ']';
            if (ch == ',' || isEnd) {
                if (isSimpleElement) {
                    Serializable simpleValue = (Serializable)YamlJSON.parseSimpleValue(simpleFromIndex, simpleToIndex, buf, endIndexHolder);
                    list.add(simpleValue);
                }
                if (!isEnd) continue;
                endIndexHolder.set(i);
                return list;
            }
            throw new YamlParseException("Syntax error, unexpected token character '" + ch + "', position " + i + ", Missing ',' or ']'");
        }
        throw new YamlParseException("Syntax error, the closing symbol ']' is not found ");
    }

    private static Map parseJSONObject(int fromIndex, int toIndex, char[] buf, AtomicInteger endIndexHolder) {
        LinkedHashMap<String, Object> instance = new LinkedHashMap<String, Object>();
        int beginIndex = fromIndex + 1;
        char ch = '\u0000';
        String key = null;
        boolean empty = true;
        for (int i = beginIndex; i < toIndex; ++i) {
            while (i < toIndex && (ch = buf[i]) <= ' ') {
                ++i;
            }
            int fieldKeyFrom = i;
            int simpleToIndex = -1;
            if (ch == '\"') {
                while (i + 1 < toIndex && buf[++i] != '\"') {
                }
                empty = false;
                ++i;
            } else {
                if (ch == '}') {
                    if (!empty) {
                        throw new YamlParseException("Syntax error, the closing symbol '}' is not allowed at pos " + i);
                    }
                    endIndexHolder.set(i);
                    return instance;
                }
                if (ch == '\'') {
                    while (i + 1 < toIndex && buf[++i] != '\'') {
                    }
                    empty = false;
                    ++i;
                } else {
                    while (i + 1 < toIndex && (ch = buf[++i]) != ':' && ch != ',' && ch != '}') {
                    }
                    empty = false;
                    if (ch == ',' || ch == '}') {
                        key = new String(buf, fieldKeyFrom, i - fieldKeyFrom).trim();
                        instance.put(key, null);
                        if (ch != '}') continue;
                        endIndexHolder.set(i);
                        return instance;
                    }
                }
            }
            while (i < toIndex && (ch = buf[i]) <= ' ') {
                ++i;
            }
            int fieldKeyTo = i;
            if (ch == ':') {
                boolean isClosingSymbol;
                key = YamlJSON.parseFieldKey(fieldKeyFrom, fieldKeyTo, buf);
                while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
                }
                int splitIndex = i - 1;
                boolean isSimpleValue = false;
                Object value = null;
                if (ch == '{') {
                    value = YamlJSON.parseJSONObject(i, toIndex, buf, endIndexHolder);
                    i = endIndexHolder.get();
                    instance.put(key, value);
                } else if (ch == '[') {
                    value = YamlJSON.parseJSONArray(i, toIndex, buf, endIndexHolder);
                    i = endIndexHolder.get();
                    instance.put(key, value);
                } else if (ch == '\"' || ch == '\'') {
                    value = YamlJSON.parseJSONString(i, toIndex, buf, ch, endIndexHolder);
                    i = endIndexHolder.get();
                    instance.put(key, value);
                } else {
                    isSimpleValue = true;
                    while (i + 1 < toIndex && (ch = buf[i + 1]) != ',' && ch != '}') {
                        ++i;
                    }
                }
                while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
                }
                if (simpleToIndex == -1) {
                    simpleToIndex = i;
                }
                boolean bl = isClosingSymbol = ch == '}';
                if (ch == ',' || isClosingSymbol) {
                    if (isSimpleValue) {
                        value = YamlJSON.parseSimpleValue(splitIndex + 1, simpleToIndex, buf, endIndexHolder);
                        instance.put(key, value);
                    }
                    if (!isClosingSymbol) continue;
                    endIndexHolder.set(i);
                    return instance;
                }
                throw new YamlParseException("Syntax error, unexpected token character '" + ch + "', position " + i);
            }
            throw new YamlParseException("Syntax error, unexpected token character '" + ch + "', position " + i);
        }
        throw new YamlParseException("Syntax error, the closing symbol '}' is not found ");
    }

    private static String parseJSONString(int from, int toIndex, char[] buf, char endCh, AtomicInteger endIndexHolder) {
        int beginIndex = from + 1;
        char ch = '\u0000';
        char next = '\u0000';
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = beginIndex; i < toIndex; ++i) {
            int len;
            while (i < toIndex && (ch = buf[i]) != '\\' && ch != endCh) {
                ++i;
            }
            if (ch == '\\') {
                if (i < toIndex - 1) {
                    next = buf[i + 1];
                }
                switch (next) {
                    case '\"': {
                        len = i - beginIndex;
                        stringBuilder.append(buf, beginIndex, len + 1);
                        stringBuilder.setCharAt(stringBuilder.length() - 1, '\"');
                        beginIndex = ++i + 1;
                        break;
                    }
                    case 'n': {
                        len = i - beginIndex;
                        stringBuilder.append(buf, beginIndex, len + 1);
                        stringBuilder.setCharAt(stringBuilder.length() - 1, '\n');
                        beginIndex = ++i + 1;
                        break;
                    }
                    case 'r': {
                        len = i - beginIndex;
                        stringBuilder.append(buf, beginIndex, len + 1);
                        stringBuilder.setCharAt(stringBuilder.length() - 1, '\r');
                        beginIndex = ++i + 1;
                        break;
                    }
                    case 't': {
                        len = i - beginIndex;
                        stringBuilder.append(buf, beginIndex, len + 1);
                        stringBuilder.setCharAt(stringBuilder.length() - 1, '\t');
                        beginIndex = ++i + 1;
                        break;
                    }
                    case 'b': {
                        len = i - beginIndex;
                        stringBuilder.append(buf, beginIndex, len + 1);
                        stringBuilder.setCharAt(stringBuilder.length() - 1, '\b');
                        beginIndex = ++i + 1;
                        break;
                    }
                    case 'f': {
                        len = i - beginIndex;
                        stringBuilder.append(buf, beginIndex, len + 1);
                        stringBuilder.setCharAt(stringBuilder.length() - 1, '\f');
                        beginIndex = ++i + 1;
                        break;
                    }
                    case 'u': {
                        len = i - beginIndex;
                        stringBuilder.append(buf, beginIndex, len + 1);
                        int c = Integer.parseInt(new String(buf, i + 2, 4), 16);
                        stringBuilder.setCharAt(stringBuilder.length() - 1, (char)c);
                        i += 4;
                        beginIndex = ++i + 1;
                        break;
                    }
                    default: {
                        len = i - beginIndex;
                        stringBuilder.append(buf, beginIndex, len + 1);
                        stringBuilder.setCharAt(stringBuilder.length() - 1, next);
                        beginIndex = ++i + 1;
                        break;
                    }
                }
                continue;
            }
            endIndexHolder.set(i);
            len = i - beginIndex;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(buf, beginIndex, len);
                return stringBuilder.toString();
            }
            return len == 0 ? "" : new String(buf, beginIndex, len);
        }
        throw new YamlParseException("Syntax error, the closing symbol '" + endCh + "' is not found ");
    }

    private static Object parseSimpleValue(int fromIndex, int toIndex, char[] buf, AtomicInteger endIndexHolder) {
        char beginChar = '\u0000';
        char endChar = '\u0000';
        while (fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' ') {
            ++fromIndex;
        }
        while (toIndex > fromIndex && (endChar = buf[toIndex - 1]) <= ' ') {
            --toIndex;
        }
        int len = toIndex - fromIndex;
        if (len == 4 && beginChar == 't' && buf[fromIndex + 1] == 'r' && buf[fromIndex + 2] == 'u' && endChar == 'e') {
            return true;
        }
        if (len == 5 && beginChar == 'f' && buf[fromIndex + 1] == 'a' && buf[fromIndex + 2] == 'l' && buf[fromIndex + 3] == 's' && endChar == 'e') {
            return false;
        }
        if (len == 4 && beginChar == 'n' && buf[fromIndex + 1] == 'u' && buf[fromIndex + 2] == 'l' && endChar == 'l') {
            return null;
        }
        boolean existUnDigit = false;
        boolean existDot = false;
        int digitNum = 0;
        for (int i = 0; i < len; ++i) {
            char ch = buf[i + fromIndex];
            if (ch == '.') {
                existDot = true;
                continue;
            }
            if (i == 0 && ch == '-') continue;
            if (!Character.isDigit(ch)) {
                existUnDigit = true;
                continue;
            }
            ++digitNum;
        }
        String val = new String(buf, fromIndex, len);
        if (existUnDigit) {
            return val;
        }
        if (existDot) {
            return Double.parseDouble(val);
        }
        long num = Long.parseLong(val);
        return num >= Integer.MIN_VALUE && num <= Integer.MAX_VALUE ? (long)((int)num) : num;
    }

    private static String parseFieldKey(int from, int to, char[] buf) {
        int start = 34;
        while (from < to && (start = buf[from]) <= 32) {
            ++from;
        }
        int end = 34;
        while (to > from && (end = buf[to - 1]) <= 32) {
            --to;
        }
        if (start == 34 && end == 34 || start == 39 && end == 39) {
            int len = to - from - 2;
            return new String(buf, from + 1, len);
        }
        return new String(buf, from, to - from);
    }
}

