/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.yaml;

import io.github.wycst.wast.yaml.YamlGeneral;
import io.github.wycst.wast.yaml.YamlJSON;
import io.github.wycst.wast.yaml.YamlNode;
import io.github.wycst.wast.yaml.YamlParseException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class YamlParser
extends YamlGeneral {
    protected char[] source;
    private int pos;
    private int lineNum;
    private int rootIndent = -1;

    YamlParser() {
    }

    protected void parseYamlRoot(int i) {
    }

    protected void parseNodes(List<YamlNode> yamlNodes, int offset, int toIndex) {
        char prevCh = '\u0000';
        for (int i = offset; i < toIndex; ++i) {
            int lineIndex;
            char ch;
            int indent;
            Object typeOfValue;
            int valueType;
            int splitIndex;
            int j;
            boolean arrayToken;
            boolean textBlock;
            boolean leaf;
            boolean isEmpty;
            String referenceKey;
            String anchorKey;
            String value;
            String key;
            block71: {
                char append;
                block72: {
                    block73: {
                        boolean isAppendSpaceChar;
                        key = null;
                        value = null;
                        anchorKey = null;
                        referenceKey = null;
                        isEmpty = false;
                        leaf = false;
                        textBlock = false;
                        arrayToken = false;
                        j = i;
                        splitIndex = -1;
                        valueType = 0;
                        typeOfValue = null;
                        while (this.source[i] == ' ') {
                            ++i;
                        }
                        indent = i - j;
                        ch = this.source[i];
                        if (ch == '#') {
                            ++i;
                            while (!this.isNewLineChar(this.source[i])) {
                                ++i;
                            }
                            continue;
                        }
                        if (this.isNewLineChar(ch)) continue;
                        lineIndex = this.lineNum;
                        if (this.rootIndent == -1) {
                            this.rootIndent = indent;
                        } else if (indent < this.rootIndent) {
                            throw new YamlParseException("indent value " + indent + " error, cannot less then the root indent " + this.rootIndent + ", at lineNum " + (this.lineNum + 1));
                        }
                        if (ch != '-') break block71;
                        append = this.source[i + 1];
                        boolean bl = isAppendSpaceChar = append == ' ';
                        if (!isAppendSpaceChar && !this.isNewLineChar(append)) break block72;
                        arrayToken = true;
                        j = ++i;
                        while (isAppendSpaceChar) {
                            while ((ch = this.source[++j]) == ' ') {
                            }
                            if (ch != '-') break;
                            append = this.source[j + 1];
                            boolean bl2 = isAppendSpaceChar = append == ' ';
                            if (!isAppendSpaceChar && !this.isNewLineChar(append)) break;
                            this.addYamlNode(yamlNodes, indent, lineIndex, null, null, valueType, null, false, false, true, anchorKey, referenceKey);
                            indent += j - i + 1;
                            i = ++j;
                        }
                        int n = j - i;
                        j = i;
                        prevCh = '\u0000';
                        while (!this.isNewLineChar(ch = this.source[j])) {
                            if (ch != ' ' || prevCh != ':') {
                                prevCh = ch;
                                ++j;
                                continue;
                            }
                            splitIndex = j;
                            break;
                        }
                        if (splitIndex <= -1) break block73;
                        key = new String(this.source, i, j - i - 1).trim();
                        if (key.length() == 0) {
                            throw new UnsupportedOperationException("empty key before ': ' at line " + ++this.lineNum);
                        }
                        this.addYamlNode(yamlNodes, indent, lineIndex, null, null, valueType, null, false, false, true, anchorKey, referenceKey);
                        indent += n + 1;
                        arrayToken = false;
                        i = j;
                        break block71;
                    }
                    if (ch != 10) break block71;
                    --this.lineNum;
                    break block71;
                }
                if (append == '-' && this.source[i + 2] == '-') {
                    int k = i + 2;
                    while ((ch = this.source[++k]) == ' ') {
                    }
                    if (this.isNewLineChar(ch)) {
                        this.parseYamlRoot(k + 1);
                        break;
                    }
                }
            }
            j = i;
            boolean breakOutLoop = false;
            while (!this.isNewLineChar(ch = this.source[i])) {
                if (!arrayToken && splitIndex == -1) {
                    if (ch != ' ' || prevCh != ':') {
                        prevCh = ch;
                        ++i;
                        continue;
                    }
                    splitIndex = i;
                    key = new String(this.source, j, i - j - 1).trim();
                    if (key.length() == 0) {
                        throw new UnsupportedOperationException("empty key before ': ' at line " + ++this.lineNum);
                    }
                }
                while ((ch = this.source[++i]) == ' ') {
                }
                j = i;
                if (ch == '#') {
                    while (!this.isNewLineChar(this.source[i])) {
                        ++i;
                    }
                    value = null;
                    break;
                }
                if (ch == '\'' || ch == '\"') {
                    leaf = true;
                    valueType = 1;
                    char strChar = ch;
                    j = ++i;
                    prevCh = '\'';
                    boolean matchEndFlag = false;
                    while (!this.isNewLineChar(ch = this.source[i])) {
                        if (ch == strChar) {
                            matchEndFlag = true;
                            value = new String(this.source, j, i - j);
                            while ((ch = this.source[++i]) == ' ') {
                            }
                            if (ch == '#') {
                                ++i;
                                while (!this.isNewLineChar(this.source[i])) {
                                    ++i;
                                }
                                break;
                            }
                            if (this.isNewLineChar(ch)) break;
                            throw new RuntimeException("\u672a\u671f\u671b\u7684\u5b57\u7b26 '" + ch + "', lineNum " + this.lineNum);
                        }
                        ++i;
                    }
                    if (matchEndFlag) break;
                    throw new RuntimeException("\u672a\u627e\u5230\u7ed3\u675f\u5b57\u7b26 " + strChar + " , index " + i);
                }
                if (ch == '|' || ch == '>') {
                    char appendChar;
                    leaf = true;
                    valueType = 1;
                    boolean replaceAsSpace = ch == '>';
                    textBlock = true;
                    int blockType = 0;
                    if ((ch = this.source[++i]) == '+') {
                        blockType = 1;
                        ++i;
                    } else if (ch == '-') {
                        blockType = 2;
                        ++i;
                    }
                    char c = appendChar = replaceAsSpace ? (char)' ' : '\n';
                    while ((ch = this.source[i]) == ' ') {
                        ++i;
                    }
                    switch (ch) {
                        case '#': {
                            int n;
                            do {
                                n = ++i;
                                ++i;
                            } while (this.source[n] != '\n');
                            ++this.lineNum;
                            break;
                        }
                        case '\r': {
                            ++i;
                        }
                        case '\n': {
                            ++i;
                            ++this.lineNum;
                            break;
                        }
                        default: {
                            throw new RuntimeException("expected chomping or indentation indicators, but found " + ch + " in 'string', line " + (this.lineNum + 1) + ", column n:");
                        }
                    }
                    YamlNode blockYamlNode = this.addYamlNode(yamlNodes, indent, lineIndex, key, value, valueType, typeOfValue, leaf, textBlock, arrayToken, anchorKey, referenceKey);
                    StringBuilder blockValue = new StringBuilder();
                    int minTextIndent = indent;
                    j = i;
                    while (true) {
                        if (i >= toIndex) {
                            blockYamlNode.value = this.getBlockValue(blockValue, blockType, appendChar);
                            blockYamlNode.blockType = blockType;
                            breakOutLoop = true;
                            break;
                        }
                        ch = this.source[i];
                        if (ch != ' ' && !this.isNewLineChar(ch)) break;
                        ++i;
                        if (ch == 32) continue;
                        blockValue.append(appendChar);
                        j = i;
                    }
                    int textIndent = i - j;
                    if (textIndent <= minTextIndent) {
                        blockYamlNode.value = this.getBlockValue(blockValue, blockType, appendChar);
                        blockYamlNode.blockType = blockType;
                        i = j;
                        this.parseNodes(yamlNodes, i, toIndex);
                        breakOutLoop = true;
                        break;
                    }
                    int baseTextIndent = textIndent;
                    while (i < toIndex) {
                        ++i;
                        while (!this.isNewLineChar(ch = this.source[i])) {
                            ++i;
                        }
                        int off = j + baseTextIndent;
                        blockValue.append(this.source, off, i - off);
                        blockValue.append(appendChar);
                        if (ch == '\r') {
                            ++i;
                            ++this.lineNum;
                        }
                        if (i == toIndex - 1) {
                            blockYamlNode.value = this.getBlockValue(blockValue, blockType, appendChar);
                            blockYamlNode.blockType = blockType;
                            breakOutLoop = true;
                            break;
                        }
                        j = i + 1;
                        while ((ch = this.source[++i]) == ' ' || this.isNewLineChar(ch)) {
                            if (ch != ' ') {
                                blockValue.append(appendChar);
                                if (ch == '\r') {
                                    ++i;
                                    ++this.lineNum;
                                }
                                j = i + 1;
                            }
                            if (i != toIndex - 1) continue;
                            blockYamlNode.value = this.getBlockValue(blockValue, blockType, appendChar);
                            blockYamlNode.blockType = blockType;
                            breakOutLoop = true;
                            break;
                        }
                        if ((textIndent = i - j) <= minTextIndent) {
                            blockYamlNode.value = this.getBlockValue(blockValue, blockType, appendChar);
                            blockYamlNode.blockType = blockType;
                            i = j;
                            this.parseNodes(yamlNodes, i, toIndex);
                            breakOutLoop = true;
                            break;
                        }
                        if (textIndent >= baseTextIndent) continue;
                        throw new YamlParseException("indent error, lineNum " + this.lineNum);
                    }
                    if (!breakOutLoop) continue;
                    break;
                }
                if (ch == '&') {
                    if (anchorKey != null) continue;
                    char anchorAppend = this.source[i + 1];
                    if (anchorAppend == ' ' || this.isNewLineChar(anchorAppend)) {
                        throw new YamlParseException("anchor token '&' cannot be followed by ' ' and '\\n', line " + this.lineNum);
                    }
                    j = ++i;
                    while ((ch = this.source[++i]) != ' ' && !this.isNewLineChar(ch)) {
                    }
                    anchorKey = new String(this.source, j, i - j).trim();
                    continue;
                }
                if (ch == '*') {
                    char referenceAppend = this.source[i + 1];
                    if (referenceAppend == ' ' || this.isNewLineChar(referenceAppend)) {
                        throw new YamlParseException("reference token '*' cannot be followed by ' ' and '\\n', line " + this.lineNum);
                    }
                    j = ++i;
                    while ((ch = this.source[++i]) != ' ' && !this.isNewLineChar(ch)) {
                    }
                    referenceKey = new String(this.source, j, i - j).trim();
                    if (ch != 32) continue;
                    while ((ch = this.source[++i]) == ' ') {
                    }
                    if (ch != '#' && !this.isNewLineChar(ch)) {
                        throw new YamlParseException("reference token '*" + referenceKey + "' cannot be followed by any value character, line " + this.lineNum);
                    }
                    if (ch != 35) continue;
                    ++i;
                    while (!this.isNewLineChar(this.source[i])) {
                        ++i;
                    }
                    continue;
                }
                if (ch == '!') {
                    if (valueType != 0) continue;
                    char typeAppend = this.source[i + 1];
                    if (typeAppend != '!') {
                        valueType = 1;
                        continue;
                    }
                    ++i;
                    j = ++i;
                    while ((ch = this.source[++i]) != ' ' && !this.isNewLineChar(ch)) {
                    }
                    if (ch == ' ') {
                        String typeName = new String(this.source, j, i - j).trim();
                        if (typeValues.containsKey(typeName)) {
                            valueType = (Integer)typeValues.get(typeName);
                            continue;
                        }
                        throw new YamlParseException("Mandatory type '!!" + typeName + "' is not supported, line " + this.lineNum);
                    }
                    throw new YamlParseException("token '!!' must be followed by one type such as int, str, bool ...,  but empty, line " + this.lineNum);
                }
                boolean json = ch == '{' || ch == '[';
                char pv = '\u0000';
                int commentIndex = -1;
                while (!this.isNewLineChar(ch = this.source[i])) {
                    if (commentIndex == -1 && pv == ' ' && ch == '#') {
                        commentIndex = i;
                    }
                    ++i;
                    pv = ch;
                }
                value = new String(this.source, j, (commentIndex > -1 ? commentIndex : i) - j).trim();
                boolean bl = leaf = value.length() > 0;
                if (!json) break;
                try {
                    typeOfValue = YamlJSON.parse(value);
                    break;
                }
                catch (YamlParseException exception) {
                    String message = exception.getMessage();
                    message = message + ", at lineNum " + (this.lineNum + 1);
                    throw new YamlParseException(message, exception);
                }
            }
            if (breakOutLoop) break;
            if (!arrayToken && splitIndex == -1) {
                if (prevCh == ':') {
                    key = new String(this.source, j, i - j - 1).trim();
                    leaf = false;
                } else {
                    throw new YamlParseException("Separator ': ' not found in syntax, at line " + ++this.lineNum);
                }
            }
            if (isEmpty) continue;
            this.addYamlNode(yamlNodes, indent, lineIndex, key, value, valueType, typeOfValue, leaf, textBlock, arrayToken, anchorKey, referenceKey);
        }
    }

    private String getBlockValue(StringBuilder blockValue, int blockType, char target) {
        int len;
        int i;
        if (blockType == 1) {
            return blockValue.toString();
        }
        for (i = len = blockValue.length(); i > 0 && blockValue.charAt(i - 1) == target; --i) {
        }
        int newLen = blockType == 2 || i == len ? i : i + 1;
        blockValue.setLength(newLen);
        return blockValue.toString();
    }

    private YamlNode addYamlNode(List<YamlNode> yamlNodes, int indent, int lineNum, String key, String value, int valueType, Object typeOfValue, boolean leaf, boolean textBlock, boolean arrayToken, String anchorKey, String referenceKey) {
        YamlNode yamlNode = new YamlNode();
        yamlNode.indent = indent;
        yamlNode.lineNum = lineNum;
        yamlNode.textBlock = textBlock;
        yamlNode.key = key;
        yamlNode.value = value;
        yamlNode.valueType = valueType;
        yamlNode.typeOfValue = typeOfValue;
        yamlNode.leaf = leaf;
        yamlNode.arrayToken = arrayToken;
        yamlNode.anchorKey = anchorKey;
        yamlNode.referenceKey = referenceKey;
        yamlNodes.add(yamlNode);
        return yamlNode;
    }

    private boolean isNewLineChar(char ch) {
        if (ch == '\n') {
            ++this.lineNum;
            return true;
        }
        return ch == '\r';
    }
}

