/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.impl;

import io.github.wycst.wast.clients.http.definition.HttpClientConfig;
import io.github.wycst.wast.clients.http.definition.HttpClientException;
import io.github.wycst.wast.clients.http.definition.HttpClientMethod;
import io.github.wycst.wast.clients.http.definition.HttpClientRequest;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpClientRequestImpl
implements HttpClientRequest {
    private URL url;
    private String uri;
    private String host;
    private String userInfo;
    private String protocol;
    private int port;
    private String query;
    private boolean https;
    private final String method;
    private final HttpClientConfig httpClientConfig;
    private boolean useDefaultPort;

    public HttpClientRequestImpl(String spec) {
        this(spec, HttpClientMethod.GET);
    }

    public HttpClientRequestImpl(String spec, HttpClientMethod httpClientMethod) {
        this(spec, httpClientMethod, new HttpClientConfig());
    }

    public HttpClientRequestImpl(String spec, HttpClientMethod httpClientMethod, HttpClientConfig httpClientConfig) {
        this.method = String.valueOf((Object)httpClientMethod);
        this.parseUrlInfo(spec);
        if (httpClientConfig == null) {
            httpClientConfig = new HttpClientConfig();
        }
        this.httpClientConfig = httpClientConfig;
    }

    private void parseUrlInfo(String spec) {
        URL url = null;
        try {
            url = new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new HttpClientException("Invalid url [" + spec + "]", e);
        }
        this.protocol = url.getProtocol().toLowerCase();
        if ("https".indexOf(this.protocol) == -1) {
            throw new HttpClientException("Protocol not supported for [" + this.protocol + "]");
        }
        this.https = "https".endsWith(this.protocol);
        this.query = url.getQuery();
        this.uri = url.getFile();
        this.userInfo = url.getUserInfo();
        this.url = url;
        this.host = url.getHost();
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = url.getDefaultPort();
            this.useDefaultPort = true;
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public boolean isHttps() {
        return this.https;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public void addTextParameter(String name, String value) {
        this.httpClientConfig.addTextParameter(name, value);
    }

    @Override
    public void setHeader(String name, Serializable value) {
        this.httpClientConfig.setHeader(name, value);
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.httpClientConfig.setHeaders(headers);
    }

    @Override
    public void removeHeader(String name) {
        this.httpClientConfig.removeHeader(name);
    }

    @Override
    public boolean isUseDefaultPort() {
        return this.useDefaultPort;
    }
}

