/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.impl;

import io.github.wycst.wast.clients.http.definition.HttpClientResponse;
import io.github.wycst.wast.clients.http.impl.AbstractHttpClientResponse;
import io.github.wycst.wast.json.JSON;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientResponseImpl
extends AbstractHttpClientResponse {
    private String contentType;
    private Map<String, List<String>> headers;

    public HttpClientResponseImpl(int code, String reasonPhrase, InputStream is) {
        super(code, reasonPhrase, is, -1);
    }

    public HttpClientResponseImpl(int code, String reasonPhrase, InputStream is, int contentLength) {
        super(code, reasonPhrase, is, contentLength);
    }

    public HttpClientResponseImpl(int code, String reasonPhrase, byte[] content) {
        super(code, reasonPhrase, content);
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public <E> E getEntity(Class<E> entityCls) {
        byte[] content = this.content();
        if (content == null) {
            return null;
        }
        if (entityCls == HttpClientResponse.class) {
            return (E)this;
        }
        if (byte[].class.isAssignableFrom(entityCls)) {
            return (E)content;
        }
        if (InputStream.class.isAssignableFrom(entityCls)) {
            return (E)new ByteArrayInputStream(content);
        }
        String text = new String(content);
        if (entityCls == String.class) {
            return (E)text;
        }
        if ((text = text.trim()).startsWith("{") && text.endsWith("}")) {
            return JSON.parseObject(text, entityCls, new ReadOption[0]);
        }
        return null;
    }

    @Override
    public <E> List<E> getEntityList(Class<E> entityCls) {
        byte[] content = this.content();
        if (content == null) {
            return null;
        }
        String text = new String(content).trim();
        if (text.startsWith("[") && text.endsWith("]")) {
            return JSON.parseArray(text, entityCls, new ReadOption[0]);
        }
        return null;
    }

    @Override
    public void setHeaders(Map<String, List<String>> responseHeaders) {
        this.headers = responseHeaders;
    }

    @Override
    public String getHeader(String name) {
        List<String> headerValues = this.headers.get(name);
        return headerValues == null || headerValues.size() == 0 ? null : headerValues.get(0);
    }

    @Override
    public List<String> getHeaders(String name) {
        List<String> headerValues = this.headers.get(name);
        return headerValues;
    }

    @Override
    public Set<String> getHeaderNames() {
        Set<String> keys = this.headers.keySet();
        return keys;
    }

    public String toString() {
        return "Response : " + this.status() + " " + this.reasonPhrase() + " " + this.contentType;
    }
}

