/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.options;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortOptions {
    private boolean limitable;
    private long offset;
    private long count;
    private String order;
    private boolean alpha;
    private String storeKey;
    private String byKeyPattern;
    private List<String> getPatterns = new ArrayList<String>();

    public SortOptions limit(long offset, long count) {
        this.offset = offset;
        this.count = count;
        this.limitable = count > -1L;
        return this;
    }

    public SortOptions by(String pattern) {
        this.byKeyPattern = pattern;
        return this;
    }

    public SortOptions unby(String pattern) {
        this.byKeyPattern = null;
        return this;
    }

    public SortOptions get(String pattern) {
        this.getPatterns.add(pattern);
        return this;
    }

    public SortOptions remove(String pattern) {
        this.getPatterns.remove(pattern);
        return this;
    }

    public SortOptions asc() {
        this.order = "ASC";
        return this;
    }

    public SortOptions desc() {
        this.order = "DESC";
        return this;
    }

    public SortOptions alpha(boolean v) {
        this.alpha = v;
        return this;
    }

    public SortOptions store(String key) {
        this.storeKey = this.storeKey;
        return this;
    }

    public List<String> buildCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        if (this.byKeyPattern != null) {
            commands.add("BY");
            commands.add(this.byKeyPattern);
        }
        if (this.limitable) {
            commands.add("LIMIT");
            commands.add(String.valueOf(this.offset));
            commands.add(String.valueOf(this.count));
        }
        if (this.getPatterns.size() > 0) {
            for (String getPattern : this.getPatterns) {
                commands.add("GET");
                commands.add(getPattern);
            }
        }
        if (this.order != null) {
            commands.add(this.order);
        }
        if (this.alpha) {
            commands.add("ALPHA");
        }
        if (this.storeKey != null && this.storeKey.trim().length() > 0) {
            commands.add("STORE");
            commands.add("storeKey");
        }
        return commands;
    }
}

