/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.websocket;

import io.github.wycst.wast.clients.websocket.WebSocketException;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

abstract class AbstractWebSocketClient {
    private final Channel channel;
    private boolean closed;

    AbstractWebSocketClient(Channel channel) {
        this.channel = channel;
    }

    private void checkChannelIfClosed() {
        if (this.closed) {
            throw new WebSocketException("WebSocketClient is closed ");
        }
    }

    public void close(String resion) {
        this.checkChannelIfClosed();
        this.channel.writeAndFlush((Object)new CloseWebSocketFrame(1000, resion));
        try {
            this.channel.closeFuture().sync();
            this.closed = true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public void close() {
        this.checkChannelIfClosed();
        this.channel.writeAndFlush((Object)new CloseWebSocketFrame());
        try {
            this.channel.closeFuture().sync();
            this.closed = true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public ChannelFuture ping() {
        this.checkChannelIfClosed();
        PingWebSocketFrame frame = new PingWebSocketFrame(Unpooled.wrappedBuffer((byte[])new byte[]{8, 1, 8, 1}));
        return this.channel.writeAndFlush((Object)frame);
    }

    public ChannelFuture sendText(String text) {
        this.checkChannelIfClosed();
        TextWebSocketFrame frame = new TextWebSocketFrame(text);
        return this.channel.writeAndFlush((Object)frame);
    }

    public ChannelFuture sendBinary(byte[] data) {
        this.checkChannelIfClosed();
        BinaryWebSocketFrame binaryWebSocketFrame = new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])data));
        return this.channel.writeAndFlush((Object)binaryWebSocketFrame);
    }
}

