/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.websocket;

import io.github.wycst.wast.clients.websocket.WebSocketEvent;
import io.github.wycst.wast.clients.websocket.WebSocketEventHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private ChannelPromise handshakeFuture;
    private final WebSocketEventHandler eventHandler;

    public WebSocketClientHandler(WebSocketClientHandshaker handshaker, WebSocketEventHandler eventHandler) {
        this.handshaker = handshaker;
        this.eventHandler = eventHandler;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                this.handshakeFuture.setSuccess();
                this.eventHandler.onOpen(WebSocketEvent.openEvent());
            }
            catch (WebSocketHandshakeException e) {
                this.handshakeFuture.setFailure((Throwable)e);
                this.eventHandler.onError(WebSocketEvent.errorEvent(e));
            }
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            byte[] message = this.getBytes(frame);
            this.eventHandler.onMessage(WebSocketEvent.messageEvent(message, WebSocketEvent.WebSocketContentType.Text));
        } else if (frame instanceof BinaryWebSocketFrame) {
            byte[] message = this.getBytes(frame);
            this.eventHandler.onMessage(WebSocketEvent.messageEvent(message, WebSocketEvent.WebSocketContentType.Binary));
        } else if (frame instanceof PongWebSocketFrame) {
            this.eventHandler.onPong(WebSocketEvent.pongEvent());
        } else if (frame instanceof CloseWebSocketFrame) {
            ch.close();
            this.eventHandler.onClose(WebSocketEvent.closeEvent(((CloseWebSocketFrame)frame).reasonText()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
            this.eventHandler.onError(WebSocketEvent.errorEvent(cause));
        }
        ctx.close();
    }

    private byte[] getBytes(WebSocketFrame webSocketFrame) {
        ByteBuf byteBuf = webSocketFrame.content();
        if (byteBuf.hasArray()) {
            return byteBuf.array();
        }
        byte[] content = new byte[byteBuf.readableBytes()];
        byteBuf.getBytes(byteBuf.readerIndex(), content);
        return content;
    }
}

