/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.websocket;

public class WebSocketEvent {
    private final WebSocketEventType type;
    private byte[] message;
    private Throwable throwable;
    private String reason;
    private WebSocketContentType contentType = WebSocketContentType.Text;

    WebSocketEvent(WebSocketEventType type) {
        this.type = type;
    }

    static WebSocketEvent openEvent() {
        return new WebSocketEvent(WebSocketEventType.Open);
    }

    static WebSocketEvent messageEvent(byte[] message, WebSocketContentType contentType) {
        WebSocketEvent webSocketEvent = new WebSocketEvent(WebSocketEventType.Message);
        webSocketEvent.message = message;
        webSocketEvent.contentType = contentType;
        return webSocketEvent;
    }

    public String getText() {
        if (this.contentType == WebSocketContentType.Text) {
            return new String(this.message);
        }
        return null;
    }

    public byte[] getMessage() {
        return this.message;
    }

    static WebSocketEvent pongEvent() {
        WebSocketEvent webSocketEvent = new WebSocketEvent(WebSocketEventType.Pong);
        return webSocketEvent;
    }

    static WebSocketEvent closeEvent(String reason) {
        WebSocketEvent webSocketEvent = new WebSocketEvent(WebSocketEventType.Close);
        webSocketEvent.reason = reason;
        return webSocketEvent;
    }

    static WebSocketEvent errorEvent(Throwable throwable) {
        WebSocketEvent webSocketEvent = new WebSocketEvent(WebSocketEventType.Error);
        webSocketEvent.throwable = throwable;
        return webSocketEvent;
    }

    public WebSocketEventType getType() {
        return this.type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getReason() {
        return this.reason;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebSocketContentType {
        Text,
        Binary;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebSocketEventType {
        Open,
        Error,
        Message,
        Close,
        Pong;

    }
}

