/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.AbstractCharSource;
import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Arrays;

public final class AsciiStringSource
extends AbstractCharSource
implements CharSource {
    private final String input;
    private final byte[] bytes;

    AsciiStringSource(String input, byte[] bytes) {
        super(0, bytes.length);
        this.bytes = bytes;
        this.input = input;
    }

    public static AsciiStringSource of(String input) {
        byte coder = UnsafeHelper.getStringCoder(input);
        if (coder == 1) {
            throw new UnsupportedOperationException("only support LATIN1 input string.");
        }
        byte[] bytes = (byte[])UnsafeHelper.getStringValue(input);
        return new AsciiStringSource(input, bytes);
    }

    public char[] charArray() {
        throw new UnsupportedOperationException();
    }

    public byte[] byteArray() {
        return this.bytes;
    }

    public char charAt(int index) {
        return (char)(this.bytes[index] & 0xFF);
    }

    public String getString(int offset, int len) {
        return UnsafeHelper.getAsciiString(Arrays.copyOfRange(this.bytes, offset, offset + len));
    }

    public void writeTo(Writer writer, int offset, int len) throws IOException {
        writer.write(this.input, offset, len);
    }

    public void appendTo(StringBuffer stringBuffer, int offset, int len) {
        stringBuffer.append(this.input, offset, len);
    }

    public void appendTo(StringBuilder stringBuilder, int offset, int len) {
        stringBuilder.append(this.input, offset, len);
    }

    public void copy(int srcOff, char[] target, int tarOff, int len) {
        this.input.getChars(srcOff, srcOff + len, target, tarOff);
    }

    public BigDecimal ofBigDecimal(int fromIndex, int len) {
        return new BigDecimal(this.getString(fromIndex, len));
    }

    public int indexOf(char ch, int beginIndex) {
        return this.input.indexOf(ch, beginIndex);
    }

    public String substring(int beginIndex, int endIndex) {
        return UnsafeHelper.getAsciiString(Arrays.copyOfRange(this.bytes, beginIndex, endIndex));
    }

    public String input() {
        return this.input;
    }

    public String toString() {
        return this.input;
    }

    public void setCharAt(int endIndex, char c) {
        this.bytes[endIndex] = (byte)c;
    }
}

