/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.Date;
import io.github.wycst.wast.common.beans.DateTemplate;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DateFormatter {
    private DateTemplate dateTemplate;
    public static final DateFormatter YMDHMS_S_17 = new DateFormatterYMDHMS_S_17();
    public static final DateFormatter YMDHMS_14 = new DateFormatterYMDHMS_14();
    public static final DateFormatter YMD_8 = new DateFormatterYMD_8();
    public static final DateFormatter HMS_6 = new DateFormatterHMS_6();
    private static Map<String, DateFormatter> dateFormatterMap = new HashMap<String, DateFormatter>();

    public static DateFormatter of(String pattern) {
        if (pattern == null) {
            return null;
        }
        if (dateFormatterMap.containsKey(pattern)) {
            return dateFormatterMap.get(pattern);
        }
        DateFormatter dateFormatter = new DateFormatter();
        dateFormatter.dateTemplate = new DateTemplate(pattern);
        return dateFormatter;
    }

    public static DateFormatter of(char dateToken, char timeToken, char concat) {
        return new DateFormatterYMDHMS_19(dateToken, timeToken, concat);
    }

    public static DateFormatter of(char dateToken, char timeToken, char concat, boolean millis) {
        return new DateFormatterYMDHMS_S_23(new DateFormatterYMDHMS_19(dateToken, timeToken, concat));
    }

    public static DateFormatter ofDate(char dateToken) {
        return new DateFormatterYMD_10(dateToken);
    }

    public static DateFormatter ofTime(char timeToken) {
        return new DateFormatterHMS_8(timeToken);
    }

    public String format(Date date) {
        StringBuilder builder = new StringBuilder();
        this.dateTemplate.formatTo(date, builder);
        return builder.toString();
    }

    public String format(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        StringBuilder builder = new StringBuilder();
        this.dateTemplate.formatTo(year, month, dayOfMonth, hour, minute, second, 0, builder);
        return builder.toString();
    }

    public String format(int year, int month, int dayOfMonth, int hour, int minute, int second, int millisecond) {
        StringBuilder builder = new StringBuilder();
        this.dateTemplate.formatTo(year, month, dayOfMonth, hour, minute, second, millisecond, builder);
        return builder.toString();
    }

    public void formatTo(Date date, Appendable appendable) {
        this.dateTemplate.formatTo(date, appendable);
    }

    public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
        this.dateTemplate.formatTo(year, month, dayOfMonth, hour, minute, second, 0, appendable);
    }

    public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, int millisecond, Appendable appendable) {
        this.dateTemplate.formatTo(year, month, dayOfMonth, hour, minute, second, millisecond, appendable);
    }

    static {
        DateFormatter temp = DateFormatter.of('-', ':', ' ');
        dateFormatterMap.put("yyyy-MM-dd HH:mm:ss", temp);
        dateFormatterMap.put("Y-M-d H:m:s", temp);
        temp = DateFormatter.of('-', ':', 'T');
        dateFormatterMap.put("yyyy-MM-ddTHH:mm:ss", temp);
        dateFormatterMap.put("yyyy-MM-dd'T'HH:mm:ss", temp);
        temp = DateFormatter.of('/', ':', ' ');
        dateFormatterMap.put("yyyy/MM/dd HH:mm:ss", temp);
        dateFormatterMap.put("Y/M/d H:m:s", temp);
        temp = DateFormatter.of('/', ':', 'T');
        dateFormatterMap.put("yyyy/MM/ddTHH:mm:ss", temp);
        dateFormatterMap.put("yyyy/MM/dd'T'HH:mm:ss", temp);
        temp = DateFormatter.of('-', ':', ' ', true);
        dateFormatterMap.put("yyyy-MM-dd HH:mm:ss.S", temp);
        dateFormatterMap.put("yyyy-MM-dd HH:mm:ss.SSS", temp);
        temp = DateFormatter.of('-', ':', 'T', true);
        dateFormatterMap.put("yyyy-MM-ddTHH:mm:ss.S", temp);
        dateFormatterMap.put("yyyy-MM-ddTHH:mm:ss.SSS", temp);
        dateFormatterMap.put("yyyy-MM-dd'T'HH:mm:ss.S", temp);
        dateFormatterMap.put("yyyy-MM-dd'T'HH:mm:ss.SSS", temp);
        temp = DateFormatter.of('/', ':', ' ', true);
        dateFormatterMap.put("yyyy/MM/dd HH:mm:ss.S", temp);
        dateFormatterMap.put("yyyy/MM/dd HH:mm:ss.SSS", temp);
        temp = DateFormatter.of('/', ':', 'T', true);
        dateFormatterMap.put("yyyy/MM/ddTHH:mm:ss.S", temp);
        dateFormatterMap.put("yyyy/MM/ddTHH:mm:ss.SSS", temp);
        dateFormatterMap.put("yyyy/MM/dd'T'HH:mm:ss.S", temp);
        dateFormatterMap.put("yyyy/MM/dd'T'HH:mm:ss.SSS", temp);
        dateFormatterMap.put("yyyyMMddHHmmss", YMDHMS_14);
        dateFormatterMap.put("YMdHms", YMDHMS_14);
        dateFormatterMap.put("yyyyMMddHHmmssS", YMDHMS_S_17);
        dateFormatterMap.put("yyyyMMddHHmmssSSS", YMDHMS_S_17);
        dateFormatterMap.put("yyyyMMdd", YMD_8);
        dateFormatterMap.put("YMd", YMD_8);
        dateFormatterMap.put("HHmmss", HMS_6);
        dateFormatterMap.put("Hms", HMS_6);
        temp = DateFormatter.ofDate('-');
        dateFormatterMap.put("yyyy-MM-dd", temp);
        dateFormatterMap.put("Y-M-d", temp);
        temp = DateFormatter.ofDate('/');
        dateFormatterMap.put("yyyy/MM/dd", temp);
        dateFormatterMap.put("Y/M/d", temp);
        temp = DateFormatter.ofTime(':');
        dateFormatterMap.put("HH:mm:ss", temp);
        dateFormatterMap.put("H:m:s", temp);
        temp = DateFormatter.ofTime('/');
        dateFormatterMap.put("HH/mm/ss", temp);
        dateFormatterMap.put("H/m/s", temp);
    }

    static class DateFormatterHMS_8
    extends PatternedFormatter {
        public static final String DatePattern = "HH?mm?ss";
        private char timeToken;

        private DateFormatterHMS_8(char timeToken) {
            this.timeToken = timeToken;
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
            try {
                char[] DigitTens = DateTemplate.DigitTens;
                char[] DigitOnes = DateTemplate.DigitOnes;
                appendable.append(DigitTens[hour]);
                appendable.append(DigitOnes[hour]);
                appendable.append(this.timeToken);
                appendable.append(DigitTens[minute]);
                appendable.append(DigitOnes[minute]);
                appendable.append(this.timeToken);
                appendable.append(DigitTens[second]);
                appendable.append(DigitOnes[second]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    static class DateFormatterHMS_6
    extends PatternedFormatter {
        public static final String DatePattern = "HHmmss";

        DateFormatterHMS_6() {
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
            try {
                char[] DigitTens = DateTemplate.DigitTens;
                char[] DigitOnes = DateTemplate.DigitOnes;
                appendable.append(DigitTens[hour]);
                appendable.append(DigitOnes[hour]);
                appendable.append(DigitTens[minute]);
                appendable.append(DigitOnes[minute]);
                appendable.append(DigitTens[second]);
                appendable.append(DigitOnes[second]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    static class DateFormatterYMD_8
    extends PatternedFormatter {
        public static final String DatePattern = "yyyyMMdd";

        private DateFormatterYMD_8() {
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
            try {
                if (year < 0) {
                    appendable.append('-');
                    year = -year;
                }
                int y1 = year / 100;
                int y2 = year - y1 * 100;
                char[] DigitTens = DateTemplate.DigitTens;
                char[] DigitOnes = DateTemplate.DigitOnes;
                appendable.append(DigitTens[y1]);
                appendable.append(DigitOnes[y1]);
                appendable.append(DigitTens[y2]);
                appendable.append(DigitOnes[y2]);
                appendable.append(DigitTens[month]);
                appendable.append(DigitOnes[month]);
                appendable.append(DigitTens[dayOfMonth]);
                appendable.append(DigitOnes[dayOfMonth]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    static class DateFormatterYMD_10
    extends PatternedFormatter {
        public static final String DatePattern = "yyyy?MM?dd";
        private final char dateToken;

        private DateFormatterYMD_10(char dateToken) {
            this.dateToken = dateToken;
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
            try {
                if (year < 0) {
                    appendable.append('-');
                    year = -year;
                }
                int y1 = year / 100;
                int y2 = year - y1 * 100;
                char[] DigitTens = DateTemplate.DigitTens;
                char[] DigitOnes = DateTemplate.DigitOnes;
                appendable.append(DigitTens[y1]);
                appendable.append(DigitOnes[y1]);
                appendable.append(DigitTens[y2]);
                appendable.append(DigitOnes[y2]);
                appendable.append(this.dateToken);
                appendable.append(DigitTens[month]);
                appendable.append(DigitOnes[month]);
                appendable.append(this.dateToken);
                appendable.append(DigitTens[dayOfMonth]);
                appendable.append(DigitOnes[dayOfMonth]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    static class DateFormatterYMDHMS_S_17
    extends PatternedFormatter {
        public static final String DatePattern = "yyyyMMddHHmmssSSS";

        private DateFormatterYMDHMS_S_17() {
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, int millisecond, Appendable appendable) {
            try {
                if (year < 0) {
                    appendable.append('-');
                    year = -year;
                }
                int y1 = year / 100;
                int y2 = year - y1 * 100;
                char[] DigitTens = DateTemplate.DigitTens;
                char[] DigitOnes = DateTemplate.DigitOnes;
                appendable.append(DigitTens[y1]);
                appendable.append(DigitOnes[y1]);
                appendable.append(DigitTens[y2]);
                appendable.append(DigitOnes[y2]);
                appendable.append(DigitTens[month]);
                appendable.append(DigitOnes[month]);
                appendable.append(DigitTens[dayOfMonth]);
                appendable.append(DigitOnes[dayOfMonth]);
                appendable.append(DigitTens[hour]);
                appendable.append(DigitOnes[hour]);
                appendable.append(DigitTens[minute]);
                appendable.append(DigitOnes[minute]);
                appendable.append(DigitTens[second]);
                appendable.append(DigitOnes[second]);
                this.appendMillisecond(appendable, millisecond);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
            this.formatTo(year, month, dayOfMonth, hour, minute, second, 0, appendable);
        }
    }

    static class DateFormatterYMDHMS_14
    extends PatternedFormatter {
        public static final String DatePattern = "yyyyMMddHHmmss";

        private DateFormatterYMDHMS_14() {
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
            try {
                if (year < 0) {
                    appendable.append('-');
                    year = -year;
                }
                int y1 = year / 100;
                int y2 = year - y1 * 100;
                char[] DigitTens = DateTemplate.DigitTens;
                char[] DigitOnes = DateTemplate.DigitOnes;
                appendable.append(DigitTens[y1]);
                appendable.append(DigitOnes[y1]);
                appendable.append(DigitTens[y2]);
                appendable.append(DigitOnes[y2]);
                appendable.append(DigitTens[month]);
                appendable.append(DigitOnes[month]);
                appendable.append(DigitTens[dayOfMonth]);
                appendable.append(DigitOnes[dayOfMonth]);
                appendable.append(DigitTens[hour]);
                appendable.append(DigitOnes[hour]);
                appendable.append(DigitTens[minute]);
                appendable.append(DigitOnes[minute]);
                appendable.append(DigitTens[second]);
                appendable.append(DigitOnes[second]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    static class DateFormatterYMDHMS_S_23
    extends PatternedFormatter {
        public static final String DatePattern = "yyyy?MM?dd?HH?mm?ss.S+";
        private final DateFormatterYMDHMS_19 dateFormatterYMDHMS_19;

        private DateFormatterYMDHMS_S_23(DateFormatterYMDHMS_19 dateFormatterYMDHMS_19) {
            dateFormatterYMDHMS_19.getClass();
            this.dateFormatterYMDHMS_19 = dateFormatterYMDHMS_19;
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
            this.formatTo(year, month, dayOfMonth, hour, minute, second, 0, appendable);
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, int millisecond, Appendable appendable) {
            try {
                this.dateFormatterYMDHMS_19.formatTo(year, month, dayOfMonth, hour, minute, second, appendable);
                appendable.append('.');
                this.appendMillisecond(appendable, millisecond);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    static class DateFormatterYMDHMS_19
    extends PatternedFormatter {
        public static final String DatePattern = "yyyy?MM?dd?HH?mm?ss";
        private final char dateToken;
        private final char timeToken;
        private final char concat;

        private DateFormatterYMDHMS_19(char dateToken, char timeToken, char concat) {
            this.dateToken = dateToken;
            this.timeToken = timeToken;
            this.concat = concat;
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, Appendable appendable) {
            try {
                if (year < 0) {
                    appendable.append('-');
                    year = -year;
                }
                int y1 = year / 100;
                int y2 = year - y1 * 100;
                char[] DigitTens = DateTemplate.DigitTens;
                char[] DigitOnes = DateTemplate.DigitOnes;
                appendable.append(DigitTens[y1]);
                appendable.append(DigitOnes[y1]);
                appendable.append(DigitTens[y2]);
                appendable.append(DigitOnes[y2]);
                appendable.append(this.dateToken);
                appendable.append(DigitTens[month]);
                appendable.append(DigitOnes[month]);
                appendable.append(this.dateToken);
                appendable.append(DigitTens[dayOfMonth]);
                appendable.append(DigitOnes[dayOfMonth]);
                appendable.append(this.concat);
                appendable.append(DigitTens[hour]);
                appendable.append(DigitOnes[hour]);
                appendable.append(this.timeToken);
                appendable.append(DigitTens[minute]);
                appendable.append(DigitOnes[minute]);
                appendable.append(this.timeToken);
                appendable.append(DigitTens[second]);
                appendable.append(DigitOnes[second]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    static abstract class PatternedFormatter
    extends DateFormatter {
        PatternedFormatter() {
        }

        public String format(int year, int month, int dayOfMonth, int hour, int minute, int second) {
            StringBuilder appendable = new StringBuilder();
            this.formatTo(year, month, dayOfMonth, hour, minute, second, appendable);
            return appendable.toString();
        }

        public void formatTo(Date date, Appendable appendable) {
            this.formatTo(date.year, date.month, date.dayOfMonth, date.hourOfDay, date.minute, date.second, appendable);
        }

        public void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, int millisecond, Appendable appendable) {
            this.formatTo(year, month, dayOfMonth, hour, minute, second, appendable);
        }

        protected void appendMillisecond(Appendable appendable, int millisecond) throws IOException {
            char[] DigitTens = DateTemplate.DigitTens;
            char[] DigitOnes = DateTemplate.DigitOnes;
            char s1 = (char)(millisecond / 100 + 48);
            int v = millisecond % 100;
            appendable.append(s1);
            appendable.append(DigitTens[v]);
            appendable.append(DigitOnes[v]);
        }
    }
}

