/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.AbstractCharSource;
import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteOrder;

public final class UTF16ByteArraySource
extends AbstractCharSource
implements CharSource {
    private String input;
    private final byte[] bytes;
    private final char[] source;
    static final boolean LE;
    static final int HI_BYTE_SHIFT;
    static final int LO_BYTE_SHIFT;

    UTF16ByteArraySource(String input, char[] source, byte[] bytes) {
        super(0, source.length);
        this.input = input;
        this.bytes = bytes;
        this.source = source;
    }

    public static UTF16ByteArraySource of(String input, char[] source) {
        byte coder = UnsafeHelper.getStringCoder(input);
        if (coder == 0) {
            throw new UnsupportedOperationException("only support UTF16 input");
        }
        byte[] bytes = (byte[])UnsafeHelper.getStringValue(input);
        return new UTF16ByteArraySource(input, source, bytes);
    }

    public char[] charArray() {
        return this.source;
    }

    public byte[] byteArray() {
        return this.bytes;
    }

    public char charAt(int index) {
        return this.source[index];
    }

    public String getString(int offset, int len) {
        return this.input.substring(offset, offset + len);
    }

    public void writeTo(Writer writer, int offset, int len) throws IOException {
        writer.write(this.input, offset, len);
    }

    public void appendTo(StringBuffer stringBuffer, int offset, int len) {
        stringBuffer.append(this.input, offset, len);
    }

    public void appendTo(StringBuilder stringBuilder, int offset, int len) {
        stringBuilder.append(this.input, offset, len);
    }

    public void copy(int srcOff, char[] target, int tarOff, int len) {
        System.arraycopy(this.source, srcOff, target, tarOff, len);
    }

    public BigDecimal ofBigDecimal(int fromIndex, int len) {
        return new BigDecimal(this.source, fromIndex, len);
    }

    public int indexOf(char ch, int beginIndex) {
        return this.input.indexOf(ch, beginIndex);
    }

    public String substring(int beginIndex, int endIndex) {
        return this.input.substring(beginIndex, endIndex);
    }

    public String input() {
        return this.input;
    }

    public String toString() {
        return this.input;
    }

    public void setCharAt(int index, char c) {
        index <<= 1;
        this.bytes[index++] = (byte)(c >> HI_BYTE_SHIFT);
        this.bytes[index] = (byte)(c >> LO_BYTE_SHIFT);
    }

    static {
        boolean bl = LE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        if (LE) {
            HI_BYTE_SHIFT = 0;
            LO_BYTE_SHIFT = 8;
        } else {
            HI_BYTE_SHIFT = 8;
            LO_BYTE_SHIFT = 0;
        }
    }
}

