/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.beans.KeyValuePair;
import io.github.wycst.wast.common.compiler.MemoryClassLoader;
import io.github.wycst.wast.common.compiler.MemoryJavaFileManager;
import io.github.wycst.wast.common.compiler.MemoryJavaFileObject;
import io.github.wycst.wast.common.exceptions.ParserException;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.compile.CompilerEnvironment;
import io.github.wycst.wast.common.expression.compile.CompilerExprParser;
import io.github.wycst.wast.common.expression.compile.CompilerExpression;
import io.github.wycst.wast.common.expression.compile.CompilerExpressionCoder;
import io.github.wycst.wast.common.expression.functions.JavassistExprFunction;
import io.github.wycst.wast.common.expression.invoker.VariableInvoker;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompilerCodeUtils {
    private static final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private static final StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
    private static final AtomicLong ATOMIC_LONG = new AtomicLong(0L);
    private static final String PACKAGE_NAME = CompilerExpression.class.getPackage().getName();
    private static final String NativeJavaCodeTemplate = "package io.github.wycst.wast.common.expression.compile;\r\nimport io.github.wycst.wast.common.expression.ExprFunction;\r\nimport io.github.wycst.wast.common.expression.invoker.VariableInvoker;\r\npublic class ${className} extends CompilerExpression {\r\n\r\n\tpublic ${className}(CompilerEnvironment environment){\r\n\t\tsuper(environment);\r\n${initInvokes}\t}\r\n\r\n${declareInvokes}${registerFunctions}\r\n\tprotected Object invoke(Object context) {\r\n${assignmentObjectVariables}\t\treturn ${expressionCode};\r\n\t}\r\n\r\n\tprotected Object invoke(java.util.Map context) {\r\n${assignmentMapVariables}\t\treturn ${expressionCode};\r\n\t}\r\n\r\n}";
    private static final Map<Class, KeyValuePair<String, String>> primitiveValueMethods = new ConcurrentHashMap<Class, KeyValuePair<String, String>>();

    CompilerCodeUtils() {
    }

    static String generateJavaCode(String expr, CompilerEnvironment environment) {
        return CompilerCodeUtils.generateJavaCode(expr, CompilerCodeUtils.generateClassName(), environment);
    }

    static String generateJavaCode(String expr, String expressionClassName, CompilerEnvironment environment) {
        String sourceCode;
        boolean skipParse = environment.isSkipParse();
        if (skipParse) {
            environment.initTypeNameInvokers();
            expr = CompilerCodeUtils.prepareElOnSkipMode(expr, environment);
            sourceCode = CompilerCodeUtils.generateJavaSourceCode(expr, expressionClassName, environment);
        } else {
            CompilerExprParser exprParser = new CompilerExprParser(expr);
            String exprCode = exprParser.code();
            environment.initTypeNameInvokers(exprParser);
            sourceCode = CompilerCodeUtils.generateJavaSourceCode(exprCode, expressionClassName, environment);
        }
        return sourceCode;
    }

    static String generateClassName() {
        return "CEL$_" + ATOMIC_LONG.getAndIncrement();
    }

    static CompilerExpression compileByNative(String expr, CompilerEnvironment environment) {
        String expressionClassName = CompilerCodeUtils.generateClassName();
        String javaCode = CompilerCodeUtils.generateJavaCode(expr, expressionClassName, environment);
        MemoryJavaFileManager javaFileManager = new MemoryJavaFileManager(fileManager);
        try {
            JavaFileObject javaFileObject = javaFileManager.createJavaFileObject(expressionClassName + ".java", javaCode);
            JavaCompiler.CompilationTask task = compiler.getTask(null, javaFileManager, null, Arrays.asList("-encoding", "UTF-8", "-XDuseUnsharedTable"), null, Arrays.asList(javaFileObject));
            boolean bl = task.call();
            if (bl) {
                MemoryJavaFileObject memoryJavaFileObject = javaFileManager.getMemoryJavaFileObject();
                MemoryClassLoader memoryClassLoader = new MemoryClassLoader(memoryJavaFileObject);
                Class<?> clazz = memoryClassLoader.loadClass(PACKAGE_NAME + "." + expressionClassName);
                Constructor<?> clazzConstructor = clazz.getConstructor(CompilerEnvironment.class);
                clazzConstructor.setAccessible(true);
                CompilerExpression compilerExpression = (CompilerExpression)clazzConstructor.newInstance(environment);
                return compilerExpression;
            }
            try {
                throw new ExpressionException(" compile fail ");
            }
            catch (Throwable e) {
                if (e instanceof ExpressionException) {
                    throw (ExpressionException)e;
                }
                throw new ParserException(" parse exception :" + e.getMessage(), e);
            }
        }
        finally {
            try {
                javaFileManager.close();
            }
            catch (IOException iOException) {}
        }
    }

    static CompilerExpression compileByJavassist(String expr, CompilerEnvironment environment) {
        Map<String, CompilerEnvironment.ExprFunctionMeta> javassistFunctionMetaMap;
        Set<Map.Entry<String, CompilerEnvironment.ExprFunctionMeta>> set;
        int len;
        boolean skipParse = environment.isSkipParse();
        if (skipParse) {
            environment.initTypeNameInvokers();
            expr = CompilerCodeUtils.prepareElOnSkipMode(expr, environment).trim();
        } else {
            CompilerExprParser exprParser = new CompilerExprParser(expr);
            expr = exprParser.code().trim();
            environment.initTypeNameInvokers(exprParser);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("className", CompilerCodeUtils.generateClassName());
        vars.put("superclass", CompilerExpression.class.getName());
        StringBuilder constructorBodyBuilder = new StringBuilder();
        constructorBodyBuilder.append("{\n");
        constructorBodyBuilder.append("\t\tsuper($1);\n");
        StringBuilder invokeObjMethodBuilder = new StringBuilder();
        StringBuilder invokeMapMethodBuilder = new StringBuilder();
        invokeObjMethodBuilder.append("protected void doInvoke(Object context, ValueHolder valueHolder) {\n");
        invokeMapMethodBuilder.append("protected void doInvoke(java.util.Map context, ValueHolder valueHolder) {\n");
        ArrayList<String> functionSources = new ArrayList<String>();
        ArrayList<String> fieldSources = new ArrayList<String>();
        List<CompilerEnvironment.TypeNameInvoker> typeNameInvokers = environment.getTypeNameInvokers();
        HashSet<Integer> defineIndexs = new HashSet<Integer>();
        HashMap<String, String> defineJavaIdentifiers = new HashMap<String, String>();
        HashMap<String, Class> definedTypes = new HashMap<String, Class>(environment.getVariableTypes());
        HashMap<String, Class> deductionTypes = new HashMap<String, Class>();
        HashMap<Integer, Class> tailTypes = new HashMap<Integer, Class>();
        int ofIndex = 0;
        for (CompilerEnvironment.TypeNameInvoker typeNameInvoker : typeNameInvokers) {
            VariableInvoker parent;
            String defineJavaIdentifier = typeNameInvoker.defineJavaIdentifier;
            VariableInvoker variableInvoker = typeNameInvoker.variableInvoker;
            int index = variableInvoker.getIndex();
            tailTypes.put(index, typeNameInvoker.type);
            if (defineIndexs.add(index)) {
                constructorBodyBuilder.append("\t\t$0._invoke_").append(index).append(" = getInvokerAt(").append(ofIndex).append(");\r\n");
                fieldSources.add("final VariableInvoker _invoke_" + index + ";\r\n");
            }
            int currentIndex = index;
            for (VariableInvoker _parentInvoker = parent = variableInvoker.getParent(); _parentInvoker != null; _parentInvoker = _parentInvoker.getParent()) {
                int parentIndex = _parentInvoker.getIndex();
                if (defineIndexs.add(parentIndex)) {
                    constructorBodyBuilder.append("\t\t$0._invoke_").append(parentIndex).append(" = $0._invoke_").append(currentIndex).append(".getParent();\r\n");
                    fieldSources.add("final VariableInvoker _invoke_" + parentIndex + ";\r\n");
                }
                currentIndex = parentIndex;
            }
            CompilerCodeUtils.generateInvokerCodeTo(variableInvoker, defineJavaIdentifier, invokeObjMethodBuilder, invokeMapMethodBuilder, defineJavaIdentifiers, definedTypes, deductionTypes, tailTypes);
            ++ofIndex;
        }
        constructorBodyBuilder.append("}");
        if (expr.startsWith("return ")) {
            for (len = expr.length(); len > 7 && expr.charAt(len - 1) == ';'; --len) {
            }
            invokeObjMethodBuilder.append("\t\t$2.setValue(").append(expr, 7, len).append(");\n").append("}");
            invokeMapMethodBuilder.append("\t\t$2.setValue(").append(expr, 7, len).append(");\n").append("}");
        } else {
            for (len = expr.length(); len > 7 && expr.charAt(len - 1) == ';'; --len) {
            }
            invokeObjMethodBuilder.append("\t\t$2.setValue(").append(expr, 0, len).append(");\n").append("}");
            invokeMapMethodBuilder.append("\t\t$2.setValue(").append(expr, 0, len).append(");\n").append("}");
        }
        vars.put("constructorBody", constructorBodyBuilder.toString());
        vars.put("fieldSources", fieldSources);
        vars.put("invokeObjectSource", invokeObjMethodBuilder.toString());
        vars.put("invokeMapSource", invokeMapMethodBuilder.toString());
        vars.put("functionSources", functionSources);
        Map<String, ExprFunction> functionMap = environment.getFunctionMap();
        Set<Map.Entry<String, ExprFunction>> functionEntrys = functionMap.entrySet();
        if (functionEntrys.size() > 0) {
            for (Map.Entry entry : functionEntrys) {
                StringBuilder functionBuilder = new StringBuilder();
                String functionName = (String)entry.getKey();
                ExprFunction function = (ExprFunction)entry.getValue();
                if (function instanceof JavassistExprFunction) continue;
                Type[] types = CompilerCodeUtils.getFunctionGenericTypes(function.getClass());
                Class inClass = types == null ? Object.class : (Class)types[0];
                Class outClass = types == null ? Object.class : (Class)types[1];
                String inClassName = inClass.getName();
                String outClassName = outClass.getName();
                functionBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(").append(inClassName).append("[] params) {\r\n");
                functionBuilder.append("\t\tExprFunction function = getFunction(\"").append(functionName).append("\");\r\n");
                functionBuilder.append("\t\treturn function.call(params);\r\n");
                functionBuilder.append("\t}\r\n");
                functionSources.add(functionBuilder.toString());
            }
        }
        if ((set = (javassistFunctionMetaMap = environment.javassistFunctionMetaMap).entrySet()).size() > 0) {
            for (Map.Entry<String, CompilerEnvironment.ExprFunctionMeta> functionMetaEntry : set) {
                String functionName = functionMetaEntry.getKey();
                CompilerEnvironment.ExprFunctionMeta functionMeta = functionMetaEntry.getValue();
                Class<?> outClass = functionMeta.returnClass;
                Class<?>[] paramClassList = functionMeta.paramClassList;
                String outClassName = outClass.getName();
                StringBuilder functionBuilder = new StringBuilder();
                functionBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(");
                int len2 = paramClassList.length;
                for (int i = 0; i < len2; ++i) {
                    functionBuilder.append(paramClassList[i].getName()).append(" $").append(i + 1);
                    if (i >= len2 - 1) continue;
                    functionBuilder.append(",");
                }
                functionBuilder.append(") {\r\n");
                functionBuilder.append("\t\tExprFunction function = getFunction(\"").append(functionName).append("\");\r\n");
                functionBuilder.append("\t\treturn ($r)function.call($args);\r\n");
                functionBuilder.append("\t}\r\n");
                functionSources.add(functionBuilder.toString());
                if (paramClassList.length <= 0) continue;
                functionBuilder.setLength(0);
                functionBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(");
                functionBuilder.append(paramClassList[0].getName()).append("[] params");
                functionBuilder.append(") {\r\n");
                functionBuilder.append("\t\tJavassistExprFunction function = (JavassistExprFunction) getFunction(\"").append(functionName).append("\");\r\n");
                functionBuilder.append("\t\treturn ($r)function.call($1);\r\n");
                functionBuilder.append("\t}\r\n");
                functionSources.add(functionBuilder.toString());
                if (paramClassList[0] == Object.class) continue;
                functionBuilder.setLength(0);
                functionBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(Object[] params) {\r\n");
                functionBuilder.append("\t\tJavassistExprFunction function = (JavassistExprFunction) getFunction(\"").append(functionName).append("\");\r\n");
                functionBuilder.append("\t\treturn ($r)function.call($1);\r\n");
                functionBuilder.append("\t}\r\n");
                functionSources.add(functionBuilder.toString());
            }
        }
        if (!CompilerExpressionCoder.isJavassistSupported()) {
            throw new UnsupportedOperationException("Javassist toolkit dependencies not imported");
        }
        return CompilerExpressionCoder.JavassistCoder.compile(vars, environment);
    }

    private static String prepareElOnSkipMode(String expr, CompilerEnvironment environment) {
        StringBuilder builder = new StringBuilder();
        char[] chars = UnsafeHelper.getChars(expr);
        int offset = 0;
        int len = chars.length;
        String fragment = null;
        for (int i = 0; i < len; ++i) {
            int j;
            int ch = chars[i];
            int prev = 0;
            if (ch == 34) {
                fragment = new String(chars, offset, i - offset);
                builder.append(CompilerCodeUtils.checkAndReplaceVariable(fragment, environment));
                for (j = i + 1; j < len && ((ch = chars[j]) != 34 || prev == 92); ++j) {
                    prev = ch;
                }
                if (ch != 34 || prev == 92) {
                    throw new ExpressionException("Expression syntax error, from pos " + i + ", End token '\"' not found");
                }
                builder.append(new String(chars, i, j - i + 1));
                i = j++;
                offset = j;
                continue;
            }
            if (ch == 39) {
                fragment = new String(chars, offset, i - offset);
                builder.append(CompilerCodeUtils.checkAndReplaceVariable(fragment, environment));
                for (j = i + 1; j < len && ((ch = chars[j]) != 39 || prev == 92); ++j) {
                    prev = ch;
                }
                if (ch != 39 || prev == 92) {
                    throw new ExpressionException("Expression syntax error, from pos " + i + ", End token ''' not found");
                }
                builder.append('\"').append(new String(chars, i + 1, j - i - 1)).append('\"');
                i = j++;
                offset = j;
                continue;
            }
            if (ch != 64) continue;
            fragment = new String(chars, offset, i - offset);
            builder.append(CompilerCodeUtils.checkAndReplaceVariable(fragment, environment));
            offset = i + 1;
        }
        fragment = new String(chars, offset, len - offset);
        builder.append(CompilerCodeUtils.checkAndReplaceVariable(fragment, environment));
        return builder.toString();
    }

    private static String checkAndReplaceVariable(String fragment, CompilerEnvironment environment) {
        List<CompilerEnvironment.TypeNameInvoker> typeNameInvokers = environment.getTypeNameInvokers();
        for (CompilerEnvironment.TypeNameInvoker typeNameInvoker : typeNameInvokers) {
            String varName = typeNameInvoker.varName;
            String defineJavaIdentifier = typeNameInvoker.defineJavaIdentifier;
            if (varName == defineJavaIdentifier) continue;
            fragment = fragment.replace(varName, defineJavaIdentifier);
        }
        if (!environment.isDisableSecurityCheck()) {
            String[] lines;
            Set<String> disableKeys = environment.getDisableKeys();
            String codeExpr = fragment;
            for (String line : lines = codeExpr.split(";")) {
                if (!environment.isEnableSystem() && line.indexOf("System") > -1) {
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a 'System', code fragment: '%s'", fragment));
                }
                if (line.indexOf("Runtime") > -1) {
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a 'Runtime', code fragment: '%s'", fragment));
                }
                if (line.indexOf("Class") > -1) {
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a 'Class', code fragment: '%s'", fragment));
                }
                for (String key : disableKeys) {
                    if (line.indexOf(key) <= -1) continue;
                    throw new SecurityException(String.format(" \u7f16\u8bd1\u51fa\u73b0\u4e86\u4e0d\u652f\u6301\u7684\u5b89\u5168\u5173\u952e\u5b57\uff1a '%s', code fragment: '%s'", key, fragment));
                }
            }
        }
        return fragment;
    }

    private static String generateJavaSourceCode(String source, String expressionClassName, CompilerEnvironment environment) {
        StringBuilder initInvokesBuilder = new StringBuilder();
        StringBuilder declareInvokesBuilder = new StringBuilder();
        StringBuilder assignmentObjectVariablesBuilder = new StringBuilder();
        StringBuilder assignmentMapVariablesBuilder = new StringBuilder();
        StringBuilder registerFunctionsBuilder = new StringBuilder();
        HashMap<String, CharSequence> vars = new HashMap<String, CharSequence>();
        List<CompilerEnvironment.TypeNameInvoker> typeNameInvokers = environment.getTypeNameInvokers();
        HashSet<Integer> defineIndexs = new HashSet<Integer>();
        HashMap<String, String> defineJavaIdentifiers = new HashMap<String, String>();
        Map<String, Class> definedTypes = environment.getVariableTypes();
        HashMap<String, Class> deductionTypes = new HashMap<String, Class>();
        HashMap<Integer, Class> tailTypes = new HashMap<Integer, Class>();
        int ofIndex = 0;
        for (CompilerEnvironment.TypeNameInvoker typeNameInvoker : typeNameInvokers) {
            VariableInvoker parent;
            String defineJavaIdentifier = typeNameInvoker.defineJavaIdentifier;
            VariableInvoker invoker = typeNameInvoker.variableInvoker;
            int index = invoker.getIndex();
            tailTypes.put(index, typeNameInvoker.type);
            if (defineIndexs.add(index)) {
                initInvokesBuilder.append("\t\tthis._invoke_").append(index).append(" = getInvokerAt(").append(ofIndex).append(");\r\n");
                declareInvokesBuilder.append("\tfinal VariableInvoker _invoke_").append(index).append(";\r\n");
            }
            int currentIndex = index;
            for (VariableInvoker _parentInvoker = parent = invoker.getParent(); _parentInvoker != null; _parentInvoker = _parentInvoker.getParent()) {
                int parentIndex = _parentInvoker.getIndex();
                if (defineIndexs.add(parentIndex)) {
                    initInvokesBuilder.append("\t\tthis._invoke_").append(parentIndex).append(" = this._invoke_").append(currentIndex).append(".getParent();\r\n");
                    declareInvokesBuilder.append("\tfinal VariableInvoker _invoke_").append(parentIndex).append(";\r\n");
                }
                currentIndex = parentIndex;
            }
            CompilerCodeUtils.generateInvokerCodeTo(invoker, defineJavaIdentifier, assignmentObjectVariablesBuilder, assignmentMapVariablesBuilder, defineJavaIdentifiers, definedTypes, deductionTypes, tailTypes);
            ++ofIndex;
        }
        Map<String, ExprFunction> functionMap = environment.getFunctionMap();
        Set<Map.Entry<String, ExprFunction>> functionEntrys = functionMap.entrySet();
        if (functionEntrys.size() > 0) {
            registerFunctionsBuilder.append("\r\n");
            for (Map.Entry<String, ExprFunction> functionEntry : functionEntrys) {
                String functionName = functionEntry.getKey();
                ExprFunction function = functionEntry.getValue();
                if (function instanceof JavassistExprFunction) continue;
                Type[] types = CompilerCodeUtils.getFunctionGenericTypes(function.getClass());
                Class inClass = types == null ? Object.class : (Class)types[0];
                Class outClass = types == null ? Object.class : (Class)types[1];
                String inClassName = inClass.getName();
                String outClassName = outClass.getName();
                registerFunctionsBuilder.append("\t@SuppressWarnings(\"unchecked\")\r\n");
                registerFunctionsBuilder.append("\tprivate ").append(outClassName).append(" ").append(functionName).append("(").append(inClassName).append("...params) {\r\n");
                registerFunctionsBuilder.append("\t\tExprFunction<").append(inClassName).append(",").append(outClassName).append("> function = getFunction(\"").append(functionName).append("\");\r\n");
                registerFunctionsBuilder.append("\t\treturn function.call(params);\r\n");
                registerFunctionsBuilder.append("\t}\r\n");
            }
        }
        vars.put("className", expressionClassName);
        vars.put("expressionCode", source);
        vars.put("initInvokes", initInvokesBuilder);
        vars.put("declareInvokes", declareInvokesBuilder);
        vars.put("assignmentObjectVariables", assignmentObjectVariablesBuilder);
        vars.put("assignmentMapVariables", assignmentMapVariablesBuilder);
        vars.put("registerFunctions", registerFunctionsBuilder);
        return Expression.renderTemplate(NativeJavaCodeTemplate, vars);
    }

    private static void generateInvokerCodeTo(VariableInvoker variableInvoker, String defineJavaIdentifier, StringBuilder objVariablesBuilder, StringBuilder mapVariablesBuilder, Map<String, String> defineJavaIdentifiers, Map<String, Class> definedTypes, Map<String, Class> deductionTypes, Map<Integer, Class> tailTypes) {
        if (variableInvoker == null) {
            return;
        }
        VariableInvoker parent = variableInvoker.getParent();
        CompilerCodeUtils.generateInvokerCodeTo(parent, null, objVariablesBuilder, mapVariablesBuilder, defineJavaIdentifiers, definedTypes, deductionTypes, tailTypes);
        int index = variableInvoker.getIndex();
        String key = variableInvoker.getKey();
        boolean childEl = variableInvoker.isChildEl();
        boolean tail = variableInvoker.isTail();
        String invokeUniqueKey = variableInvoker.toString();
        if (defineJavaIdentifier == null) {
            defineJavaIdentifier = definedTypes.containsKey(invokeUniqueKey) ? invokeUniqueKey.replace('.', '_') : "_$" + index;
        }
        if (!defineJavaIdentifiers.containsValue(defineJavaIdentifier)) {
            objVariablesBuilder.append("\t\t");
            mapVariablesBuilder.append("\t\t");
            if (parent == null) {
                String typeName = null;
                Class defineType = definedTypes.get(invokeUniqueKey);
                if (defineType == null && tail && tailTypes.containsKey(index)) {
                    defineType = tailTypes.get(index);
                }
                if (defineType != null) {
                    typeName = CompilerCodeUtils.getTypeName(defineType);
                    objVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                    mapVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                    if (defineType.isPrimitive()) {
                        String primitiveMethodValue = primitiveValueMethods.get(defineType).getValue();
                        objVariablesBuilder.append(primitiveMethodValue).append("(");
                        mapVariablesBuilder.append(primitiveMethodValue).append("(");
                        if (!childEl) {
                            mapVariablesBuilder.append("context.get(\"").append(key).append("\")");
                        } else {
                            mapVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context)");
                        }
                        objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context)");
                        objVariablesBuilder.append(");\r\n");
                        mapVariablesBuilder.append(");\r\n");
                    } else {
                        objVariablesBuilder.append("(").append(typeName).append(") ");
                        mapVariablesBuilder.append("(").append(typeName).append(") ");
                        if (!childEl) {
                            mapVariablesBuilder.append("context.get(\"").append(key).append("\");\r\n");
                        } else {
                            mapVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context);\r\n");
                        }
                        objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context);\r\n");
                        deductionTypes.put(invokeUniqueKey, defineType);
                    }
                } else {
                    objVariablesBuilder.append("Object ").append(defineJavaIdentifier).append(" = ");
                    mapVariablesBuilder.append("Object ").append(defineJavaIdentifier).append(" = ");
                    if (!childEl) {
                        mapVariablesBuilder.append("context.get(\"").append(key).append("\");\r\n");
                    } else {
                        mapVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context);\r\n");
                    }
                    objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(context);\r\n");
                }
            } else {
                String parentUniqueKey = parent.toString();
                String parentValueVar = defineJavaIdentifiers.get(parentUniqueKey);
                if (parentValueVar == null) {
                    throw new IllegalStateException("Unexpected exception");
                }
                Class parentType = deductionTypes.get(parentUniqueKey);
                Class defineType = definedTypes.get(invokeUniqueKey);
                boolean forceConversionType = defineType != null;
                boolean forcePrimitiveType = forceConversionType ? defineType.isPrimitive() : false;
                GetterInfo getterInfo = null;
                boolean isParentMapType = false;
                if (parentType != null && !parentType.isPrimitive()) {
                    if (Map.class.isAssignableFrom(parentType)) {
                        isParentMapType = true;
                    } else {
                        ClassStructureWrapper parentStructureWrapper;
                        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(parentType);
                        if (classCategory == ReflectConsts.ClassCategory.ObjectCategory && (getterInfo = CompilerCodeUtils.getGetterInfo(parentStructureWrapper = ClassStructureWrapper.get(parentType), key)) != null && getterInfo.getReturnType() == defineType) {
                            forceConversionType = false;
                            forcePrimitiveType = false;
                        }
                        if (defineType == null) {
                            Class clazz = defineType = getterInfo == null ? null : getterInfo.getReturnType();
                        }
                    }
                    if (defineType == null) {
                        defineType = tail && tailTypes.containsKey(index) ? tailTypes.get(index) : Object.class;
                    }
                    String typeName = CompilerCodeUtils.getTypeName(defineType);
                    objVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                    mapVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                    if (forceConversionType) {
                        if (forcePrimitiveType) {
                            String primitiveMethodValue = primitiveValueMethods.get(defineType).getValue();
                            objVariablesBuilder.append(primitiveMethodValue).append("(");
                            mapVariablesBuilder.append(primitiveMethodValue).append("(");
                        } else {
                            objVariablesBuilder.append("(").append(typeName).append(") ");
                            mapVariablesBuilder.append("(").append(typeName).append(") ");
                        }
                    }
                    if (getterInfo != null) {
                        objVariablesBuilder.append(parentValueVar).append(".").append(getterInfo.getMethodName()).append("()");
                        mapVariablesBuilder.append(parentValueVar).append(".").append(getterInfo.getMethodName()).append("()");
                    } else if (isParentMapType && !childEl) {
                        objVariablesBuilder.append(parentValueVar).append(".get(\"").append(key).append("\")");
                        mapVariablesBuilder.append(parentValueVar).append(".get(\"").append(key).append("\")");
                    } else {
                        objVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(")");
                        mapVariablesBuilder.append("_invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(")");
                    }
                    if (forcePrimitiveType) {
                        objVariablesBuilder.append(");\r\n");
                        mapVariablesBuilder.append(");\r\n");
                    } else {
                        objVariablesBuilder.append(";\r\n");
                        mapVariablesBuilder.append(";\r\n");
                    }
                } else {
                    String typeName = null;
                    if (defineType == null && tail && tailTypes.containsKey(index)) {
                        defineType = tailTypes.get(index);
                    }
                    if (defineType != null) {
                        typeName = CompilerCodeUtils.getTypeName(defineType);
                        objVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                        mapVariablesBuilder.append(typeName).append(" ").append(defineJavaIdentifier).append(" = ");
                        if (defineType.isPrimitive()) {
                            String primitiveMethodValue = primitiveValueMethods.get(defineType).getValue();
                            objVariablesBuilder.append(primitiveMethodValue).append("(_invoke_").append(index).append(".invokeValue(").append(parentValueVar).append("));\r\n");
                            mapVariablesBuilder.append(primitiveMethodValue).append("(_invoke_").append(index).append(".invokeValue(").append(parentValueVar).append("));\r\n");
                        } else {
                            objVariablesBuilder.append("(").append(typeName).append(") _invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(");\r\n");
                            mapVariablesBuilder.append("(").append(typeName).append(") _invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(");\r\n");
                            deductionTypes.put(invokeUniqueKey, defineType);
                        }
                    } else {
                        objVariablesBuilder.append("Object ").append(defineJavaIdentifier).append(" = _invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(");\r\n");
                        mapVariablesBuilder.append("Object ").append(defineJavaIdentifier).append(" = _invoke_").append(index).append(".invokeValue(").append(parentValueVar).append(");\r\n");
                    }
                }
                if (defineType != null && defineType != Object.class && !defineType.isPrimitive()) {
                    deductionTypes.put(invokeUniqueKey, defineType);
                }
            }
            defineJavaIdentifiers.put(invokeUniqueKey, defineJavaIdentifier);
        }
    }

    private static GetterInfo getGetterInfo(ClassStructureWrapper parentStructureWrapper, String key) {
        List<GetterInfo> getterInfos = parentStructureWrapper.getGetterInfos();
        for (GetterInfo getterInfo : getterInfos) {
            if (!key.equals(getterInfo.getName()) && !key.equals(getterInfo.getUnderlineName())) continue;
            return getterInfo;
        }
        return null;
    }

    private static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            StringBuilder builder = new StringBuilder();
            Class<?> componentType = type.getComponentType();
            int cnt = 1;
            while (componentType.isArray()) {
                ++cnt;
                componentType = componentType.getComponentType();
            }
            builder.append(componentType.getName());
            for (int i = 0; i < cnt; ++i) {
                builder.append("[]");
            }
            return builder.toString();
        }
        return type.getName();
    }

    private static Type[] getFunctionGenericTypes(Class<?> targetClass) {
        Type[] typeArray;
        int n;
        int n2;
        Type[] implementTypes = targetClass.getGenericInterfaces();
        if (implementTypes.length == 0) {
            Class<?> parentCls = targetClass.getSuperclass();
            implementTypes = parentCls.getGenericInterfaces();
        }
        if ((n2 = 0) < (n = (typeArray = implementTypes).length)) {
            ParameterizedType parameterizedType;
            Type[] types;
            Type implementType = typeArray[n2];
            if (implementType instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)implementType).getActualTypeArguments()) != null && types.length > 0) {
                return types;
            }
            return null;
        }
        return null;
    }

    static {
        KeyValuePair<String, String> intType = new KeyValuePair<String, String>("int", "intValue");
        KeyValuePair<String, String> longType = new KeyValuePair<String, String>("long", "longValue");
        KeyValuePair<String, String> doubleType = new KeyValuePair<String, String>("double", "doubleValue");
        KeyValuePair<String, String> floatType = new KeyValuePair<String, String>("float", "floatValue");
        KeyValuePair<String, String> shortType = new KeyValuePair<String, String>("short", "shortValue");
        KeyValuePair<String, String> byteType = new KeyValuePair<String, String>("byte", "byteValue");
        KeyValuePair<String, String> booleanType = new KeyValuePair<String, String>("boolean", "booleanValue");
        KeyValuePair<String, String> charType = new KeyValuePair<String, String>("char", "charValue");
        primitiveValueMethods.put(Integer.TYPE, intType);
        primitiveValueMethods.put(Long.TYPE, longType);
        primitiveValueMethods.put(Double.TYPE, doubleType);
        primitiveValueMethods.put(Float.TYPE, floatType);
        primitiveValueMethods.put(Short.TYPE, shortType);
        primitiveValueMethods.put(Byte.TYPE, byteType);
        primitiveValueMethods.put(Boolean.TYPE, booleanType);
        primitiveValueMethods.put(Character.TYPE, charType);
        primitiveValueMethods.put(Integer.class, intType);
        primitiveValueMethods.put(Long.class, longType);
        primitiveValueMethods.put(Double.class, doubleType);
        primitiveValueMethods.put(Float.class, floatType);
        primitiveValueMethods.put(Short.class, shortType);
        primitiveValueMethods.put(Byte.class, byteType);
    }
}

