/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.expression.ExprEvaluator;
import io.github.wycst.wast.common.expression.ExpressionException;

public final class CompilerExprEvaluator
extends ExprEvaluator {
    public String code() {
        StringBuilder builder = new StringBuilder();
        int opsType = this.opsType;
        if (this.isStaticExpr()) {
            Object result = this.evaluate();
            if (result instanceof String) {
                String strValue = (String)result;
                if (strValue.indexOf(34) > -1) {
                    strValue = strValue.replace("\"", "\\\"");
                }
                return builder.append("\"").append(strValue).append("\"").toString();
            }
            return String.valueOf(result);
        }
        int evalType = this.getEvalType();
        boolean negate = this.isNegate();
        boolean logicalNot = this.isLogicalNot();
        ExprEvaluator left = this.getLeft();
        ExprEvaluator right = this.getRight();
        if (evalType == 1) {
            String leftGenerateCode = left.code();
            if (right == null) {
                return leftGenerateCode;
            }
            String rightGenerateCode = right.code();
            switch (opsType) {
                case 1: {
                    return builder.append(leftGenerateCode).append(" * ").append(rightGenerateCode).toString();
                }
                case 2: {
                    return builder.append(leftGenerateCode).append(" / ").append(rightGenerateCode).toString();
                }
                case 3: {
                    return builder.append(leftGenerateCode).append(" % ").append(rightGenerateCode).toString();
                }
                case 4: {
                    return builder.append("Math.pow(").append(leftGenerateCode).append(", ").append(rightGenerateCode).append(")").toString();
                }
                case 11: {
                    return builder.append(leftGenerateCode).append(" + ").append(rightGenerateCode).toString();
                }
                case 12: {
                    return builder.append(leftGenerateCode).append(" - ").append(rightGenerateCode).toString();
                }
                case 21: {
                    return builder.append(leftGenerateCode).append(" >> ").append(rightGenerateCode).toString();
                }
                case 22: {
                    return builder.append(leftGenerateCode).append(" << ").append(rightGenerateCode).toString();
                }
                case 31: {
                    return builder.append(leftGenerateCode).append(" & ").append(rightGenerateCode).toString();
                }
                case 32: {
                    return builder.append(leftGenerateCode).append(" ^ ").append(rightGenerateCode).toString();
                }
                case 33: {
                    return builder.append(leftGenerateCode).append(" | ").append(rightGenerateCode).toString();
                }
                case 51: {
                    return builder.append(leftGenerateCode).append(" > ").append(rightGenerateCode).toString();
                }
                case 52: {
                    return builder.append(leftGenerateCode).append(" < ").append(rightGenerateCode).toString();
                }
                case 53: {
                    return builder.append(leftGenerateCode).append(" == ").append(rightGenerateCode).toString();
                }
                case 54: {
                    return builder.append(leftGenerateCode).append(" >= ").append(rightGenerateCode).toString();
                }
                case 55: {
                    return builder.append(leftGenerateCode).append(" <= ").append(rightGenerateCode).toString();
                }
                case 56: {
                    return builder.append(leftGenerateCode).append(" != ").append(rightGenerateCode).toString();
                }
                case 61: {
                    return builder.append(leftGenerateCode).append(" && ").append(rightGenerateCode).toString();
                }
                case 62: {
                    return builder.append(leftGenerateCode).append(" || ").append(rightGenerateCode).toString();
                }
                case 63: {
                    throw new ExpressionException("\u6682\u65f6\u4e0d\u652f\u6301'in'\u7b26\u53f7\u7f16\u8bd1");
                }
                case 64: {
                    throw new ExpressionException("\u6682\u65f6\u4e0d\u652f\u6301'out'\u7b26\u53f7\u7f16\u8bd1");
                }
                case 70: {
                    return builder.append(leftGenerateCode).append(" : ").append(rightGenerateCode).toString();
                }
                case 71: {
                    return builder.append(leftGenerateCode).append(" ? ").append(rightGenerateCode).toString();
                }
            }
        } else {
            if (evalType == 5) {
                if (negate) {
                    return builder.append("-(").append(right.code()).append(")").toString();
                }
                if (logicalNot) {
                    return builder.append("!(").append(right.code()).append(")").toString();
                }
                return builder.append("(").append(right.code()).append(")").toString();
            }
            if (evalType == 6) {
                throw new UnsupportedOperationException();
            }
            return left.code();
        }
        return null;
    }
}

