/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.compile.CompilerCodeUtils;
import io.github.wycst.wast.common.expression.compile.CompilerEnvironment;
import io.github.wycst.wast.common.expression.compile.CompilerExpressionCoder;
import io.github.wycst.wast.common.expression.invoker.VariableInvoker;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompilerExpression
extends Expression {
    private static Coder DefaultCoder = CompilerExpressionCoder.isJavassistSupported() ? Coder.Javassist : Coder.Native;
    protected final CompilerEnvironment environment;

    public static void setDefaultCoder(Coder defaultCoder) {
        DefaultCoder = defaultCoder;
    }

    protected CompilerExpression(CompilerEnvironment environment) {
        this.environment = environment;
    }

    public static CompilerEnvironment createEnvironment() {
        return new CompilerEnvironment();
    }

    public static CompilerExpression compile(String expr) {
        return CompilerExpression.compile(expr, CompilerExpression.createEnvironment());
    }

    public static String generateJavaCode(String expr, CompilerEnvironment environment) {
        return CompilerCodeUtils.generateJavaCode(expr, environment);
    }

    public static CompilerExpression compile(String expr, CompilerEnvironment environment) {
        return CompilerExpression.compile(expr, environment, DefaultCoder);
    }

    public static CompilerExpression compile(String expr, CompilerEnvironment environment, Coder coder) {
        if (coder == null) {
            coder = DefaultCoder == null ? Coder.Native : DefaultCoder;
        }
        switch (coder) {
            case Native: {
                return CompilerCodeUtils.compileByNative(expr, environment);
            }
            case Javassist: {
                return CompilerCodeUtils.compileByJavassist(expr, environment);
            }
        }
        throw new UnsupportedOperationException("unknown coder " + (Object)((Object)coder));
    }

    @Deprecated
    public static CompilerExpression compileJavassist(String expr, CompilerEnvironment environment) {
        return CompilerCodeUtils.compileByJavassist(expr, environment);
    }

    protected final ExprFunction getFunction(String functionName) {
        return this.environment.getFunction(functionName);
    }

    @Override
    public final Object evaluate() {
        return this.evaluate((Object)null);
    }

    @Override
    public Object evaluate(Map context) {
        return this.invoke(context);
    }

    @Override
    public Object evaluate(Object context) {
        return this.invoke(context);
    }

    @Override
    public final Object evaluate(EvaluateEnvironment evaluateEnvironment) {
        return this.evaluate(evaluateEnvironment.getContext());
    }

    protected final <T> T getValue(Object value, Class<T> tClass) {
        return (T)value;
    }

    protected VariableInvoker getInvokerAt(int index) {
        return this.environment.getTypeNameInvokers().get((int)index).variableInvoker;
    }

    protected Object invoke(Object context) {
        throw new UnsupportedOperationException();
    }

    protected Object invoke(Map context) {
        throw new UnsupportedOperationException();
    }

    protected final int intValue(Object value) {
        Number number = (Number)value;
        return number.intValue();
    }

    protected final byte byteValue(Object value) {
        Number number = (Number)value;
        return number.byteValue();
    }

    protected final double doubleValue(Object value) {
        Number number = (Number)value;
        return number.doubleValue();
    }

    protected final float floatValue(Object value) {
        Number number = (Number)value;
        return number.floatValue();
    }

    protected final long longValue(Object value) {
        Number number = (Number)value;
        return number.longValue();
    }

    protected final char charValue(Object value) {
        return ((Character)value).charValue();
    }

    protected final short shortValue(Object value) {
        Number number = (Number)value;
        return number.shortValue();
    }

    protected final boolean booleanValue(Object value) {
        return (Boolean)value;
    }

    protected final String stringValue(Object value) {
        return String.valueOf(value);
    }

    protected final Object objectValue(Object value) {
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Coder {
        Native,
        Javassist;

    }
}

