/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.ReflectConsts;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericParameterizedType<T> {
    private static final Map<Class, GenericParameterizedType> GENERIC_PARAMETERIZED_TYPE_MAP = new HashMap<Class, GenericParameterizedType>();
    public static final GenericParameterizedType StringType = GenericParameterizedType.actualType(String.class);
    public static final GenericParameterizedType DefaultMap = GenericParameterizedType.actualType(LinkedHashMap.class);
    public static final GenericParameterizedType DefaultCollection = GenericParameterizedType.collectionType(ArrayList.class, Object.class);
    public static final GenericParameterizedType<Integer> IntType = GenericParameterizedType.actualType(Integer.TYPE);
    public static final GenericParameterizedType<Long> LongType = GenericParameterizedType.actualType(Long.TYPE);
    public static final GenericParameterizedType<BigDecimal> BigDecimalType = GenericParameterizedType.actualType(BigDecimal.class);
    public static GenericParameterizedType AnyType = GenericParameterizedType.actualType(Object.class);
    boolean array;
    Class<?> actualType;
    private int paramClassType;
    private int paramClassNumberType;
    ReflectConsts.ClassCategory actualClassCategory;
    Class<?> mapKeyClass;
    GenericParameterizedType valueType;
    boolean generic;
    Class<?> genericClass;
    Map<String, Class<?>> genericClassMap;
    private boolean camouflage;
    String genericName;
    private String datePattern;
    private String dateTimezone;

    private GenericParameterizedType() {
    }

    public static <T> GenericParameterizedType<T> actualType(Class<T> actualType) {
        GenericParameterizedType<T> genericParameterizedType = GENERIC_PARAMETERIZED_TYPE_MAP.get(actualType);
        if (genericParameterizedType == null) {
            genericParameterizedType = new GenericParameterizedType<T>();
            super.setActualType(actualType);
            genericParameterizedType.actualClassCategory = ReflectConsts.getClassCategory(actualType);
            genericParameterizedType.initParamClassType();
            GENERIC_PARAMETERIZED_TYPE_MAP.put(actualType, genericParameterizedType);
        }
        return genericParameterizedType;
    }

    static <T> GenericParameterizedType<T> newActualType(Class<T> actualType) {
        GenericParameterizedType<T> genericParameterizedType = new GenericParameterizedType<T>();
        super.setActualType(actualType);
        genericParameterizedType.actualClassCategory = ReflectConsts.getClassCategory(actualType);
        genericParameterizedType.initParamClassType();
        return genericParameterizedType;
    }

    private <T> void setActualType(Class<T> actualType) {
        this.actualType = actualType;
    }

    public static GenericParameterizedType mapType(Class<? extends Map> mapClass, Class<?> mapKeyClass, Class<?> valueActualType) {
        GenericParameterizedType parameterizedType = new GenericParameterizedType();
        parameterizedType.generic = true;
        super.setActualType(mapClass);
        parameterizedType.mapKeyClass = mapKeyClass;
        GenericParameterizedType valueType = new GenericParameterizedType();
        super.setActualType(valueActualType);
        valueType.initParamClassType();
        parameterizedType.valueType = valueType;
        return parameterizedType;
    }

    public static GenericParameterizedType mapType(Class<? extends Map> mapClass, Class<?> mapKeyClass, GenericParameterizedType valueType) {
        GenericParameterizedType parameterizedType = new GenericParameterizedType();
        parameterizedType.generic = true;
        super.setActualType(mapClass);
        parameterizedType.mapKeyClass = mapKeyClass;
        parameterizedType.valueType = valueType;
        valueType.initParamClassType();
        return parameterizedType;
    }

    public static GenericParameterizedType arrayType(Class<?> componentType) {
        GenericParameterizedType<?> valueType;
        GenericParameterizedType parameterizedType = new GenericParameterizedType();
        parameterizedType.actualType = Array.newInstance(componentType, 0).getClass();
        parameterizedType.generic = true;
        parameterizedType.array = true;
        parameterizedType.valueType = valueType = GenericParameterizedType.actualType(componentType);
        return parameterizedType;
    }

    public static <E> GenericParameterizedType<E> collectionType(Class<E> collectionClass, Class<?> valueActualType) {
        GenericParameterizedType<?> valueType;
        GenericParameterizedType parameterizedType = new GenericParameterizedType();
        parameterizedType.generic = true;
        super.setActualType(collectionClass == null ? ArrayList.class : collectionClass);
        parameterizedType.valueType = valueType = GenericParameterizedType.actualType(valueActualType);
        return parameterizedType;
    }

    public static <E> GenericParameterizedType<E> collectionType(Class<E> collectionClass, GenericParameterizedType valueType) {
        GenericParameterizedType parameterizedType = new GenericParameterizedType();
        parameterizedType.generic = true;
        super.setActualType(collectionClass);
        parameterizedType.valueType = valueType;
        valueType.initParamClassType();
        return parameterizedType;
    }

    public static <E> GenericParameterizedType<E> entityType(Class<E> entityClass, Class<?> genericClass) {
        GenericParameterizedType parameterizedType = new GenericParameterizedType();
        super.setActualType(entityClass);
        parameterizedType.generic = true;
        parameterizedType.genericClass = genericClass;
        return parameterizedType;
    }

    public static <E> GenericParameterizedType<E> entityType(Class<E> entityClass, Map<String, Class<?>> genericClassMap) {
        GenericParameterizedType parameterizedType = new GenericParameterizedType();
        super.setActualType(entityClass);
        parameterizedType.genericClassMap = genericClassMap;
        return parameterizedType;
    }

    static GenericParameterizedType genericCollectionType(Class<?> parameterType, Type genericType) {
        GenericParameterizedType genericParameterizedType = new GenericParameterizedType();
        super.setActualType(parameterType);
        genericParameterizedType.generic = true;
        GenericParameterizedType.parseValueType(genericParameterizedType, genericType);
        return genericParameterizedType;
    }

    static GenericParameterizedType genericArrayType(Type genericComponentType) {
        GenericParameterizedType genericParameterizedType = new GenericParameterizedType();
        genericParameterizedType.array = true;
        genericParameterizedType.generic = true;
        GenericParameterizedType.parseValueType(genericParameterizedType, genericComponentType);
        return genericParameterizedType;
    }

    static GenericParameterizedType genericMapType(Class<?> parameterType, Type key, Type value) {
        GenericParameterizedType genericParameterizedType = new GenericParameterizedType();
        super.setActualType(parameterType);
        genericParameterizedType.generic = true;
        genericParameterizedType.mapKeyClass = key instanceof WildcardType || !(key instanceof Class) ? Object.class : (Class)key;
        GenericParameterizedType.parseValueType(genericParameterizedType, value);
        return genericParameterizedType;
    }

    static GenericParameterizedType genericEntityType(Class<?> parameterType, String genericName) {
        GenericParameterizedType genericParameterizedType = new GenericParameterizedType();
        super.setActualType(parameterType);
        genericParameterizedType.genericName = genericName;
        genericParameterizedType.camouflage = true;
        return genericParameterizedType;
    }

    private static void parseValueType(GenericParameterizedType genericParameterizedType, Type genericType) {
        if (genericType instanceof Class) {
            Class entityClass = (Class)genericType;
            genericParameterizedType.valueType = GenericParameterizedType.actualType(entityClass);
        } else if (genericType instanceof GenericArrayType) {
            ReflectConsts.PrimitiveType primitiveType;
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Type genericComponentType = genericArrayType.getGenericComponentType();
            genericParameterizedType.valueType = genericComponentType instanceof Class && (primitiveType = ReflectConsts.PrimitiveType.typeOf((Class)genericComponentType)) != null ? GenericParameterizedType.actualType(primitiveType.getGenericArrayType()) : GenericParameterizedType.genericArrayType(genericComponentType);
        } else if (genericType instanceof ParameterizedType) {
            ParameterizedType ptType = (ParameterizedType)genericType;
            Class genericClazz = (Class)ptType.getRawType();
            Type[] types = ptType.getActualTypeArguments();
            if (Map.class.isAssignableFrom(genericClazz)) {
                if (types.length == 2) {
                    genericParameterizedType.valueType = GenericParameterizedType.genericMapType(genericClazz, types[0], types[1]);
                }
            } else if (Collection.class.isAssignableFrom(genericClazz)) {
                if (types.length == 1) {
                    genericParameterizedType.valueType = GenericParameterizedType.genericCollectionType(genericClazz, types[0]);
                }
            } else if (genericClazz.isArray()) {
                Class<?> componentType = genericClazz.getComponentType();
                genericParameterizedType.valueType = GenericParameterizedType.entityType(genericClazz, componentType);
            } else if (types.length == 1) {
                try {
                    Class cls = (Class)types[0];
                    genericParameterizedType.valueType = GenericParameterizedType.entityType(genericClazz, cls);
                }
                catch (Throwable throwable) {}
            }
        } else if (genericType instanceof WildcardType) {
            genericParameterizedType.valueType = GenericParameterizedType.actualType(Object.class);
        }
    }

    public GenericParameterizedType copyAndReplaceActualType(Class<?> actualType) {
        GenericParameterizedType<T> genericParameterizedType = new GenericParameterizedType<T>();
        super.setActualType(actualType);
        genericParameterizedType.valueType = this.valueType;
        genericParameterizedType.mapKeyClass = this.mapKeyClass;
        genericParameterizedType.genericClass = this.genericClass;
        return genericParameterizedType;
    }

    public Class<?> getActualType() {
        return this.actualType;
    }

    public Class<?> getMapKeyClass() {
        return this.mapKeyClass;
    }

    public GenericParameterizedType getValueType() {
        return this.valueType;
    }

    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    public Class<?> getGenericClass(String genericName) {
        if (this.genericClass != null) {
            return this.genericClass;
        }
        if (this.genericClassMap != null) {
            return this.genericClassMap.get(genericName);
        }
        return null;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    void initParamClassType() {
        this.paramClassType = ReflectConsts.getParamClassType(this.actualType);
        this.paramClassNumberType = ReflectConsts.getParamClassNumberType(this.actualType);
    }

    public int getParamClassType() {
        return this.paramClassType;
    }

    public int getParamClassNumberType() {
        return this.paramClassNumberType;
    }

    public boolean isCamouflage() {
        return this.camouflage;
    }

    public String getGenericName() {
        return this.genericName;
    }

    public ReflectConsts.ClassCategory getActualClassCategory() {
        if (this.actualClassCategory != null) {
            return this.actualClassCategory;
        }
        this.actualClassCategory = ReflectConsts.getClassCategory(this.actualType);
        return this.actualClassCategory;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getDateTimezone() {
        return this.dateTimezone;
    }

    public void setDateTimezone(String dateTimezone) {
        this.dateTimezone = dateTimezone;
    }
}

