/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.ReflectConsts;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsafeHelper {
    private static final Unsafe unsafe;
    private static final Field stringValueField;
    private static final long stringValueOffset;
    private static final long stringCoderOffset;
    private static final long OVERRIDE_OFFSET;

    public static char[] getChars(String string) {
        if (stringCoderOffset > -1L) {
            return string.toCharArray();
        }
        string.getClass();
        return (char[])UnsafeHelper.getObjectValue(string, stringValueOffset);
    }

    public static long getStringCoderOffset() {
        return stringCoderOffset;
    }

    public static Object getStringValue(String source) {
        source.getClass();
        return UnsafeHelper.getObjectValue(source, stringValueOffset);
    }

    public static byte getStringCoder(String source) {
        source.getClass();
        if (stringCoderOffset > -1L) {
            return unsafe.getByte(source, stringCoderOffset);
        }
        throw new UnsupportedOperationException();
    }

    public static String getString(char[] buf) {
        if (stringCoderOffset > -1L) {
            return new String(buf);
        }
        buf.getClass();
        String result = new String();
        UnsafeHelper.putObjectValue(result, stringValueOffset, buf);
        return result;
    }

    public static void clearString(String value) {
        value.getClass();
        if (stringCoderOffset > -1L) {
            unsafe.putObject(value, stringValueOffset, new byte[0]);
            unsafe.putByte(value, stringCoderOffset, (byte)0);
        } else {
            unsafe.putObject(value, stringValueOffset, new char[0]);
        }
    }

    public static String getAsciiString(byte[] bytes) {
        if (stringCoderOffset > -1L) {
            bytes.getClass();
            String result = new String();
            UnsafeHelper.putObjectValue(result, stringValueOffset, bytes);
            return result;
        }
        return new String(bytes);
    }

    public static String getUTF16String(byte[] utf16Bytes) {
        if (stringCoderOffset > -1L) {
            utf16Bytes.getClass();
            String result = new String();
            unsafe.putObject(result, stringValueOffset, utf16Bytes);
            unsafe.putByte(result, stringCoderOffset, (byte)1);
            return result;
        }
        throw new UnsupportedOperationException();
    }

    public static Object toArray(Collection collection, Class<?> componentType) {
        collection.getClass();
        componentType.getClass();
        Object array = Array.newInstance(componentType, collection.size());
        int k = 0;
        if (unsafe != null) {
            ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
            if (primitiveType != null) {
                int base = primitiveType.arrayBaseOffset;
                int scale = primitiveType.arrayIndexScale;
                for (Object obj : collection) {
                    long valueOffset = base + scale * k++;
                    UnsafeHelper.putPrimitiveValue(array, valueOffset, obj, primitiveType);
                }
            } else {
                Object[] objects = (Object[])array;
                for (Object obj : collection) {
                    objects[k++] = obj;
                }
            }
        } else {
            for (Object obj : collection) {
                Array.set(array, k++, obj);
            }
        }
        return array;
    }

    public static Object arrayValueAt(Object arr, int index) {
        if (unsafe != null) {
            if (index == -1) {
                throw new ArrayIndexOutOfBoundsException(-1);
            }
            Class<?> arrCls = arr.getClass();
            if (!arrCls.isArray()) {
                throw new UnsupportedOperationException("Non array object do not support get value by index");
            }
            Class<?> componentType = arrCls.getComponentType();
            ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
            if (primitiveType != null) {
                int base = primitiveType.arrayBaseOffset;
                int scale = primitiveType.arrayIndexScale;
                long valueOffset = base + scale * index;
                return primitiveType.get(arr, valueOffset);
            }
            Object[] objects = (Object[])arr;
            return objects[index];
        }
        return Array.get(arr, index);
    }

    static Unsafe getUnsafe() {
        return unsafe;
    }

    static long objectFieldOffset(Field field) {
        if (unsafe != null) {
            return unsafe.objectFieldOffset(field);
        }
        return -1L;
    }

    static void putObjectValue(Object target, long fieldOffset, Object value) {
        target.getClass();
        unsafe.putObject(target, fieldOffset, value);
    }

    static Object getObjectValue(Object target, long fieldOffset) {
        target.getClass();
        return unsafe.getObject(target, fieldOffset);
    }

    static void putPrimitiveValue(Object target, long fieldOffset, Object value, ReflectConsts.PrimitiveType primitiveType) {
        primitiveType.put(target, fieldOffset, value);
    }

    static Object getPrimitiveValue(Object target, long fieldOffset, ReflectConsts.PrimitiveType primitiveType) {
        return primitiveType.get(target, fieldOffset);
    }

    public static boolean setAccessible(AccessibleObject accessibleObject) {
        if (OVERRIDE_OFFSET > -1L) {
            unsafe.putBoolean(accessibleObject, OVERRIDE_OFFSET, true);
            return true;
        }
        return false;
    }

    public static void setAccessibleList(AccessibleObject ... accessibleList) {
        for (AccessibleObject accessibleObject : accessibleList) {
            UnsafeHelper.setAccessible(accessibleObject);
        }
    }

    static int arrayBaseOffset(Class arrayCls) {
        if (unsafe != null) {
            return unsafe.arrayBaseOffset(arrayCls);
        }
        return -1;
    }

    static int arrayIndexScale(Class arrayCls) {
        if (unsafe != null) {
            return unsafe.arrayIndexScale(arrayCls);
        }
        return -1;
    }

    static {
        Field valueField;
        Field theUnsafeField = null;
        try {
            theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
        }
        catch (NoSuchFieldException exception) {
            theUnsafeField = null;
        }
        Unsafe instance = null;
        if (theUnsafeField != null) {
            try {
                instance = (Unsafe)theUnsafeField.get(null);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        unsafe = instance;
        long valueOffset = -1L;
        long coderOffset = -1L;
        try {
            valueField = String.class.getDeclaredField("value");
            UnsafeHelper.setAccessible(valueField);
            valueOffset = UnsafeHelper.objectFieldOffset(valueField);
            Object emptyValue = UnsafeHelper.getObjectValue("", valueOffset);
            if (!char[].class.isInstance(emptyValue)) {
                valueField = null;
                Field coderField = String.class.getDeclaredField("coder");
                coderOffset = UnsafeHelper.objectFieldOffset(coderField);
            }
        }
        catch (Exception e) {
            valueField = null;
        }
        stringValueField = valueField;
        stringValueOffset = valueOffset;
        stringCoderOffset = coderOffset;
        long overrideOffset = -1L;
        try {
            Field overrideField = AccessibleObject.class.getDeclaredField("override");
            overrideOffset = UnsafeHelper.objectFieldOffset(overrideField);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        OVERRIDE_OFFSET = overrideOffset;
    }
}

