/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.datasource;

import io.github.wycst.wast.jdbc.datasource.AbstractDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SimpleDataSource
extends AbstractDataSource {
    private String driverClass;
    private String jdbcUrl;
    private String username;
    private String password;
    private boolean driverCheckState;

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        try {
            Class.forName(driverClass);
            this.driverCheckState = true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.driverCheckState = false;
        }
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.username, this.password);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        this.checkDriverClassState();
        return DriverManager.getConnection(this.jdbcUrl, username, password);
    }

    private void checkDriverClassState() throws SQLException {
        if (!this.driverCheckState) {
            throw new SQLException("Driver class not specified or not available ");
        }
    }
}

