/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.entity;

import io.github.wycst.wast.common.idgenerate.providers.IdGenerator;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.annotations.Column;
import io.github.wycst.wast.jdbc.annotations.Id;
import io.github.wycst.wast.jdbc.entity.CascadeFetchMapping;
import io.github.wycst.wast.jdbc.entity.FieldColumn;
import io.github.wycst.wast.jdbc.entity.JoinColumn;
import io.github.wycst.wast.jdbc.entity.JoinEntityMapping;
import io.github.wycst.wast.jdbc.exception.OqlParematerException;
import io.github.wycst.wast.jdbc.oql.FieldCondition;
import io.github.wycst.wast.jdbc.oql.FieldOrder;
import io.github.wycst.wast.jdbc.oql.OqlQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySqlMapping {
    private final Class<?> entityClass;
    private final String tableName;
    private final Map<String, FieldColumn> fieldColumnMapping;
    private final FieldColumn primary;
    private Id.GenerationType generationType;
    private final Map<Class<?>, JoinEntityMapping> joinEntityMappings;
    private final List<CascadeFetchMapping> cascadeFetchMappings;
    private String selectSql;
    private String insertTemplate;
    private String deleteTemplate;
    private String updateTemplate;

    public EntitySqlMapping(Class<?> entityClass, String tableName, Map<String, FieldColumn> fieldColumnMapping, FieldColumn primary, Map<Class<?>, JoinEntityMapping> joinEntityMappings, List<CascadeFetchMapping> cascadeFetchMappings) {
        this.entityClass = entityClass;
        this.tableName = tableName;
        this.fieldColumnMapping = fieldColumnMapping;
        this.primary = primary;
        this.joinEntityMappings = joinEntityMappings;
        this.cascadeFetchMappings = cascadeFetchMappings;
        this.init();
    }

    public Map<Class<?>, JoinEntityMapping> getJoinEntityMappings() {
        return this.joinEntityMappings;
    }

    private String initDeleteTemplate() {
        return this.getDeleteTemplate("DELETE FROM %s WHERE %s = #{%s}");
    }

    String getSelectSql(Collection<String> queryFields) {
        return this.getSelectTemplate("SELECT %s FROM %s t %s WHERE t.%s = ?", queryFields);
    }

    public String getSelectTemplate(Collection<String> queryFields) {
        return this.getSelectTemplate("SELECT %s FROM %s t %s WHERE t.%s = #{%s}", queryFields);
    }

    private void appendQueryFieldColumn(String queryField, StringBuilder columnsBuffer) {
        FieldColumn fieldColumn = this.fieldColumnMapping.get(queryField);
        String columnName = fieldColumn.getColumnName();
        if (columnName.equals(queryField)) {
            columnsBuffer.append("t.").append(columnName).append(",");
        } else {
            columnsBuffer.append("t.").append(columnName).append(" as \"").append(queryField).append("\",");
        }
    }

    public String getSelectTemplate(String formatTemplate, Collection<String> queryFields) {
        if (this.primary == null) {
            return null;
        }
        StringBuilder columnsBuffer = new StringBuilder();
        int deleteDotIndex = -1;
        for (String queryField : queryFields) {
            if (!this.fieldColumnMapping.containsKey(queryField)) continue;
            this.appendQueryFieldColumn(queryField, columnsBuffer);
            deleteDotIndex = columnsBuffer.length() - 1;
        }
        StringBuilder onClause = new StringBuilder();
        if (this.joinEntityMappings != null && this.joinEntityMappings.size() > 0) {
            int i = 1;
            for (Map.Entry<Class<?>, JoinEntityMapping> entry : this.joinEntityMappings.entrySet()) {
                JoinEntityMapping joinEntityMapping = entry.getValue();
                List<JoinColumn> joinColumns = joinEntityMapping.getJoinColumns();
                String tableName = joinEntityMapping.getTableName();
                String tableAlias = "t" + i;
                for (JoinColumn joinColumn : joinColumns) {
                    String fieldName = joinColumn.getFieldName();
                    FieldColumn fieldColumn = joinColumn.getJoinFieldColumn();
                    columnsBuffer.append(tableAlias).append(".").append(fieldColumn.getColumnName()).append(" as \"").append(fieldName).append("\",");
                    deleteDotIndex = columnsBuffer.length() - 1;
                }
                Map<String, String> joinOnColumnKeys = joinEntityMapping.getJoinOnColumnKeys();
                if (joinOnColumnKeys.size() > 0) {
                    onClause.append(" left join ").append(tableName).append(" ").append(tableAlias).append(" on ");
                    int j = 0;
                    for (Map.Entry<String, String> columnKeyEntry : joinOnColumnKeys.entrySet()) {
                        String columnName = columnKeyEntry.getKey();
                        String joinColumnName = columnKeyEntry.getValue();
                        if (j++ > 0) {
                            onClause.append(" and ");
                        }
                        onClause.append("t.").append(columnName).append(" = ").append(tableAlias).append(".").append(joinColumnName);
                    }
                }
                ++i;
            }
        }
        if (deleteDotIndex > -1) {
            columnsBuffer.deleteCharAt(deleteDotIndex);
        }
        return StringUtils.replacePlaceholder(formatTemplate, "%s", columnsBuffer.toString(), this.tableName, onClause.toString(), this.primary.getColumnName(), this.primary.getField().getName());
    }

    public String getSelectTemplate(String selectTemplate, OqlQuery oqlQuery) {
        StringBuilder columnsBuffer = new StringBuilder();
        int deleteDotIndex = -1;
        boolean disableJoin = oqlQuery.isDisableJoin();
        Collection<String> selectFields = oqlQuery.getSelectFields();
        List<FieldCondition> fieldConditions = oqlQuery.getConditions();
        if (selectFields.size() == 0) {
            selectFields = this.fieldColumnMapping.keySet();
        }
        for (String queryField : selectFields) {
            if (!this.fieldColumnMapping.containsKey(queryField)) continue;
            this.appendQueryFieldColumn(queryField, columnsBuffer);
            deleteDotIndex = columnsBuffer.length() - 1;
        }
        StringBuilder onClause = new StringBuilder();
        if (!disableJoin && this.joinEntityMappings != null && this.joinEntityMappings.size() > 0) {
            int i = 1;
            for (Map.Entry<Class<?>, JoinEntityMapping> entry : this.joinEntityMappings.entrySet()) {
                JoinEntityMapping joinEntityMapping = entry.getValue();
                List<JoinColumn> joinColumns = joinEntityMapping.getJoinColumns();
                String tableName = joinEntityMapping.getTableName();
                String tableAlias = "t" + i;
                for (JoinColumn joinColumn : joinColumns) {
                    String fieldName = joinColumn.getFieldName();
                    FieldColumn fieldColumn = joinColumn.getJoinFieldColumn();
                    columnsBuffer.append(tableAlias).append(".").append(fieldColumn.getColumnName()).append(" as \"").append(fieldName).append("\",");
                    deleteDotIndex = columnsBuffer.length() - 1;
                }
                Map<String, String> joinOnColumnKeys = joinEntityMapping.getJoinOnColumnKeys();
                if (joinOnColumnKeys.size() > 0) {
                    onClause.append(" left join ").append(tableName).append(" ").append(tableAlias).append(" on ");
                    int j = 0;
                    for (Map.Entry<String, String> columnKeyEntry : joinOnColumnKeys.entrySet()) {
                        String columnName = columnKeyEntry.getKey();
                        String joinColumnName = columnKeyEntry.getValue();
                        if (j++ > 0) {
                            onClause.append(" and ");
                        }
                        onClause.append("t.").append(columnName).append(" = ").append(tableAlias).append(".").append(joinColumnName);
                    }
                }
                ++i;
            }
        }
        if (deleteDotIndex > -1) {
            columnsBuffer.deleteCharAt(deleteDotIndex);
        }
        StringBuilder whereBuffer = new StringBuilder();
        this.appendWhereClause(whereBuffer, fieldConditions);
        List<FieldOrder> orders = oqlQuery.getOrders();
        StringBuilder orderBuffer = new StringBuilder();
        boolean appendFlag = false;
        for (FieldOrder fieldOrder : orders) {
            String field = fieldOrder.getField();
            if (!this.fieldColumnMapping.containsKey(field)) continue;
            FieldColumn fieldColumn = this.fieldColumnMapping.get(field);
            if (appendFlag) {
                orderBuffer.append(",");
            } else {
                orderBuffer.append(" ORDER BY ");
                appendFlag = true;
            }
            orderBuffer.append("t.").append(fieldColumn.getColumnName()).append(" ").append((Object)fieldOrder.getOrder());
        }
        return StringUtils.replacePlaceholder(selectTemplate, "%s", columnsBuffer.toString(), this.tableName, onClause.toString(), whereBuffer.toString(), orderBuffer.toString());
    }

    public String getSelectTemplate(OqlQuery oqlQuery) {
        if (oqlQuery == null) {
            oqlQuery = OqlQuery.create();
        }
        String selectTemplate = "SELECT %s FROM %s t %s %s %s";
        return this.getSelectTemplate(selectTemplate, oqlQuery);
    }

    public String getUpdateTemplate(String updateTemplate, Collection<String> updateFields) {
        return this.getUpdateTemplate(updateTemplate, updateFields, false);
    }

    public String getUpdateTemplate(String updateTemplate, Collection<String> fields, boolean isExclude) {
        if (this.primary == null) {
            return null;
        }
        if (updateTemplate == null) {
            updateTemplate = "UPDATE %s SET %s WHERE %s = #{%s}";
        }
        Collection<String> updateFields = null;
        Set<String> fullFields = this.fieldColumnMapping.keySet();
        if (isExclude) {
            updateFields = new HashSet<String>(fullFields);
            if (fields != null) {
                updateFields.removeAll(fields);
            }
        } else {
            updateFields = fields == null || fields.size() == 0 ? fullFields : fields;
        }
        StringBuilder columnsBuffer = new StringBuilder();
        int deleteDotIndex = -1;
        for (String updateField : updateFields) {
            if (!this.fieldColumnMapping.containsKey(updateField) || updateField.equals(this.primary.getField().getName())) continue;
            FieldColumn fieldColumn = this.fieldColumnMapping.get(updateField);
            String placeholder = this.getPlaceholder(fieldColumn);
            columnsBuffer.append(fieldColumn.getColumnName()).append(" = ").append(placeholder).append(",");
            deleteDotIndex = columnsBuffer.length() - 1;
        }
        if (deleteDotIndex > -1) {
            columnsBuffer.deleteCharAt(deleteDotIndex);
        }
        return StringUtils.replacePlaceholder(updateTemplate, "%s", this.tableName, columnsBuffer.toString(), this.primary.getColumnName(), this.primary.getField().getName());
    }

    private String getPlaceholder(FieldColumn fieldColumn) {
        Column column = fieldColumn.getColumn();
        String placeholder = "#{" + fieldColumn.getField().getName() + "}";
        if (column != null && column.placeholder().trim().length() > 0) {
            String ph = column.placeholder().trim();
            placeholder = ph.replace("?", placeholder);
        }
        return placeholder;
    }

    public String getUpdateTemplate(Collection<String> updateFields) {
        String updateTemplate = "UPDATE %s SET %s WHERE %s = #{%s}";
        return this.getUpdateTemplate(updateTemplate, updateFields);
    }

    public String getInsertTemplate(Collection<String> insertFields) {
        String insertTemplate = "INSERT INTO %s(%s) VALUES(%s)";
        StringBuilder columnsNameBuffer = new StringBuilder();
        StringBuilder columnsValueBuffer = new StringBuilder();
        int deleteDotOfNameIndex = -1;
        int deleteDotOfValueIndex = -1;
        for (String queryField : insertFields) {
            if (!this.fieldColumnMapping.containsKey(queryField)) continue;
            FieldColumn fieldColumn = this.fieldColumnMapping.get(queryField);
            if (fieldColumn.isPrimary()) {
                Id.GenerationType type;
                Id id = fieldColumn.getId();
                this.generationType = type = id.strategy();
                if (type == Id.GenerationType.Identity) continue;
                if (type == Id.GenerationType.UUID) {
                    columnsNameBuffer.append(fieldColumn.getColumnName()).append(",");
                    columnsValueBuffer.append("'%s',");
                } else if (type == Id.GenerationType.AutoAlg) {
                    columnsNameBuffer.append(fieldColumn.getColumnName()).append(",");
                    Class<?> primaryType = fieldColumn.getField().getType();
                    if (primaryType == String.class) {
                        columnsValueBuffer.append("'%s',");
                    } else {
                        columnsValueBuffer.append("%d,");
                    }
                } else {
                    columnsNameBuffer.append(fieldColumn.getColumnName()).append(",");
                    columnsValueBuffer.append("#{").append(fieldColumn.getField().getName()).append("},");
                }
            } else {
                columnsNameBuffer.append(fieldColumn.getColumnName()).append(",");
                columnsValueBuffer.append("#{").append(fieldColumn.getField().getName()).append("},");
            }
            deleteDotOfNameIndex = columnsNameBuffer.length() - 1;
            deleteDotOfValueIndex = columnsValueBuffer.length() - 1;
        }
        if (deleteDotOfNameIndex > -1) {
            columnsNameBuffer.deleteCharAt(deleteDotOfNameIndex);
        }
        if (deleteDotOfValueIndex > -1) {
            columnsValueBuffer.deleteCharAt(deleteDotOfValueIndex);
        }
        return StringUtils.replacePlaceholder(insertTemplate, "%s", this.tableName, columnsNameBuffer.toString(), columnsValueBuffer.toString());
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSelectSql() {
        return this.selectSql;
    }

    public boolean isPrimaryCodeGenerate() {
        return this.generationType == Id.GenerationType.UUID || this.generationType == Id.GenerationType.AutoAlg;
    }

    public String getInsertTemplate() {
        if (this.generationType == Id.GenerationType.UUID) {
            return StringUtils.replacePlaceholder(this.insertTemplate, "%s", UUID.randomUUID().toString());
        }
        if (this.generationType == Id.GenerationType.AutoAlg) {
            Class<?> idType = this.primary.getField().getType();
            if (idType == String.class) {
                return StringUtils.replacePlaceholder(this.insertTemplate, "%s", IdGenerator.getInstance().generateHexString());
            }
            return StringUtils.replacePlaceholder(this.insertTemplate, "%s", IdGenerator.getInstance().generateId());
        }
        return this.insertTemplate;
    }

    public String getInsertTemplate(Object entity) {
        if (this.isPrimaryCodeGenerate()) {
            Object pk = null;
            Object sql = null;
            if (this.generationType == Id.GenerationType.UUID) {
                pk = UUID.randomUUID().toString();
            } else if (this.generationType == Id.GenerationType.AutoAlg) {
                Class<?> idType = this.primary.getField().getType();
                pk = idType == String.class ? IdGenerator.getInstance().generateHexString() : Long.valueOf(IdGenerator.getInstance().generateId());
            }
            if (entity != null) {
                this.primary.getField().setAccessible(true);
                try {
                    this.primary.getField().set(entity, pk);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return StringUtils.replacePlaceholder(this.insertTemplate, "%s", pk);
        }
        return this.insertTemplate;
    }

    public String getDeleteTemplate() {
        return this.deleteTemplate;
    }

    public String getUpdateTemplate() {
        return this.updateTemplate;
    }

    public String getUpdateTemplate(String sqlStringFormat) {
        if (sqlStringFormat == null) {
            return this.updateTemplate;
        }
        return this.getUpdateTemplate(sqlStringFormat, this.fieldColumnMapping.keySet());
    }

    public Map<String, FieldColumn> getFieldColumnMapping() {
        return this.fieldColumnMapping;
    }

    public FieldColumn getPrimary() {
        return this.primary;
    }

    public String getDeleteTemplate(String formatTemplate) {
        if (this.primary == null) {
            return null;
        }
        if (formatTemplate == null) {
            return this.deleteTemplate;
        }
        return StringUtils.replacePlaceholder(formatTemplate, "%s", this.tableName, this.primary.getColumnName(), this.primary.getField().getName());
    }

    public void init() {
        Set<String> fields = this.fieldColumnMapping.keySet();
        this.selectSql = this.getSelectSql(fields);
        this.updateTemplate = this.getUpdateTemplate(fields);
        this.insertTemplate = this.getInsertTemplate(fields);
        this.deleteTemplate = this.initDeleteTemplate();
    }

    public String getDeleteTemplateBy(Object params) {
        String deleteSql = "DELETE FROM %s%s";
        StringBuilder whereClause = new StringBuilder();
        if (params != null) {
            boolean isBeginer = true;
            Collection<String> fields = this.getParamsFields(params);
            for (String fieldName : fields) {
                if (!this.fieldColumnMapping.containsKey(fieldName)) {
                    throw new OqlParematerException("\u6761\u4ef6params\u4e2d\u5b58\u5728\u5b9e\u4f53\u7c7b\u4e2d\u672a\u5b9a\u4e49\u7684\u5c5e\u6027\u57df\uff1a " + fieldName);
                }
                if (isBeginer) {
                    whereClause.append(" WHERE ");
                } else {
                    whereClause.append(" AND ");
                }
                FieldColumn fieldColumn = this.fieldColumnMapping.get(fieldName);
                whereClause.append(fieldColumn.getColumnName()).append(" = ");
                whereClause.append("#{").append(fieldName).append("}");
                isBeginer = false;
            }
        }
        return StringUtils.replacePlaceholder(deleteSql, "%s", this.tableName, whereClause.toString());
    }

    private Collection<String> getParamsFields(Object params) {
        Collection<String> fields = null;
        if (params instanceof Map) {
            Map map = (Map)params;
            fields = map.keySet();
        } else {
            fields = ObjectUtils.getNonEmptyFields(params);
        }
        return fields;
    }

    public String getSelectTemplateBy(Object params) {
        OqlQuery oqlQuery = OqlQuery.create();
        if (params != null) {
            oqlQuery.addConditions(this.getParamsFields(params));
        }
        return this.getSelectTemplate(oqlQuery);
    }

    public String getCountTemplateBy(Object params) {
        OqlQuery oqlQuery = OqlQuery.create();
        if (params != null) {
            oqlQuery.addConditions(this.getParamsFields(params));
        }
        String countTemplate = "SELECT count(*) FROM %s t %s ";
        List<FieldCondition> fieldConditions = oqlQuery.getConditions();
        StringBuilder whereBuffer = new StringBuilder();
        this.appendWhereClause(whereBuffer, fieldConditions);
        return StringUtils.replacePlaceholder(countTemplate, "%s", this.tableName, whereBuffer.toString().trim());
    }

    private void appendWhereClause(StringBuilder whereBuffer, List<FieldCondition> fieldConditions) {
        boolean appendFlag = false;
        for (FieldCondition fieldCondition : fieldConditions) {
            String field = fieldCondition.getField();
            if (!this.fieldColumnMapping.containsKey(field)) continue;
            FieldColumn fieldColumn = this.fieldColumnMapping.get(field);
            if (appendFlag) {
                whereBuffer.append(" AND ");
            } else {
                whereBuffer.append(" WHERE ");
                appendFlag = true;
            }
            whereBuffer.append("t.").append(fieldColumn.getColumnName()).append(" ").append(fieldCondition.getOperator()).append(" ").append(fieldCondition.getValue());
        }
    }

    public String getSelectSqlByIds(Collection ids) {
        OqlQuery emptyQuery = OqlQuery.create();
        StringBuilder baseSelectSql = new StringBuilder(this.getSelectTemplate(emptyQuery).trim());
        baseSelectSql.append(" WHERE t.").append(this.primary.getColumnName()).append(" in (");
        int len = ids.size();
        while (len-- > 0) {
            baseSelectSql.append("?");
            if (len <= 0) continue;
            baseSelectSql.append(",");
        }
        baseSelectSql.append(")");
        return baseSelectSql.toString();
    }

    public List<CascadeFetchMapping> getCascadeFetchMappings() {
        return this.cascadeFetchMappings;
    }
}

