/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.beans.Date;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.entity.CascadeFetchMapping;
import io.github.wycst.wast.jdbc.entity.EntitySqlMapping;
import io.github.wycst.wast.jdbc.entity.FieldColumn;
import io.github.wycst.wast.jdbc.entity.SqlType;
import io.github.wycst.wast.jdbc.exception.EntityException;
import io.github.wycst.wast.jdbc.exception.OqlParematerException;
import io.github.wycst.wast.jdbc.exception.SqlExecuteException;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import io.github.wycst.wast.jdbc.executer.EntityManagementFactory;
import io.github.wycst.wast.jdbc.oql.OqlExecuter;
import io.github.wycst.wast.jdbc.oql.OqlQuery;
import io.github.wycst.wast.jdbc.query.page.Page;
import io.github.wycst.wast.jdbc.util.StreamCursor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityExecuter
implements OqlExecuter {
    private DefaultSqlExecuter sqlExecuter;

    EntityExecuter(DefaultSqlExecuter sqlExecuter) {
        this.sqlExecuter = sqlExecuter;
    }

    @Override
    public DefaultSqlExecuter getSqlExecuter() {
        return this.sqlExecuter;
    }

    @Override
    public <E> E get(Class<E> entityCls, Serializable id) {
        return this.get(entityCls, id, false);
    }

    @Override
    public <E> E get(Class<E> entityCls, Serializable id, boolean fetch) {
        id.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        E result = this.getById(entitySqlMapping, entityCls, id);
        if (fetch && result != null) {
            this.handleFetch(entitySqlMapping, result);
        }
        return result;
    }

    @Override
    public <E> List<E> queryAll(Class<E> cls) {
        return this.queryBy(cls, (E)null);
    }

    @Override
    public <E> E queryOne(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryOne(entityCls, params);
    }

    @Override
    public <E> E queryOne(Class<E> entityCls, E params) {
        return this.executeQueryOne(entityCls, params);
    }

    @Override
    public <E> long queryCount(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryCount(entityCls, params);
    }

    @Override
    public <E> long queryCount(Class<E> entityCls, E params) {
        return this.executeQueryCount(entityCls, params);
    }

    @Override
    public <E> E queryUnique(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryUnique(entityCls, params);
    }

    @Override
    public <E> E queryUnique(Class<E> entityCls, E params) {
        return this.executeQueryUnique(entityCls, params);
    }

    @Override
    public <E> List<E> queryList(Class<E> entityCls, OqlQuery query, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplate(query);
        return this.sqlExecuter.getTemplateExecutor().queryList(selectTemplate, params, entityCls);
    }

    @Override
    public <E> StreamCursor<E> queryStreamBy(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryStreamBy(entityCls, params);
    }

    @Override
    public <E> StreamCursor<E> queryStreamBy(Class<E> entityCls, E params) {
        return this.executeQueryStreamBy(entityCls, params);
    }

    @Override
    public <E> StreamCursor<E> queryStream(Class<E> entityCls, OqlQuery query, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplate(query);
        return this.sqlExecuter.getTemplateExecutor().queryStream(selectTemplate, params, entityCls);
    }

    @Override
    public <E> List<E> queryBy(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryBy(entityCls, params);
    }

    @Override
    public <E> List<E> queryBy(Class<E> entityCls, E params) {
        return this.executeQueryBy(entityCls, params);
    }

    @Override
    public <E> List<E> queryByIds(Class<E> entityCls, List<? extends Serializable> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectInSql = entitySqlMapping.getSelectSqlByIds(ids);
        return this.sqlExecuter.queryList(selectInSql, entityCls, ids.toArray());
    }

    @Override
    public <E> List<E> queryByIds(Class<E> entityCls, Serializable ... ids) {
        if (ids.length == 0) {
            return new ArrayList();
        }
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        List<Serializable> list = Arrays.asList(ids);
        String selectInSql = entitySqlMapping.getSelectSqlByIds(list);
        return this.sqlExecuter.queryList(selectInSql, entityCls, (Object[])ids);
    }

    @Override
    public <E> void queryPage(Page<E> page, OqlQuery query, Object params) {
        Class<E> entityCls = page.actualType();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplate(query);
        this.sqlExecuter.getTemplateExecutor().queryPage(page, selectTemplate, params);
    }

    @Override
    public <E> void queryPage(Page<E> page, Map<String, Object> params) {
        this.executeQueryPage(page, params);
    }

    @Override
    public <E> void queryPage(Page<E> page, E params) {
        this.executeQueryPage(page, params);
    }

    @Override
    public <E> Serializable insert(E entity) {
        Class<?> entityCls = entity.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String insertTemplate = entitySqlMapping.getInsertTemplate(entity);
        return this.sqlExecuter.getTemplateExecutor().insert(insertTemplate, true, entity);
    }

    @Override
    public <E> void insertList(List<E> entityList) {
        if (entityList.size() == 0) {
            return;
        }
        Class<?> entityCls = entityList.get(0).getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        if (entitySqlMapping.isPrimaryCodeGenerate()) {
            for (E entity : entityList) {
                String insertTemplate = entitySqlMapping.getInsertTemplate(entity);
                this.sqlExecuter.getTemplateExecutor().insert(insertTemplate, false, entity);
            }
        } else {
            String insertTemplate = entitySqlMapping.getInsertTemplate();
            this.sqlExecuter.getTemplateExecutor().updateCollection(insertTemplate, entityList);
        }
    }

    @Override
    public <E> int mysqlBatchInsert(List<E> entityList) {
        if (!this.isSupportBatchInsert()) {
            throw new SqlExecuteException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u6279\u91cf\u63d2\u5165");
        }
        if (entityList.size() == 0) {
            return 0;
        }
        Class<?> entityCls = entityList.get(0).getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        if (entitySqlMapping.isPrimaryCodeGenerate()) {
            for (E entity : entityList) {
                String insertTemplate = entitySqlMapping.getInsertTemplate(entity);
                this.sqlExecuter.getTemplateExecutor().insert(insertTemplate, false, entity);
            }
            return 0;
        }
        String insertTemplate = entitySqlMapping.getInsertTemplate();
        return this.sqlExecuter.getTemplateExecutor().mysqlBatchInsert(insertTemplate, entityList);
    }

    @Override
    public <E> int update(E entity) {
        Class<?> entityCls = entity.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlStringFormat = this.getSqlStringFormat(SqlType.UPDATE);
        String updateTemplate = entitySqlMapping.getUpdateTemplate(sqlStringFormat);
        if (updateTemplate == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        return this.sqlExecuter.getTemplateExecutor().update(updateTemplate, entity);
    }

    @Override
    public <E> int updateFields(E e, String ... fields) {
        return this.updateFields(e, Arrays.asList(fields), false);
    }

    @Override
    public <E> int updateFields(E entity, List<String> fields) {
        return this.updateFields(entity, fields, false);
    }

    @Override
    public <E> int updateFields(E entity, List<String> fields, boolean isExclude) {
        Class<?> entityCls = entity.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlStringFormat = this.getSqlStringFormat(SqlType.UPDATE);
        String updateTemplate = entitySqlMapping.getUpdateTemplate(sqlStringFormat, fields, isExclude);
        if (updateTemplate == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        return this.sqlExecuter.getTemplateExecutor().update(updateTemplate, entity);
    }

    @Override
    public <E> int deleteAll(Class<E> entityCls) {
        return this.deleteBy(entityCls, (Map<String, Object>)null);
    }

    @Override
    public <E> int delete(Class<E> entityCls, Serializable id) {
        return this.delete(entityCls, id, false);
    }

    @Override
    public <E> int delete(Class<E> entityCls, Serializable id, boolean cascade) {
        id.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlStringFormat = this.getSqlStringFormat(SqlType.DELETE);
        String deleteTemplate = null;
        deleteTemplate = entitySqlMapping.getDeleteTemplate(sqlStringFormat);
        if (deleteTemplate == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        if (cascade) {
            this.executeCascadeDelete(entitySqlMapping, id);
        }
        return this.sqlExecuter.getTemplateExecutor().delete(deleteTemplate, id);
    }

    @Override
    public <E> int deleteList(List<E> entityList) {
        if (entityList == null) {
            return 0;
        }
        int influenceRows = 0;
        for (E entity : entityList) {
            Class<?> entityCls = entity.getClass();
            this.checkEntityClass(entityCls);
            EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
            String sqlStringFormat = this.getSqlStringFormat(SqlType.DELETE);
            String deleteTemplate = null;
            deleteTemplate = entitySqlMapping.getDeleteTemplate(sqlStringFormat);
            if (deleteTemplate == null) {
                throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
            }
            influenceRows += this.sqlExecuter.getTemplateExecutor().delete(deleteTemplate, entity);
        }
        return influenceRows;
    }

    @Override
    public <E> int deleteByIds(Class<E> entityCls, List<Serializable> ids) {
        if (ids == null || ids.size() == 0) {
            return 0;
        }
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlStringFormat = this.getSqlStringFormat(SqlType.DELETE);
        String deleteTemplate = entitySqlMapping.getDeleteTemplate(sqlStringFormat);
        if (deleteTemplate == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        this.sqlExecuter.getTemplateExecutor().updateCollection(deleteTemplate, ids);
        return 0;
    }

    @Override
    public <E> int deleteByIds(Class<E> cls, Serializable ... ids) {
        return this.deleteByIds(cls, Arrays.asList(ids));
    }

    @Override
    public <E> int deleteBy(Class<E> entityCls, E params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String deleteTemplateBy = entitySqlMapping.getDeleteTemplateBy(params);
        return this.sqlExecuter.getTemplateExecutor().delete(deleteTemplateBy, params);
    }

    @Override
    public <E> int deleteBy(Class<E> entityCls, Map<String, Object> params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String deleteTemplateBy = entitySqlMapping.getDeleteTemplateBy(params);
        return this.sqlExecuter.getTemplateExecutor().delete(deleteTemplateBy, params);
    }

    @Override
    public <E> int deleteBy(Class<E> entityCls, OqlQuery query, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplate(query);
        List<E> entityList = this.sqlExecuter.getTemplateExecutor().queryList(selectTemplate, params, entityCls);
        int influenceRows = 0;
        String sqlStringFormat = this.getSqlStringFormat(SqlType.DELETE);
        String deleteTemplateById = entitySqlMapping.getDeleteTemplate(sqlStringFormat);
        if (deleteTemplateById == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        for (E entity : entityList) {
            influenceRows += this.sqlExecuter.getTemplateExecutor().delete(deleteTemplateById, entity);
        }
        return influenceRows;
    }

    @Override
    public <E> String reverseDeleteSQL(E entity) {
        this.checkEntityClass(entity.getClass());
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entity.getClass());
        return this.generateDeleteSql(entitySqlMapping, entity);
    }

    @Override
    public <E> String reverseInsertSQL(E entity) {
        this.checkEntityClass(entity.getClass());
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entity.getClass());
        return this.generateInsertSql(entitySqlMapping, entity);
    }

    void checkEntityClass(Class<?> entityCls) {
        entityCls.getClass();
        if (!EntityManagementFactory.defaultManagementFactory().existEntity(entityCls)) {
            throw new OqlParematerException("\u53c2\u6570\u9519\u8bef\uff1a" + entityCls + "\u6ca1\u6709\u7eb3\u5165\u5bf9\u8c61sql\u7ba1\u7406\uff0c\u8bf7\u68c0\u67e5\u5b9e\u4f53\u626b\u63cf\u914d\u7f6e");
        }
    }

    EntitySqlMapping getEntitySqlMapping(Class<?> entityCls) {
        return EntityManagementFactory.defaultManagementFactory().getEntitySqlMapping(entityCls);
    }

    void handleFetch(EntitySqlMapping entitySqlMapping, Object result) {
        List<CascadeFetchMapping> cascadeFetchMappings = entitySqlMapping.getCascadeFetchMappings();
        for (CascadeFetchMapping cascadeFetchMapping : cascadeFetchMappings) {
            if (!cascadeFetchMapping.isFetch()) continue;
            Map<String, Object> params = this.getCascadeFetchParams(cascadeFetchMapping, entitySqlMapping, result);
            if (params == null) {
                return;
            }
            Field fetchField = cascadeFetchMapping.getCascadeFetchField();
            int fieldTypeValue = cascadeFetchMapping.getFieldType();
            Class<?> targetEntityClass = cascadeFetchMapping.getTargetEntityClass();
            List<?> list = this.executeQueryBy(targetEntityClass, params);
            List<?> fetchFieldVal = null;
            if (fieldTypeValue == 1) {
                if (list.size() > 0) {
                    fetchFieldVal = list.get(0);
                }
            } else {
                fetchFieldVal = list;
            }
            if (fetchFieldVal == null) continue;
            fetchField.setAccessible(true);
            try {
                fetchField.set(result, fetchFieldVal);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    Map<String, Object> getCascadeFetchParams(CascadeFetchMapping cascadeFetchMapping, EntitySqlMapping entitySqlMapping, Object result) {
        String targetFieldName = cascadeFetchMapping.getTargetFieldName();
        String fieldName = cascadeFetchMapping.getFieldName();
        FieldColumn fieldColumn = entitySqlMapping.getFieldColumnMapping().get(fieldName);
        Field fetchField = cascadeFetchMapping.getCascadeFetchField();
        if (fieldColumn == null) {
            Class<?> clazz = entitySqlMapping.getEntityClass();
            throw new EntityException(" Entity Class " + clazz + " and field[" + fetchField.getName() + "] is AnnotationPresent @CascadeFetch, but field '" + fieldName + "' is not exist");
        }
        Field field = fieldColumn.getField();
        field.setAccessible(true);
        HashMap<String, Object> params = null;
        try {
            Object val = field.get(result);
            if (val != null) {
                params = new HashMap<String, Object>();
                params.put(targetFieldName, val);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return params;
    }

    <E> E getById(EntitySqlMapping entitySqlMapping, Class<E> entityCls, Serializable id) {
        String selectSql = entitySqlMapping.getSelectSql();
        if (selectSql == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        return this.sqlExecuter.queryObject(selectSql, entityCls, id);
    }

    <E> E executeQueryOne(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplateBy(params);
        return this.sqlExecuter.getTemplateExecutor().queryObject(selectTemplate, params, entityCls);
    }

    long executeQueryCount(Class<?> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String countTemplate = entitySqlMapping.getCountTemplateBy(params);
        return this.sqlExecuter.getTemplateExecutor().queryValue(countTemplate, params, Long.TYPE);
    }

    <E> E executeQueryUnique(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplateBy(params);
        return this.sqlExecuter.getTemplateExecutor().queryUniqueObject(selectTemplate, params, entityCls);
    }

    <E> StreamCursor<E> executeQueryStreamBy(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplateBy(params);
        return this.sqlExecuter.getTemplateExecutor().queryStream(selectTemplate, params, entityCls);
    }

    <E> List<E> executeQueryBy(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplateBy(params);
        return this.sqlExecuter.getTemplateExecutor().queryList(selectTemplate, params, entityCls);
    }

    <E> void executeQueryPage(Page<E> page, Object params) {
        Class<E> entityCls = page.actualType();
        this.checkEntityClass(entityCls);
        OqlQuery query = OqlQuery.create();
        query.addConditions(ObjectUtils.getNonEmptyFields(params));
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectTemplate = entitySqlMapping.getSelectTemplate(query);
        this.sqlExecuter.getTemplateExecutor().queryPage(page, selectTemplate, params);
    }

    String getSqlStringFormat(SqlType sqlType) {
        return this.sqlExecuter.sqlTemplates[sqlType.ordinal()];
    }

    void executeCascadeDelete(EntitySqlMapping entitySqlMapping, Serializable id) {
        List<CascadeFetchMapping> cascadeFetchMappings = entitySqlMapping.getCascadeFetchMappings();
        Class<?> clazz = entitySqlMapping.getEntityClass();
        Object result = this.getById(entitySqlMapping, clazz, id);
        for (CascadeFetchMapping cascadeFetchMapping : cascadeFetchMappings) {
            if (!cascadeFetchMapping.isCascade()) continue;
            Map<String, Object> params = this.getCascadeFetchParams(cascadeFetchMapping, entitySqlMapping, result);
            if (params == null) {
                return;
            }
            Class<?> entityClass = cascadeFetchMapping.getTargetEntityClass();
            EntitySqlMapping targetEntitySqlMapping = this.getEntitySqlMapping(entityClass);
            String deleteTemplateBy = targetEntitySqlMapping.getDeleteTemplateBy(params);
            this.sqlExecuter.getTemplateExecutor().delete(deleteTemplateBy, params);
        }
    }

    String generateDeleteSql(EntitySqlMapping entitySqlMapping, Object entity) {
        Object primaryValue;
        if (entity == null) {
            return null;
        }
        String template = "DELETE FROM `%s` WHERE %s = ";
        if (this.sqlExecuter.clickHouse) {
            template = "ALTER TABLE %s DELETE WHERE %s = ";
        }
        if ((primaryValue = ObjectUtils.get(entity, entitySqlMapping.getPrimary().getField().getName())) instanceof String) {
            primaryValue = "'" + primaryValue + "'";
        }
        String sql = StringUtils.replacePlaceholder(template, "%s", entitySqlMapping.getTableName(), entitySqlMapping.getPrimary().getColumnName());
        return sql + primaryValue;
    }

    private String generateInsertSql(EntitySqlMapping entitySqlMapping, Object entity) {
        if (entity == null) {
            return null;
        }
        String tmpSql = "INSERT INTO `%s` (%s) VALUES (%s)";
        StringBuffer columns = new StringBuffer();
        StringBuffer values = new StringBuffer();
        int index = 0;
        Map<String, FieldColumn> fieldColumnMapping = entitySqlMapping.getFieldColumnMapping();
        int columnLength = fieldColumnMapping.size();
        for (String fieldName : fieldColumnMapping.keySet()) {
            FieldColumn fieldColumn = fieldColumnMapping.get(fieldName);
            String columnName = fieldColumn.getColumnName();
            Object value = ObjectUtils.get(entity, fieldName);
            columns.append(columnName);
            if (value == null || value instanceof Number) {
                values.append(value);
            } else {
                if (value instanceof java.util.Date) {
                    value = new Date(((java.util.Date)value).getTime()).format();
                } else if (value instanceof String) {
                    value = ((String)value).replace("\\", "\\\\");
                    value = ((String)value).replace("\n", "\\n");
                    value = ((String)value).replace("\"", "\\\"");
                    value = ((String)value).replace("'", "\\'");
                }
                values.append("'").append(value).append("'");
            }
            if (++index >= columnLength) continue;
            columns.append(", ");
            values.append(", ");
        }
        return StringUtils.replacePlaceholder(tmpSql, "%s", entitySqlMapping.getTableName(), columns.toString(), values.toString());
    }

    public boolean isSupportBatchInsert() {
        return this.sqlExecuter.isSupportBatchInsert();
    }
}

