/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.jdbc.commands.SqlExecuteCall;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import io.github.wycst.wast.jdbc.query.page.Page;
import io.github.wycst.wast.jdbc.query.sql.Sql;
import io.github.wycst.wast.jdbc.util.SqlUtil;
import io.github.wycst.wast.jdbc.util.StreamCursor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateSqlExecuter {
    private DefaultSqlExecuter sqlExecuter;

    TemplateSqlExecuter(DefaultSqlExecuter sqlExecuter) {
        this.sqlExecuter = sqlExecuter;
    }

    public void updateCollection(String tmpSql, Collection<?> paramList) {
        Sql sqlObject = SqlUtil.getSqlObject(tmpSql, null);
        String sql = sqlObject.getFormalSql();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        for (Object target : paramList) {
            Object[] values = null;
            List<String> paramNames = sqlObject.getParamNames();
            values = paramNames.size() == 1 && (target instanceof CharSequence || target instanceof Number || target instanceof Boolean) ? new Object[]{target} : ObjectUtils.get(target, sqlObject.getParamNames());
            dataList.add(values);
        }
        this.sqlExecuter.updateCollection(sql, dataList);
    }

    public int mysqlBatchInsert(String tmpSql, Collection<?> paramList) {
        Sql sqlObject = SqlUtil.getSqlObject(tmpSql, null);
        String sql = sqlObject.getFormalSql().trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        String[] sqlFragments = sql.split("[Vv][Aa][Ll][Uu][Ee][Ss]");
        String placeholder = sqlFragments[1];
        StringBuffer batchSqlBuffer = new StringBuffer(sql);
        ArrayList<Object> dataList = new ArrayList<Object>();
        int i = 0;
        int len = paramList.size();
        for (Object target : paramList) {
            if (i++ > 0) {
                batchSqlBuffer.append(",").append(placeholder);
            }
            List<String> paramNames = sqlObject.getParamNames();
            Object[] values = ObjectUtils.get(target, sqlObject.getParamNames());
            dataList.addAll(Arrays.asList(values));
        }
        return this.sqlExecuter.update(batchSqlBuffer.toString(), dataList.toArray());
    }

    public int update(String tmpSql, Object paramObject) {
        Sql sqlObject = SqlUtil.getSqlObject(tmpSql, paramObject);
        return this.sqlExecuter.update(sqlObject.getFormalSql(), sqlObject.getParamValues());
    }

    public Serializable insert(String tmpSql, boolean returnGeneratedKeys, Object paramObject) {
        Sql sqlObject = SqlUtil.getSqlObject(tmpSql, paramObject);
        return this.sqlExecuter.insert(sqlObject.getFormalSql(), returnGeneratedKeys, sqlObject.getParamValues());
    }

    public int delete(String tmpSql, Object paramObject) {
        Sql sqlObject = SqlUtil.getSqlObject(tmpSql, paramObject);
        return this.sqlExecuter.update(sqlObject.getFormalSql(), sqlObject.getParamValues());
    }

    public Object queryValue(String tmpSql, Object paramObject) {
        Sql sqlObject = SqlUtil.getSqlObject(tmpSql, paramObject);
        return this.sqlExecuter.queryValue(sqlObject.getFormalSql(), sqlObject.getParamValues());
    }

    public <E> E queryValue(String tmpSql, Object paramObject, Class<E> valueClass) {
        Sql sqlObject = SqlUtil.getSqlObject(tmpSql, paramObject);
        return this.sqlExecuter.queryValue(sqlObject.getFormalSql(), valueClass, sqlObject.getParamValues());
    }

    public Map queryMap(String tmpSql, Object paramObject) {
        Sql sqlObject = SqlUtil.getSqlObject(tmpSql, paramObject);
        return this.sqlExecuter.queryMap(sqlObject.getFormalSql(), sqlObject.getParamValues());
    }

    public <E> E queryObject(String sql, Object paramObject, Class<E> cls) {
        Sql sqlObject = SqlUtil.getSqlObject(sql, paramObject);
        return this.sqlExecuter.queryObject(sqlObject.getFormalSql(), cls, sqlObject.getParamValues());
    }

    public <E> E queryUniqueObject(String sql, Object paramObject, Class<E> cls) {
        Sql sqlObject = SqlUtil.getSqlObject(sql, paramObject);
        return this.sqlExecuter.queryUniqueObject(sqlObject.getFormalSql(), cls, sqlObject.getParamValues());
    }

    public <E> List<E> queryList(String sql, Object paramObject, Class<E> cls) {
        Sql sqlObject = SqlUtil.getSqlObject(sql, paramObject);
        return this.sqlExecuter.queryList(sqlObject.getFormalSql(), cls, sqlObject.getParamValues());
    }

    public <E> StreamCursor<E> queryStream(String sql, Object paramObject, Class<E> cls) {
        Sql sqlObject = SqlUtil.getSqlObject(sql, paramObject);
        return this.sqlExecuter.queryStream(sqlObject.getFormalSql(), cls, sqlObject.getParamValues());
    }

    public <E> void queryPage(Page<E> page, String sql, Object paramObject) {
        Sql sqlObject = SqlUtil.getSqlObject(sql, paramObject);
        this.sqlExecuter.queryPage(page, sqlObject.getFormalSql(), sqlObject.getParamValues());
    }

    public <E> Page<E> queryPage(String sql, long pageNum, int limit, Object paramObject, Class<E> cls) {
        Sql sqlObject = SqlUtil.getSqlObject(sql, paramObject);
        return this.sqlExecuter.queryPage(sqlObject.getFormalSql(), pageNum, limit, cls, sqlObject.getParamValues());
    }

    public Page<Map> queryPage(String sql, long pageNum, int limit, Object paramObject) {
        return this.queryPage(sql, pageNum, limit, paramObject, Map.class);
    }

    public <E> void executePipelined(SqlExecuteCall<E> sqlExecuteCall) {
        this.sqlExecuter.executePipelined(sqlExecuteCall);
    }
}

