/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.oql;

import java.io.Serializable;

public class FieldCondition {
    private final String field;
    private final Operator operator;
    private String value;
    private String logicType = "and";

    public FieldCondition(String field, Operator ops, Serializable value) {
        this.field = field;
        Operator operator = this.operator = ops == null ? Operator.Equal : ops;
        if (value == null) {
            this.setValueExpr();
        } else if (value instanceof Number) {
            this.value = String.valueOf(value);
        } else if (value instanceof String) {
            this.value = ((String)((Object)value)).matches("#\\{.*?\\}") ? ((String)((Object)value)).trim() : "'" + ((String)((Object)value)).trim() + "'";
        }
    }

    private void setValueExpr() {
        this.value = this.operator == Operator.Like ? "'%${" + this.field + "}%'" : (this.operator == Operator.LeftLike ? "'%${" + this.field + "}'" : (this.operator == Operator.RightLike ? "'${" + this.field + "}%'" : "#{" + this.field + "}"));
    }

    public FieldCondition(String field, Operator ops) {
        this.field = field;
        this.operator = ops == null ? Operator.Equal : ops;
        this.setValueExpr();
    }

    public String getField() {
        return this.field;
    }

    public String getOperator() {
        switch (this.operator) {
            case Gt: {
                return ">";
            }
            case Lt: {
                return "<";
            }
            case Equal: {
                return "=";
            }
            case NotEqual: {
                return "!=";
            }
            case GtOrEqual: {
                return ">=";
            }
            case LtOrEqual: {
                return "<=";
            }
            case Like: {
                return "like";
            }
            case LeftLike: {
                return "like";
            }
            case RightLike: {
                return "like";
            }
        }
        return "=";
    }

    public String getLogicType() {
        return this.logicType;
    }

    public void setLogicType(String logicType) {
        this.logicType = logicType;
    }

    public String getValue() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        Like,
        LeftLike,
        RightLike,
        Gt,
        Lt,
        Equal,
        GtOrEqual,
        LtOrEqual,
        NotEqual;

    }
}

