/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.oql;

import io.github.wycst.wast.jdbc.oql.FieldCondition;
import io.github.wycst.wast.jdbc.oql.FieldOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OqlQuery {
    private final List<String> selectFields = new ArrayList<String>();
    private final List<FieldCondition> fieldConditions = new ArrayList<FieldCondition>();
    private final List<FieldOrder> orders = new ArrayList<FieldOrder>();
    private boolean disableJoin;

    private OqlQuery() {
    }

    public static OqlQuery create() {
        return new OqlQuery();
    }

    public OqlQuery order(String field) {
        this.order(field, FieldOrder.Order.ASC);
        return this;
    }

    public OqlQuery order(String field, FieldOrder.Order by) {
        this.orders.add(new FieldOrder(field, by));
        return this;
    }

    public void clearSelectFields() {
        this.selectFields.clear();
    }

    public void clearConditions() {
        this.fieldConditions.clear();
    }

    private void clearOrders() {
        this.orders.clear();
    }

    public void clear() {
        this.clearSelectFields();
        this.clearConditions();
        this.clearOrders();
    }

    public OqlQuery addSelectFields(String ... fields) {
        for (String field : fields) {
            if (this.selectFields.contains(field)) continue;
            this.selectFields.add(field);
        }
        return this;
    }

    public OqlQuery addConditions(String ... fields) {
        for (String field : fields) {
            this.addCondition(field, FieldCondition.Operator.Equal);
        }
        return this;
    }

    public OqlQuery addConditions(Collection<String> fields) {
        for (String field : fields) {
            this.addCondition(field, FieldCondition.Operator.Equal);
        }
        return this;
    }

    public OqlQuery addCondition(String field, FieldCondition.Operator ops, Serializable value) {
        this.fieldConditions.add(new FieldCondition(field, ops, value));
        return this;
    }

    public OqlQuery addCondition(String field, FieldCondition.Operator ops) {
        this.fieldConditions.add(new FieldCondition(field, ops));
        return this;
    }

    public OqlQuery clearConditions(String ... fields) {
        FieldCondition[] conditions = this.fieldConditions.toArray(new FieldCondition[this.fieldConditions.size()]);
        List<String> fieldList = Arrays.asList(fields);
        for (FieldCondition fieldCondition : conditions) {
            if (!fieldList.contains(fieldCondition.getField())) continue;
            this.fieldConditions.remove(fieldCondition);
        }
        return this;
    }

    public boolean isDisableJoin() {
        return this.disableJoin;
    }

    public void setDisableJoin(boolean disableJoin) {
        this.disableJoin = disableJoin;
    }

    public OqlQuery disableJoin() {
        this.disableJoin = true;
        return this;
    }

    public OqlQuery fetchJoin() {
        this.disableJoin = false;
        return this;
    }

    public List<String> getSelectFields() {
        return this.selectFields;
    }

    public List<FieldCondition> getConditions() {
        return this.fieldConditions;
    }

    public List<FieldOrder> getOrders() {
        return this.orders;
    }
}

