/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.query;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.commands.ResultSetCommand;
import io.github.wycst.wast.jdbc.query.StreamCursorImpl;
import io.github.wycst.wast.jdbc.util.StreamCursor;
import io.github.wycst.wast.log.Log;
import io.github.wycst.wast.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecutor {
    private Log log = LogFactory.getLog(QueryExecutor.class);

    public <E> E queryObject(final Class<E> cls, PreparedStatement statement) throws SQLException {
        return this.executeQuery(statement, new ResultSetCommand<E>(){

            @Override
            public E doResultSet(ResultSet resultSet, ResultSetMetaData rsmd) throws Exception {
                Object result = null;
                if (resultSet.next()) {
                    result = QueryExecutor.this.parseResultSet(resultSet, rsmd, cls);
                }
                return result;
            }
        });
    }

    public <E> List<E> queryList(final Class<E> cls, PreparedStatement statement) throws SQLException {
        return (List)this.executeQuery(statement, new ResultSetCommand<List<E>>(){

            @Override
            public List<E> doResultSet(ResultSet resultSet, ResultSetMetaData rsmd) throws Exception {
                ArrayList<Object> collection = new ArrayList<Object>();
                while (resultSet.next()) {
                    Object e = QueryExecutor.this.parseResultSet(resultSet, rsmd, cls);
                    collection.add(e);
                }
                return collection;
            }
        });
    }

    public <E> E queryUniqueObject(final Class<E> cls, PreparedStatement statement) throws SQLException {
        return this.executeQuery(statement, new ResultSetCommand<E>(){

            @Override
            public E doResultSet(ResultSet resultSet, ResultSetMetaData rsmd) throws Exception {
                resultSet.last();
                int row = resultSet.getRow();
                if (row > 1) {
                    throw new SQLException("\u671f\u671b\u8fd4\u56de1\u4e2a\u8bb0\u5f55\uff0c\u5b9e\u9645\u8fd4\u56de\u4e86" + row + "\u4e2a\u8bb0\u5f55");
                }
                if (row == 0) {
                    return null;
                }
                return QueryExecutor.this.parseResultSet(resultSet, rsmd, cls);
            }
        });
    }

    private <E> E executeQuery(PreparedStatement statement, ResultSetCommand<E> command) throws SQLException {
        ResultSet resultSet = null;
        try {
            E result;
            resultSet = statement.executeQuery();
            ResultSetMetaData rsmd = resultSet.getMetaData();
            E e = result = command.doResultSet(resultSet, rsmd);
            return e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    <E> Object parseResultSet(ResultSet resultSet, ResultSetMetaData rsmd, Class<E> cls) throws Exception {
        boolean isMap = false;
        Map mapData = null;
        Object instance = null;
        ClassStructureWrapper classStructureWrapper = null;
        if (Map.class.isAssignableFrom(cls)) {
            isMap = true;
            mapData = cls.isInterface() ? new LinkedHashMap() : (Map)cls.newInstance();
        } else {
            classStructureWrapper = ClassStructureWrapper.get(cls);
            instance = classStructureWrapper.newInstance();
        }
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String fieldName = rsmd.getColumnLabel(i).trim();
            int columnType = rsmd.getColumnType(i);
            Object fieldValue = this.getColumnValue(resultSet, columnType, i);
            if (isMap) {
                mapData.put(fieldName, fieldValue);
                continue;
            }
            if (classStructureWrapper == null) continue;
            SetterInfo setterInfo = classStructureWrapper.getSetterInfo(fieldName);
            if (setterInfo == null) {
                String camelCase = StringUtils.getCamelCase(fieldName);
                setterInfo = classStructureWrapper.getSetterInfo(camelCase);
            }
            if (setterInfo != null) {
                setterInfo.invoke(instance, ObjectUtils.toType(fieldValue, setterInfo.getParameterType(), setterInfo.getGenericParameterizedType().getActualClassCategory()));
                continue;
            }
            if (!fieldName.matches("(\\w|[$\u00a5])+([.](\\w|[$\u00a5])+)+")) continue;
            this.parseObjectField(fieldName, fieldValue, instance, classStructureWrapper);
        }
        return isMap ? mapData : instance;
    }

    private void parseObjectField(String fieldName, Object fieldValue, Object instance, ClassStructureWrapper classWrapper) throws Exception {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            SetterInfo setterInfo = classWrapper.getSetterInfo(fieldName);
            if (setterInfo != null) {
                setterInfo.invoke(instance, ObjectUtils.toType(fieldValue, setterInfo.getParameterType(), setterInfo.getGenericParameterizedType().getActualClassCategory()));
            }
        } else {
            String topFieldName = fieldName.substring(0, dotIndex);
            String nextFieldName = fieldName.substring(dotIndex + 1);
            SetterInfo setterInfo = classWrapper.getSetterInfo(topFieldName);
            if (setterInfo != null) {
                Class<?> parameterType = setterInfo.getParameterType();
                ReflectConsts.ClassCategory classCategory = setterInfo.getGenericParameterizedType().getActualClassCategory();
                if (classCategory != ReflectConsts.ClassCategory.ObjectCategory && classCategory != ReflectConsts.ClassCategory.MapCategory) {
                    return;
                }
                Object target = null;
                GetterInfo getterInfo = classWrapper.getGetterInfo(topFieldName);
                if (getterInfo != null) {
                    target = getterInfo.invoke(instance);
                    if (target == null) {
                        target = Map.class == parameterType ? new HashMap() : parameterType.newInstance();
                        setterInfo.invoke(instance, target);
                    }
                    if (target instanceof Map) {
                        Map targetMap = (Map)target;
                        targetMap.put(nextFieldName, fieldValue);
                    } else if (parameterType.isInstance(target)) {
                        ClassStructureWrapper nextClassStructureWrapper = ClassStructureWrapper.get(parameterType);
                        this.parseObjectField(nextFieldName, fieldValue, target, nextClassStructureWrapper);
                    }
                }
            }
        }
    }

    public <E> E queryValue(final Class<E> valueClass, PreparedStatement statement) throws SQLException {
        return this.executeQuery(statement, new ResultSetCommand<E>(){

            @Override
            public E doResultSet(ResultSet resultSet, ResultSetMetaData rsmd) throws Exception {
                resultSet.last();
                int row = resultSet.getRow();
                if (row > 1) {
                    throw new SQLException("Expected to return 1 record, but actually returned " + row + " record");
                }
                if (row == 0) {
                    return null;
                }
                int columnCount = rsmd.getColumnCount();
                if (columnCount > 1) {
                    throw new SQLException("Expected to return 1 column, but actually returned " + columnCount + " column, please call queryObject ");
                }
                int columnIndex = 1;
                int columnType = rsmd.getColumnType(columnIndex);
                Object columnValue = QueryExecutor.this.getColumnValue(resultSet, columnType, columnIndex);
                if (valueClass == null) {
                    return columnValue;
                }
                return ObjectUtils.toType(columnValue, valueClass);
            }
        });
    }

    Object getColumnValue(ResultSet resultSet, int columnType, int columnIndex) throws SQLException {
        Object fieldValue;
        switch (columnType) {
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                fieldValue = resultSet.getString(columnIndex);
                break;
            }
            case 2: 
            case 3: {
                fieldValue = resultSet.getBigDecimal(columnIndex);
                break;
            }
            case -7: {
                fieldValue = resultSet.getBoolean(columnIndex);
                break;
            }
            case -6: {
                fieldValue = resultSet.getByte(columnIndex);
                break;
            }
            case 5: {
                fieldValue = resultSet.getShort(columnIndex);
                break;
            }
            case 4: {
                fieldValue = resultSet.getInt(columnIndex);
                break;
            }
            case -5: {
                fieldValue = resultSet.getLong(columnIndex);
                break;
            }
            case 7: {
                fieldValue = Float.valueOf(resultSet.getFloat(columnIndex));
                break;
            }
            case 6: 
            case 8: {
                fieldValue = resultSet.getDouble(columnIndex);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                fieldValue = resultSet.getBytes(columnIndex);
                break;
            }
            case 91: {
                fieldValue = resultSet.getDate(columnIndex);
                break;
            }
            case 92: {
                fieldValue = resultSet.getTime(columnIndex);
                break;
            }
            case 93: {
                fieldValue = resultSet.getTimestamp(columnIndex);
                break;
            }
            default: {
                fieldValue = resultSet.getObject(columnIndex);
            }
        }
        return fieldValue;
    }

    public <E> StreamCursor<E> queryStreamCursor(Class<E> cls, PreparedStatement statement, Connection conn) throws SQLException {
        try {
            ResultSet resultSet = statement.executeQuery();
            ResultSetMetaData rsmd = resultSet.getMetaData();
            return new StreamCursorImpl<E>(resultSet, rsmd, cls, conn, this);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage(), throwable);
        }
    }
}

