/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.query;

import io.github.wycst.wast.jdbc.exception.SqlExecuteException;
import io.github.wycst.wast.jdbc.query.QueryExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetIterator<E>
implements Iterator {
    private final ResultSetMetaData rsmd;
    private ResultSet resultSet;
    private Class<E> entityClass;
    private Connection connection;
    private QueryExecutor queryExecutor;
    private boolean isClosed = false;

    ResultSetIterator(ResultSet resultSet, ResultSetMetaData rsmd, Class<E> cls, Connection connection, QueryExecutor queryExecutor) {
        this.resultSet = resultSet;
        this.rsmd = rsmd;
        this.entityClass = cls;
        this.connection = connection;
        this.queryExecutor = queryExecutor;
    }

    @Override
    public boolean hasNext() {
        this.checkConnection();
        try {
            boolean hasNext = this.resultSet.next();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }
        catch (SQLException throwables) {
            this.close();
            return false;
        }
    }

    private void checkConnection() {
        if (this.isClosed) {
            throw new UnsupportedOperationException(" connection is closed ");
        }
    }

    public void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.resultSet = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
        this.isClosed = true;
    }

    @Override
    public E next() {
        this.checkConnection();
        try {
            return (E)this.queryExecutor.parseResultSet(this.resultSet, this.rsmd, this.entityClass);
        }
        catch (Exception e) {
            this.close();
            throw new SqlExecuteException(e.getMessage(), e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

