/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.AsciiStringSource;
import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.UTF16ByteArraySource;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.json.JSONByteArrayParser;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONReader;
import io.github.wycst.wast.json.JSONStringWriter;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONValidator;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.options.JsonConfig;
import io.github.wycst.wast.json.options.Options;
import io.github.wycst.wast.json.options.ReadOption;
import io.github.wycst.wast.json.options.WriteOption;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSON
extends JSONGeneral {
    public static Object parse(String json, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        return JSONDefaultParser.parse(json, readOptions);
    }

    public static Map parseMap(String json, Class<? extends Map> mapCls, ReadOption ... readOptions) {
        return JSONDefaultParser.parseMap(json, mapCls, readOptions);
    }

    public static Collection parseCollection(String json, Class<? extends Collection> collectionCls, ReadOption ... readOptions) {
        return JSONDefaultParser.parseCollection(json, collectionCls, readOptions);
    }

    public static Object parse(char[] buf, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(buf, readOptions);
    }

    public static Object parse(byte[] bytes, ReadOption ... readOptions) {
        if (bytes == null) {
            return null;
        }
        return JSONDefaultParser.parseBytes(bytes, readOptions);
    }

    public static Object parse(String json, Class<?> actualType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        if (JDK_9_ABOVE) {
            byte code = UnsafeHelper.getStringCoder(json);
            if (code == 0) {
                if (json.length() < 8192) {
                    return JSON.parse(null, JSON.getChars(json), actualType, null, readOptions);
                }
                AsciiStringSource charSource = AsciiStringSource.of(json);
                return JSON.parse((CharSource)charSource, charSource.byteArray(), actualType, null, readOptions);
            }
            char[] chars = JSON.getChars(json);
            return JSON.parse((CharSource)UTF16ByteArraySource.of(json, chars), chars, actualType, null, readOptions);
        }
        return JSON.parse(null, JSON.getChars(json), actualType, null, readOptions);
    }

    public static <T> T parseObject(String json, Class<T> actualType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (typeDeserializer == JSONTypeDeserializer.MAP) {
            Map map = JSONDefaultParser.parseMap(json, actualType, readOptions);
            return (T)map;
        }
        if (JDK_9_ABOVE) {
            byte code = UnsafeHelper.getStringCoder(json);
            if (code == 0) {
                if (json.length() < 8192) {
                    return JSON.parseObject(typeDeserializer, null, JSON.getChars(json), actualType, readOptions);
                }
                AsciiStringSource charSource = AsciiStringSource.of(json);
                return JSON.parseObject(typeDeserializer, (CharSource)charSource, charSource.byteArray(), actualType, readOptions);
            }
            char[] chars = JSON.getChars(json);
            return JSON.parseObject(typeDeserializer, (CharSource)UTF16ByteArraySource.of(json, chars), chars, actualType, readOptions);
        }
        return JSON.parseObject(typeDeserializer, null, JSON.getChars(json), actualType, readOptions);
    }

    public static <T> T parseObject(char[] buf, Class<T> actualType, ReadOption ... readOptions) {
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        return JSON.parseObject(typeDeserializer, null, buf, actualType, readOptions);
    }

    public static <T> T parseObject(byte[] buf, Class<T> actualType, ReadOption ... readOptions) {
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        return JSON.parseObject(typeDeserializer, null, buf, actualType, readOptions);
    }

    private static <T> T parseObject(final JSONTypeDeserializer deserializer, final CharSource charSource, char[] buf, final Class<T> actualType, ReadOption[] readOptions) {
        return (T)JSON.deserialize(buf, new Deserializer(){

            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                GenericParameterizedType genericParameterizedType = deserializer.getGenericParameterizedType();
                if (genericParameterizedType == null) {
                    genericParameterizedType = GenericParameterizedType.actualType(actualType);
                }
                return deserializer.deserialize(charSource, buf, fromIndex, toIndex, genericParameterizedType, null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static <T> T parseObject(final JSONTypeDeserializer deserializer, final CharSource charSource, byte[] buf, final Class<T> actualType, ReadOption[] readOptions) {
        return (T)JSON.deserialize(buf, new Deserializer(){

            Object deserialize(byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                GenericParameterizedType genericParameterizedType = deserializer.getGenericParameterizedType();
                if (genericParameterizedType == null) {
                    genericParameterizedType = GenericParameterizedType.actualType(actualType);
                }
                return deserializer.deserialize(charSource, buf, fromIndex, toIndex, genericParameterizedType, null, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    public static <T> T parseObject(String json, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        return JSON.parseObject(JSON.getChars(json), genericParameterizedType, readOptions);
    }

    public static <T> T parseObject(char[] buf, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return JSON.parse(buf, genericParameterizedType, readOptions);
    }

    public static <T> T parse(String json, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        byte code;
        if (json == null) {
            return null;
        }
        if (JDK_9_ABOVE && (code = UnsafeHelper.getStringCoder(json)) == 1) {
            char[] chars = JSON.getChars(json);
            return JSON.parse((CharSource)UTF16ByteArraySource.of(json, chars), chars, genericParameterizedType, readOptions);
        }
        return JSON.parse(JSON.getChars(json), genericParameterizedType, readOptions);
    }

    public static <T> T parse(char[] buf, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return JSON.parse(null, buf, genericParameterizedType, readOptions);
    }

    private static <T> T parse(final CharSource charSource, char[] buf, final GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return (T)JSON.deserialize(buf, new Deserializer(){

            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                ReflectConsts.ClassCategory classCategory = genericParameterizedType.getActualClassCategory();
                return JSONTypeDeserializer.TYPE_DESERIALIZERS[classCategory.ordinal()].deserialize(charSource, buf, fromIndex, toIndex, genericParameterizedType, null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    public static <T> List<T> parseArray(String json, Class<T> actualType, ReadOption ... readOptions) {
        byte code;
        if (json == null) {
            return null;
        }
        if (JDK_9_ABOVE && (code = UnsafeHelper.getStringCoder(json)) == 1) {
            char[] chars = JSON.getChars(json);
            return JSON.parseArray(UTF16ByteArraySource.of(json, chars), chars, actualType, readOptions);
        }
        return JSON.parseArray(JSON.getChars(json), actualType, readOptions);
    }

    public static <T> List<T> parseArray(char[] buf, Class<T> actualType, ReadOption ... readOptions) {
        return JSON.parseArray(null, buf, actualType, readOptions);
    }

    private static <T> List<T> parseArray(final CharSource charSource, char[] buf, final Class<T> actualType, ReadOption ... readOptions) {
        return (List)JSON.deserialize(buf, new Deserializer(){

            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                return JSONTypeDeserializer.COLLECTION.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    public static Object parse(char[] buf, Class<?> actualType, ReadOption ... readOptions) {
        return JSON.parse(null, buf, 0, buf.length, actualType, null, readOptions);
    }

    public static Object parse(char[] buf, int fromIndex, int toIndex, Class<?> actualType, ReadOption ... readOptions) {
        return JSON.parse(null, buf, fromIndex, toIndex, actualType, null, readOptions);
    }

    public static Object parse(byte[] buf, Class<?> actualType, ReadOption ... readOptions) {
        return JSON.parse(null, buf, actualType, null, readOptions);
    }

    private static Object parse(CharSource charSource, char[] buf, Class<?> actualType, Object defaultValue, ReadOption ... readOptions) {
        return JSON.parse(charSource, buf, 0, buf.length, actualType, defaultValue, readOptions);
    }

    private static Object parse(final CharSource charSource, char[] buf, int fromIndex, int toIndex, final Class<?> actualType, final Object defaultValue, ReadOption ... readOptions) {
        return JSON.deserialize(buf, fromIndex, toIndex, new Deserializer(){

            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                char beginChar = buf[fromIndex];
                switch (beginChar) {
                    case '[': {
                        return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, toIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), defaultValue == null ? new ArrayList() : defaultValue, jsonParseContext);
                    }
                }
                JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
                GenericParameterizedType type = typeDeserializer.getGenericParameterizedType();
                if (type == null) {
                    type = GenericParameterizedType.actualType(actualType);
                }
                return typeDeserializer.deserialize(charSource, buf, fromIndex, toIndex, type, defaultValue, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static Object parse(final CharSource charSource, byte[] buf, final Class<?> actualType, final Object defaultValue, ReadOption ... readOptions) {
        return JSON.deserialize(buf, new Deserializer(){

            Object deserialize(byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                byte beginByte = buf[fromIndex];
                switch (beginByte) {
                    case 91: {
                        return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, toIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), defaultValue == null ? new ArrayList() : defaultValue, jsonParseContext);
                    }
                }
                JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
                GenericParameterizedType type = typeDeserializer.getGenericParameterizedType();
                if (type == null) {
                    type = GenericParameterizedType.actualType(actualType);
                }
                return typeDeserializer.deserialize(charSource, buf, fromIndex, toIndex, type, defaultValue, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    public static Object parseToObject(String json, Object instance, ReadOption ... readOptions) {
        byte code;
        if (instance == null || json == null) {
            return null;
        }
        if (JDK_9_ABOVE && (code = UnsafeHelper.getStringCoder(json)) == 1) {
            char[] chars = JSON.getChars(json);
            return JSON.parseToObject(UTF16ByteArraySource.of(json, chars), chars, instance, readOptions);
        }
        return JSON.parseToObject(null, JSON.getChars(json), instance, readOptions);
    }

    private static Object parseToObject(final CharSource charSource, char[] buf, final Object instance, ReadOption ... readOptions) {
        return JSON.deserialize(buf, new Deserializer(){

            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                if (instance instanceof Map) {
                    return JSONTypeDeserializer.MAP.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.DefaultMap, instance, '\u0000', jsonParseContext);
                }
                return JSONTypeDeserializer.OBJECT.deserializeObject(charSource, buf, fromIndex, toIndex, GenericParameterizedType.actualType(instance.getClass()), instance, jsonParseContext);
            }
        }, readOptions);
    }

    public static <E> Object parseToList(String json, Collection instance, Class<E> actualType, ReadOption ... readOptions) {
        byte code;
        if (instance == null || json == null) {
            return null;
        }
        if (JDK_9_ABOVE && (code = UnsafeHelper.getStringCoder(json)) == 1) {
            char[] chars = JSON.getChars(json);
            return JSON.parseToList(UTF16ByteArraySource.of(json, chars), chars, instance, actualType, readOptions);
        }
        return JSON.parseToList(null, JSON.getChars(json), instance, actualType, readOptions);
    }

    private static <E> Object parseToList(final CharSource charSource, char[] buf, final Collection instance, final Class<E> actualType, ReadOption ... readOptions) {
        return JSON.deserialize(buf, new Deserializer(){

            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, toIndex, GenericParameterizedType.collectionType(instance.getClass(), actualType), (Object)instance, jsonParseContext);
            }
        }, readOptions);
    }

    private static Object deserialize(char[] buf, Deserializer deserializer, ReadOption ... readOptions) {
        return JSON.deserialize(buf, 0, buf.length, deserializer, readOptions);
    }

    private static Object deserialize(char[] buf, int fromIndex, int toIndex, Deserializer deserializer, ReadOption ... readOptions) {
        char beginChar = '\u0000';
        while (fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' ') {
            ++fromIndex;
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        Options.readOptions(readOptions, jsonParseContext);
        try {
            boolean allowComment = jsonParseContext.isAllowComment();
            if (allowComment && beginChar == '/') {
                fromIndex = JSON.clearCommentAndWhiteSpaces(buf, fromIndex + 1, toIndex, jsonParseContext);
            }
            Object result = deserializer.deserialize(buf, fromIndex, toIndex, jsonParseContext);
            int endIndex = jsonParseContext.getEndIndex();
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSON.clearCommentAndWhiteSpaces(buf, endIndex + 1, toIndex, jsonParseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex);
                throw new JSONException("Syntax error, at pos " + endIndex + " extra characters found, '" + new String(buf, endIndex, wordNum) + " ...'");
            }
            Object object = result;
            Object var12_14 = null;
            jsonParseContext.clear();
            return object;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof JSONException) {
                    throw (JSONException)ex;
                }
                if (ex instanceof IndexOutOfBoundsException) {
                    String errorContextTextAt = JSON.createErrorContextText(buf, toIndex);
                    throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.");
                }
                throw new JSONException("Error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                jsonParseContext.clear();
                throw throwable;
            }
        }
    }

    private static Object deserialize(byte[] buf, Deserializer deserializer, ReadOption ... readOptions) {
        int fromIndex;
        int toIndex = buf.length;
        byte beginByte = 0;
        for (fromIndex = 0; fromIndex < toIndex && (beginByte = buf[fromIndex]) <= 32; ++fromIndex) {
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= 32) {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        Options.readOptions(readOptions, jsonParseContext);
        try {
            boolean allowComment = jsonParseContext.isAllowComment();
            if (allowComment && beginByte == 47) {
                fromIndex = JSONByteArrayParser.clearComments(buf, fromIndex + 1, toIndex, jsonParseContext);
            }
            Object result = deserializer.deserialize(buf, fromIndex, toIndex, jsonParseContext);
            int endIndex = jsonParseContext.getEndIndex();
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSONByteArrayParser.clearComments(buf, endIndex + 1, toIndex, jsonParseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex);
                throw new JSONException("Syntax error, at pos " + endIndex + " extra characters found, '" + new String(buf, endIndex, wordNum) + " ...'");
            }
            Object object = result;
            Object var12_14 = null;
            jsonParseContext.clear();
            return object;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof JSONException) {
                    throw (JSONException)ex;
                }
                if (ex instanceof IndexOutOfBoundsException) {
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, toIndex);
                    throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.");
                }
                throw new JSONException("Error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                jsonParseContext.clear();
                throw throwable;
            }
        }
    }

    public static final Date parseDate(String dateStr, Class<? extends Date> dateCls) {
        char[] buf = JSON.getChars(dateStr);
        return JSON.matchDate(buf, 0, dateStr.length(), null, dateCls);
    }

    public static Object read(byte[] bytes, ReadOption ... readOptions) {
        if (bytes == null) {
            return null;
        }
        return JSONDefaultParser.parseBytes(bytes, readOptions);
    }

    public static Object read(InputStream is, ReadOption ... readOptions) throws IOException {
        if (is == null) {
            return null;
        }
        return JSON.read(is, (long)is.available(), readOptions);
    }

    private static Object read(InputStream is, long size, ReadOption ... readOptions) throws IOException {
        if (size <= 0L) {
            size = is.available();
        }
        if (size <= 8192L) {
            char[] buf = JSON.readInputStream(is, (int)size);
            return JSON.parse(buf, readOptions);
        }
        JSONReader jsonReader = new JSONReader(is);
        jsonReader.setOptions(readOptions);
        return jsonReader.read();
    }

    public static <T> T read(byte[] bytes, Class<T> actualType, ReadOption ... readOptions) {
        return (T)JSON.parse(null, bytes, actualType, null, readOptions);
    }

    public static <T> T read(InputStream is, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read(is, Integer.MAX_VALUE, actualType, readOptions);
    }

    private static <T> T read(InputStream is, long size, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        if (size <= 0L) {
            size = is.available();
        }
        if (size <= 8192L) {
            if (size == 0L) {
                return null;
            }
            char[] buf = JSON.readInputStream(is, (int)size);
            return (T)JSON.parse(buf, actualType, readOptions);
        }
        JSONReader jsonReader = new JSONReader(is);
        jsonReader.setOptions(readOptions);
        return jsonReader.readAsResult(GenericParameterizedType.actualType(actualType));
    }

    public static <T> T read(File file, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read((InputStream)new FileInputStream(file), Integer.MAX_VALUE, actualType, readOptions);
    }

    public static <T> T read(URL url, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read(url, actualType, false, -1, readOptions);
    }

    public static <T> T read(URL url, Class<T> actualType, boolean forceStreamMode, int timeout, ReadOption ... readOptions) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (timeout > 0) {
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
        }
        conn.connect();
        return JSON.read(conn.getInputStream(), forceStreamMode ? Integer.MAX_VALUE : (long)conn.getContentLength(), actualType, readOptions);
    }

    public static <T> T read(File file, GenericParameterizedType<T> genericType, ReadOption ... readOptions) throws IOException {
        JSONReader jsonReader = JSONReader.from(file);
        jsonReader.setOptions(readOptions);
        return jsonReader.readAsResult(genericType);
    }

    public static <T> T read(InputStream is, GenericParameterizedType<T> genericType, ReadOption ... readOptions) throws IOException {
        JSONReader jsonReader = JSONReader.from(is);
        jsonReader.setOptions(readOptions);
        return jsonReader.readAsResult(genericType);
    }

    public static String toJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.toJsonString(obj, WriteOption.Default);
    }

    public static String toJsonString(Object obj, WriteOption ... options) {
        if (obj == null) {
            return null;
        }
        JsonConfig jsonConfig = new JsonConfig();
        Options.writeOptions(options, jsonConfig);
        return JSON.stringify(obj, jsonConfig, 0);
    }

    public static byte[] toJsonBytes(Object obj, WriteOption ... options) {
        if (obj == null) {
            return null;
        }
        String json = JSON.toJsonString(obj, options);
        return json.getBytes();
    }

    public static String toJsonString(Object obj, JsonConfig jsonConfig) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, jsonConfig, 0);
    }

    public static String stringify(Object obj, JsonConfig jsonConfig) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, jsonConfig, 0);
    }

    private static String stringify(Object obj, JsonConfig jsonConfig, int indentLevel) {
        JSONStringWriter content = new JSONStringWriter();
        try {
            JSON.stringify(obj, content, jsonConfig, indentLevel);
            String string = content.toString();
            Object var6_6 = null;
            content.reset();
            jsonConfig.clear();
            return string;
        }
        catch (Exception e) {
            try {
                throw e instanceof JSONException ? (JSONException)e : new JSONException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                content.reset();
                jsonConfig.clear();
                throw throwable;
            }
        }
    }

    public static void writeJsonTo(Object object, File file, WriteOption ... options) {
        try {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            JSON.writeJsonTo(object, new FileOutputStream(file), options);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void writeJsonTo(Object object, OutputStream os, WriteOption ... options) {
        JSON.writeJsonTo(object, new OutputStreamWriter(os), options);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeJsonTo(Object object, Writer writer, WriteOption ... options) {
        if (object == null) {
            return;
        }
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        JsonConfig jsonConfig = new JsonConfig();
        Options.writeOptions(options, jsonConfig);
        JSON.stringify(object, bufferedWriter, jsonConfig, 0);
        bufferedWriter.flush();
        Object var7_5 = null;
        jsonConfig.clear();
        if (!jsonConfig.isAutoCloseStream()) return;
        try {
            bufferedWriter.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return;
        {
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            jsonConfig.clear();
            if (!jsonConfig.isAutoCloseStream()) throw throwable;
            try {
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    static void stringify(Object obj, Writer content, JsonConfig jsonConfig, int indentLevel) throws Exception {
        JSONTypeSerializer.getValueSerializer(obj).serialize(obj, content, jsonConfig, indentLevel);
    }

    public static boolean validate(String json, ReadOption ... readOptions) {
        return JSON.validate(json, false, readOptions);
    }

    public static boolean validate(String json, boolean printIfException, ReadOption ... readOptions) {
        if (json == null) {
            return false;
        }
        return JSON.validate(JSON.getChars(json), printIfException, readOptions);
    }

    public static boolean validate(char[] buf, ReadOption ... readOptions) {
        return JSON.validate(buf, false, readOptions);
    }

    public static boolean validate(char[] buf, boolean printIfException, ReadOption ... readOptions) {
        JSONValidator jsonValidator = new JSONValidator(buf);
        boolean result = jsonValidator.validate(readOptions);
        if (printIfException) {
            // empty if block
        }
        return result;
    }

    public static String validateMessage(String json, ReadOption ... readOptions) {
        if (json == null) {
            return "Exception: java.lang.NullPointerException";
        }
        return JSON.validateMessage(JSON.getChars(json), readOptions);
    }

    public static String validateMessage(char[] buf, ReadOption ... readOptions) {
        JSONValidator jsonValidator = new JSONValidator(buf);
        jsonValidator.validate(true, readOptions);
        return jsonValidator.getValidateMessage();
    }

    static abstract class Deserializer {
        Deserializer() {
        }

        Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            throw new UnsupportedOperationException();
        }

        Object deserialize(byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

