/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONStringWriter;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.options.Options;
import io.github.wycst.wast.json.options.ReadOption;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

class JSONByteArrayParser
extends JSONGeneral {
    JSONByteArrayParser() {
    }

    public static Object parse(byte[] bytes, ReadOption ... readOptions) {
        return JSONByteArrayParser.parse(null, bytes, null, readOptions);
    }

    public static Object parse(String source, byte[] bytes, ReadOption ... readOptions) {
        return JSONByteArrayParser.parse(source, bytes, null, readOptions);
    }

    static Object parse(String source, byte[] bytes, Object defaultValue, ReadOption ... readOptions) {
        bytes.getClass();
        return JSONByteArrayParser.parse(source, bytes, 0, bytes.length, defaultValue, readOptions);
    }

    static Object parse(String source, byte[] bytes, int fromIndex, int toIndex, Object defaultValue, ReadOption ... readOptions) {
        byte beginByte = 0;
        while (fromIndex < toIndex && (beginByte = bytes[fromIndex]) <= 32) {
            ++fromIndex;
        }
        while (toIndex > fromIndex && bytes[toIndex - 1] <= 32) {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        Options.readOptions(readOptions, jsonParseContext);
        try {
            Object result;
            boolean allowComment = jsonParseContext.isAllowComment();
            if (allowComment && beginByte == 47) {
                fromIndex = JSONByteArrayParser.clearComments(bytes, fromIndex + 1, toIndex, jsonParseContext);
                beginByte = bytes[fromIndex];
            }
            switch (beginByte) {
                case 123: {
                    result = JSONByteArrayParser.parseJSONObject(source, bytes, fromIndex, toIndex, defaultValue == null ? new LinkedHashMap() : (Map)defaultValue, jsonParseContext);
                    break;
                }
                case 91: {
                    result = JSONByteArrayParser.parseJSONArray(source, bytes, fromIndex, toIndex, defaultValue == null ? new ArrayList() : (Collection)defaultValue, jsonParseContext);
                    break;
                }
                case 34: {
                    result = JSONByteArrayParser.parseJSONString(source, bytes, fromIndex, toIndex, beginByte, jsonParseContext);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginByte + "'");
                }
            }
            int endIndex = jsonParseContext.getEndIndex();
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex) {
                    char c = (char)bytes[++endIndex];
                    commentStart = c;
                    if (c <= ' ') continue;
                }
                if (commentStart == 47) {
                    endIndex = JSONByteArrayParser.clearComments(bytes, endIndex + 1, toIndex, jsonParseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, bytes.length - endIndex - 1);
                String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, endIndex + 1);
                throw new JSONException("Syntax error, at pos " + endIndex + ", context text by '" + errorContextTextAt + "', extra characters found, '" + new String(bytes, endIndex + 1, wordNum) + " ...'");
            }
            Object object = result;
            Object var14_16 = null;
            jsonParseContext.clear();
            return object;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof JSONException) {
                    throw (JSONException)ex;
                }
                if (ex instanceof IndexOutOfBoundsException) {
                    ex.printStackTrace();
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, toIndex);
                    throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.");
                }
                throw new JSONException("Error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                jsonParseContext.clear();
                throw throwable;
            }
        }
    }

    static Collection parseJSONArray(String source, byte[] bytes, int fromIndex, int toIndex, Collection list, JSONParseContext jsonParseContext) throws Exception {
        int beginIndex;
        int i = beginIndex = fromIndex + 1;
        while (true) {
            block18: {
                byte b;
                if ((b = bytes[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (jsonParseContext.isAllowComment() && b == 47) {
                    i = JSONByteArrayParser.clearComments(bytes, i + 1, toIndex, jsonParseContext);
                    b = bytes[i];
                }
                if (b == 93) {
                    if (list.size() > 0) {
                        throw new JSONException("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return list;
                }
                switch (b) {
                    case 123: {
                        Object value = JSONByteArrayParser.parseJSONObject(source, bytes, i, toIndex, new LinkedHashMap(), jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case 91: {
                        Object value = JSONByteArrayParser.parseJSONArray(source, bytes, i, toIndex, new ArrayList(), jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case 34: 
                    case 39: {
                        Object value = JSONByteArrayParser.parseJSONString(source, bytes, i, toIndex, b, jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case 110: {
                        Object value = JSONByteArrayParser.parseNull(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    case 116: {
                        Object value = JSONByteArrayParser.parseTrue(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    case 102: {
                        Object value = JSONByteArrayParser.parseFalse(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    default: {
                        Object value = JSONByteArrayParser.parseDefaultNumber(bytes, i, toIndex, (byte)93, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        byte next = bytes[++i];
                        if (next == 93) {
                            jsonParseContext.setEndIndex(i);
                            return list;
                        }
                        break block18;
                    }
                }
                while ((b = bytes[++i]) <= 32) {
                }
                if (jsonParseContext.isAllowComment() && b == 47) {
                    i = JSONByteArrayParser.clearComments(bytes, i + 1, toIndex, jsonParseContext);
                    b = bytes[i];
                }
                if (b != 44) {
                    if (b == 93) {
                        jsonParseContext.setEndIndex(i);
                        return list;
                    }
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or ']'");
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map parseJSONObject(String source, byte[] bytes, int fromIndex, int toIndex, Map instance, JSONParseContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        boolean empty = true;
        boolean allowomment = jsonParseContext.isAllowComment();
        boolean disableCacheMapKey = jsonParseContext.isDisableCacheMapKey();
        int i = beginIndex;
        while (true) {
            block33: {
                String key;
                byte b;
                if ((b = bytes[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (allowomment && b == 47) {
                    i = JSONByteArrayParser.clearComments(bytes, i + 1, toIndex, jsonParseContext);
                    b = bytes[i];
                }
                int fieldKeyFrom = i;
                if (b == 34) {
                    key = disableCacheMapKey ? JSONByteArrayParser.parseMapKey(bytes, i, toIndex, '\"', jsonParseContext) : JSONByteArrayParser.parseMapKeyByCache(bytes, i, toIndex, '\"', jsonParseContext);
                    i = jsonParseContext.getEndIndex();
                    empty = false;
                    ++i;
                } else {
                    if (b == 125) {
                        if (!empty) {
                            throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.setEndIndex(i);
                        return instance;
                    }
                    if (b == 39) {
                        if (!jsonParseContext.isAllowSingleQuotes()) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                        while (i + 1 < toIndex && (bytes[++i] != 39 || bytes[i - 1] == 92)) {
                        }
                        empty = false;
                        key = JSONByteArrayParser.parseKeyOfMap(bytes, fieldKeyFrom, ++i, false);
                    } else if (jsonParseContext.isAllowUnquotedFieldNames()) {
                        while (i + 1 < toIndex && bytes[++i] != 58) {
                        }
                        empty = false;
                        key = JSONByteArrayParser.parseKeyOfMap(bytes, fieldKeyFrom, i, true);
                        if (key.equals("null")) {
                            key = null;
                        }
                    } else {
                        int j = i++;
                        boolean isNullKey = false;
                        key = null;
                        if (b == 110 && bytes[i] == 117 && bytes[++i] == 108 && bytes[++i] == 108) {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                        }
                    }
                }
                while ((b = bytes[i]) <= 32) {
                    ++i;
                }
                if (allowomment && b == 47) {
                    i = JSONByteArrayParser.clearComments(bytes, i + 1, toIndex, jsonParseContext);
                    b = bytes[i];
                }
                if (b != 58) throw new JSONException("Syntax error, at pos " + i + ", unexpected token character '" + b + "', Colon character ':' is expected.");
                while ((b = bytes[++i]) <= 32) {
                }
                if (jsonParseContext.isAllowComment() && b == 47) {
                    i = JSONByteArrayParser.clearComments(bytes, i + 1, toIndex, jsonParseContext);
                    b = bytes[i];
                }
                switch (b) {
                    case 123: {
                        Object value = JSONByteArrayParser.parseJSONObject(source, bytes, i, toIndex, new LinkedHashMap(), jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case 91: {
                        Object value = JSONByteArrayParser.parseJSONArray(source, bytes, i, toIndex, new ArrayList(), jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case 34: 
                    case 39: {
                        Object value = JSONByteArrayParser.parseJSONString(source, bytes, i, toIndex, b, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case 110: {
                        Object value = JSONByteArrayParser.parseNull(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case 116: {
                        Object value = JSONByteArrayParser.parseTrue(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    case 102: {
                        Object value = JSONByteArrayParser.parseFalse(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        break;
                    }
                    default: {
                        Object value = JSONByteArrayParser.parseDefaultNumber(bytes, i, toIndex, (byte)125, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        instance.put(key, value);
                        byte next = bytes[++i];
                        if (next == 125) {
                            jsonParseContext.setEndIndex(i);
                            return instance;
                        }
                        break block33;
                    }
                }
                while ((b = bytes[++i]) <= 32) {
                }
                if (allowomment && b == 47) {
                    i = JSONByteArrayParser.clearComments(bytes, i + 1, toIndex, jsonParseContext);
                    b = bytes[i];
                }
                if (b != 44) {
                    if (b == 125) {
                        jsonParseContext.setEndIndex(i);
                        return instance;
                    }
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or '}'");
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String parseJSONString(String source, byte[] bytes, int from, int toIndex, byte endCh, JSONParseContext jsonParseContext) {
        byte b;
        boolean useSource;
        int beginIndex = from + 1;
        JSONStringWriter writer = null;
        boolean bl = useSource = source != null;
        if (useSource && JDK_9_ABOVE) {
            int endIndex = source.indexOf(endCh, beginIndex);
            bytes[endIndex] = 92;
            int escapeIndex = source.indexOf(92, beginIndex);
            bytes[endIndex] = endCh;
            if (escapeIndex == endIndex) {
                jsonParseContext.setEndIndex(endIndex);
                int len = endIndex - beginIndex;
                if (len == 0) {
                    return "";
                }
                return UnsafeHelper.getAsciiString(Arrays.copyOfRange(bytes, beginIndex, endIndex));
            }
            writer = JSONByteArrayParser.getContextWriter(jsonParseContext);
            byte prev = bytes[endIndex - 1];
            if (prev == 92) {
                while ((prev = bytes[(endIndex = source.indexOf(endCh, endIndex + 1)) - 1]) == 92) {
                }
            }
            bytes[endIndex] = 92;
            boolean shortText = endIndex - from < 512;
            try {
                do {
                    beginIndex = JSONByteArrayParser.escapeAscii(source, bytes, bytes[escapeIndex + 1], escapeIndex, beginIndex, writer, jsonParseContext);
                    if (shortText) {
                        byte c;
                        while ((c = bytes[beginIndex]) != 92) {
                            writer.write(c);
                            ++beginIndex;
                        }
                        escapeIndex = beginIndex;
                        continue;
                    }
                    escapeIndex = source.indexOf(92, beginIndex);
                } while (escapeIndex != endIndex);
                Object var15_24 = null;
                bytes[endIndex] = endCh;
            }
            catch (Throwable throwable) {
                Object var15_25 = null;
                bytes[endIndex] = endCh;
                throw throwable;
            }
            jsonParseContext.setEndIndex(endIndex);
            writer.writeString(source, beginIndex, escapeIndex - beginIndex);
            return writer.toString();
        }
        int asciiFlag = 0;
        if (JDK_9_ABOVE) {
            byte next = 0;
            int i = beginIndex;
            boolean escape = false;
            boolean latin1 = true;
            while (true) {
                byte b2;
                if ((b2 = bytes[i]) != 92 && b2 != endCh) {
                    ++i;
                    if (!latin1 || b2 >= 0) continue;
                    latin1 = false;
                    continue;
                }
                if (b2 == 92) {
                    next = bytes[i + 1];
                    if (writer == null) {
                        writer = JSONByteArrayParser.getContextWriter(jsonParseContext);
                        escape = true;
                    }
                    if (latin1) {
                        String str = UnsafeHelper.getAsciiString(Arrays.copyOfRange(bytes, beginIndex, i));
                        writer.writeString(str, 0, i - beginIndex);
                        beginIndex = i;
                    }
                } else {
                    jsonParseContext.setEndIndex(i);
                    int len = i - beginIndex;
                    if (escape) {
                        writer.writeBytes(bytes, beginIndex, len);
                        return writer.toString();
                    }
                    if (latin1) {
                        return UnsafeHelper.getAsciiString(Arrays.copyOfRange(bytes, beginIndex, i));
                    }
                    return new String(bytes, beginIndex, len);
                }
                beginIndex = JSONByteArrayParser.escape(bytes, next, i, beginIndex, writer, jsonParseContext);
                i = jsonParseContext.getEndIndex();
                ++i;
            }
        }
        int i = beginIndex;
        byte prev = 0;
        boolean escape = false;
        while ((b = bytes[i]) != endCh || prev == 92) {
            if (b == 92) {
                asciiFlag = -1;
                escape = true;
                if (writer == null) {
                    writer = JSONByteArrayParser.getContextWriter(jsonParseContext);
                }
                byte next = bytes[i + 1];
                beginIndex = JSONByteArrayParser.escape(bytes, next, i, beginIndex, writer, jsonParseContext);
                i = jsonParseContext.getEndIndex() + 1;
                continue;
            }
            asciiFlag |= b;
            prev = b;
            ++i;
        }
        jsonParseContext.setEndIndex(i);
        if (asciiFlag > 0) {
            int len = i - beginIndex;
            char[] chars = new char[len];
            for (int j = 0; j < len; ++j) {
                chars[j] = (char)bytes[j + beginIndex];
            }
            return UnsafeHelper.getString(chars);
        }
        if (escape) {
            writer.writeBytes(bytes, beginIndex, i - beginIndex);
            return writer.toString();
        }
        return new String(bytes, beginIndex, i - beginIndex);
    }

    static Object parseNull(byte[] bytes, int fromIndex, int toIndex, JSONParseContext jsonParseContext) {
        int endIndex = fromIndex + 3;
        if (bytes[fromIndex + 1] == 117 && bytes[fromIndex + 2] == 108 && bytes[endIndex] == 108) {
            jsonParseContext.setEndIndex(endIndex);
            return null;
        }
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(bytes, fromIndex, Math.min(toIndex - fromIndex + 1, 4)) + "'");
    }

    static Object parseTrue(byte[] bytes, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
        int endIndex = fromIndex + 3;
        if (bytes[fromIndex + 1] == 114 && bytes[fromIndex + 2] == 117 && bytes[endIndex] == 101) {
            jsonParseContext.setEndIndex(endIndex);
            return true;
        }
        int len = Math.min(toIndex - fromIndex + 1, 4);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'true' because it starts with 't', but found text '" + new String(bytes, fromIndex, len) + "'");
    }

    static Object parseFalse(byte[] bytes, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
        int endIndex = fromIndex + 4;
        if (bytes[fromIndex + 1] == 97 && bytes[fromIndex + 2] == 108 && bytes[fromIndex + 3] == 115 && bytes[endIndex] == 101) {
            jsonParseContext.setEndIndex(endIndex);
            return false;
        }
        int len = Math.min(toIndex - fromIndex + 1, 5);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'false' because it starts with 'f', but found text '" + new String(bytes, fromIndex, len) + "'");
    }

    static Number parseDefaultNumber(byte[] bytes, int fromIndex, int toIndex, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        boolean negative = false;
        int i = fromIndex;
        byte b = bytes[fromIndex];
        if (b == 45) {
            negative = true;
            ++i;
        } else if (b == 43) {
            ++i;
        }
        double value = 0.0;
        int numberLen = 0;
        int decimalCount = 0;
        int radix = 10;
        int expValue = 0;
        boolean expNegative = false;
        int mode = 0;
        int specifySuffix = 0;
        while (true) {
            int digit;
            if ((digit = JSONByteArrayParser.digitDecimal(b = bytes[i])) == -1) {
                if (b == 44 || b == endToken) break;
                if (b == 46) {
                    if (mode != 0) {
                        throw new JSONException("For input string: \"" + new String(bytes, fromIndex, i + 1 - fromIndex) + "\"");
                    }
                    mode = 1;
                    b = bytes[++i];
                    digit = JSONByteArrayParser.digitDecimal(b);
                } else if (b == 69 || b == 101) {
                    if (mode == 2) {
                        throw new JSONException("For input string: \"" + new String(bytes, fromIndex, i + 1 - fromIndex) + "\"");
                    }
                    mode = 2;
                    if ((b = bytes[++i]) == 45) {
                        expNegative = true;
                        b = bytes[++i];
                    }
                    digit = JSONByteArrayParser.digitDecimal(b);
                }
            }
            if (digit == -1) {
                boolean breakLoop = false;
                switch (b) {
                    case 76: 
                    case 108: {
                        if (specifySuffix == 0) {
                            specifySuffix = 1;
                            while ((b = bytes[++i]) <= 32) {
                            }
                            if (b == 44 || b == endToken) {
                                breakLoop = true;
                                break;
                            }
                        }
                        String contextErrorAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                        throw new JSONException("For input string: \"" + new String(bytes, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + b + "', context text by '" + contextErrorAt + "'");
                    }
                    case 70: 
                    case 102: {
                        if (specifySuffix == 0) {
                            specifySuffix = 2;
                            while ((b = bytes[++i]) <= 32) {
                            }
                            if (b == 44 || b == endToken) {
                                breakLoop = true;
                                break;
                            }
                        }
                        String contextErrorAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                        throw new JSONException("For input string: \"" + new String(bytes, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + b + "', context text by '" + contextErrorAt + "'");
                    }
                    case 68: 
                    case 100: {
                        if (specifySuffix == 0) {
                            specifySuffix = 3;
                            while ((b = bytes[++i]) <= 32) {
                            }
                            if (b == 44 || b == endToken) {
                                breakLoop = true;
                                break;
                            }
                        }
                        String contextErrorAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                        throw new JSONException("For input string: \"" + new String(bytes, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + b + "', context text by '" + contextErrorAt + "'");
                    }
                    default: {
                        if (b > 32) break;
                        while ((b = bytes[++i]) <= 32) {
                        }
                        if (b == 44 || b == endToken) {
                            breakLoop = true;
                            break;
                        }
                        String contextErrorAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                        throw new JSONException("For input string: \"" + new String(bytes, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + b + "', context text by '" + contextErrorAt + "'");
                    }
                }
                if (breakLoop) break;
                String contextErrorAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                throw new JSONException("For input string: \"" + new String(bytes, fromIndex, i - fromIndex + 1) + "\", at pos " + i + ", context text by '" + contextErrorAt + "'");
            }
            ++numberLen;
            switch (mode) {
                case 0: {
                    value *= 10.0;
                    value += (double)digit;
                    break;
                }
                case 1: {
                    value *= 10.0;
                    value += (double)digit;
                    ++decimalCount;
                    break;
                }
                case 2: {
                    expValue = (expValue << 3) + (expValue << 1);
                    expValue += digit;
                }
            }
            ++i;
        }
        jsonParseContext.setEndIndex(i - 1);
        if (mode == 0) {
            if (numberLen > 18) {
                int endIndex = i - 1;
                while (bytes[endIndex] <= 32) {
                    --endIndex;
                }
                return new BigInteger(new String(bytes, fromIndex, endIndex - fromIndex + 1));
            }
            double d = value = negative ? -value : value;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return (long)value;
                    }
                    case 2: {
                        return Float.valueOf((float)value);
                    }
                }
                return value;
            }
            if (value <= 2.147483647E9 && value > -2.147483648E9) {
                return (int)value;
            }
            if (value <= 9.223372036854776E18 && value > -9.223372036854776E18) {
                return (long)value;
            }
            return value;
        }
        int n = expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
        if (expValue > 0) {
            double powValue = JSONByteArrayParser.getDecimalPowerValue(expValue);
            value *= powValue;
        } else if (expValue < 0) {
            double powValue = JSONByteArrayParser.getDecimalPowerValue(-expValue);
            value /= powValue;
        }
        double d = value = negative ? -value : value;
        if (specifySuffix > 0) {
            switch (specifySuffix) {
                case 1: {
                    return (long)value;
                }
                case 2: {
                    return Float.valueOf((float)value);
                }
            }
            return value;
        }
        return value;
    }

    static String parseMapKey(byte[] bytes, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        byte b = 0;
        byte next = 0;
        int i = beginIndex;
        JSONStringWriter writer = null;
        boolean escape = false;
        while (true) {
            if ((b = bytes[i]) != 92 && b != endCh) {
                ++i;
                continue;
            }
            if (b == 92) {
                if (i < toIndex - 1) {
                    next = bytes[i + 1];
                }
                if (writer == null) {
                    writer = JSONByteArrayParser.getContextWriter(jsonParseContext);
                }
            } else {
                jsonParseContext.setEndIndex(i);
                int len = i - beginIndex;
                if (escape) {
                    writer.writeBytes(bytes, beginIndex, len);
                    return writer.toString();
                }
                return len == 0 ? "" : new String(bytes, beginIndex, len);
            }
            escape = true;
            beginIndex = JSONByteArrayParser.escape(bytes, next, i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.getEndIndex();
            ++i;
        }
    }

    static String parseMapKeyByCache(byte[] bytes, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        byte next = 0;
        int i = beginIndex;
        JSONStringWriter writer = null;
        boolean escape = false;
        while (true) {
            byte b;
            int hashValue = 0;
            while ((b = bytes[i]) != 92 && b != endCh) {
                ++i;
                hashValue = hashValue * 31 + b;
            }
            if (b == 92) {
                if (i < toIndex - 1) {
                    next = bytes[i + 1];
                }
                if (writer == null) {
                    writer = JSONByteArrayParser.getContextWriter(jsonParseContext);
                }
            } else {
                jsonParseContext.setEndIndex(i);
                int len = i - beginIndex;
                if (escape) {
                    writer.writeBytes(bytes, beginIndex, len);
                    return writer.toString();
                }
                return len == 0 ? "" : jsonParseContext.getCacheKey(bytes, beginIndex, len, hashValue);
            }
            escape = true;
            beginIndex = JSONByteArrayParser.escape(bytes, next, i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.getEndIndex();
            ++i;
        }
    }

    static String parseKeyOfMap(byte[] bytes, int from, int to, boolean isUnquotedFieldName) {
        if (isUnquotedFieldName) {
            while (from < to && bytes[from] <= 32) {
                ++from;
            }
            while (to > from && bytes[to - 1] <= 32) {
                --to;
            }
            return new String(bytes, from, to - from);
        }
        int len = to - from - 2;
        return new String(bytes, from + 1, len);
    }

    static int escape(byte[] bytes, byte next, int i, int beginIndex, JSONStringWriter writer, JSONParseContext jsonParseContext) {
        switch (next) {
            case 34: 
            case 39: {
                if (i > beginIndex) {
                    writer.writeBytes(bytes, beginIndex, i - beginIndex + 1);
                    writer.setCharAt(writer.size() - 1, (char)next);
                } else {
                    writer.append((char)next);
                }
                beginIndex = ++i + 1;
                break;
            }
            case 110: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\n');
                beginIndex = ++i + 1;
                break;
            }
            case 114: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\r');
                beginIndex = ++i + 1;
                break;
            }
            case 116: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\t');
                beginIndex = ++i + 1;
                break;
            }
            case 98: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\b');
                beginIndex = ++i + 1;
                break;
            }
            case 102: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\f');
                beginIndex = ++i + 1;
                break;
            }
            case 117: {
                int c;
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                int j = i + 2;
                try {
                    int c1 = JSONByteArrayParser.hex(bytes[j++]);
                    int c2 = JSONByteArrayParser.hex(bytes[j++]);
                    int c3 = JSONByteArrayParser.hex(bytes[j++]);
                    int c4 = JSONByteArrayParser.hex(bytes[j++]);
                    c = c1 << 12 | c2 << 8 | c3 << 4 | c4;
                }
                catch (Throwable throwable) {
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, i + 1);
                    throw new JSONException("Syntax error, from pos " + (i + 1) + ", context text by '" + errorContextTextAt + "', " + throwable.getMessage());
                }
                writer.setCharAt(writer.size() - 1, (char)c);
                i += 4;
                beginIndex = ++i + 1;
                break;
            }
            default: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, (char)next);
                beginIndex = ++i + 1;
            }
        }
        jsonParseContext.setEndIndex(i);
        return beginIndex;
    }

    static int escapeAscii(String source, byte[] bytes, byte next, int i, int beginIndex, JSONStringWriter writer, JSONParseContext jsonParseContext) {
        if (i > beginIndex) {
            writer.writeString(source, beginIndex, i - beginIndex);
        }
        if (next == 117) {
            int c;
            int j = i + 2;
            try {
                int c1 = JSONByteArrayParser.hex(bytes[j++]);
                int c2 = JSONByteArrayParser.hex(bytes[j++]);
                int c3 = JSONByteArrayParser.hex(bytes[j++]);
                int c4 = JSONByteArrayParser.hex(bytes[j++]);
                c = c1 << 12 | c2 << 8 | c3 << 4 | c4;
            }
            catch (Throwable throwable) {
                String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, i + 1);
                throw new JSONException("Syntax error, from pos " + (i + 1) + ", context text by '" + errorContextTextAt + "', " + throwable.getMessage());
            }
            writer.append((char)c);
            i += 4;
            beginIndex = ++i + 1;
        } else if (next < 160) {
            writer.append(EscapeChars[next]);
            beginIndex = ++i + 1;
        } else {
            writer.append((char)next);
            beginIndex = ++i + 1;
        }
        jsonParseContext.setEndIndex(i);
        return beginIndex;
    }

    static String createErrorMessage(byte[] bytes, int at) {
        try {
            int len = bytes.length;
            byte[] text = new byte[40];
            int begin = Math.max(at - 18, 0);
            int count = at - begin;
            System.arraycopy(bytes, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 18);
            System.arraycopy(bytes, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    static int clearComments(byte[] bytes, int beginIndex, int toIndex, JSONParseContext jsonParseContext) {
        int i = beginIndex;
        if (i >= toIndex) {
            throw new JSONException("Syntax error, unexpected token character '/', position " + (beginIndex - 1));
        }
        byte b = bytes[beginIndex];
        if (b == 47) {
            while (i < toIndex && bytes[i] != 10) {
                ++i;
            }
            b = 0;
            while (i + 1 < toIndex && (b = bytes[++i]) <= 32) {
            }
            if (b == 47) {
                i = JSONByteArrayParser.clearComments(bytes, i + 1, toIndex, jsonParseContext);
            }
        } else if (b == 42) {
            byte prev = 0;
            boolean matched = false;
            while (i + 1 < toIndex) {
                if ((b = bytes[++i]) == 47 && prev == 42) {
                    matched = true;
                    break;
                }
                prev = b;
            }
            if (!matched) {
                throw new JSONException("Syntax error, not found the close comment '*/' util the end ");
            }
            b = 0;
            while (i + 1 < toIndex && (b = bytes[++i]) <= 32) {
            }
            if (b == 47) {
                i = JSONByteArrayParser.clearComments(bytes, i + 1, toIndex, jsonParseContext);
            }
        } else {
            throw new JSONException("Syntax error, unexpected token character '" + (char)b + "', position " + beginIndex);
        }
        return i;
    }
}

