/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.tools.Base64;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.options.Options;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader
extends JSONGeneral {
    private final Reader reader;
    protected int pos;
    private char[] buf;
    protected int bufferSize = 8192;
    protected int count;
    protected int offset;
    protected int current;
    private ReaderCallback callback;
    private final JSONParseContext parseContext = new JSONParseContext();
    private ReadOption[] readOptions = new ReadOption[0];
    private GenericParameterizedType genericType;
    private Object result;
    private boolean reading;
    private boolean closed;
    private boolean aborted;
    protected final StringBuilder bufferWriter = new StringBuilder();
    protected int readingOffset = -1;
    private Object lock = new Object();
    private boolean async;
    private long timeout = 60000L;
    private long currentThreadId;

    private JSONReader(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public static JSONReader from(File file) {
        try {
            return new JSONReader(file);
        }
        catch (FileNotFoundException e) {
            throw new JSONException(e);
        }
    }

    public static JSONReader from(InputStream inputStream) {
        return new JSONReader(inputStream);
    }

    public static JSONReader from(String json) {
        return new JSONReader(JSONReader.getChars(json));
    }

    public static JSONReader from(char[] source) {
        return new JSONReader(source);
    }

    public JSONReader(char[] buf) {
        this.buf = buf;
        this.count = buf.length;
        this.reader = null;
    }

    JSONReader() {
        this.reader = null;
    }

    public JSONReader(InputStream inputStream) {
        this.reader = new InputStreamReader(inputStream);
    }

    public JSONReader(InputStream inputStream, int buffSize) {
        this.reader = new InputStreamReader(inputStream);
        this.bufferSize = buffSize;
    }

    public JSONReader(InputStream inputStream, String charsetName) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(inputStream, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
        this.reader = reader;
    }

    public JSONReader(Reader reader) {
        if (reader == null) {
            throw new UnsupportedOperationException("reader is null");
        }
        this.reader = reader;
    }

    public void setOptions(ReadOption ... readOptions) {
        this.readOptions = readOptions;
        Options.readOptions(readOptions, this.parseContext);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Object read() {
        block5: {
            this.readBuffer();
            if (!this.isCompleted()) break block5;
            Object object = JSONDefaultParser.parse(null, this.buf, 0, this.count, null, this.readOptions);
            Object var3_3 = null;
            this.close();
            return object;
        }
        try {
            try {
                this.defaultRead();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            Object var3_4 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.close();
            throw throwable;
        }
        return this.result;
    }

    public void read(boolean async) {
        this.read(new ReaderCallback(), async);
    }

    public Object readAsResult(Class<?> actualType) {
        this.genericType = GenericParameterizedType.actualType(actualType);
        this.executeReadStream();
        return this.result;
    }

    public <T> T readAsResult(GenericParameterizedType<T> genericType) {
        this.genericType = genericType;
        this.executeReadStream();
        return (T)this.result;
    }

    public void read(ReaderCallback callback) {
        this.read(callback, false);
    }

    public void read(ReaderCallback callback, boolean async) {
        if (this.closed) {
            throw new UnsupportedOperationException("Stream has been closed");
        }
        if (this.aborted) {
            throw new UnsupportedOperationException("Reader has been aborted");
        }
        if (this.reading) {
            throw new UnsupportedOperationException("Stream is being read");
        }
        this.callback = callback;
        this.reading = true;
        if (!async) {
            this.executeReadStream();
        } else {
            this.async = true;
            this.currentThreadId = Thread.currentThread().getId();
            new Thread(new Runnable(){

                public void run() {
                    JSONReader.this.executeReadStream();
                }
            }).start();
        }
    }

    private void executeReadStream() {
        try {
            try {
                this.readBuffer();
                this.beginReadWithType();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            Object var3_1 = null;
            this.close();
            this.reading = false;
            this.closed = true;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.close();
            this.reading = false;
            this.closed = true;
            this.unlock();
            throw throwable;
        }
    }

    private void readBuffer() throws IOException {
        if (this.reader == null) {
            return;
        }
        if (this.buf == null) {
            this.buf = new char[this.bufferSize];
        }
        if (this.readingOffset > -1) {
            if (this.bufferSize > this.readingOffset) {
                this.bufferWriter.append(this.buf, this.readingOffset, this.bufferSize - this.readingOffset);
            }
            this.readingOffset = 0;
        }
        this.count = this.reader.read(this.buf);
        this.offset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    private void await() {
        this.await(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(timeout);
            }
            catch (InterruptedException e) {
                throw new JSONException(e);
            }
        }
    }

    private void defaultRead() throws Exception {
        this.clearWhitespaces();
        switch (this.current) {
            case 123: {
                this.result = this.readObject();
                break;
            }
            case 91: {
                this.result = this.readArray();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Character stream start character error. Only object({) or array([) parsing is supported");
            }
        }
        this.clearWhitespaces();
        if (this.current > -1) {
            throw new JSONException("Syntax error, extra characters found, '" + (char)this.current + "', pos " + this.pos);
        }
    }

    private void beginReadWithType() throws Exception {
        this.clearWhitespaces();
        switch (this.current) {
            case 123: {
                this.checkAutoGenericObjectType();
                this.result = this.readObject("", this.genericType);
                break;
            }
            case 91: {
                this.checkAutoGenericCollectionType();
                this.result = this.readArray("", this.genericType);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Character stream start character error. Only object({) or array([) parsing is supported");
            }
        }
        if (this.isAborted()) {
            return;
        }
        this.clearWhitespaces();
        if (this.current > -1) {
            throw new JSONException("Syntax error, extra characters found, '" + (char)this.current + "', pos " + this.pos);
        }
        if (this.callback != null) {
            this.callback.complete(this.result);
        }
    }

    private void checkAutoGenericCollectionType() {
        if (this.genericType == null) {
            this.genericType = GenericParameterizedType.collectionType(ArrayList.class, LinkedHashMap.class);
        } else {
            Class<?> actualType = this.genericType.getActualType();
            if (!Collection.class.isAssignableFrom(actualType)) {
                this.genericType = GenericParameterizedType.collectionType(ArrayList.class, actualType);
            }
        }
    }

    private void checkAutoGenericObjectType() {
        if (this.genericType == null) {
            this.genericType = GenericParameterizedType.actualType(LinkedHashMap.class);
        }
    }

    private Object readObject() throws Exception {
        LinkedHashMap<String, Object> instance = new LinkedHashMap<String, Object>();
        boolean empty = true;
        block8: while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                if (!empty) {
                    throw new JSONException("Syntax error, not allowed ',' followed by '}', pos " + this.pos);
                }
                return instance;
            }
            if (this.current == 34) {
                empty = false;
                this.beginReading(0);
                while (this.readNext() > -1 && this.current != 34) {
                }
                String key = this.endReadingAsString(-1);
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    switch (this.current) {
                        case 123: {
                            Object value = this.readObject();
                            instance.put(key, value);
                            break;
                        }
                        case 91: {
                            Object value = this.readArray();
                            instance.put(key, value);
                            break;
                        }
                        case 34: {
                            Object value = this.readString();
                            instance.put(key, value);
                            break;
                        }
                        case 110: {
                            this.readNull();
                            instance.put(key, null);
                            break;
                        }
                        case 116: {
                            this.readTrue();
                            instance.put(key, true);
                            break;
                        }
                        case 102: {
                            this.readFalse();
                            instance.put(key, false);
                            break;
                        }
                        default: {
                            Object value = this.readNumber('}');
                            instance.put(key, value);
                            if (this.current != 125) continue block8;
                            return instance;
                        }
                    }
                    this.clearWhitespaces();
                    if (this.current == 44) continue;
                    if (this.current == 125) {
                        return instance;
                    }
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
    }

    private void readTrue() throws Exception {
        if (this.readNext(true) == 114 && this.readNext(true) == 117 && this.readNext(true) == 101) {
            return;
        }
        this.throwUnexpectedException();
    }

    private void readFalse() throws Exception {
        if (this.readNext(true) == 97 && this.readNext(true) == 108 && this.readNext(true) == 115 && this.readNext(true) == 101) {
            return;
        }
        this.throwUnexpectedException();
    }

    private void readNull() throws Exception {
        if (this.readNext(true) == 117 && this.readNext(true) == 108 && this.readNext(true) == 108) {
            return;
        }
        this.throwUnexpectedException();
    }

    private Number readNumber(char endSyntax) throws Exception {
        if (this.parseContext.isUseBigDecimalAsDefault()) {
            this.beginCurrent();
            while (this.readNext() > -1) {
                if (this.current != 44 && this.current != endSyntax) continue;
                this.endReading(-1);
                int len = this.bufferWriter.length();
                while (this.bufferWriter.charAt(len - 1) <= ' ') {
                    --len;
                }
                char[] digits = new char[len];
                this.bufferWriter.getChars(0, len, digits, 0);
                return new BigDecimal(digits, 0, digits.length);
            }
            throw new JSONException("Syntax error, the closing symbol '" + endSyntax + "' is not found, end pos: " + this.pos);
        }
        boolean negative = false;
        char beginChar = (char)this.current;
        if (beginChar == '-') {
            negative = true;
            this.readNext();
        } else if (beginChar == '+') {
            this.readNext();
        }
        double value = 0.0;
        int decimalCount = 0;
        int radix = 10;
        int expValue = 0;
        boolean expNegative = false;
        int mode = 0;
        int specifySuffix = 0;
        do {
            char ch;
            int digit;
            if ((digit = JSONReader.digitDecimal(ch = (char)this.current)) == -1) {
                if (ch == ',' || ch == endSyntax) break;
                if (ch == '.') {
                    if (mode != 0) {
                        this.throwUnexpectedException();
                        return value;
                    }
                    mode = 1;
                    ch = (char)this.readNext(true);
                    digit = JSONReader.digitDecimal(ch);
                } else if (ch == 'E' || ch == 'e') {
                    if (mode == 2) {
                        this.throwUnexpectedException();
                        return value;
                    }
                    mode = 2;
                    ch = (char)this.readNext(true);
                    if (ch == '-') {
                        expNegative = true;
                        ch = (char)this.readNext(true);
                    }
                    digit = JSONReader.digitDecimal(ch);
                }
            }
            if (digit == -1) {
                boolean breakLoop = false;
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        if (specifySuffix == 0) {
                            specifySuffix = 1;
                            while ((ch = (char)this.readNext()) <= ' ') {
                            }
                            if (ch == ',' || ch == endSyntax) {
                                breakLoop = true;
                                break;
                            }
                        }
                        this.throwUnexpectedException();
                        return value;
                    }
                    case 'F': 
                    case 'f': {
                        if (specifySuffix == 0) {
                            specifySuffix = 2;
                            while ((ch = (char)this.readNext()) <= ' ') {
                            }
                            if (ch == ',' || ch == endSyntax) {
                                breakLoop = true;
                                break;
                            }
                        }
                        this.throwUnexpectedException();
                        return value;
                    }
                    case 'D': 
                    case 'd': {
                        if (specifySuffix == 0) {
                            specifySuffix = 3;
                            while ((ch = (char)this.readNext()) <= ' ') {
                            }
                            if (ch == ',' || ch == endSyntax) {
                                breakLoop = true;
                                break;
                            }
                        }
                        this.throwUnexpectedException();
                        return value;
                    }
                    default: {
                        if (ch > ' ') break;
                        while ((ch = (char)this.readNext()) <= ' ') {
                        }
                        if (ch == ',' || ch == endSyntax) {
                            breakLoop = true;
                            break;
                        }
                        this.throwUnexpectedException();
                        return value;
                    }
                }
                if (breakLoop) break;
                this.throwUnexpectedException();
                return value;
            }
            switch (mode) {
                case 0: {
                    value *= 10.0;
                    value += (double)digit;
                    break;
                }
                case 1: {
                    value *= 10.0;
                    value += (double)digit;
                    ++decimalCount;
                    break;
                }
                case 2: {
                    expValue *= 10;
                    expValue += digit;
                }
            }
        } while (this.readNext() > -1);
        if (mode == 0) {
            double d = value = negative ? -value : value;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return (long)value;
                    }
                    case 2: {
                        return Float.valueOf((float)value);
                    }
                }
                return value;
            }
            if (value <= 2.147483647E9 && value > -2.147483648E9) {
                return (int)value;
            }
            if (value <= 9.223372036854776E18 && value > -9.223372036854776E18) {
                return (long)value;
            }
            return value;
        }
        int n = expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
        if (expValue > 0) {
            double powValue = JSONReader.getDecimalPowerValue(expValue);
            value *= powValue;
        } else if (expValue < 0) {
            double powValue = JSONReader.getDecimalPowerValue(-expValue);
            value /= powValue;
        }
        double d = value = negative ? -value : value;
        if (specifySuffix > 0) {
            switch (specifySuffix) {
                case 1: {
                    return (long)value;
                }
                case 2: {
                    return Float.valueOf((float)value);
                }
            }
            return value;
        }
        return value;
    }

    private Object readArray() throws Exception {
        ArrayList<Object> arrInstance = new ArrayList<Object>();
        int elementIndex = 0;
        block8: while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                if (elementIndex > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + this.pos);
                }
                return arrInstance;
            }
            switch (this.current) {
                case 123: {
                    Object value = this.readObject();
                    arrInstance.add(value);
                    break;
                }
                case 91: {
                    Object value = this.readArray();
                    arrInstance.add(value);
                    break;
                }
                case 34: {
                    Object value = this.readString();
                    arrInstance.add(value);
                    break;
                }
                case 110: {
                    this.readNull();
                    arrInstance.add(null);
                    break;
                }
                case 116: {
                    this.readTrue();
                    arrInstance.add(true);
                    break;
                }
                case 102: {
                    this.readFalse();
                    arrInstance.add(false);
                    break;
                }
                default: {
                    Object value = this.readNumber(']');
                    arrInstance.add(value);
                    if (this.current != 93) continue block8;
                    return arrInstance;
                }
            }
            ++elementIndex;
            this.clearWhitespaces();
            if (this.current == 44) continue;
            if (this.current == 93) {
                return arrInstance;
            }
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readObject(String path, GenericParameterizedType genericType) throws Exception {
        Object instance;
        Object var4_3 = null;
        boolean assignableFromMap = true;
        ClassStructureWrapper classStructureWrapper = null;
        boolean externalImpl = this.isExternalImpl();
        GenericParameterizedType ofValueType = null;
        if (!externalImpl) {
            if (genericType != null) {
                Class<?> actualType = genericType.getActualType();
                ReflectConsts.ClassCategory classCategory = genericType.getActualClassCategory();
                if (classCategory == ReflectConsts.ClassCategory.MapCategory || classCategory == ReflectConsts.ClassCategory.ANY) {
                    Class<?> mapCls = actualType;
                    assignableFromMap = true;
                    Map map = JSONDefaultParser.createMapInstance(mapCls);
                    instance = map;
                    ofValueType = genericType.getValueType();
                } else {
                    if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) throw new UnsupportedOperationException("Class " + actualType + " is not supported ");
                    assignableFromMap = false;
                    classStructureWrapper = ClassStructureWrapper.get(actualType);
                    if (classStructureWrapper == null) {
                        throw new UnsupportedOperationException("Class " + actualType + " is not supported ");
                    }
                    instance = classStructureWrapper.newInstance();
                }
            } else {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                instance = linkedHashMap;
            }
        } else {
            instance = this.callback.created(path, 1);
        }
        boolean empty = true;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                if (empty) return instance;
                throw new JSONException("Syntax error, not allowed ',' followed by '}', pos " + this.pos);
            }
            if (this.current == 34) {
                empty = false;
                this.beginReading(0);
                while (this.readNext() > -1 && this.current != 34) {
                }
                String key = this.endReadingAsString(-1);
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    boolean toBreakOrContinue = false;
                    GenericParameterizedType valueType = ofValueType == null ? null : ofValueType;
                    SetterInfo setterInfo = null;
                    boolean isSkipValue = false;
                    if (!externalImpl && !assignableFromMap) {
                        setterInfo = classStructureWrapper.getSetterInfo(key);
                        boolean bl = isSkipValue = setterInfo == null;
                        if (!isSkipValue) {
                            valueType = setterInfo.getGenericParameterizedType();
                        }
                    }
                    if (isSkipValue) {
                        this.skipValue('}');
                    } else {
                        String nextPath = externalImpl ? path + "/" + key : null;
                        switch (this.current) {
                            case 123: {
                                void var4_7;
                                Object value = this.readObject(nextPath, valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 91: {
                                void var4_7;
                                Object value = this.readArray(nextPath, valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 34: {
                                void var4_7;
                                Object value = this.parseStringTo(this.readString(), valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 110: {
                                void var4_7;
                                this.readNull();
                                this.invokeValueOfObject(key, null, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 116: {
                                void var4_7;
                                this.readTrue();
                                Object value = this.toBoolType(true, valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 102: {
                                void var4_7;
                                this.readFalse();
                                Object value = this.toBoolType(false, valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            default: {
                                void var4_7;
                                Object value = this.parseNumberTo(this.readNumber('}'), valueType);
                                toBreakOrContinue = true;
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                            }
                        }
                        if (this.isAborted()) {
                            return instance;
                        }
                        if (this.callback != null && this.callback.isAbored()) {
                            this.abortRead();
                            return instance;
                        }
                        if (!toBreakOrContinue) {
                            this.clearWhitespaces();
                        }
                    }
                    if (this.current == 125) return instance;
                    if (this.current == 44) continue;
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
    }

    private Object toBoolType(boolean b, GenericParameterizedType valueType) {
        if (valueType == null) {
            return b;
        }
        if (valueType.getActualClassCategory() == ReflectConsts.ClassCategory.BoolCategory) {
            return b;
        }
        Class<?> actualType = valueType.getActualType();
        if (actualType == AtomicBoolean.class) {
            return new AtomicBoolean(b);
        }
        throw new JSONException("boolean value " + b + " is mismatch " + actualType);
    }

    private void skipValue(char endChar) throws Exception {
        switch (this.current) {
            case 123: {
                this.skipObject();
                this.clearWhitespaces();
                break;
            }
            case 91: {
                this.skipArray();
                this.clearWhitespaces();
                break;
            }
            case 34: {
                this.skipString();
                this.clearWhitespaces();
                break;
            }
            default: {
                this.skipSimple(endChar);
            }
        }
    }

    private void skipObject() throws Exception {
        boolean empty = true;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                if (!empty) {
                    throw new JSONException("Syntax error, not allowed ',' followed by '}', pos " + this.pos);
                }
                return;
            }
            if (this.current == 34) {
                empty = false;
                while (this.readNext() > -1 && this.current != 34) {
                }
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    this.skipValue('}');
                    if (this.current == 125) {
                        return;
                    }
                    if (this.current == 44) continue;
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
    }

    private void skipArray() throws Exception {
        int elementIndex = 0;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                if (elementIndex > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + this.pos);
                }
                return;
            }
            this.skipValue(']');
            ++elementIndex;
            if (this.current == 93) {
                return;
            }
            if (this.current == 44) continue;
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
    }

    private void skipString() throws Exception {
        int prev = 0;
        while (this.readNext() > -1) {
            if (this.current == 34 && prev != 92) {
                return;
            }
            prev = (char)this.current;
        }
        this.throwUnexpectedException();
    }

    private void skipSimple(char endChar) throws Exception {
        while (this.readNext() > -1) {
            if (this.current != 44 && this.current != endChar) continue;
            return;
        }
        this.throwUnexpectedException();
    }

    protected void beginReading(int n) {
        this.bufferWriter.setLength(0);
        this.readingOffset = this.offset + n;
    }

    protected String endReadingAsString(int n) {
        if (this.bufferWriter.length() > 0) {
            this.endReading(n);
            return this.bufferWriter.toString();
        }
        int endIndex = this.offset + n;
        String result = new String(this.buf, this.readingOffset, endIndex - this.readingOffset);
        this.readingOffset = -1;
        return result;
    }

    private void endReading(int n) {
        this.endReading(n, -1);
    }

    protected void endReading(int n, int newOffset) {
        int endIndex = this.offset + n;
        if (endIndex > this.readingOffset) {
            this.bufferWriter.append(this.buf, this.readingOffset, endIndex - this.readingOffset);
        }
        this.readingOffset = newOffset;
    }

    private Object parseNumberTo(Object simpleValue, GenericParameterizedType valueType) {
        ReflectConsts.ClassCategory classCategory;
        if (simpleValue == null) {
            return null;
        }
        if (valueType == null || (classCategory = valueType.getActualClassCategory()) == ReflectConsts.ClassCategory.ANY) {
            return simpleValue;
        }
        Class<?> actualType = valueType.getActualType();
        if (actualType.isInstance(simpleValue)) {
            return simpleValue;
        }
        Number numValue = (Number)simpleValue;
        if (classCategory == ReflectConsts.ClassCategory.NumberCategory) {
            int numberType = valueType.getParamClassNumberType();
            switch (numberType) {
                case 101: {
                    return numValue.byteValue();
                }
                case 102: {
                    return numValue.shortValue();
                }
                case 103: {
                    return numValue.intValue();
                }
                case 104: {
                    return numValue.longValue();
                }
                case 105: {
                    return Float.valueOf(numValue.floatValue());
                }
                case 106: {
                    return numValue.doubleValue();
                }
                case 107: {
                    return new AtomicInteger(numValue.intValue());
                }
                case 108: {
                    return new AtomicLong(numValue.longValue());
                }
                case 109: {
                    return new BigDecimal(numValue.doubleValue());
                }
                case 110: {
                    return new BigInteger(String.valueOf(numValue.longValue()));
                }
            }
            return null;
        }
        if (classCategory == ReflectConsts.ClassCategory.EnumCategory) {
            int ordinal = numValue.intValue();
            Enum[] values = (Enum[])actualType.getEnumConstants();
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("value " + numValue + " is mismatch enum " + actualType);
        }
        throw new JSONException("value " + numValue + " is mismatch type " + actualType);
    }

    private Object parseStringTo(String value, GenericParameterizedType valueType) throws Exception {
        if (value == null) {
            return null;
        }
        if (valueType == null || valueType == GenericParameterizedType.AnyType) {
            return value;
        }
        Class<?> actualType = valueType.getActualType();
        if (actualType == String.class || actualType == CharSequence.class) {
            return value;
        }
        char[] chars = JSONReader.getChars(value);
        if (actualType == char[].class) {
            return chars;
        }
        ReflectConsts.ClassCategory classCategory = valueType.getActualClassCategory();
        switch (classCategory) {
            case DateCategory: {
                char[] dateChars = new char[chars.length + 2];
                dateChars[0] = 34;
                System.arraycopy(chars, 0, dateChars, 1, chars.length);
                dateChars[chars.length + 1] = 34;
                String pattern = valueType.getDatePattern();
                String timezone = valueType.getDateTimezone();
                return JSONReader.parseDateValue(0, dateChars.length, dateChars, pattern, timezone, actualType);
            }
            case Binary: {
                if (this.parseContext.isByteArrayFromHexString()) {
                    return JSONReader.hexString2Bytes(chars, 0, chars.length);
                }
                return Base64.getDecoder().decode(value);
            }
            case EnumCategory: {
                try {
                    Class<?> enumCls = actualType;
                    return Enum.valueOf(enumCls, value);
                }
                catch (RuntimeException exception) {
                    if (this.parseContext.isUnknownEnumAsNull()) {
                        return null;
                    }
                    throw exception;
                }
            }
            case CharSequence: {
                if (actualType == StringBuffer.class) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(chars);
                    return buffer;
                }
                if (actualType == StringBuilder.class) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(chars);
                    return builder;
                }
                if (actualType == Character.class || actualType == Character.TYPE) {
                    if (chars.length == 1) {
                        return Character.valueOf(chars[0]);
                    }
                    throw new JSONException("value " + value + " is mismatch " + actualType);
                }
                return null;
            }
            case ClassCategory: {
                return Class.forName(value);
            }
        }
        throw new JSONException("value " + value + " is mismatch " + actualType);
    }

    private void invokeValueOfObject(String key, Object value, String nextPath, boolean externalImpl, boolean assignableFromMap, Map mapInstane, Object instance, SetterInfo setterInfo) throws Exception {
        if (!externalImpl) {
            if (assignableFromMap) {
                mapInstane.put(key, value);
            } else if (setterInfo != null) {
                setterInfo.invoke(instance, value);
            }
        } else {
            this.callback.parseValue(key, value, instance, -1, nextPath);
        }
    }

    private void parseCollectionElement(boolean externalImpl, Object value, Collection arrInstance, Object instance, int elementIndex, String nextPath) throws Exception {
        if (!externalImpl) {
            arrInstance.add(value);
        } else {
            this.callback.parseValue(null, value, instance, elementIndex, nextPath);
        }
    }

    private void abortRead() {
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private Object readArray(String path, GenericParameterizedType genericType) throws Exception {
        ArrayList instance;
        ArrayList<Object> arrInstance = null;
        Class<?> collectionCls = null;
        GenericParameterizedType<?> valueType = null;
        Class<?> actualType = null;
        boolean isArrayCls = false;
        if (genericType != null) {
            collectionCls = genericType.getActualType();
            valueType = genericType.getValueType();
            actualType = valueType == null ? null : valueType.getActualType();
        }
        boolean externalImpl = this.isExternalImpl();
        if (!this.isExternalImpl()) {
            if (collectionCls == null || collectionCls == ArrayList.class) {
                arrInstance = new ArrayList();
            } else {
                isArrayCls = collectionCls.isArray();
                if (isArrayCls) {
                    arrInstance = new ArrayList();
                    actualType = collectionCls.getComponentType();
                    if (valueType == null) {
                        valueType = GenericParameterizedType.actualType(actualType);
                    }
                } else {
                    arrInstance = JSONReader.createCollectionInstance(collectionCls);
                }
            }
            instance = arrInstance;
        } else {
            instance = this.callback.created(path, 2);
        }
        int elementIndex = 0;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                if (elementIndex > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + this.pos);
                }
                return isArrayCls ? JSONReader.collectionToArray(arrInstance, actualType == null ? Object.class : actualType) : arrInstance;
            }
            boolean toBreakOrContinue = false;
            String nextPath = externalImpl ? path + "/[" + elementIndex + "]" : null;
            switch (this.current) {
                case 123: {
                    Object value = this.readObject(nextPath, valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 91: {
                    Object value = this.readArray(nextPath, valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 34: {
                    Object value = this.parseStringTo(this.readString(), valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 110: {
                    this.readNull();
                    this.parseCollectionElement(externalImpl, null, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 116: {
                    this.readTrue();
                    Object value = this.toBoolType(true, valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 102: {
                    this.readFalse();
                    Object value = this.toBoolType(false, valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                default: {
                    Object value = this.parseNumberTo(this.readNumber(']'), valueType);
                    toBreakOrContinue = true;
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
            }
            if (this.isAborted()) {
                return isArrayCls ? JSONReader.collectionToArray(arrInstance, actualType == null ? Object.class : actualType) : arrInstance;
            }
            if (this.callback != null && this.callback.isAbored()) {
                this.abortRead();
                return isArrayCls ? JSONReader.collectionToArray(arrInstance, actualType == null ? Object.class : actualType) : arrInstance;
            }
            ++elementIndex;
            if (!toBreakOrContinue) {
                this.clearWhitespaces();
            }
            if (this.current == 93) break;
            if (this.current == 44) continue;
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
        return isArrayCls ? JSONReader.collectionToArray(arrInstance, actualType == null ? Object.class : actualType) : arrInstance;
    }

    protected final void throwUnexpectedException() {
        throw new JSONException("Syntax error, unexpected token character '" + (char)this.current + "', position " + this.pos);
    }

    protected void beginCurrent() {
        this.beginReading(-1);
    }

    protected String readString() throws Exception {
        this.beginReading(0);
        int prev = 0;
        while (this.readNext() > -1) {
            if (prev == 92) {
                if (this.offset == 1) {
                    int bufferLen = this.bufferWriter.length();
                    this.bufferWriter.setLength(bufferLen - 1);
                }
                switch (this.current) {
                    case 34: {
                        this.endReading(-2, this.offset);
                        this.bufferWriter.append('\"');
                        break;
                    }
                    case 110: {
                        this.endReading(-2, this.offset);
                        this.bufferWriter.append('\n');
                        break;
                    }
                    case 114: {
                        this.endReading(-2, this.offset);
                        this.bufferWriter.append('\r');
                        break;
                    }
                    case 116: {
                        this.endReading(-2, this.offset);
                        this.bufferWriter.append('\t');
                        break;
                    }
                    case 98: {
                        this.endReading(-2, this.offset);
                        this.bufferWriter.append('\b');
                        break;
                    }
                    case 102: {
                        this.endReading(-2, this.offset);
                        this.bufferWriter.append('\f');
                        break;
                    }
                    case 117: {
                        this.endReading(-2, this.offset);
                        this.readingOffset = -1;
                        int c1 = this.readNext(true);
                        int c2 = this.readNext(true);
                        int c3 = this.readNext(true);
                        int c4 = this.readNext(true);
                        int c = JSONReader.hex4(c1, c2, c3, c4);
                        this.readingOffset = this.offset;
                        this.bufferWriter.append((char)c);
                        break;
                    }
                    case 92: {
                        this.endReading(-2, this.offset);
                        this.bufferWriter.append('\\');
                        break;
                    }
                    default: {
                        this.endReading(-2, this.offset);
                        this.bufferWriter.append((char)this.current);
                    }
                }
                prev = 0;
                continue;
            }
            if (this.current == 34) {
                return this.endReadingAsString(-1);
            }
            prev = (char)this.current;
        }
        this.throwUnexpectedException();
        return null;
    }

    protected int readNext() throws Exception {
        ++this.pos;
        if (this.offset < this.count) {
            this.current = this.buf[this.offset++];
            return this.current;
        }
        if (this.reader == null) {
            this.current = -1;
            return -1;
        }
        if (this.count == this.bufferSize) {
            this.readBuffer();
            if (this.count == -1) {
                this.current = -1;
                return -1;
            }
            this.current = this.buf[this.offset++];
            return this.current;
        }
        this.current = -1;
        return -1;
    }

    protected final int readNext(boolean check) throws Exception {
        this.readNext();
        if (check && this.current == -1) {
            this.close();
            throw new JSONException("Unexpected error, stream is end ");
        }
        return this.current;
    }

    private void clearWhitespaces() throws Exception {
        while (this.readNext() > -1 && this.current <= 32) {
        }
    }

    private boolean isExternalImpl() {
        return this.callback != null && this.callback.readParseMode == ReadParseMode.ExternalImpl;
    }

    protected boolean isCompleted() {
        return this.reader == null || this.count < this.bufferSize;
    }

    public Object getResult() {
        return this.getResult(this.timeout);
    }

    public Object getResult(long timeout) {
        if (this.async) {
            long threadId = Thread.currentThread().getId();
            if (threadId != this.currentThreadId) {
                return this.result;
            }
            this.await(timeout);
        }
        return this.result;
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.closed = true;
            }
            this.bufferWriter.setLength(0);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class ReaderCallback {
        private final ReadParseMode readParseMode;
        private boolean abored;

        public ReaderCallback() {
            this(ReadParseMode.BuiltParse);
        }

        public ReaderCallback(ReadParseMode readParseMode) {
            this.readParseMode = readParseMode;
        }

        public Object created(String path, int type) throws Exception {
            return null;
        }

        public void parseValue(String key, Object value, Object host, int elementIndex, String path) throws Exception {
        }

        protected void complete(Object result) {
        }

        protected final void abort() {
            this.abored = true;
        }

        final boolean isAbored() {
            return this.abored;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReadParseMode {
        BuiltParse,
        ExternalImpl;

    }
}

