/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.json.JSONByteArrayParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JSONSimpleParser
extends JSONGeneral {
    public static Object parse(String json) {
        byte code;
        json.getClass();
        if (StringCoder && (code = UnsafeHelper.getStringCoder(json)) == 0) {
            byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
            return JSONSimpleParser.parse(json, bytes);
        }
        return JSONSimpleParser.parse(json, JSONSimpleParser.getChars(json));
    }

    static Object parse(String source, char[] buf) {
        int fromIndex;
        int toIndex = buf.length;
        char beginChar = '\u0000';
        for (fromIndex = 0; fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' '; ++fromIndex) {
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        try {
            Object result;
            switch (beginChar) {
                case '{': {
                    result = JSONSimpleParser.parseJSONObject(source, buf, fromIndex, toIndex, new LinkedHashMap(), jsonParseContext);
                    break;
                }
                case '[': {
                    result = JSONSimpleParser.parseJSONArray(source, buf, fromIndex, toIndex, new ArrayList(), jsonParseContext);
                    break;
                }
                case '\"': {
                    result = JSONSimpleParser.parseJSONString(source, buf, fromIndex, toIndex, beginChar, jsonParseContext);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginChar + "'");
                }
            }
            int endIndex = jsonParseContext.getEndIndex();
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                String errorContextTextAt = JSONSimpleParser.createErrorContextText(buf, endIndex + 1);
                throw new JSONException("Syntax error, at pos " + endIndex + ", context text by '" + errorContextTextAt + "', extra characters found, '" + new String(buf, endIndex + 1, wordNum) + " ...'");
            }
            Object object = result;
            Object var11_13 = null;
            jsonParseContext.clear();
            return object;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof JSONException) {
                    throw (JSONException)ex;
                }
                if (ex instanceof IndexOutOfBoundsException) {
                    String errorContextTextAt = JSONSimpleParser.createErrorContextText(buf, toIndex);
                    throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.");
                }
                throw new JSONException("Error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                jsonParseContext.clear();
                throw throwable;
            }
        }
    }

    static Collection parseJSONArray(String source, char[] buf, int fromIndex, int toIndex, Collection list, JSONParseContext jsonParseContext) throws Exception {
        int beginIndex;
        int i = beginIndex = fromIndex + 1;
        while (true) {
            block16: {
                char ch;
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (ch == ']') {
                    if (list.size() > 0) {
                        throw new JSONException("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return list;
                }
                switch (ch) {
                    case '{': {
                        Object value = JSONSimpleParser.parseJSONObject(source, buf, i, toIndex, new LinkedHashMap(), jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case '[': {
                        Object value = JSONSimpleParser.parseJSONArray(source, buf, i, toIndex, new ArrayList(), jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        Object value = JSONSimpleParser.parseJSONString(source, buf, i, toIndex, ch, jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case 'n': {
                        Object value = JSONTypeDeserializer.NULL.deserialize(null, buf, i, toIndex, null, null, '\u0000', jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    case 't': {
                        Object value = JSONTypeDeserializer.BOOLEAN.deserializeTrue(buf, i, toIndex, null, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    case 'f': {
                        Object value = JSONTypeDeserializer.BOOLEAN.deserializeFalse(buf, i, toIndex, null, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    default: {
                        Object value = JSONTypeDeserializer.NUMBER.deserialize(null, buf, i, toIndex, GenericParameterizedType.AnyType, null, ']', jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        char next = buf[++i];
                        if (next == ']') {
                            jsonParseContext.setEndIndex(i);
                            return list;
                        }
                        break block16;
                    }
                }
                while ((ch = buf[++i]) <= ' ') {
                }
                if (ch != ',') {
                    if (ch == ']') {
                        jsonParseContext.setEndIndex(i);
                        return list;
                    }
                    String errorContextTextAt = JSONSimpleParser.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or ']'");
                }
            }
            ++i;
        }
    }

    static Map parseJSONObject(String source, char[] buf, int fromIndex, int toIndex, Map instance, JSONParseContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        boolean empty = true;
        int i = beginIndex;
        while (true) {
            block23: {
                char ch;
                block22: {
                    String key;
                    if ((ch = buf[i]) <= ' ') {
                        ++i;
                        continue;
                    }
                    if (ch == '\"') {
                        int endIndex = source.indexOf(34, i + 1);
                        key = new String(buf, i + 1, endIndex - i - 1);
                        i = endIndex;
                        empty = false;
                        ++i;
                    } else {
                        if (ch == '}') {
                            if (!empty) {
                                throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                            }
                            jsonParseContext.setEndIndex(i);
                            return instance;
                        }
                        boolean isNullKey = false;
                        int j = i++;
                        key = null;
                        if (ch == 'n' && buf[i] == 'u' && buf[++i] == 'l' && buf[++i] == 'l') {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = JSONSimpleParser.createErrorContextText(buf, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected '\"' ");
                        }
                    }
                    while ((ch = buf[i]) <= ' ') {
                        ++i;
                    }
                    if (ch != ':') break block22;
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    switch (ch) {
                        case '{': {
                            Object value = JSONSimpleParser.parseJSONObject(source, buf, i, toIndex, new LinkedHashMap(), jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case '[': {
                            Object value = JSONSimpleParser.parseJSONArray(source, buf, i, toIndex, new ArrayList(), jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            Object value = JSONSimpleParser.parseJSONString(source, buf, i, toIndex, ch, jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case 'n': {
                            Object value = JSONTypeDeserializer.NULL.deserialize(null, buf, i, toIndex, null, null, '\u0000', jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case 't': {
                            Object value = JSONTypeDeserializer.BOOLEAN.deserializeTrue(buf, i, toIndex, null, jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case 'f': {
                            Object value = JSONTypeDeserializer.BOOLEAN.deserializeFalse(buf, i, toIndex, null, jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        default: {
                            Object value = JSONTypeDeserializer.NUMBER.deserialize(null, buf, i, toIndex, GenericParameterizedType.AnyType, null, '}', jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            char next = buf[++i];
                            if (next == '}') {
                                jsonParseContext.setEndIndex(i);
                                return instance;
                            }
                            break block23;
                        }
                    }
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (ch != ',') {
                        if (ch == '}') {
                            jsonParseContext.setEndIndex(i);
                            return instance;
                        }
                        String errorContextTextAt = JSONSimpleParser.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + ch + "', expected ',' or '}'");
                    }
                    break block23;
                }
                throw new JSONException("Syntax error, at pos " + i + ", unexpected token character '" + ch + "', Colon character ':' is expected.");
            }
            ++i;
        }
    }

    static String parseJSONString(String source, char[] buf, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        int endIndex = source.indexOf(endCh, beginIndex);
        char prev = buf[endIndex - 1];
        if (prev == '\\') {
            while ((prev = buf[(endIndex = source.indexOf(endCh, endIndex + 1)) - 1]) == '\\') {
            }
        }
        jsonParseContext.setEndIndex(endIndex);
        int len = endIndex - beginIndex;
        return len == 0 ? "" : new String(buf, beginIndex, len);
    }

    static Object parse(String source, byte[] bytes) {
        int fromIndex;
        int toIndex = bytes.length;
        byte beginByte = 0;
        for (fromIndex = 0; fromIndex < toIndex && (beginByte = bytes[fromIndex]) <= 32; ++fromIndex) {
        }
        while (toIndex > fromIndex && bytes[toIndex - 1] <= 32) {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        try {
            Object result;
            switch (beginByte) {
                case 123: {
                    result = JSONSimpleParser.parseJSONObject(source, bytes, fromIndex, toIndex, new LinkedHashMap(), jsonParseContext);
                    break;
                }
                case 91: {
                    result = JSONSimpleParser.parseJSONArray(source, bytes, fromIndex, toIndex, new ArrayList(), jsonParseContext);
                    break;
                }
                case 34: {
                    result = JSONSimpleParser.parseJSONString(source, bytes, fromIndex, toIndex, beginByte, jsonParseContext);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginByte + "'");
                }
            }
            int endIndex = jsonParseContext.getEndIndex();
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, bytes.length - endIndex - 1);
                String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, endIndex + 1);
                throw new JSONException("Syntax error, at pos " + endIndex + ", context text by '" + errorContextTextAt + "', extra characters found, '" + new String(bytes, endIndex + 1, wordNum) + " ...'");
            }
            Object object = result;
            Object var11_13 = null;
            jsonParseContext.clear();
            return object;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof JSONException) {
                    throw (JSONException)ex;
                }
                if (ex instanceof IndexOutOfBoundsException) {
                    ex.printStackTrace();
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, toIndex);
                    throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.");
                }
                throw new JSONException("Error: " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                jsonParseContext.clear();
                throw throwable;
            }
        }
    }

    static Collection parseJSONArray(String source, byte[] bytes, int fromIndex, int toIndex, Collection list, JSONParseContext jsonParseContext) throws Exception {
        int beginIndex;
        int i = beginIndex = fromIndex + 1;
        while (true) {
            block16: {
                byte b;
                if ((b = bytes[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (b == 93) {
                    if (list.size() > 0) {
                        throw new JSONException("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.setEndIndex(i);
                    return list;
                }
                switch (b) {
                    case 123: {
                        Object value = JSONSimpleParser.parseJSONObject(source, bytes, i, toIndex, new LinkedHashMap(), jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case 91: {
                        Object value = JSONSimpleParser.parseJSONArray(source, bytes, i, toIndex, new ArrayList(), jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case 34: {
                        Object value = JSONSimpleParser.parseJSONString(source, bytes, i, toIndex, b, jsonParseContext);
                        list.add(value);
                        i = jsonParseContext.getEndIndex();
                        break;
                    }
                    case 110: {
                        Object value = JSONByteArrayParser.parseNull(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    case 116: {
                        Object value = JSONByteArrayParser.parseTrue(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    case 102: {
                        Object value = JSONByteArrayParser.parseFalse(bytes, i, toIndex, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        break;
                    }
                    default: {
                        Object value = JSONByteArrayParser.parseDefaultNumber(bytes, i, toIndex, (byte)93, jsonParseContext);
                        i = jsonParseContext.getEndIndex();
                        list.add(value);
                        char next = (char)bytes[++i];
                        if (next == ']') {
                            jsonParseContext.setEndIndex(i);
                            return list;
                        }
                        break block16;
                    }
                }
                while ((b = bytes[++i]) <= 32) {
                }
                if (b != 44) {
                    if (b == 93) {
                        jsonParseContext.setEndIndex(i);
                        return list;
                    }
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or ']'");
                }
            }
            ++i;
        }
    }

    static Map parseJSONObject(String source, byte[] bytes, int fromIndex, int toIndex, Map instance, JSONParseContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        boolean empty = true;
        int i = beginIndex;
        while (true) {
            block23: {
                byte b;
                block22: {
                    String key;
                    if ((b = bytes[i]) <= 32) {
                        ++i;
                        continue;
                    }
                    int fieldKeyFrom = i;
                    if (b == 34) {
                        int endIndex = source.indexOf(34, i + 1);
                        key = new String(bytes, i + 1, endIndex - i - 1);
                        i = endIndex;
                        empty = false;
                        ++i;
                    } else {
                        if (b == 125) {
                            if (!empty) {
                                throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                            }
                            jsonParseContext.setEndIndex(i);
                            return instance;
                        }
                        int j = i++;
                        boolean isNullKey = false;
                        key = null;
                        if (b == 110 && bytes[i] == 117 && bytes[++i] == 108 && bytes[++i] == 108) {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected '\"'");
                        }
                    }
                    while ((b = bytes[i]) <= 32) {
                        ++i;
                    }
                    if (b != 58) break block22;
                    while ((b = bytes[++i]) <= 32) {
                    }
                    switch (b) {
                        case 123: {
                            Object value = JSONSimpleParser.parseJSONObject(source, bytes, i, toIndex, new LinkedHashMap(), jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case 91: {
                            Object value = JSONSimpleParser.parseJSONArray(source, bytes, i, toIndex, new ArrayList(), jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case 34: {
                            Object value = JSONSimpleParser.parseJSONString(source, bytes, i, toIndex, b, jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case 110: {
                            Object value = JSONByteArrayParser.parseNull(bytes, i, toIndex, jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case 116: {
                            Object value = JSONByteArrayParser.parseTrue(bytes, i, toIndex, jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        case 102: {
                            Object value = JSONByteArrayParser.parseFalse(bytes, i, toIndex, jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            break;
                        }
                        default: {
                            Object value = JSONByteArrayParser.parseDefaultNumber(bytes, i, toIndex, (byte)125, jsonParseContext);
                            i = jsonParseContext.getEndIndex();
                            instance.put(key, value);
                            char next = (char)bytes[++i];
                            if (next == '}') {
                                jsonParseContext.setEndIndex(i);
                                return instance;
                            }
                            break block23;
                        }
                    }
                    while ((b = bytes[++i]) <= 32) {
                    }
                    if (b != 44) {
                        if (b == 125) {
                            jsonParseContext.setEndIndex(i);
                            return instance;
                        }
                        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(bytes, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token character '" + b + "', expected ',' or '}'");
                    }
                    break block23;
                }
                throw new JSONException("Syntax error, at pos " + i + ", unexpected token character '" + b + "', Colon character ':' is expected.");
            }
            ++i;
        }
    }

    static String parseJSONString(String source, byte[] bytes, int from, int toIndex, byte endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        int endIndex = source.indexOf(endCh, beginIndex);
        byte prev = bytes[endIndex - 1];
        if (prev == 92) {
            while ((prev = bytes[(endIndex = source.indexOf(endCh, endIndex + 1)) - 1]) == 92) {
            }
        }
        jsonParseContext.setEndIndex(endIndex);
        int len = endIndex - beginIndex;
        return len == 0 ? "" : new String(bytes, beginIndex, len);
    }
}

