/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.JSONByteArrayParser;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.temporal.TemporalInstantDeserializer;
import io.github.wycst.wast.json.temporal.TemporalLocalDateDeserializer;
import io.github.wycst.wast.json.temporal.TemporalLocalDateTimeDeserializer;
import io.github.wycst.wast.json.temporal.TemporalLocalTimeDeserializer;
import io.github.wycst.wast.json.temporal.TemporalZonedDateTimeDeserializer;
import java.lang.reflect.InvocationTargetException;

public abstract class JSONTemporalDeserializer
extends JSONTypeDeserializer {
    protected int patternType;
    protected DateTemplate dateTemplate;

    protected JSONTemporalDeserializer(GenericParameterizedType parameterizedType) {
        this.checkClass(parameterizedType);
        String pattern = parameterizedType.getDatePattern();
        this.patternType = JSONTemporalDeserializer.getPatternType(pattern);
        if (this.patternType == 0) {
            this.createDefaultTemplate();
        } else {
            this.dateTemplate = new DateTemplate(pattern);
        }
    }

    static JSONTypeDeserializer getTemporalDeserializerInstance(ClassStructureWrapper.ClassWrapperType classWrapperType, GenericParameterizedType genericParameterizedType) {
        switch (classWrapperType) {
            case TemporalLocalDate: {
                return new TemporalLocalDateDeserializer(genericParameterizedType);
            }
            case TemporalLocalTime: {
                return new TemporalLocalTimeDeserializer(genericParameterizedType);
            }
            case TemporalLocalDateTime: {
                return new TemporalLocalDateTimeDeserializer(genericParameterizedType);
            }
            case TemporalZonedDateTime: {
                return new TemporalZonedDateTimeDeserializer(genericParameterizedType);
            }
            case TemporalInstant: {
                return new TemporalInstantDeserializer(genericParameterizedType);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected void createDefaultTemplate() {
    }

    protected abstract void checkClass(GenericParameterizedType var1);

    protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
        char beginChar = buf[fromIndex];
        switch (beginChar) {
            case '\"': {
                STRING.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                int endIndex = jsonParseContext.getEndIndex();
                try {
                    return this.deserializeTemporal(buf, fromIndex, endIndex, jsonParseContext);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable).getTargetException();
                    }
                    String source = new String(buf, fromIndex + 1, endIndex - fromIndex - 1);
                    String errorContextTextAt = JSONTemporalDeserializer.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', temporal text '" + source + "' cannot convert to the temporal type , exception: " + throwable.getMessage());
                }
            }
            case 'n': {
                return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
        }
        String errorContextTextAt = JSONTemporalDeserializer.createErrorContextText(buf, fromIndex);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Temporal Type, expected '\"' ");
    }

    protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        byte beginByte = buf[fromIndex];
        char beginChar = (char)beginByte;
        switch (beginChar) {
            case '\"': {
                STRING.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                int endIndex = jsonParseContext.getEndIndex();
                try {
                    return this.deserializeTemporal(buf, fromIndex, endIndex, jsonParseContext);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable).getTargetException();
                    }
                    String source = new String(buf, fromIndex + 1, endIndex - fromIndex - 1);
                    String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', temporal text '" + source + "' cannot convert to the temporal type , exception: " + throwable.getMessage());
                }
            }
            case 'n': {
                return JSONByteArrayParser.parseNull(buf, fromIndex, toIndex, jsonParseContext);
            }
        }
        String errorContextTextAt = JSONByteArrayParser.createErrorMessage(buf, fromIndex);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected token character '" + beginChar + "' for Temporal Type, expected '\"' ");
    }

    protected abstract Object deserializeTemporal(char[] var1, int var2, int var3, JSONParseContext var4) throws Exception;

    protected abstract Object deserializeTemporal(byte[] var1, int var2, int var3, JSONParseContext var4) throws Exception;
}

