/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateFormatter;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.options.JsonConfig;
import io.github.wycst.wast.json.reflect.ObjectStructureWrapper;
import io.github.wycst.wast.json.temporal.TemporalInstantSerializer;
import io.github.wycst.wast.json.temporal.TemporalLocalDateSerializer;
import io.github.wycst.wast.json.temporal.TemporalLocalDateTimeSerializer;
import io.github.wycst.wast.json.temporal.TemporalLocalTimeSerializer;
import io.github.wycst.wast.json.temporal.TemporalZonedDateTimeSerializer;
import java.io.Writer;

public abstract class JSONTemporalSerializer
extends JSONTypeSerializer {
    protected final ObjectStructureWrapper objectStructureWrapper;
    protected DateFormatter dateFormatter;
    protected final boolean useFormatter;

    protected JSONTemporalSerializer(ObjectStructureWrapper objectStructureWrapper, JsonProperty property) {
        String pattern;
        this.checkClass(objectStructureWrapper);
        this.objectStructureWrapper = objectStructureWrapper;
        if (property != null && (pattern = property.pattern().trim()).length() > 0) {
            this.dateFormatter = DateFormatter.of(pattern);
        }
        this.useFormatter = this.dateFormatter != null;
    }

    static JSONTypeSerializer getTemporalSerializerInstance(ObjectStructureWrapper objectStructureWrapper, JsonProperty property) {
        ClassStructureWrapper.ClassWrapperType classWrapperType = objectStructureWrapper.getClassWrapperType();
        switch (classWrapperType) {
            case TemporalLocalDate: {
                return new TemporalLocalDateSerializer(objectStructureWrapper, property);
            }
            case TemporalLocalTime: {
                return new TemporalLocalTimeSerializer(objectStructureWrapper, property);
            }
            case TemporalLocalDateTime: {
                return new TemporalLocalDateTimeSerializer(objectStructureWrapper, property);
            }
            case TemporalZonedDateTime: {
                return new TemporalZonedDateTimeSerializer(objectStructureWrapper, property);
            }
            case TemporalInstant: {
                return new TemporalInstantSerializer(objectStructureWrapper, property);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected abstract void checkClass(ObjectStructureWrapper var1);

    protected void serialize(Object value, Writer writer, JsonConfig jsonConfig, int indent) throws Exception {
        if (this.useFormatter) {
            this.writeTemporalWithTemplate(value, writer, jsonConfig);
        } else {
            this.writeDefault(value, writer, jsonConfig, indent);
        }
    }

    protected abstract void writeTemporalWithTemplate(Object var1, Writer var2, JsonConfig var3) throws Exception;

    protected void writeDefault(Object value, Writer writer, JsonConfig jsonConfig, int indent) throws Exception {
        String temporal = value.toString();
        STRING.serialize(temporal, writer, jsonConfig, indent);
    }

    protected final void writeYYYY_MM_dd_T_HH_mm_ss_SSS(Writer writer, int year, int month, int day, int hour, int minute, int second, int millisecond) throws Exception {
        int y1 = year / 100;
        int y2 = year - y1 * 100;
        writer.write(DigitTens[y1]);
        writer.write(DigitOnes[y1]);
        writer.write(DigitTens[y2]);
        writer.write(DigitOnes[y2]);
        writer.write(45);
        writer.write(DigitTens[month]);
        writer.write(DigitOnes[month]);
        writer.write(45);
        writer.write(DigitTens[day]);
        writer.write(DigitOnes[day]);
        writer.write(84);
        writer.write(DigitTens[hour]);
        writer.write(DigitOnes[hour]);
        writer.write(58);
        writer.write(DigitTens[minute]);
        writer.write(DigitOnes[minute]);
        writer.write(58);
        writer.write(DigitTens[second]);
        writer.write(DigitOnes[second]);
        writer.write(46);
        char s1 = (char)(millisecond / 100 + 48);
        int v = millisecond % 100;
        writer.write(s1);
        writer.write(DigitTens[v]);
        writer.write(DigitOnes[v]);
    }
}

