/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateFormatter;
import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.tools.Base64;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONStringWriter;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.options.JsonConfig;
import io.github.wycst.wast.json.reflect.FieldSerializer;
import io.github.wycst.wast.json.reflect.ObjectStructureWrapper;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.sql.Time;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONTypeSerializer
extends JSONGeneral {
    static final int LENGTH = ReflectConsts.ClassCategory.values().length;
    static final JSONTypeSerializer[] TYPE_SERIALIZERS = new JSONTypeSerializer[LENGTH];
    private static final Map<Class<?>, JSONTypeSerializer> classJSONTypeSerializerMap = new ConcurrentHashMap();
    protected static final CharSequenceSerializer STRING = new CharSequenceSerializer();

    private static void putTypeSerializer(JSONTypeSerializer typeSerializer, Class ... types) {
        for (Class type : types) {
            classJSONTypeSerializerMap.put(type, typeSerializer);
        }
    }

    protected static JSONTypeSerializer getTypeSerializer(ReflectConsts.ClassCategory classCategory, JsonProperty jsonProperty) {
        int ordinal = classCategory.ordinal();
        if (classCategory == ReflectConsts.ClassCategory.DateCategory && jsonProperty != null) {
            return new DateSerializer.DateInstanceSerializer(jsonProperty);
        }
        if (classCategory == ReflectConsts.ClassCategory.NonInstance) {
            return new ObjectSerializer.ObjectWithTypeSerializer();
        }
        return TYPE_SERIALIZERS[ordinal];
    }

    protected static JSONTypeSerializer getTypeSerializer(Class<?> cls) {
        JSONTypeSerializer typeSerializer = classJSONTypeSerializerMap.get(cls);
        if (typeSerializer != null) {
            return typeSerializer;
        }
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(cls);
        typeSerializer = classCategory == ReflectConsts.ClassCategory.ObjectCategory ? new ObjectSerializer.ObjectWrapperSerializer(cls) : JSONTypeSerializer.getTypeSerializer(classCategory, null);
        classJSONTypeSerializerMap.put(cls, typeSerializer);
        return typeSerializer;
    }

    protected static JSONTypeSerializer getFieldTypeSerializer(ReflectConsts.ClassCategory classCategory, Class<?> type, JsonProperty jsonProperty) {
        ObjectStructureWrapper objectStructureWrapper;
        if (classCategory == ReflectConsts.ClassCategory.NumberCategory) {
            return JSONTypeSerializer.getTypeSerializer(type);
        }
        if (classCategory == ReflectConsts.ClassCategory.ObjectCategory && (objectStructureWrapper = ObjectStructureWrapper.get(type)).isTemporal()) {
            return JSONTemporalSerializer.getTemporalSerializerInstance(objectStructureWrapper, jsonProperty);
        }
        return JSONTypeSerializer.getTypeSerializer(classCategory, jsonProperty);
    }

    protected static JSONTypeSerializer getValueSerializer(Object value) {
        return JSONTypeSerializer.getTypeSerializer(value.getClass());
    }

    protected abstract void serialize(Object var1, Writer var2, JsonConfig var3, int var4) throws Exception;

    static {
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.CharSequence.ordinal()] = STRING;
        SimpleSerializer SIMPLE = new SimpleSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.NumberCategory.ordinal()] = SIMPLE;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.BoolCategory.ordinal()] = SIMPLE;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.DateCategory.ordinal()] = new DateSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ClassCategory.ordinal()] = new ClassSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.EnumCategory.ordinal()] = new EnumSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.AnnotationCategory.ordinal()] = new AnnotationSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.Binary.ordinal()] = new BinarySerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ArrayCategory.ordinal()] = new ArraySerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.CollectionCategory.ordinal()] = new CollectionSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.MapCategory.ordinal()] = new MapSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ObjectCategory.ordinal()] = new ObjectSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ANY.ordinal()] = new ANYSerializer();
        SimpleSerializer.SimpleIntegerSerializer integerSerializer = new SimpleSerializer.SimpleIntegerSerializer();
        JSONTypeSerializer.putTypeSerializer(integerSerializer, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class);
    }

    private static class ANYSerializer
    extends JSONTypeSerializer {
        private ANYSerializer() {
        }

        protected void serialize(Object value, Writer writer, JsonConfig jsonConfig, int indent) throws Exception {
            Class<?> clazz = value.getClass();
            if (clazz == Object.class) {
                writer.write(EMPTY_OBJECT);
            } else {
                ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(clazz);
                int ordinal = classCategory.ordinal();
                TYPE_SERIALIZERS[ordinal].serialize(value, writer, jsonConfig, indent);
            }
        }
    }

    private static class ObjectSerializer
    extends JSONTypeSerializer {
        private ObjectSerializer() {
        }

        protected void serialize(Object obj, Writer content, JsonConfig jsonConfig, int indentLevel) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    content.write(NULL);
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            boolean writeFullProperty = jsonConfig.isFullProperty();
            boolean formatOut = jsonConfig.isFormatOut();
            content.append('{');
            Class<?> clazz = obj.getClass();
            ObjectStructureWrapper classStructureWrapper = this.getObjectStructureWrapper(clazz);
            boolean isFirstKey = this.isWriteType(content, clazz, formatOut, indentLevel);
            FieldSerializer[] fieldSerializers = classStructureWrapper.getFieldSerializers(jsonConfig.isUseFields());
            boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
            boolean camelCaseToUnderline = jsonConfig.isCamelCaseToUnderline();
            for (FieldSerializer fieldSerializer : fieldSerializers) {
                Object value;
                GetterInfo getterInfo = fieldSerializer.getGetterInfo();
                if (!getterInfo.existField() && skipGetterOfNoExistField || (value = getterInfo.invoke(obj)) == null && !writeFullProperty) continue;
                char[] quotBuffers = fieldSerializer.getFixedFieldName();
                if (isFirstKey) {
                    isFirstKey = false;
                } else {
                    content.append(",");
                }
                ObjectSerializer.writeFormatSymbolOut(content, indentLevel + 1, formatOut);
                if (value == null) {
                    if (camelCaseToUnderline) {
                        content.append('\"').append(getterInfo.getUnderlineName()).append("\":null");
                        continue;
                    }
                    content.write(quotBuffers, 1, quotBuffers.length - 2);
                    continue;
                }
                if (camelCaseToUnderline) {
                    content.append('\"').append(getterInfo.getUnderlineName()).append("\":");
                } else {
                    content.write(quotBuffers, 1, quotBuffers.length - 6);
                }
                JSONTypeSerializer serializer = fieldSerializer.getSerializer();
                serializer.serialize(value, content, jsonConfig, formatOut ? indentLevel + 1 : -1);
            }
            ObjectSerializer.writeFormatSymbolOut(content, indentLevel, formatOut);
            content.append('}');
            jsonConfig.setStatus(hashcode, -1);
        }

        ObjectStructureWrapper getObjectStructureWrapper(Class clazz) {
            return ObjectStructureWrapper.get(clazz);
        }

        boolean isWriteType(Writer content, Class clazz, boolean formatOut, int indentLevel) throws IOException {
            return true;
        }

        static class ObjectWrapperSerializer
        extends ObjectSerializer {
            final ObjectStructureWrapper classStructureWrapper;

            ObjectWrapperSerializer(Class cls) {
                this.classStructureWrapper = ObjectStructureWrapper.get(cls);
            }

            ObjectStructureWrapper getObjectStructureWrapper(Class clazz) {
                return this.classStructureWrapper;
            }
        }

        static class ObjectWithTypeSerializer
        extends ObjectSerializer {
            ObjectWithTypeSerializer() {
            }

            protected void serialize(Object obj, Writer content, JsonConfig jsonConfig, int indentLevel) throws Exception {
                ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(obj.getClass());
                if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) {
                    ObjectWithTypeSerializer.getTypeSerializer(classCategory, null).serialize(obj, content, jsonConfig, indentLevel);
                } else {
                    super.serialize(obj, content, jsonConfig, indentLevel);
                }
            }

            boolean isWriteType(Writer content, Class clazz, boolean formatOut, int indentLevel) throws IOException {
                ObjectWithTypeSerializer.writeFormatSymbolOut(content, indentLevel + 1, formatOut);
                content.append("\"@c\":\"");
                content.append(clazz.getName());
                content.append("\"");
                return false;
            }
        }
    }

    private static class MapSerializer
    extends JSONTypeSerializer {
        private MapSerializer() {
        }

        private static void writeMapValue(Object obj, Writer content, JsonConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            Map map = (Map)obj;
            if (map.size() == 0) {
                content.write(EMPTY_OBJECT);
            } else {
                content.write(123);
                Set entrySet = map.entrySet();
                boolean isFirstKey = true;
                for (Map.Entry entry : entrySet) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (isFirstKey) {
                        isFirstKey = false;
                    } else {
                        content.append(',');
                    }
                    MapSerializer.writeFormatSymbolOut(content, indentLevel + 1, formatOut);
                    if (jsonConfig.isAllowUnquotedMapKey() && (key == null || key instanceof Number)) {
                        content.append(String.valueOf(key)).append(':');
                    } else {
                        content.append('\"').append(key.toString()).append('\"').append(':');
                    }
                    if (value == null) {
                        content.write(NULL);
                        continue;
                    }
                    JSONTypeSerializer valueSerializer = MapSerializer.getValueSerializer(value);
                    valueSerializer.serialize(value, content, jsonConfig, formatOut ? indentLevel + 1 : -1);
                }
                MapSerializer.writeFormatSymbolOut(content, indentLevel, formatOut);
                content.write(125);
            }
        }

        protected void serialize(Object obj, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    content.write(NULL);
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            MapSerializer.writeMapValue(obj, content, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }
    }

    private static class CollectionSerializer
    extends JSONTypeSerializer {
        private CollectionSerializer() {
        }

        private static void writeCollectionValue(Object obj, Writer content, JsonConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            Collection collect = (Collection)obj;
            if (collect.size() == 0) {
                content.write(EMPTY_ARRAY);
            } else {
                content.write(91);
                int lastLevel = indentLevel;
                boolean isFirstElement = true;
                for (Object value : collect) {
                    if (isFirstElement) {
                        isFirstElement = false;
                    } else {
                        content.write(44);
                    }
                    lastLevel = indentLevel + 1;
                    CollectionSerializer.writeFormatSymbolOut(content, lastLevel, formatOut);
                    if (value == null) {
                        content.write(NULL);
                        continue;
                    }
                    JSONTypeSerializer valueSerializer = CollectionSerializer.getValueSerializer(value);
                    valueSerializer.serialize(value, content, jsonConfig, formatOut ? indentLevel + 1 : -1);
                }
                if (lastLevel > indentLevel) {
                    CollectionSerializer.writeFormatSymbolOut(content, indentLevel, formatOut);
                }
                content.append(']');
            }
        }

        protected void serialize(Object obj, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    content.write(NULL);
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            CollectionSerializer.writeCollectionValue(obj, content, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }
    }

    private static class ArraySerializer
    extends JSONTypeSerializer {
        private ArraySerializer() {
        }

        static void writeArrayValue(Object obj, Writer content, JsonConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            int length = Array.getLength(obj);
            if (length == 0) {
                content.write(EMPTY_ARRAY);
            } else {
                content.write(91);
                int lastLevel = indentLevel;
                boolean isFirstKey = true;
                for (int i = 0; i < length; ++i) {
                    if (isFirstKey) {
                        isFirstKey = false;
                    } else {
                        content.append(",");
                    }
                    lastLevel = indentLevel + 1;
                    ArraySerializer.writeFormatSymbolOut(content, lastLevel, formatOut);
                    Object value = ArraySerializer.getArrayValueAt(obj, i);
                    if (value == null) {
                        content.write(NULL);
                        continue;
                    }
                    JSONTypeSerializer valueSerializer = ArraySerializer.getValueSerializer(value);
                    valueSerializer.serialize(value, content, jsonConfig, formatOut ? indentLevel + 1 : -1);
                }
                if (lastLevel > indentLevel) {
                    ArraySerializer.writeFormatSymbolOut(content, indentLevel, formatOut);
                }
                content.append(']');
            }
        }

        protected void serialize(Object obj, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    content.write(NULL);
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            ArraySerializer.writeArrayValue(obj, content, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }
    }

    private static class BinarySerializer
    extends JSONTypeSerializer {
        private BinarySerializer() {
        }

        protected void serialize(Object value, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            if (jsonConfig.isBytesArrayToNative()) {
                ArraySerializer.writeArrayValue(value, content, jsonConfig, indent);
            } else {
                byte[] bytes = (byte[])value;
                if (jsonConfig.isBytesArrayToHex()) {
                    content.append('\"').append(BinarySerializer.printHexString(bytes, '\u0000')).append('\"');
                } else {
                    content.append('\"').append(Base64.getEncoder().encodeToString(bytes)).append('\"');
                }
            }
        }
    }

    private static class AnnotationSerializer
    extends JSONTypeSerializer {
        private AnnotationSerializer() {
        }

        protected void serialize(Object value, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            content.append('\"').append(value.toString()).append('\"');
        }
    }

    private static class ClassSerializer
    extends JSONTypeSerializer {
        private ClassSerializer() {
        }

        protected void serialize(Object value, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            content.append('\"').append(((Class)value).getName()).append('\"');
        }
    }

    private static class EnumSerializer
    extends JSONTypeSerializer {
        private EnumSerializer() {
        }

        protected void serialize(Object value, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            Enum enmuValue = (Enum)value;
            if (jsonConfig.isWriteEnumAsOrdinal()) {
                content.append(String.valueOf(enmuValue.ordinal()));
            } else {
                content.append('\"').append(enmuValue.name()).append('\"');
            }
        }
    }

    private static class DateSerializer
    extends JSONTypeSerializer {
        protected boolean writeDateAsTime;
        protected String pattern;
        protected String timezone;
        protected DateFormatter dateFormatter;

        private DateSerializer() {
        }

        protected void serialize(Object value, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            Date date = (Date)value;
            if (this.writeDateAsTime || jsonConfig.isWriteDateAsTime()) {
                content.append(String.valueOf(date.getTime()));
                return;
            }
            String pattern = this.pattern;
            String timezone = this.timezone;
            if (pattern == null) {
                pattern = jsonConfig.getDateFormatPattern();
            }
            if (timezone == null) {
                timezone = jsonConfig.getTimezone();
            }
            this.writeDate(date, pattern, timezone, content);
        }

        private void writeDate(Date date, String pattern, String timezone, Writer content) throws IOException {
            GeneralDate generalDate = new GeneralDate(date.getTime(), timezone);
            int year = generalDate.getYear();
            int month = generalDate.getMonth();
            int day = generalDate.getDay();
            int hourOfDay = generalDate.getHourOfDay();
            int minute = generalDate.getMinute();
            int second = generalDate.getSecond();
            if (pattern == null) {
                if (date instanceof Time) {
                    DateSerializer.writeDefaultFormatTime(hourOfDay, minute, second, content);
                } else {
                    DateSerializer.writeDefaultFormatDate(year, month, day, hourOfDay, minute, second, content);
                }
                return;
            }
            int millisecond = generalDate.getMillisecond();
            if (this.dateFormatter != null) {
                content.append('\"');
                this.dateFormatter.formatTo(year, month, day, hourOfDay, minute, second, millisecond, content);
                content.append('\"');
                return;
            }
            boolean isAm = generalDate.isAm();
            pattern = pattern.trim();
            int len = pattern.length();
            content.append('\"');
            char prevChar = '\u0000';
            int count = 0;
            for (int i = 0; i <= len; ++i) {
                char ch = '\u0000';
                if (i < len) {
                    ch = pattern.charAt(i);
                }
                if (ch == 'Y') {
                    ch = 'y';
                }
                if (prevChar == ch) {
                    ++count;
                } else {
                    switch (prevChar) {
                        case 'y': {
                            int y2 = year % 100;
                            if (count == 2) {
                                content.write(DigitTens[y2]);
                                content.write(DigitOnes[y2]);
                                break;
                            }
                            int y1 = year / 100;
                            content.write(DigitTens[y1]);
                            content.write(DigitOnes[y1]);
                            content.write(DigitTens[y2]);
                            content.write(DigitOnes[y2]);
                            break;
                        }
                        case 'M': {
                            content.write(DigitTens[month]);
                            content.write(DigitOnes[month]);
                            break;
                        }
                        case 'd': {
                            content.write(DigitTens[day]);
                            content.write(DigitOnes[day]);
                            break;
                        }
                        case 'a': {
                            if (isAm) {
                                content.append("am");
                                break;
                            }
                            content.append("pm");
                            break;
                        }
                        case 'H': {
                            content.write(DigitTens[hourOfDay]);
                            content.write(DigitOnes[hourOfDay]);
                            break;
                        }
                        case 'h': {
                            int h = hourOfDay % 12;
                            if (h == 0) {
                                h = 12;
                            }
                            content.write(DigitTens[h]);
                            content.write(DigitOnes[h]);
                            break;
                        }
                        case 'm': {
                            content.write(DigitTens[minute]);
                            content.write(DigitOnes[minute]);
                            break;
                        }
                        case 's': {
                            content.write(DigitTens[second]);
                            content.write(DigitOnes[second]);
                            break;
                        }
                        case 'S': {
                            content.write(String.valueOf(millisecond));
                            break;
                        }
                        default: {
                            if (prevChar == '\u0000') break;
                            if (count == 1) {
                                if (prevChar == '\"') {
                                    content.append('\\');
                                }
                                content.append(prevChar);
                                break;
                            }
                            int n = count;
                            while (n-- > 0) {
                                if (prevChar == '\"') {
                                    content.append('\\');
                                }
                                content.append(prevChar);
                            }
                            break block0;
                        }
                    }
                    count = 1;
                }
                prevChar = ch;
            }
            content.append('\"');
        }

        private static void writeDefaultFormatDate(int year, int month, int day, int hourOfDay, int minute, int second, Writer content) throws IOException {
            int y1 = year / 100;
            int y2 = year - y1 * 100;
            if (content instanceof JSONStringWriter) {
                JSONStringWriter writer = (JSONStringWriter)content;
                writer.ensureCapacity(21);
                writer.writeDirectly(34);
                writer.writeDirectly((int)DigitTens[y1]);
                writer.writeDirectly((int)DigitOnes[y1]);
                writer.writeDirectly((int)DigitTens[y2]);
                writer.writeDirectly((int)DigitOnes[y2]);
                writer.writeDirectly(45);
                writer.writeDirectly((int)DigitTens[month]);
                writer.writeDirectly((int)DigitOnes[month]);
                writer.writeDirectly(45);
                writer.writeDirectly((int)DigitTens[day]);
                writer.writeDirectly((int)DigitOnes[day]);
                writer.writeDirectly(32);
                writer.writeDirectly((int)DigitTens[hourOfDay]);
                writer.writeDirectly((int)DigitOnes[hourOfDay]);
                writer.writeDirectly(58);
                writer.writeDirectly((int)DigitTens[minute]);
                writer.writeDirectly((int)DigitOnes[minute]);
                writer.writeDirectly(58);
                writer.writeDirectly((int)DigitTens[second]);
                writer.writeDirectly((int)DigitOnes[second]);
                writer.writeDirectly(34);
                return;
            }
            char[] chars = (char[])CachedCharsDate_19.get();
            chars[1] = DigitTens[y1];
            chars[2] = DigitOnes[y1];
            chars[3] = DigitTens[y2];
            chars[4] = DigitOnes[y2];
            chars[6] = DigitTens[month];
            chars[7] = DigitOnes[month];
            chars[9] = DigitTens[day];
            chars[10] = DigitOnes[day];
            chars[12] = DigitTens[hourOfDay];
            chars[13] = DigitOnes[hourOfDay];
            chars[15] = DigitTens[minute];
            chars[16] = DigitOnes[minute];
            chars[18] = DigitTens[second];
            chars[19] = DigitOnes[second];
            content.write(chars);
        }

        private static void writeDefaultFormatTime(int hourOfDay, int minute, int second, Writer content) throws IOException {
            if (content instanceof JSONStringWriter) {
                JSONStringWriter writer = (JSONStringWriter)content;
                writer.ensureCapacity(10);
                writer.writeDirectly(34);
                writer.writeDirectly((int)DigitTens[hourOfDay]);
                writer.writeDirectly((int)DigitOnes[hourOfDay]);
                writer.writeDirectly(58);
                writer.writeDirectly((int)DigitTens[minute]);
                writer.writeDirectly((int)DigitOnes[minute]);
                writer.writeDirectly(58);
                writer.writeDirectly((int)DigitTens[second]);
                writer.writeDirectly((int)DigitOnes[second]);
                writer.writeDirectly(34);
                return;
            }
            content.write(34);
            content.write(DigitTens[hourOfDay]);
            content.write(DigitOnes[hourOfDay]);
            content.write(58);
            content.write(DigitTens[minute]);
            content.write(DigitOnes[minute]);
            content.write(58);
            content.write(DigitTens[second]);
            content.write(DigitOnes[second]);
            content.write(34);
        }

        static class DateInstanceSerializer
        extends DateSerializer {
            public DateInstanceSerializer(JsonProperty jsonProperty) {
                this.writeDateAsTime = jsonProperty.asTimestamp();
                String pattern = jsonProperty.pattern().trim();
                String timezone = jsonProperty.timezone().trim();
                if (pattern.length() > 0) {
                    this.pattern = pattern;
                    this.dateFormatter = DateFormatter.of(pattern);
                }
                if (timezone.length() > 0) {
                    this.timezone = timezone;
                }
            }
        }
    }

    private static class SimpleSerializer
    extends JSONTypeSerializer {
        private SimpleSerializer() {
        }

        protected void serialize(Object value, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            content.append(value.toString());
        }

        static class SimpleIntegerSerializer
        extends SimpleSerializer {
            SimpleIntegerSerializer() {
            }

            static int stringSize(long x) {
                long p = 10L;
                for (int i = 1; i < 19; ++i) {
                    if (x < p) {
                        return i;
                    }
                    p = (p << 3) + (p << 1);
                }
                return 19;
            }

            protected void serialize(Object value, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
                long v;
                int size;
                long numValue = ((Number)value).longValue();
                if (numValue == 0L) {
                    content.append('0');
                    return;
                }
                if (numValue < 0L) {
                    numValue = -numValue;
                    content.append('-');
                }
                int pos = size = SimpleIntegerSerializer.stringSize(numValue);
                if (content instanceof JSONStringWriter) {
                    long v2;
                    JSONStringWriter stringWriter = (JSONStringWriter)content;
                    int count = stringWriter.addLength(size);
                    if ((pos & 1) == 1) {
                        v2 = numValue / 10L;
                        int digit = (int)(numValue - ((v2 << 3) + (v2 << 1)));
                        stringWriter.setCharAt(--count, DigitOnes[digit]);
                        numValue = v2;
                    }
                    while (numValue > 0L) {
                        v2 = numValue / 100L;
                        int digits = (int)(numValue - ((v2 << 6) + (v2 << 5) + (v2 << 2)));
                        stringWriter.setCharAt(--count, DigitOnes[digits]);
                        stringWriter.setCharAt(--count, DigitTens[digits]);
                        numValue = v2;
                    }
                    return;
                }
                char[] contextChars = (char[])CachedChars_20.get();
                if ((pos & 1) == 1) {
                    v = numValue / 10L;
                    int digit = (int)(numValue - ((v << 3) + (v << 1)));
                    contextChars[--pos] = DigitOnes[digit];
                    numValue = v;
                }
                while (numValue > 0L) {
                    v = numValue / 100L;
                    int digits = (int)(numValue - ((v << 6) + (v << 5) + (v << 2)));
                    contextChars[--pos] = DigitOnes[digits];
                    contextChars[--pos] = DigitTens[digits];
                    numValue = v;
                }
                content.write(contextChars, pos, size);
            }
        }
    }

    static class CharSequenceSerializer
    extends JSONTypeSerializer {
        CharSequenceSerializer() {
        }

        protected void serialize(Object value, Writer content, JsonConfig jsonConfig, int indent) throws Exception {
            char[] chars;
            int len;
            boolean isCharSequence = value instanceof CharSequence;
            if (isCharSequence) {
                String strValue = value.toString();
                len = strValue.length();
                chars = CharSequenceSerializer.getChars(strValue);
            } else if (value instanceof char[]) {
                chars = (char[])value;
                len = chars.length;
            } else {
                char c = ((Character)value).charValue();
                chars = new char[]{c};
                len = 1;
            }
            content.append('\"');
            int beginIndex = 0;
            if (!jsonConfig.isDisableEscapeValidate()) {
                for (int i = 0; i < len; ++i) {
                    int length;
                    char ch = chars[i];
                    if (ch == '\\') {
                        length = i - beginIndex;
                        if (length > 0) {
                            content.write(chars, beginIndex, length);
                        }
                        content.append('\\').append('\\');
                        beginIndex = i + 1;
                        continue;
                    }
                    if (ch > '\"' || !needEscapes[ch]) continue;
                    length = i - beginIndex;
                    if (length > 0) {
                        content.write(chars, beginIndex, length);
                    }
                    content.write(escapes[ch]);
                    beginIndex = i + 1;
                }
            }
            content.write(chars, beginIndex, len - beginIndex);
            content.append('\"');
        }
    }
}

