/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.reflect;

import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.annotations.JsonDeserialize;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.custom.JsonDeserializer;
import io.github.wycst.wast.json.options.JSONParseContext;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDeserializer
extends JSONTypeDeserializer {
    private final String name;
    private final int hash;
    private final SetterInfo setterInfo;
    private final JsonProperty jsonProperty;
    private final GenericParameterizedType genericParameterizedType;
    private final ReflectConsts.ClassCategory classCategory;
    private Class<?> implClass;
    private JSONTypeDeserializer deserializer;
    private boolean customDeserialize = false;
    private final String pattern;
    private final String timezone;
    private static final Map<Class<? extends JsonDeserializer>, JsonDeserializer> customDeserializers = new ConcurrentHashMap<Class<? extends JsonDeserializer>, JsonDeserializer>();

    FieldDeserializer(String name, SetterInfo setterInfo, JsonProperty jsonProperty) {
        if (setterInfo == null) {
            throw new IllegalArgumentException("setterInfo is null");
        }
        this.name = name;
        this.hash = name.hashCode();
        this.setterInfo = setterInfo;
        this.jsonProperty = jsonProperty;
        this.genericParameterizedType = setterInfo.getGenericParameterizedType();
        Class<?> actualClass = this.genericParameterizedType.getActualType();
        this.classCategory = ReflectConsts.getClassCategory(actualClass);
        String pattern = null;
        String timezone = null;
        if (jsonProperty != null) {
            pattern = jsonProperty.pattern().trim();
            timezone = jsonProperty.timezone().trim();
            if (pattern.length() == 0) {
                pattern = null;
            }
            if (timezone.length() == 0) {
                timezone = null;
            }
        }
        this.pattern = pattern;
        this.timezone = timezone;
    }

    void initDeserializer() {
        if (this.setterInfo.isNonInstanceType()) {
            Class<?> impl;
            this.deserializer = this.genericParameterizedType.getActualType() == Serializable.class ? SERIALIZABLE_DESERIALIZER : null;
            if (this.jsonProperty != null && (impl = this.jsonProperty.impl()) != Object.class && this.isAvailableImpl(impl)) {
                this.implClass = impl;
            }
        } else {
            this.deserializer = this.getDeserializer(this.genericParameterizedType);
        }
    }

    private JSONTypeDeserializer getDeserializer(GenericParameterizedType genericParameterizedType) {
        JsonDeserialize jsonDeserialize = (JsonDeserialize)this.setterInfo.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null) {
            Class<? extends JsonDeserializer> jsonDeserializerClass = jsonDeserialize.value();
            this.customDeserialize = true;
            try {
                if (jsonDeserialize.singleton()) {
                    JsonDeserializer jsonDeserializer = customDeserializers.get(jsonDeserializerClass);
                    if (jsonDeserializer == null) {
                        jsonDeserializer = jsonDeserializerClass.newInstance();
                        customDeserializers.put(jsonDeserializerClass, jsonDeserializer);
                    }
                    return jsonDeserializer;
                }
                return jsonDeserializerClass.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return JSONTypeDeserializer.getFieldDeserializer(genericParameterizedType, this.jsonProperty);
    }

    public String getName() {
        return this.name;
    }

    public int getHash() {
        return this.hash;
    }

    public boolean isCustomDeserialize() {
        return this.customDeserialize;
    }

    public SetterInfo getSetterInfo() {
        return this.setterInfo;
    }

    @Override
    public GenericParameterizedType getGenericParameterizedType() {
        return this.genericParameterizedType;
    }

    @Override
    protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ReflectConsts.ClassCategory getClassCategory() {
        return this.classCategory;
    }

    public JSONTypeDeserializer getDeserializer() {
        return this.deserializer;
    }

    public Object getDefaultFieldValue(Object instance) {
        return this.setterInfo.getDefaultFieldValue(instance);
    }

    public boolean isNonInstanceType() {
        return this.setterInfo.isNonInstanceType();
    }

    public int getIndex() {
        return this.setterInfo.getIndex();
    }

    public void invoke(Object entity, Object value) {
        this.setterInfo.invoke(entity, value);
    }

    public String getDatePattern() {
        return this.pattern;
    }

    public String getDateTimezone() {
        return this.timezone;
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public boolean isAvailableImpl(Class<?> cls) {
        return this.genericParameterizedType.getActualType().isAssignableFrom(cls) && ReflectConsts.getClassCategory(cls) == ReflectConsts.ClassCategory.ObjectCategory;
    }

    public boolean isInstance(Object value) {
        return value == null || this.genericParameterizedType.getActualType().isInstance(value);
    }
}

