/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.options.JSONParseContext;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;

public class TemporalInstantDeserializer
extends JSONTemporalDeserializer {
    public TemporalInstantDeserializer(GenericParameterizedType genericParameterizedType) {
        super(genericParameterizedType);
    }

    protected void checkClass(GenericParameterizedType genericParameterizedType) {
        if (genericParameterizedType.getActualType() != TemporalAloneInvoker.instantClass) {
            throw new UnsupportedOperationException("Not Support for class " + genericParameterizedType.getActualType());
        }
    }

    protected void createDefaultTemplate() {
        this.dateTemplate = new DateTemplate("yyyy-MM-ddTHH:mm:ss.SZ");
    }

    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        long time = this.dateTemplate.parseTime(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return TemporalAloneInvoker.createOrOfInstant(time);
    }

    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        long time = this.dateTemplate.parseTime(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return TemporalAloneInvoker.createOrOfInstant(time);
    }
}

