/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.Date;
import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.options.JsonConfig;
import io.github.wycst.wast.json.reflect.ObjectStructureWrapper;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;
import java.io.Writer;

public class TemporalInstantSerializer
extends JSONTemporalSerializer {
    public TemporalInstantSerializer(ObjectStructureWrapper objectStructureWrapper, JsonProperty property) {
        super(objectStructureWrapper, property);
    }

    protected void checkClass(ObjectStructureWrapper objectStructureWrapper) {
        Class<?> sourceClass = objectStructureWrapper.getSourceClass();
        if (sourceClass != TemporalAloneInvoker.instantClass) {
            throw new UnsupportedOperationException("Not Support for class temporal type " + sourceClass);
        }
    }

    protected void writeTemporalWithTemplate(Object value, Writer writer, JsonConfig jsonConfig) throws Exception {
        long epochMilli = TemporalAloneInvoker.invokeInstantEpochMilli(value).longValue();
        writer.append('\"');
        this.dateFormatter.formatTo(new Date(epochMilli, ZERO_TIME_ZONE), writer);
        writer.append('\"');
    }

    protected void writeDefault(Object value, Writer writer, JsonConfig jsonConfig, int indent) throws Exception {
        long epochMilli = TemporalAloneInvoker.invokeInstantEpochMilli(value).longValue();
        GeneralDate generalDate = new GeneralDate(epochMilli, ZERO_TIME_ZONE);
        int year = generalDate.getYear();
        int month = generalDate.getMonth();
        int day = generalDate.getDay();
        int hour = generalDate.getHourOfDay();
        int minute = generalDate.getMinute();
        int second = generalDate.getSecond();
        int millisecond = generalDate.getMillisecond();
        writer.append('\"');
        this.writeYYYY_MM_dd_T_HH_mm_ss_SSS(writer, year, month, day, hour, minute, second, millisecond);
        writer.append('Z');
        writer.append('\"');
    }
}

