/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.json.temporal.TemporalInterface;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;

class TemporalInterfaceImplProvider
implements TemporalInterface {
    private TimeZone defaultTimezone = GeneralDate.getDefaultTimeZone();
    private ZoneId defaultZoneId = this.defaultTimezone.toZoneId();

    TemporalInterfaceImplProvider() {
    }

    public Object getDefaultZoneId() throws Exception {
        TimeZone timeZone = GeneralDate.getDefaultTimeZone();
        if (timeZone == this.defaultTimezone) {
            return this.defaultZoneId;
        }
        this.defaultTimezone = timeZone;
        this.defaultZoneId = this.defaultTimezone.toZoneId();
        return this.defaultZoneId;
    }

    public Object getZoneId(Object zonedDateTime) throws Exception {
        ZonedDateTime zonedDateTime0 = (ZonedDateTime)zonedDateTime;
        return zonedDateTime0.getZone();
    }

    public Object ofZoneId(String zoneId) throws Exception {
        return ZoneId.of(zoneId);
    }

    public Number getLocalDateYear(Object value) throws Exception {
        LocalDate localDate = (LocalDate)value;
        return localDate.getYear();
    }

    public Number getLocalDateMonth(Object value) throws Exception {
        LocalDate localDate = (LocalDate)value;
        return localDate.getMonthValue();
    }

    public Number getLocalDateDay(Object value) throws Exception {
        LocalDate localDate = (LocalDate)value;
        return localDate.getDayOfMonth();
    }

    public Number getLocalDateTimeYear(Object value) throws Exception {
        LocalDateTime localDateTime = (LocalDateTime)value;
        return localDateTime.getYear();
    }

    public Number getLocalDateTimeMonth(Object value) throws Exception {
        LocalDateTime localDateTime = (LocalDateTime)value;
        return localDateTime.getMonthValue();
    }

    public Number getLocalDateTimeDay(Object value) throws Exception {
        LocalDateTime localDateTime = (LocalDateTime)value;
        return localDateTime.getDayOfMonth();
    }

    public Number getLocalDateTimeHour(Object value) throws Exception {
        LocalDateTime localDateTime = (LocalDateTime)value;
        return localDateTime.getHour();
    }

    public Number getLocalDateTimeMinute(Object value) throws Exception {
        LocalDateTime localDateTime = (LocalDateTime)value;
        return localDateTime.getMinute();
    }

    public Number getLocalDateTimeSecond(Object value) throws Exception {
        LocalDateTime localDateTime = (LocalDateTime)value;
        return localDateTime.getSecond();
    }

    public Number getLocalDateTimeNano(Object value) throws Exception {
        LocalDateTime localDateTime = (LocalDateTime)value;
        return localDateTime.getNano();
    }

    public Number getLocalTimeHour(Object value) throws Exception {
        LocalTime localTime = (LocalTime)value;
        return localTime.getHour();
    }

    public Number getLocalTimeMinute(Object value) throws Exception {
        LocalTime localTime = (LocalTime)value;
        return localTime.getMinute();
    }

    public Number getLocalTimeSecond(Object value) throws Exception {
        LocalTime localTime = (LocalTime)value;
        return localTime.getSecond();
    }

    public Number getLocalTimeNano(Object value) throws Exception {
        LocalTime localTime = (LocalTime)value;
        return localTime.getNano();
    }

    public Number getInstantEpochMilli(Object value) throws Exception {
        Instant instant = (Instant)value;
        return instant.toEpochMilli();
    }

    public Number getZonedDateTimeYear(Object value) throws Exception {
        ZonedDateTime zonedDateTime = (ZonedDateTime)value;
        return zonedDateTime.getYear();
    }

    public Number getZonedDateTimeMonth(Object value) throws Exception {
        ZonedDateTime zonedDateTime = (ZonedDateTime)value;
        return zonedDateTime.getMonthValue();
    }

    public Number getZonedDateTimeDay(Object value) throws Exception {
        ZonedDateTime zonedDateTime = (ZonedDateTime)value;
        return zonedDateTime.getDayOfMonth();
    }

    public Number getZonedDateTimeHour(Object value) throws Exception {
        ZonedDateTime zonedDateTime = (ZonedDateTime)value;
        return zonedDateTime.getHour();
    }

    public Number getZonedDateTimeMinute(Object value) throws Exception {
        ZonedDateTime zonedDateTime = (ZonedDateTime)value;
        return zonedDateTime.getMinute();
    }

    public Number getZonedDateTimeSecond(Object value) throws Exception {
        ZonedDateTime zonedDateTime = (ZonedDateTime)value;
        return zonedDateTime.getSecond();
    }

    public Number getZonedDateTimeNano(Object value) throws Exception {
        ZonedDateTime zonedDateTime = (ZonedDateTime)value;
        return zonedDateTime.getNano();
    }

    public Object ofInstant(long millis) throws Exception {
        return Instant.ofEpochMilli(millis);
    }

    public Object ofZonedDateTime(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, Object zoneId) throws Exception {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, (ZoneId)zoneId);
    }

    public Object parseZonedDateTime(CharSequence charSequence) throws Exception {
        return ZonedDateTime.parse(charSequence);
    }

    public Object ofLocalDateTime(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond) throws Exception {
        return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond);
    }

    public Object ofLocalTime(int hour, int minute, int second, int nanoOfSecond) throws Exception {
        return LocalTime.of(hour, minute, second, nanoOfSecond);
    }

    public Object ofLocalDate(int year, int month, int day) throws Exception {
        return LocalDate.of(year, month, day);
    }
}

