/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.options.JsonConfig;
import io.github.wycst.wast.json.reflect.ObjectStructureWrapper;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;
import java.io.Writer;

public class TemporalLocalDateTimeSerializer
extends JSONTemporalSerializer {
    public TemporalLocalDateTimeSerializer(ObjectStructureWrapper objectStructureWrapper, JsonProperty property) {
        super(objectStructureWrapper, property);
    }

    protected void checkClass(ObjectStructureWrapper objectStructureWrapper) {
        Class<?> sourceClass = objectStructureWrapper.getSourceClass();
        if (sourceClass != TemporalAloneInvoker.localDateTimeClass) {
            throw new UnsupportedOperationException("Not Support for class temporal type " + sourceClass);
        }
    }

    protected void writeTemporalWithTemplate(Object value, Writer writer, JsonConfig jsonConfig) throws Exception {
        int year = TemporalAloneInvoker.invokeLocalDateTimeYear(value).intValue();
        int month = TemporalAloneInvoker.invokeLocalDateTimeMonth(value).intValue();
        int day = TemporalAloneInvoker.invokeLocalDateTimeDay(value).intValue();
        int hour = TemporalAloneInvoker.invokeLocalDateTimeHour(value).intValue();
        int minute = TemporalAloneInvoker.invokeLocalDateTimeMinute(value).intValue();
        int second = TemporalAloneInvoker.invokeLocalDateTimeSecond(value).intValue();
        int nano = TemporalAloneInvoker.invokeLocalDateTimeNano(value).intValue();
        int millisecond = nano / 1000000;
        writer.append('\"');
        this.dateFormatter.formatTo(year, month, day, hour, minute, second, millisecond, writer);
        writer.append('\"');
    }

    protected void writeDefault(Object value, Writer writer, JsonConfig jsonConfig, int indent) throws Exception {
        int year = TemporalAloneInvoker.invokeLocalDateTimeYear(value).intValue();
        int month = TemporalAloneInvoker.invokeLocalDateTimeMonth(value).intValue();
        int day = TemporalAloneInvoker.invokeLocalDateTimeDay(value).intValue();
        int hour = TemporalAloneInvoker.invokeLocalDateTimeHour(value).intValue();
        int minute = TemporalAloneInvoker.invokeLocalDateTimeMinute(value).intValue();
        int second = TemporalAloneInvoker.invokeLocalDateTimeSecond(value).intValue();
        int nano = TemporalAloneInvoker.invokeLocalDateTimeNano(value).intValue();
        writer.write(34);
        this.writeYYYY_MM_dd_T_HH_mm_ss_SSS(writer, year, month, day, hour, minute, second, nano / 1000000);
        writer.write(34);
    }
}

