/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.options.JsonConfig;
import io.github.wycst.wast.json.reflect.ObjectStructureWrapper;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;
import java.io.Writer;

public class TemporalLocalTimeSerializer
extends JSONTemporalSerializer {
    public TemporalLocalTimeSerializer(ObjectStructureWrapper objectStructureWrapper, JsonProperty property) {
        super(objectStructureWrapper, property);
    }

    protected void checkClass(ObjectStructureWrapper objectStructureWrapper) {
        Class<?> sourceClass = objectStructureWrapper.getSourceClass();
        if (sourceClass != TemporalAloneInvoker.localTimeClass) {
            throw new UnsupportedOperationException("Not Support for class temporal type " + sourceClass);
        }
    }

    protected void writeTemporalWithTemplate(Object value, Writer writer, JsonConfig jsonConfig) throws Exception {
        int hour = TemporalAloneInvoker.invokeLocalTimeHour(value).intValue();
        int minute = TemporalAloneInvoker.invokeLocalTimeMinute(value).intValue();
        int second = TemporalAloneInvoker.invokeLocalTimeSecond(value).intValue();
        int nano = TemporalAloneInvoker.invokeLocalTimeNano(value).intValue();
        int millisecond = nano / 1000000;
        writer.append('\"');
        this.dateFormatter.formatTo(1970, 1, 1, hour, minute, second, millisecond, writer);
        writer.append('\"');
    }

    protected void writeDefault(Object value, Writer writer, JsonConfig jsonConfig, int indent) throws Exception {
        int hour = TemporalAloneInvoker.invokeLocalTimeHour(value).intValue();
        int minute = TemporalAloneInvoker.invokeLocalTimeMinute(value).intValue();
        int second = TemporalAloneInvoker.invokeLocalTimeSecond(value).intValue();
        int nano = TemporalAloneInvoker.invokeLocalTimeNano(value).intValue();
        int millisecond = nano / 1000000;
        writer.write(34);
        writer.write(DigitTens[hour]);
        writer.write(DigitOnes[hour]);
        writer.write(58);
        writer.write(DigitTens[minute]);
        writer.write(DigitOnes[minute]);
        writer.write(58);
        writer.write(DigitTens[second]);
        writer.write(DigitOnes[second]);
        writer.write(46);
        char s1 = (char)(millisecond / 100 + 48);
        int v = millisecond % 100;
        writer.write(s1);
        writer.write(DigitTens[v]);
        writer.write(DigitOnes[v]);
        writer.write(34);
    }
}

