/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedNameValueMap<T> {
    private final int capacity;
    private final NameValueEntryNode<T>[] valueEntryNodes;
    private int count;
    private final int maxCount;

    public FixedNameValueMap(int size) {
        int capacity = FixedNameValueMap.tableSizeFor(size) << 1;
        if (size > 1) {
            capacity = Math.max(capacity, 16);
        }
        this.maxCount = size;
        this.capacity = capacity;
        this.valueEntryNodes = new NameValueEntryNode[capacity];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(String name, T value) {
        FixedNameValueMap fixedNameValueMap = this;
        synchronized (fixedNameValueMap) {
            if (this.count >= this.maxCount) {
                return;
            }
            ++this.count;
        }
        char[] keyChars = name.toCharArray();
        int keyHash = name.hashCode();
        int index = keyHash & this.capacity - 1;
        NameValueEntryNode<T> valueEntryNode = new NameValueEntryNode<T>(keyChars, value, keyHash);
        NameValueEntryNode<T> oldEntryNode = this.valueEntryNodes[index];
        this.valueEntryNodes[index] = valueEntryNode;
        if (oldEntryNode != null) {
            valueEntryNode.next = oldEntryNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        FixedNameValueMap fixedNameValueMap = this;
        synchronized (fixedNameValueMap) {
            this.count = 0;
            for (int i = 0; i < this.capacity; ++i) {
                this.valueEntryNodes[i] = null;
            }
        }
    }

    public T getValue(String field) {
        char[] buf = field.toCharArray();
        int hashValue = field.hashCode();
        return this.getValue(buf, 0, buf.length, hashValue);
    }

    public T getValue(char[] buf, int beginIndex, int endIndex, int hashValue) {
        int len = endIndex - beginIndex;
        int index = hashValue & this.capacity - 1;
        NameValueEntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode == null) {
            return null;
        }
        while (!FixedNameValueMap.matchKey(buf, beginIndex, len, entryNode.key)) {
            entryNode = entryNode.next;
            if (entryNode != null) continue;
            return null;
        }
        return entryNode.value;
    }

    public T getValue(byte[] bytes, int beginIndex, int endIndex, int hashValue) {
        int len = endIndex - beginIndex;
        int index = hashValue & this.capacity - 1;
        NameValueEntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode == null) {
            return null;
        }
        while (!FixedNameValueMap.matchKey(bytes, beginIndex, len, entryNode.key)) {
            entryNode = entryNode.next;
            if (entryNode != null) continue;
            return null;
        }
        return entryNode.value;
    }

    public T getValueByHash(int hashValue) {
        int index = hashValue & this.capacity - 1;
        NameValueEntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode == null) {
            return null;
        }
        while (hashValue != entryNode.hash) {
            entryNode = entryNode.next;
            if (entryNode != null) continue;
            return null;
        }
        return entryNode.value;
    }

    private static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static boolean matchKey(char[] buf, int offset, int len, char[] key) {
        if (len != key.length) {
            return false;
        }
        for (int j = 0; j < len; ++j) {
            if (buf[offset + j] == key[j]) continue;
            return false;
        }
        return true;
    }

    private static boolean matchKey(byte[] bytes, int offset, int len, char[] key) {
        if (len != key.length) {
            return false;
        }
        for (int j = 0; j < len; ++j) {
            if (bytes[offset + j] == key[j]) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NameValueEntryNode<T> {
        int hash;
        char[] key;
        T value;
        NameValueEntryNode<T> next;

        public NameValueEntryNode(char[] key, T value, int keyHash) {
            this.key = key;
            this.hash = keyHash;
            this.value = value;
        }
    }
}

