/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.definition;

import io.github.wycst.wast.common.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HttpClientParameter {
    private final String name;
    private final String value;
    private String contentType;
    private long contentLength;
    private File file;
    private byte[] bytes;
    private boolean fileUpload = false;

    HttpClientParameter(String name, String value) {
        this.name = name;
        this.value = value == null ? "" : value;
        this.contentLength = this.value.getBytes().length;
        this.contentType = "text/plain; charset=UTF-8";
    }

    HttpClientParameter(String name, File file, String contentType) {
        this.name = name;
        this.value = file.getName();
        this.contentType = contentType;
        this.file = file;
        this.contentLength = file.length();
        this.fileUpload = true;
    }

    HttpClientParameter(String name, String fileName, byte[] bytes, String contentType) {
        this.name = name;
        this.value = fileName;
        this.contentType = contentType;
        this.bytes = bytes;
        this.contentLength = bytes.length;
        this.fileUpload = true;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public boolean isFileUpload() {
        return this.fileUpload;
    }

    public void writeContentTo(OutputStream os) throws IOException {
        if (this.fileUpload) {
            if (this.file != null) {
                FileInputStream is = new FileInputStream(this.file);
                this.bytes = IOUtils.readBytes(is);
                this.file = null;
                os.write(this.bytes);
            } else {
                os.write(this.bytes);
            }
        } else {
            os.write(this.value.getBytes());
        }
    }
}

