/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.NumberUtils;
import java.lang.reflect.Field;
import java.util.TimeZone;

public class GeneralDate {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY_OF_MONTH = 3;
    public static final int HOURS = 4;
    public static final int MINUTE = 5;
    public static final int SECOND = 6;
    public static final int MILLISECOND = 7;
    protected int year;
    protected int month;
    protected int dayOfMonth;
    protected int hourOfDay;
    protected int minute;
    protected int second;
    protected int millisecond;
    protected boolean leapYear;
    protected int daysOfYear;
    protected long standardMills;
    protected long timeMills = -1L;
    public static final long YEAR_TIMEMILLS = 31556925216L;
    public static final long RELATIVE_DAYS = 719164L;
    public static final long RELATIVE_MILLS = 62135769600000L;
    public static final int RELATIVE_DAY_OF_WEEK = 5;
    protected TimeZone timeZone;
    protected int currentOffset;
    private static TimeZone defaultTimeZone;
    private static final Field defaultTimeZoneField;
    protected long currentDays;
    private static final int[] DaysOfYearOffset;
    private static final int[] DaysOfLeapYearOffset;
    protected static final long MILLS_DAY = 86400000L;
    protected static final long MILLS_365_DAY = 31536000000L;
    protected static final long MILLS_366_DAY = 31622400000L;
    protected static final long Seconds_1991_09_14_23_59_59 = 62820658799L;
    protected static final long Seconds_1900_01_01_07_59_59 = 59926809599L;
    protected static final long Time_1900_01_01_08_05_43 = -2208988800000L;
    protected static final long Time_1991_09_15_00_00_00 = 684864000000L;
    protected static final YearMeta[] Positive_Year_Metas;
    protected static final long MaxCacheOffsetDays;
    protected static final MonthDayMeta[] Month_Day_Of_Year;
    protected static final MonthDayMeta[] Month_Day_Of_LeapYear;
    static final int OFFSET_DAYS_DIVISOR = 146097;

    public GeneralDate(TimeZone timeZone) {
        this.ofTimeZone(timeZone);
    }

    public GeneralDate(long time) {
        this(time, defaultTimeZone);
    }

    public GeneralDate(long time, TimeZone timeZone) {
        this.ofTimeZone(timeZone);
        this.setTime(time, true);
    }

    public GeneralDate(long time, String timeZone) {
        this.ofTimeZone(timeZone == null ? defaultTimeZone : this.getTimeZoneById(timeZone));
        this.setTime(time, true);
    }

    GeneralDate(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        this.ofTimeZone(timeZone);
        this.year = year;
        this.month = month;
        this.dayOfMonth = day;
        this.hourOfDay = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
    }

    public static GeneralDate of(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        GeneralDate generalDate = new GeneralDate(year, month, day, hour, minute, second, millisecond, null);
        generalDate.updateTime();
        return generalDate;
    }

    public GeneralDate setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        int rawOffset = timeZone.getRawOffset();
        if (this.currentOffset != rawOffset) {
            this.currentOffset = rawOffset;
            this.setTime(this.timeMills, true);
        }
        return this;
    }

    public GeneralDate setTimeZone(String offsetExpr) {
        return this.setTimeZone(this.getTimeZoneById(offsetExpr));
    }

    TimeZone getTimeZoneById(String offsetExpr) {
        if (offsetExpr.startsWith("GMT")) {
            return TimeZone.getTimeZone(offsetExpr);
        }
        return TimeZone.getTimeZone("GMT" + offsetExpr);
    }

    protected void ofTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        if (timeZone == null) {
            this.timeZone = GeneralDate.getDefaultTimeZone();
        }
        this.currentOffset = this.timeZone.getRawOffset();
    }

    public static final long getTime(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        GeneralDate generalDate = new GeneralDate(year, month, day, hour, minute, second, millisecond, timeZone);
        generalDate.updateTime();
        return generalDate.timeMills;
    }

    public static final long parseTime(String dateStr) {
        return GeneralDate.parseTime(dateStr, null);
    }

    public static final long parseTime(String dateStr, TimeZone timeZone) {
        GeneralDate generalDate = GeneralDate.parseGeneralDate(dateStr, timeZone);
        generalDate.updateTime();
        return generalDate.timeMills;
    }

    public static final GeneralDate parseGeneralDate(String dateStr, TimeZone timeZone) {
        dateStr.getClass();
        int length = dateStr.length();
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            int day;
            int month;
            int year;
            if (length == 19) {
                year = NumberUtils.parseInt4(dateStr.charAt(0), dateStr.charAt(1), dateStr.charAt(2), dateStr.charAt(3));
                month = NumberUtils.parseInt2(dateStr.charAt(5), (int)dateStr.charAt(6));
                day = NumberUtils.parseInt2(dateStr.charAt(8), (int)dateStr.charAt(9));
                hour = NumberUtils.parseInt2(dateStr.charAt(11), (int)dateStr.charAt(12));
                minute = NumberUtils.parseInt2(dateStr.charAt(14), (int)dateStr.charAt(15));
                second = NumberUtils.parseInt2(dateStr.charAt(17), (int)dateStr.charAt(18));
            } else if (length == 10) {
                year = NumberUtils.parseInt4(dateStr.charAt(0), dateStr.charAt(1), dateStr.charAt(2), dateStr.charAt(3));
                month = NumberUtils.parseInt2(dateStr.charAt(5), (int)dateStr.charAt(6));
                day = NumberUtils.parseInt2(dateStr.charAt(8), (int)dateStr.charAt(9));
            } else {
                throw new UnsupportedOperationException(" Date Format Error, only supported 'yyyy-MM-dd' or 'yyyy-MM-dd HH:mm:ss'");
            }
            return new GeneralDate(year, month, day, hour, minute, second, 0, timeZone);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException("Date Format Error, default parse only supported 'yyyy-MM-dd' or 'yyyy-MM-dd HH:mm:ss'");
        }
    }

    public static final GeneralDate parseGeneralDate_Standard_19(char[] buf, int offset, TimeZone timeZone) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            int year = NumberUtils.parseInt4(buf[offset], buf[offset + 1], buf[offset + 2], buf[offset + 3]);
            int month = NumberUtils.parseInt2(buf[offset + 5], (int)buf[offset + 6]);
            int day = NumberUtils.parseInt2(buf[offset + 8], (int)buf[offset + 9]);
            hour = NumberUtils.parseInt2(buf[offset + 11], (int)buf[offset + 12]);
            minute = NumberUtils.parseInt2(buf[offset + 14], (int)buf[offset + 15]);
            second = NumberUtils.parseInt2(buf[offset + 17], (int)buf[offset + 18]);
            return new GeneralDate(year, month, day, hour, minute, second, 0, timeZone);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException("Date Format Error, parseGeneralDate_Standard_19 only supported 'yyyy?MM?dd?HH:mm:ss'");
        }
    }

    public static final GeneralDate parseGeneralDate_Standard_19(byte[] buf, int offset, TimeZone timeZone) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            int year = NumberUtils.parseInt4(buf[offset], buf[offset + 1], buf[offset + 2], buf[offset + 3]);
            int month = NumberUtils.parseInt2(buf[offset + 5], (int)buf[offset + 6]);
            int day = NumberUtils.parseInt2(buf[offset + 8], (int)buf[offset + 9]);
            hour = NumberUtils.parseInt2(buf[offset + 11], (int)buf[offset + 12]);
            minute = NumberUtils.parseInt2(buf[offset + 14], (int)buf[offset + 15]);
            second = NumberUtils.parseInt2(buf[offset + 17], (int)buf[offset + 18]);
            return new GeneralDate(year, month, day, hour, minute, second, 0, timeZone);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException("Date Format Error, parseGeneralDate_Standard_19 only supported 'yyyy?MM?dd?HH:mm:ss'");
        }
    }

    public static final GeneralDate parseGeneralDate_Standard_10(char[] buf, int offset, TimeZone timeZone) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            int year = NumberUtils.parseInt4(buf[offset], buf[offset + 1], buf[offset + 2], buf[offset + 3]);
            int month = NumberUtils.parseInt2(buf[offset + 5], (int)buf[offset + 6]);
            int day = NumberUtils.parseInt2(buf[offset + 8], (int)buf[offset + 9]);
            return new GeneralDate(year, month, day, hour, minute, second, 0, timeZone);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException("Date Format Error, parseGeneralDate_Standard_10 only supported 'yyyy?MM?dd'");
        }
    }

    public static TimeZone getDefaultTimeZone() {
        if (defaultTimeZoneField != null) {
            try {
                TimeZone defaultTimezone = (TimeZone)defaultTimeZoneField.get(null);
                if (defaultTimezone != null) {
                    defaultTimeZone = defaultTimezone;
                    return defaultTimeZone;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        defaultTimeZone = TimeZone.getDefault();
        return defaultTimeZone;
    }

    private void overflow() {
        if (this.month > 12) {
            int increaseYear = (this.month - 1) / 12;
            this.year += increaseYear;
            this.month -= increaseYear * 12;
        } else if (this.month < 1) {
            int increaseYear = this.month / 12 - 1;
            this.year += increaseYear;
            this.month -= increaseYear * 12;
        }
    }

    private static boolean isLeapYear(int year) {
        boolean remainder4;
        boolean bl = remainder4 = (year & 3) == 0;
        return year > 1582 ? remainder4 && (year % 100 != 0 || year % 400 == 0) : remainder4;
    }

    private static long getOffsetDays(long year) {
        if (year > 1582L) {
            return (year - 1L) * 365L + (year - 1L) / 4L - (year - 1L) / 100L + (year - 1L) / 400L + 2L;
        }
        return (year - 1L) * 365L + (year - 1L) / 4L;
    }

    protected void updateTime() {
        this.overflow();
        YearMeta meta = GeneralDate.getYearMeta(this.year);
        boolean isLeapYear = meta.leap;
        long days = meta.offsetDays;
        int offset = isLeapYear ? DaysOfLeapYearOffset[this.month - 1] : DaysOfYearOffset[this.month - 1];
        int daysOfYear = offset + this.dayOfMonth;
        if (this.year == 1582 && this.month > 9) {
            if (this.month == 10) {
                if (this.dayOfMonth > 14) {
                    daysOfYear -= 10;
                } else if (this.dayOfMonth > 4 && this.dayOfMonth <= 14) {
                    this.dayOfMonth += 10;
                }
            } else {
                daysOfYear -= 10;
            }
        }
        long seconds = (days += (long)daysOfYear) * 86400L + (long)(this.hourOfDay * 3600) + (long)(this.minute * 60) + (long)this.second;
        this.standardMills = this.timeMills = seconds * 1000L + (long)this.millisecond - (long)this.currentOffset - 62135769600000L;
        if (seconds <= 62820658799L && seconds > 59926809599L) {
            int actualOffset = this.timeZone.getOffset(this.timeMills);
            this.timeMills += (long)(this.currentOffset - actualOffset);
        }
        this.leapYear = isLeapYear;
        this.daysOfYear = daysOfYear;
        this.currentDays = days;
    }

    void setTime(long timeMills, boolean reset) {
        MonthDayMeta monthDayMeta;
        int millisecond;
        long seconds;
        this.timeMills = timeMills;
        if (timeMills >= -2208988800000L && timeMills < 684864000000L) {
            int zoneOffset = this.timeZone.getOffset(timeMills);
            this.standardMills = timeMills -= (long)(this.currentOffset - zoneOffset);
        }
        long offset = 62135769600000L + (long)this.currentOffset;
        int offsetYear = 0;
        if ((timeMills += offset) > 0L) {
            seconds = timeMills / 1000L;
            millisecond = (int)(timeMills - seconds * 1000L);
        } else if (this.timeMills > Long.MAX_VALUE - offset) {
            int rem = (int)(this.timeMills % 1000L);
            seconds = this.timeMills / 1000L + (offset + (long)rem) / 1000L;
            millisecond = (int)((long)rem + offset % 1000L) % 1000;
        } else {
            do {
                boolean leap = (offsetYear + 1 & 3) == 0;
                timeMills += leap ? 31622400000L : 31536000000L;
                ++offsetYear;
            } while ((timeMills += 86400000L) < 0L);
            seconds = timeMills / 1000L;
            millisecond = (int)(timeMills - seconds * 1000L);
        }
        long days = seconds / 86400L;
        int secondsOfDay = (int)(seconds - days * 86400L);
        int hour = secondsOfDay / 3600;
        int minute = (secondsOfDay -= hour * 3600) / 60;
        int second = secondsOfDay - minute * 60;
        int year = (int)(days * 400L) / 146097 + 1;
        YearMeta targetMeta = GeneralDate.getYearMeta(year);
        long offsetDays = targetMeta.offsetDays;
        if (days <= offsetDays) {
            targetMeta = GeneralDate.getYearMeta(--year);
            offsetDays = targetMeta.offsetDays;
        }
        int daysOfYear = (int)(days - offsetDays);
        boolean isLeapYear = targetMeta.leap;
        try {
            int dayIndex = daysOfYear - 1;
            if (isLeapYear) {
                if (daysOfYear > Month_Day_Of_LeapYear.length) {
                    daysOfYear -= 366;
                    dayIndex -= 366;
                    ++year;
                    isLeapYear = false;
                }
                monthDayMeta = Month_Day_Of_LeapYear[dayIndex];
            } else {
                if (daysOfYear > Month_Day_Of_Year.length) {
                    daysOfYear -= 365;
                    dayIndex -= 365;
                    isLeapYear = GeneralDate.isLeapYear(++year);
                }
                monthDayMeta = Month_Day_Of_Year[dayIndex];
            }
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("error for " + this.timeMills);
        }
        int month = monthDayMeta.month;
        int day = monthDayMeta.day;
        if (year == 1582 && daysOfYear >= 278) {
            if (month == 10 && (day += 10) > 31) {
                ++month;
                day -= 31;
            } else if (month == 11 && day > 30) {
                ++month;
                day -= 30;
            }
        }
        this.year = year - offsetYear;
        this.month = month;
        this.dayOfMonth = day;
        this.hourOfDay = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
        this.daysOfYear = daysOfYear;
        this.leapYear = isLeapYear;
        this.currentDays = days;
    }

    public static final long getDefaultOffset() {
        return GeneralDate.getDefaultTimeZone().getRawOffset();
    }

    private static YearMeta createYearMeta(int year) {
        boolean leap = GeneralDate.isLeapYear(year);
        long offsetDays = GeneralDate.getOffsetDays(year) - 1L;
        return new YearMeta(year, leap, offsetDays);
    }

    static YearMeta getYearMeta(int year) {
        if (year > -1 && year < Positive_Year_Metas.length) {
            return Positive_Year_Metas[year];
        }
        return GeneralDate.createYearMeta(year);
    }

    public final int getYear() {
        return this.year;
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getDay() {
        return this.dayOfMonth;
    }

    public final int getHourOfDay() {
        return this.hourOfDay;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final int getSecond() {
        return this.second;
    }

    public final int getMillisecond() {
        return this.millisecond;
    }

    public long getTime() {
        return this.timeMills;
    }

    public long getStandardTime() {
        return this.standardMills;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public boolean isAm() {
        return this.hourOfDay < 12;
    }

    static {
        DaysOfYearOffset = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        DaysOfLeapYearOffset = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        Positive_Year_Metas = new YearMeta[2100];
        Month_Day_Of_Year = new MonthDayMeta[365];
        Month_Day_Of_LeapYear = new MonthDayMeta[366];
        Field timeZoneField = null;
        try {
            timeZoneField = TimeZone.class.getDeclaredField("defaultTimeZone");
            if (!UnsafeHelper.setAccessible(timeZoneField)) {
                timeZoneField.setAccessible(true);
            }
        }
        catch (Throwable throwable) {
            timeZoneField = null;
        }
        defaultTimeZoneField = timeZoneField;
        GeneralDate.getDefaultTimeZone();
        for (int year = 0; year < Positive_Year_Metas.length; ++year) {
            GeneralDate.Positive_Year_Metas[year] = GeneralDate.createYearMeta(year);
        }
        MaxCacheOffsetDays = GeneralDate.Positive_Year_Metas[GeneralDate.Positive_Year_Metas.length - 1].offsetDays;
        int monthOfYear = 1;
        int monthOfLeapYear = 1;
        int daysOfYearOffset = DaysOfYearOffset[monthOfYear - 1];
        int daysOfLeapYearOffset = DaysOfLeapYearOffset[monthOfLeapYear - 1];
        for (int i = 0; i < 366; ++i) {
            if (i < 365) {
                int dayOfMonthAtYear = i - daysOfYearOffset + 1;
                GeneralDate.Month_Day_Of_Year[i] = new MonthDayMeta(monthOfYear, dayOfMonthAtYear);
                if (monthOfYear < 12 && i == DaysOfYearOffset[monthOfYear] - 1) {
                    daysOfYearOffset = DaysOfYearOffset[monthOfYear++];
                }
            }
            int dayOfMonthAtLeapYear = i - daysOfLeapYearOffset + 1;
            GeneralDate.Month_Day_Of_LeapYear[i] = new MonthDayMeta(monthOfLeapYear, dayOfMonthAtLeapYear);
            if (monthOfLeapYear >= 12 || i != DaysOfLeapYearOffset[monthOfLeapYear] - 1) continue;
            daysOfLeapYearOffset = DaysOfLeapYearOffset[monthOfLeapYear++];
        }
    }

    static class MonthDayMeta {
        final int month;
        final int day;

        public MonthDayMeta(int month, int day) {
            this.month = month;
            this.day = day;
        }
    }

    static class YearMeta {
        final int year;
        final boolean leap;
        final long offsetDays;

        YearMeta(int year, boolean leap, long offsetDays) {
            this.year = year;
            this.leap = leap;
            this.offsetDays = offsetDays;
        }
    }
}

