/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.csv;

import io.github.wycst.wast.common.csv.CSVColumn;
import io.github.wycst.wast.common.csv.CSVRow;
import io.github.wycst.wast.common.csv.CSVTable;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.ObjectUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CSV {
    public static CSVTable read(File file) {
        try {
            return CSV.read(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static CSVTable read(File file, String charsetName) {
        try {
            return CSV.read((InputStream)new FileInputStream(file), charsetName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static CSVTable read(InputStream is) {
        return CSV.read(is, Charset.defaultCharset());
    }

    public static CSVTable read(InputStream is, String charsetName) {
        return CSV.read(is, Charset.forName(charsetName));
    }

    public static CSVTable read(InputStream is, Charset charset) {
        CSVTable csvTable = new CSVTable();
        ArrayList<CSVRow> csvRows = new ArrayList<CSVRow>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, charset));
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                csvRows.add(CSV.readRow(csvTable, line));
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        csvTable.setRows(csvRows);
        return csvTable;
    }

    private static CSVRow readRow(CSVTable csvTable, String line) {
        ArrayList<String> rowValues = new ArrayList<String>();
        char[] chars = UnsafeHelper.getChars(line);
        int len = chars.length;
        StringBuilder stringBuilder = null;
        block0: for (int i = 0; i < len; ++i) {
            int offset;
            char ch;
            while ((ch = chars[i]) == ' ') {
                ++i;
            }
            if (ch == '\"') {
                offset = i + 1;
                boolean escape = false;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.setLength(0);
                while (true) {
                    boolean isEnd;
                    if (i < len && (ch = chars[++i]) != '\"') {
                        continue;
                    }
                    if (ch != '\"') {
                        throw new UnsupportedOperationException("ERROR CSV missing closing '\"' from offset " + offset);
                    }
                    int j = i;
                    while (++i < len && (ch = chars[i]) == ' ') {
                    }
                    boolean bl = isEnd = i == len;
                    if (ch == ',' || isEnd) {
                        rowValues.add(escape ? stringBuilder.append(chars, offset, j - offset).toString() : new String(chars, offset, j - offset));
                        continue block0;
                    }
                    if (ch != '\"') {
                        throw new UnsupportedOperationException("ERROR CSV offset " + i + " expected '\"' ");
                    }
                    stringBuilder.append(chars, offset, i - offset);
                    offset = i + 1;
                    escape = true;
                }
            }
            offset = i;
            while (++i < len && (ch = chars[i]) != ',') {
            }
            int j = i;
            while (chars[j - 1] == ' ') {
                --j;
            }
            rowValues.add(new String(chars, offset, j - offset));
            if (ch != ',') break;
        }
        return new CSVRow(csvTable, rowValues);
    }

    public static CSVTable read(byte[] data) {
        return CSV.read(new String(data));
    }

    public static CSVTable read(byte[] data, String charsetName) {
        return CSV.read(new String(data, Charset.forName(charsetName)));
    }

    public static CSVTable read(String content) {
        CSVTable csvTable = new CSVTable();
        ArrayList<CSVRow> csvRows = new ArrayList<CSVRow>();
        char[] chars = UnsafeHelper.getChars(content);
        int i = 0;
        int endIndex = chars.length - 1;
        if (chars[endIndex] != '\n') {
            chars = Arrays.copyOf(chars, endIndex + 1);
            chars[++endIndex] = 10;
        }
        ArrayList<String> rowValues = new ArrayList<String>();
        StringBuilder stringBuilder = null;
        while (i <= endIndex) {
            block18: {
                int offset;
                char ch;
                while ((ch = chars[i]) == ' ') {
                    ++i;
                }
                if (ch == '\"') {
                    offset = i + 1;
                    boolean escape = false;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.setLength(0);
                    while (true) {
                        boolean isLineBreak;
                        if (i < endIndex && (ch = chars[++i]) != '\"') {
                            continue;
                        }
                        if (ch != '\"') {
                            throw new UnsupportedOperationException("ERROR CSV missing closing '\"' from offset " + offset);
                        }
                        int j = i;
                        while ((ch = chars[++i]) == ' ') {
                        }
                        if (ch == '\r' && (ch = chars[++i]) != '\n') {
                            throw new UnsupportedOperationException("ERROR CSV expected '\\n' after '\\r'" + new String(chars, offset, i - offset));
                        }
                        boolean bl = isLineBreak = ch == '\n';
                        if (ch == ',' || isLineBreak) {
                            rowValues.add(escape ? stringBuilder.append(chars, offset, j - offset).toString() : new String(chars, offset, j - offset));
                            if (isLineBreak) {
                                csvRows.add(new CSVRow(csvTable, rowValues));
                            }
                            break block18;
                        }
                        if (ch != '\"') {
                            throw new UnsupportedOperationException("ERROR CSV offset " + i + " expected '\"' ");
                        }
                        stringBuilder.append(chars, offset, i - offset);
                        offset = i + 1;
                        escape = true;
                    }
                }
                offset = i;
                while ((ch = chars[++i]) != ',' && ch != '\r' && ch != '\n') {
                }
                int j = i;
                while (chars[j - 1] == ' ') {
                    --j;
                }
                rowValues.add(new String(chars, offset, j - offset));
                if (ch != ',') {
                    if (ch == '\r') {
                        ch = chars[++i];
                    }
                    if (ch != '\n') {
                        throw new UnsupportedOperationException("ERROR CSV offset " + i + " expected '\\n' " + new String(chars, offset, i - offset));
                    }
                    csvRows.add(new CSVRow(csvTable, rowValues));
                    rowValues = new ArrayList();
                }
            }
            ++i;
        }
        csvTable.setRows(csvRows);
        return csvTable;
    }

    public static void writeObjectTo(List<?> objList, File file) {
        try {
            CSV.writeObjectTo(objList, (OutputStream)new FileOutputStream(file), Charset.defaultCharset());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeObjectTo(List<?> objList, OutputStream os, String charsetName) {
        CSV.writeObjectTo(objList, os, Charset.forName(charsetName));
    }

    public static String toCSVString(List<?> objList) {
        if (objList == null || objList.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        try {
            CSV.writeObjectTo(builder, objList);
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeObjectTo(List<?> objList, OutputStream os, Charset charset) {
        if (objList == null || objList.size() == 0) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(os, charset));
        try {
            CSV.writeObjectTo(bufferedWriter, objList);
            bufferedWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void writeObjectTo(Appendable appendable, List<?> objList) throws IOException {
        Object first = objList.get(0);
        ArrayList<String> csvColumnNames = new ArrayList<String>();
        ArrayList<String> objectKeys = new ArrayList<String>();
        CSV.getColumnNames(first, csvColumnNames, objectKeys);
        CSV.writeRow(appendable, csvColumnNames);
        for (Object obj : objList) {
            int i = 0;
            for (String key : objectKeys) {
                String value = String.valueOf(ObjectUtils.get(obj, key));
                if (i++ > 0) {
                    appendable.append(',');
                }
                CSV.writeValue(appendable, value);
            }
            appendable.append('\n');
        }
    }

    private static void getColumnNames(Object obj, List<String> csvColumnNames, List<String> objectKeys) {
        Class<?> aClass = obj.getClass();
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(aClass);
        if (classCategory == ReflectConsts.ClassCategory.MapCategory) {
            Map map = (Map)obj;
            Set keySet = map.keySet();
            for (Object key : keySet) {
                csvColumnNames.add(String.valueOf(key));
            }
            objectKeys.addAll(csvColumnNames);
        } else if (classCategory == ReflectConsts.ClassCategory.ObjectCategory) {
            ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(aClass);
            List<GetterInfo> getterInfos = classStructureWrapper.getGetterInfos(classStructureWrapper.isForceUseFields());
            for (GetterInfo getterInfo : getterInfos) {
                String name;
                CSVColumn csvColumn = (CSVColumn)getterInfo.getAnnotation(CSVColumn.class);
                if (csvColumn != null && (name = csvColumn.value().trim()).length() > 0) {
                    csvColumnNames.add(name);
                } else {
                    csvColumnNames.add(getterInfo.getName());
                }
                objectKeys.add(getterInfo.getName());
            }
        }
    }

    static void writeRow(Appendable appendable, List<String> values) throws IOException {
        int i = 0;
        for (String value : values) {
            if (i++ > 0) {
                appendable.append(',');
            }
            CSV.writeValue(appendable, value);
        }
        appendable.append('\n');
    }

    static void writeValue(Appendable appendable, String value) throws IOException {
        char[] buf = UnsafeHelper.getChars(value);
        char ch = '\u0000';
        int j = 0;
        int len = buf.length;
        int begin = 0;
        boolean escape = false;
        while (true) {
            if (j < len && (ch = buf[j]) != ',' && ch != '\"') {
                ++j;
                continue;
            }
            if (j == len) {
                appendable.append(value, begin, j);
                if (!escape) break;
                appendable.append('\"');
                break;
            }
            ++j;
            escape = true;
            if (begin == 0) {
                appendable.append('\"');
                appendable.append(value, 0, j);
            } else {
                appendable.append(value, begin, j - begin);
            }
            if (ch == '\"') {
                appendable.append('\"');
            }
            begin = j;
        }
    }
}

