/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.functions;

import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.expression.ExpressionException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public final class BuiltInFunction {
    public static Object max(Object ... params) {
        int length = params.length;
        if (length == 0) {
            return 0;
        }
        Object max = null;
        for (int i = 0; i < length; ++i) {
            Object value = params[i];
            max = max == null ? value : (BuiltInFunction.compareTo(max, value) > 0 ? max : value);
        }
        return max;
    }

    public static Object min(Object ... params) {
        int length = params.length;
        if (length == 0) {
            return 0;
        }
        Object min = null;
        for (int i = 0; i < length; ++i) {
            Object value = params[i];
            min = min == null ? value : (BuiltInFunction.compareTo(min, value) < 0 ? min : value);
        }
        return min;
    }

    private static int compareTo(Object o1, Object o2) {
        if (o1.getClass() == o2.getClass()) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return c1.compareTo(c2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            double d2;
            double d1 = ((Number)o1).doubleValue();
            return d1 > (d2 = ((Number)o2).doubleValue()) ? 1 : -1;
        }
        return o1.toString().compareTo(o2.toString());
    }

    public static Number avg(Number ... numbers) {
        int length = numbers.length;
        if (length == 0) {
            return 0;
        }
        return BuiltInFunction.sum(numbers).doubleValue() / (double)length;
    }

    public static Number sum(Number ... numbers) {
        int length = numbers.length;
        if (length == 0) {
            return 0;
        }
        Double total = 0.0;
        boolean useDouble = false;
        boolean useLong = false;
        for (Number number : numbers) {
            if (number instanceof Double || number instanceof Float) {
                useDouble = true;
            } else if (number instanceof Long) {
                useLong = true;
            }
            total = total + number.doubleValue();
        }
        if (useDouble) {
            return total;
        }
        if (useLong) {
            return total.longValue();
        }
        return total.intValue();
    }

    public static Number abs(Number number) {
        return Math.abs(number.doubleValue());
    }

    public static Number sqrt(Number number) {
        return Math.sqrt(number.doubleValue());
    }

    public static int length(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public static String lower(String str) {
        return str.toLowerCase();
    }

    public static String upper(String str) {
        return str.toUpperCase();
    }

    public static int size(Object object) {
        if (object == null) {
            return 0;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object instanceof String) {
            return ((String)object).length();
        }
        throw new ExpressionException("Unsupported call size() by type: " + object.getClass());
    }

    public static Object ifNull(Object left, Object right) {
        return left == null ? right : left;
    }

    public static Date now() {
        return new Date();
    }

    public static String date(long offset) {
        return BuiltInFunction.date_format(offset, "Y-M-d H:m:s");
    }

    public static String date_format(long offset, String template) {
        long current = System.currentTimeMillis();
        return new GregorianDate(current + offset * 1000L).format(template);
    }
}

