/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ReflectConsts {
    private static final Map<Class, ClassCategory> classClassCategoryMap = new ConcurrentHashMap<Class, ClassCategory>();

    private static void putAllType(ClassCategory classCategory, Class<?> ... classList) {
        for (Class<?> cls : classList) {
            classClassCategoryMap.put(cls, classCategory);
        }
    }

    private static synchronized void putType(Class<?> cls, ClassCategory classCategory) {
        if (classClassCategoryMap.size() >= 4096) {
            return;
        }
        classClassCategoryMap.put(cls, classCategory);
    }

    public static ClassCategory getClassCategory(Class cls) {
        if (cls == null) {
            return ClassCategory.ANY;
        }
        ClassCategory classCategory = classClassCategoryMap.get(cls);
        if (classCategory != null) {
            return classCategory;
        }
        if (CharSequence.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.CharSequence;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Number.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.NumberCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (java.util.Date.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.DateCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (cls.isEnum()) {
            classCategory = ClassCategory.EnumCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.CollectionCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Map.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.MapCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (cls.isArray()) {
            classCategory = ClassCategory.ArrayCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Class.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.ClassCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Annotation.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.AnnotationCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) {
            classCategory = ClassCategory.NonInstance;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        classCategory = ClassCategory.ObjectCategory;
        ReflectConsts.putType(cls, classCategory);
        return classCategory;
    }

    static int arrayBaseOffset(Class arrayCls) {
        return UnsafeHelper.arrayBaseOffset(arrayCls);
    }

    static int arrayIndexScale(Class arrayCls) {
        return UnsafeHelper.arrayIndexScale(arrayCls);
    }

    static {
        ReflectConsts.putAllType(ClassCategory.Binary, byte[].class);
        ReflectConsts.putAllType(ClassCategory.CollectionCategory, ArrayList.class, HashSet.class);
        ReflectConsts.putAllType(ClassCategory.MapCategory, HashMap.class, LinkedHashMap.class);
        ReflectConsts.putAllType(ClassCategory.CharSequence, String.class, char[].class, StringBuilder.class, StringBuffer.class, Character.TYPE, Character.class);
        ReflectConsts.putAllType(ClassCategory.NumberCategory, BigDecimal.class, BigInteger.class, Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Float.TYPE, Float.class, Long.TYPE, Long.class, Double.TYPE, Double.class);
        ReflectConsts.putAllType(ClassCategory.BoolCategory, Boolean.TYPE, Boolean.class);
        ReflectConsts.putAllType(ClassCategory.DateCategory, java.util.Date.class, Timestamp.class, Date.class);
        ReflectConsts.putAllType(ClassCategory.ANY, Object.class);
    }

    public static enum PrimitiveType {
        PrimitiveByte(byte[].class, ReflectConsts.arrayBaseOffset(byte[].class), ReflectConsts.arrayIndexScale(byte[].class)){

            @Override
            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putByte(target, fieldOffset, (Byte)value);
            }

            @Override
            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getByte(target, fieldOffset);
            }

            @Override
            public int arrayLength(Object objects) {
                return ((byte[])objects).length;
            }

            @Override
            public Byte elementAt(Object objects, int index) {
                return ((byte[])objects)[index];
            }
        }
        ,
        PrimitiveShort(short[].class, ReflectConsts.arrayBaseOffset(short[].class), ReflectConsts.arrayIndexScale(short[].class)){

            @Override
            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putShort(target, fieldOffset, (Short)value);
            }

            @Override
            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getShort(target, fieldOffset);
            }

            @Override
            public int arrayLength(Object objects) {
                return ((short[])objects).length;
            }

            @Override
            public Short elementAt(Object objects, int index) {
                return ((short[])objects)[index];
            }
        }
        ,
        PrimitiveInt(int[].class, ReflectConsts.arrayBaseOffset(int[].class), ReflectConsts.arrayIndexScale(int[].class)){

            @Override
            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putInt(target, fieldOffset, ((Number)value).intValue());
            }

            @Override
            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getInt(target, fieldOffset);
            }

            @Override
            public int arrayLength(Object objects) {
                return ((int[])objects).length;
            }

            @Override
            public Integer elementAt(Object objects, int index) {
                return ((int[])objects)[index];
            }
        }
        ,
        PrimitiveFloat(float[].class, ReflectConsts.arrayBaseOffset(float[].class), ReflectConsts.arrayIndexScale(float[].class)){

            @Override
            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putFloat(target, fieldOffset, ((Number)value).floatValue());
            }

            @Override
            Object getValue(Object target, long fieldOffset) {
                return Float.valueOf(UnsafeHelper.getUnsafe().getFloat(target, fieldOffset));
            }

            @Override
            public int arrayLength(Object objects) {
                return ((float[])objects).length;
            }

            @Override
            public Float elementAt(Object objects, int index) {
                return Float.valueOf(((float[])objects)[index]);
            }
        }
        ,
        PrimitiveLong(long[].class, ReflectConsts.arrayBaseOffset(long[].class), ReflectConsts.arrayIndexScale(long[].class)){

            @Override
            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putLong(target, fieldOffset, ((Number)value).longValue());
            }

            @Override
            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getLong(target, fieldOffset);
            }

            @Override
            public int arrayLength(Object objects) {
                return ((long[])objects).length;
            }

            @Override
            public Long elementAt(Object objects, int index) {
                return ((long[])objects)[index];
            }
        }
        ,
        PrimitiveDouble(double[].class, ReflectConsts.arrayBaseOffset(double[].class), ReflectConsts.arrayIndexScale(double[].class)){

            @Override
            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putDouble(target, fieldOffset, ((Number)value).doubleValue());
            }

            @Override
            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getDouble(target, fieldOffset);
            }

            @Override
            public int arrayLength(Object objects) {
                return ((double[])objects).length;
            }

            @Override
            public Double elementAt(Object objects, int index) {
                return ((double[])objects)[index];
            }
        }
        ,
        PrimitiveBoolean(boolean[].class, ReflectConsts.arrayBaseOffset(boolean[].class), ReflectConsts.arrayIndexScale(boolean[].class)){

            @Override
            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putBoolean(target, fieldOffset, (Boolean)value);
            }

            @Override
            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getBoolean(target, fieldOffset);
            }

            @Override
            public int arrayLength(Object objects) {
                return ((boolean[])objects).length;
            }

            @Override
            public Boolean elementAt(Object objects, int index) {
                return ((boolean[])objects)[index];
            }
        }
        ,
        PrimitiveCharacter(char[].class, ReflectConsts.arrayBaseOffset(char[].class), ReflectConsts.arrayIndexScale(char[].class)){

            @Override
            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putChar(target, fieldOffset, ((Character)value).charValue());
            }

            @Override
            Object getValue(Object target, long fieldOffset) {
                return Character.valueOf(UnsafeHelper.getUnsafe().getChar(target, fieldOffset));
            }

            @Override
            public int arrayLength(Object objects) {
                return ((char[])objects).length;
            }

            @Override
            public Character elementAt(Object objects, int index) {
                return Character.valueOf(((char[])objects)[index]);
            }
        };

        final Class genericArrayType;
        final int arrayBaseOffset;
        final int arrayIndexScale;
        static final int DoubleNameHash = -1325958191;
        static final int IntNameHash = 104431;
        static final int ByteNameHash = 3039496;
        static final int CharNameHash = 3052374;
        static final int LongNameHash = 3327612;
        static final int BooleanNameHash = 64711720;
        static final int FloatNameHash = 97526364;
        static final int ShortNameHash = 109413500;

        private PrimitiveType(Class genericArrayType, int arrayBaseOffset, int arrayIndexScale) {
            this.genericArrayType = genericArrayType;
            this.arrayBaseOffset = arrayBaseOffset;
            this.arrayIndexScale = arrayIndexScale;
        }

        public int arrayLength(Object objects) {
            return 0;
        }

        public Object elementAt(Object objects, int index) {
            return null;
        }

        void put(Object target, long fieldOffset, Object value) {
            target.getClass();
            if (value == null) {
                return;
            }
            this.putValue(target, fieldOffset, value);
        }

        Object get(Object target, long fieldOffset) {
            target.getClass();
            return this.getValue(target, fieldOffset);
        }

        abstract Object getValue(Object var1, long var2);

        abstract void putValue(Object var1, long var2, Object var4);

        public static PrimitiveType typeOf(Class<?> fieldType) {
            if (!fieldType.isPrimitive()) {
                return null;
            }
            int hash = fieldType.getName().hashCode();
            switch (hash) {
                case -1325958191: {
                    return PrimitiveDouble;
                }
                case 104431: {
                    return PrimitiveInt;
                }
                case 3039496: {
                    return PrimitiveByte;
                }
                case 3052374: {
                    return PrimitiveCharacter;
                }
                case 3327612: {
                    return PrimitiveLong;
                }
                case 64711720: {
                    return PrimitiveBoolean;
                }
                case 97526364: {
                    return PrimitiveFloat;
                }
                case 109413500: {
                    return PrimitiveShort;
                }
            }
            return null;
        }

        public Class getGenericArrayType() {
            return this.genericArrayType;
        }
    }

    public static enum ClassCategory {
        CharSequence,
        NumberCategory,
        BoolCategory,
        DateCategory,
        ClassCategory,
        EnumCategory,
        AnnotationCategory,
        Binary,
        ArrayCategory,
        CollectionCategory,
        MapCategory,
        ObjectCategory,
        ANY,
        NonInstance;

    }
}

