/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.ReflectConsts;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import sun.misc.Unsafe;

public final class UnsafeHelper {
    public static final Unsafe UNSAFE;
    public static final long STRING_VALUE_OFFSET;
    public static final long STRING_CODER_OFFSET;
    public static final long DEFAULT_TIME_ZONE_OFFSET;
    public static final long BIGINTEGER_MAG_OFFSET;
    public static final long ARRAYLIST_ELEMENT_DATA_OFFSET;
    public static final long OVERRIDE_OFFSET;
    public static final long CHAR_ARRAY_OFFSET;
    public static final long BYTE_ARRAY_OFFSET;
    public static final long BAO_BUF_OFFSET;
    public static final long BAO_COUNT_OFFSET;

    public static Object getStaticFieldValue(String targetClass, String fieldName) {
        try {
            Class<?> target = Class.forName(targetClass);
            Field field = target.getDeclaredField(fieldName);
            long offset = UNSAFE.staticFieldOffset(field);
            return UNSAFE.getObject(target, offset);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static char[] getChars(String string) {
        if (STRING_CODER_OFFSET > -1L) {
            return string.toCharArray();
        }
        string.getClass();
        return (char[])UnsafeHelper.getObjectValue(string, STRING_VALUE_OFFSET);
    }

    public static long getStringCoderOffset() {
        return STRING_CODER_OFFSET;
    }

    public static long getDeclaredFieldOffset(Class<?> targetClass, String fieldName) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            return UnsafeHelper.objectFieldOffset(field);
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public static Object getStringValue(String source) {
        source.getClass();
        return UnsafeHelper.getObjectValue(source, STRING_VALUE_OFFSET);
    }

    public static byte getStringCoder(String source) {
        source.getClass();
        if (STRING_CODER_OFFSET > -1L) {
            return UNSAFE.getByte(source, STRING_CODER_OFFSET);
        }
        throw new UnsupportedOperationException();
    }

    public static String getString(char[] buf) {
        if (STRING_CODER_OFFSET == -1L) {
            buf.getClass();
            String result = new String();
            UnsafeHelper.putObjectValue(result, STRING_VALUE_OFFSET, buf);
            return result;
        }
        return new String(buf);
    }

    public static String getAsciiString(byte[] bytes) {
        if (STRING_CODER_OFFSET > -1L) {
            String result = null;
            try {
                result = (String)UNSAFE.allocateInstance(String.class);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            UnsafeHelper.putObjectValue(result, STRING_VALUE_OFFSET, bytes);
            return result;
        }
        return new String(bytes);
    }

    public static String getUTF16String(byte[] utf16Bytes) {
        if (STRING_CODER_OFFSET > -1L) {
            utf16Bytes.getClass();
            String result = null;
            try {
                result = (String)UNSAFE.allocateInstance(String.class);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            UNSAFE.putObject(result, STRING_VALUE_OFFSET, utf16Bytes);
            UNSAFE.putByte(result, STRING_CODER_OFFSET, (byte)1);
            return result;
        }
        throw new UnsupportedOperationException();
    }

    public static int[] getMag(BigInteger value) {
        if (BIGINTEGER_MAG_OFFSET > -1L) {
            return (int[])UNSAFE.getObject(value, BIGINTEGER_MAG_OFFSET);
        }
        throw new UnsupportedOperationException();
    }

    public static Object[] getArrayListData(ArrayList value) {
        if (ARRAYLIST_ELEMENT_DATA_OFFSET > -1L) {
            return (Object[])UNSAFE.getObject(value, ARRAYLIST_ELEMENT_DATA_OFFSET);
        }
        return value.toArray();
    }

    public static void copyMemory(char[] chars, int cOff, byte[] bytes, int bOff, int cLen) {
        int arrayBaseOffset = ReflectConsts.PrimitiveType.PrimitiveCharacter.arrayBaseOffset;
        int arrayIndexScale = ReflectConsts.PrimitiveType.PrimitiveCharacter.arrayIndexScale;
        int targetArrayBaseOffset = ReflectConsts.PrimitiveType.PrimitiveByte.arrayBaseOffset;
        int targetIndexScale = ReflectConsts.PrimitiveType.PrimitiveByte.arrayIndexScale;
        UNSAFE.copyMemory(chars, arrayBaseOffset + arrayIndexScale * cOff, bytes, targetArrayBaseOffset + targetIndexScale * bOff, cLen * arrayIndexScale);
    }

    public static void copyMemory(byte[] bytes, int bOff, char[] chars, int cOff, int bLen) {
        int arrayBaseOffset = ReflectConsts.PrimitiveType.PrimitiveByte.arrayBaseOffset;
        int arrayIndexScale = ReflectConsts.PrimitiveType.PrimitiveByte.arrayIndexScale;
        int targetArrayBaseOffset = ReflectConsts.PrimitiveType.PrimitiveCharacter.arrayBaseOffset;
        int targetIndexScale = ReflectConsts.PrimitiveType.PrimitiveCharacter.arrayIndexScale;
        UNSAFE.copyMemory(bytes, arrayBaseOffset + arrayIndexScale * bOff, chars, targetArrayBaseOffset + targetIndexScale * cOff, bLen * arrayIndexScale);
    }

    public static Object toArray(Collection collection, Class<?> componentType) {
        collection.getClass();
        componentType.getClass();
        Object array = Array.newInstance(componentType, collection.size());
        int k = 0;
        if (UNSAFE != null) {
            ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
            if (primitiveType != null) {
                int base = primitiveType.arrayBaseOffset;
                int scale = primitiveType.arrayIndexScale;
                for (Object obj : collection) {
                    long valueOffset = base + scale * k++;
                    primitiveType.put(array, valueOffset, obj);
                }
            } else {
                Object[] objects = (Object[])array;
                for (Object obj : collection) {
                    objects[k++] = obj;
                }
            }
        } else {
            for (Object obj : collection) {
                Array.set(array, k++, obj);
            }
        }
        return array;
    }

    public static Object arrayValueAt(Object arr, int index) {
        if (UNSAFE != null) {
            if (index == -1) {
                throw new ArrayIndexOutOfBoundsException(-1);
            }
            Class<?> arrCls = arr.getClass();
            if (!arrCls.isArray()) {
                throw new UnsupportedOperationException("Non array object do not support get value by index");
            }
            Class<?> componentType = arrCls.getComponentType();
            ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
            if (primitiveType != null) {
                int base = primitiveType.arrayBaseOffset;
                int scale = primitiveType.arrayIndexScale;
                long valueOffset = base + scale * index;
                return primitiveType.get(arr, valueOffset);
            }
            Object[] objects = (Object[])arr;
            return objects[index];
        }
        return Array.get(arr, index);
    }

    public static TimeZone getDefaultTimeZone() {
        if (DEFAULT_TIME_ZONE_OFFSET > -1L) {
            try {
                TimeZone timeZone = (TimeZone)UNSAFE.getObject(TimeZone.class, DEFAULT_TIME_ZONE_OFFSET);
                if (timeZone != null) {
                    return timeZone;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return TimeZone.getDefault();
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static long getLong(char[] buf, int offset) {
        return UNSAFE.getLong(buf, CHAR_ARRAY_OFFSET + (long)(offset << 1));
    }

    public static int putLong(char[] buf, int offset, long value) {
        buf.getClass();
        long off = CHAR_ARRAY_OFFSET + (long)(offset << 1);
        UNSAFE.putLong(buf, off, value);
        return 4;
    }

    public static int putLong(byte[] buf, int offset, long value) {
        buf.getClass();
        long off = BYTE_ARRAY_OFFSET + (long)offset;
        UNSAFE.putLong(buf, off, value);
        return 8;
    }

    public static int putInt(char[] buf, int offset, int value) {
        buf.getClass();
        long off = CHAR_ARRAY_OFFSET + (long)(offset << 1);
        UNSAFE.putInt(buf, off, value);
        return 2;
    }

    public static int getInt(byte[] buf, int offset) {
        return UNSAFE.getInt(buf, BYTE_ARRAY_OFFSET + (long)offset);
    }

    public static int putInt(byte[] buf, int offset, int value) {
        buf.getClass();
        long off = BYTE_ARRAY_OFFSET + (long)offset;
        UNSAFE.putInt(buf, off, value);
        return 4;
    }

    public static int putShort(byte[] buf, int offset, short value) {
        buf.getClass();
        long off = BYTE_ARRAY_OFFSET + (long)offset;
        UNSAFE.putShort(buf, off, value);
        return 2;
    }

    public static long[] getLongs(String value) {
        char[] chars = UnsafeHelper.getChars(value);
        int strLength = chars.length;
        int l = strLength >> 2;
        int rem = strLength & 3;
        if (rem > 0) {
            ++l;
        }
        char[] buf = new char[l << 2];
        value.getChars(0, strLength, buf, 0);
        long[] results = new long[l];
        int offset = 0;
        for (int i = 0; i < l; ++i) {
            results[i] = UnsafeHelper.getLong(buf, offset);
            offset += 4;
        }
        return results;
    }

    public static int[] getInts(String value) {
        byte[] bytes = value.getBytes();
        int byteLen = bytes.length;
        int l = byteLen >> 2;
        int rem = byteLen & 3;
        if (rem > 0) {
            ++l;
        }
        byte[] buf = new byte[l << 2];
        System.arraycopy(bytes, 0, buf, 0, byteLen);
        int[] results = new int[l];
        int offset = 0;
        for (int i = 0; i < l; ++i) {
            results[i] = UnsafeHelper.getInt(buf, offset);
            offset += 4;
        }
        return results;
    }

    public static void writeLongsToChars(long[] longs, char[] chars, int offset) {
        for (long l : longs) {
            UnsafeHelper.putLong(chars, offset, l);
            offset += 4;
        }
    }

    public static void writeIntsToBytes(int[] ints, byte[] bytes, int offset) {
        for (int val : ints) {
            UnsafeHelper.putInt(bytes, offset, val);
            offset += 4;
        }
    }

    static long objectFieldOffset(Field field) {
        if (UNSAFE != null) {
            return UNSAFE.objectFieldOffset(field);
        }
        return -1L;
    }

    static void putObjectValue(Object target, long fieldOffset, Object value) {
        target.getClass();
        UNSAFE.putObject(target, fieldOffset, value);
    }

    static Object getObjectValue(Object target, long fieldOffset) {
        target.getClass();
        return UNSAFE.getObject(target, fieldOffset);
    }

    public static boolean setAccessible(AccessibleObject accessibleObject) {
        if (OVERRIDE_OFFSET > -1L) {
            UNSAFE.putBoolean(accessibleObject, OVERRIDE_OFFSET, true);
            return true;
        }
        return false;
    }

    public static void setAccessibleList(AccessibleObject ... accessibleList) {
        for (AccessibleObject accessibleObject : accessibleList) {
            UnsafeHelper.setAccessible(accessibleObject);
        }
    }

    static int arrayBaseOffset(Class arrayCls) {
        if (UNSAFE != null) {
            return UNSAFE.arrayBaseOffset(arrayCls);
        }
        return -1;
    }

    static int arrayIndexScale(Class arrayCls) {
        if (UNSAFE != null) {
            return UNSAFE.arrayIndexScale(arrayCls);
        }
        return -1;
    }

    static {
        Field magField2;
        Field theUnsafeField = null;
        try {
            theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
        }
        catch (NoSuchFieldException exception) {
            theUnsafeField = null;
        }
        Unsafe instance = null;
        if (theUnsafeField != null) {
            try {
                instance = (Unsafe)theUnsafeField.get(null);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        UNSAFE = instance;
        CHAR_ARRAY_OFFSET = UnsafeHelper.arrayBaseOffset(char[].class);
        BYTE_ARRAY_OFFSET = UnsafeHelper.arrayBaseOffset(byte[].class);
        BAO_BUF_OFFSET = UnsafeHelper.getDeclaredFieldOffset(ByteArrayOutputStream.class, "buf");
        BAO_COUNT_OFFSET = UnsafeHelper.getDeclaredFieldOffset(ByteArrayOutputStream.class, "count");
        long valueOffset = -1L;
        long coderOffset = -1L;
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueOffset = UnsafeHelper.objectFieldOffset(valueField);
            Object emptyValue = UnsafeHelper.getObjectValue("", valueOffset);
            if (!char[].class.isInstance(emptyValue)) {
                Field coderField = String.class.getDeclaredField("coder");
                coderOffset = UnsafeHelper.objectFieldOffset(coderField);
            }
        }
        catch (Exception emptyValue) {
            // empty catch block
        }
        STRING_VALUE_OFFSET = valueOffset;
        STRING_CODER_OFFSET = coderOffset;
        long defaultTimeZoneOff = -1L;
        try {
            Field timeZoneField = TimeZone.class.getDeclaredField("defaultTimeZone");
            defaultTimeZoneOff = UNSAFE.staticFieldOffset(timeZoneField);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEFAULT_TIME_ZONE_OFFSET = defaultTimeZoneOff;
        long magOffset = -1L;
        try {
            magField2 = BigInteger.class.getDeclaredField("mag");
            magOffset = UnsafeHelper.objectFieldOffset(magField2);
        }
        catch (Exception magField2) {
            // empty catch block
        }
        BIGINTEGER_MAG_OFFSET = magOffset;
        long elementDataOffset = -1L;
        try {
            magField2 = ArrayList.class.getDeclaredField("elementData");
            elementDataOffset = UnsafeHelper.objectFieldOffset(magField2);
        }
        catch (Exception magField3) {
            // empty catch block
        }
        ARRAYLIST_ELEMENT_DATA_OFFSET = elementDataOffset;
        long overrideOffset = 12L;
        try {
            Field overrideField = AccessibleObject.class.getDeclaredField("override");
            overrideOffset = UnsafeHelper.objectFieldOffset(overrideField);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        OVERRIDE_OFFSET = overrideOffset;
    }
}

