/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public final class EnvUtils {
    public static final float JDK_VERSION;
    public static final boolean JDK_16_PLUS;
    public static final boolean JDK_9_PLUS;
    public static final boolean BIG_ENDIAN;
    public static final int HI_BYTE_SHIFT;
    public static final int LO_BYTE_SHIFT;
    public static final int STRING_HV = 1195259493;
    public static final int INT_HV = 104431;
    public static final int INTEGER_HV = -2056817302;
    public static final int LONG_PRI_HV = 3327612;
    public static final int LONG_HV = 398795216;
    public static final int HASHMAP_HV = -1402722386;
    public static final int LINK_HASHMAP_HV = 1258621781;
    public static final int ARRAY_LIST_HV = -1114099497;
    public static final int HASH_SET_HV = -1402716492;
    public static final Charset CHARSET_DEFAULT;
    public static final Charset CHARSET_ISO_8859_1;
    public static final Charset CHARSET_UTF_8;
    public static final Method SC_HAS_NEGATIVES_METHOD;

    private static Charset forCharsetName(String charsetName) {
        try {
            return Charset.forName(charsetName);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean hasNegatives(byte[] bytes, int offset, int len) {
        try {
            if (SC_HAS_NEGATIVES_METHOD != null) {
                return (Boolean)SC_HAS_NEGATIVES_METHOD.invoke(null, bytes, offset, len);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        CHARSET_DEFAULT = Charset.defaultCharset();
        CHARSET_ISO_8859_1 = EnvUtils.forCharsetName("ISO_8859_1");
        CHARSET_UTF_8 = EnvUtils.forCharsetName("UTF-8");
        float jdkVersion = 1.8f;
        try {
            String version = System.getProperty("java.specification.version");
            if (version != null) {
                jdkVersion = Float.parseFloat(version);
            }
        }
        catch (Throwable version) {
            // empty catch block
        }
        JDK_VERSION = jdkVersion;
        JDK_9_PLUS = JDK_VERSION >= 9.0f;
        boolean bl = JDK_16_PLUS = JDK_VERSION >= 16.0f;
        if (BIG_ENDIAN) {
            HI_BYTE_SHIFT = 8;
            LO_BYTE_SHIFT = 0;
        } else {
            HI_BYTE_SHIFT = 0;
            LO_BYTE_SHIFT = 8;
        }
        Method scHasNegatives = null;
        if (JDK_9_PLUS) {
            try {
                Class<?> scClass = Class.forName("java.lang.StringCoding");
                scHasNegatives = scClass.getMethod("hasNegatives", byte[].class, Integer.TYPE, Integer.TYPE);
                UnsafeHelper.setAccessible(scHasNegatives);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        SC_HAS_NEGATIVES_METHOD = scHasNegatives;
    }
}

