/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public final class NumberUtils {
    static final double[] POSITIVE_DECIMAL_POWER = new double[325];
    static final double[] NEGATIVE_DECIMAL_POWER = new double[325];
    static final char[][] POSITIVE_DECIMAL_POWER_CHARS = new char[325][];
    static final char[][] NEGATIVE_DECIMAL_POWER_CHARS = new char[325][];
    static final long[] LONG_VALUES_FOR_STRING = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L, Long.MAX_VALUE};
    static final BigInteger BI_TO_DECIMAL_BASE = BigInteger.valueOf(1000000000L);
    static final BigInteger BI_MAX_VALUE_FOR_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final long[] FOUR_DIGITS_64_BITS = new long[10000];
    static final int[] FOUR_DIGITS_32_BITS = new int[10000];
    static final int[] TWO_DIGITS_32_BITS = new int[100];
    static final short[] TWO_DIGITS_16_BITS = new short[100];
    static final long[] POW5_LONG_VALUES = new long[27];
    static final long MOD_DOUBLE_EXP = 4095L;
    static final int MOD_FLOAT_EXP = 511;
    static final long MOD_DOUBLE_MANTISSA = 0xFFFFFFFFFFFFFL;
    static final int MOD_FLOAT_MANTISSA = 0x7FFFFF;
    static final double LOG2_10 = 3.321928094887362;

    public static char[] copyDigitOnes() {
        return Arrays.copyOf(DigitOnes, DigitOnes.length);
    }

    public static char[] copyDigitTens() {
        return Arrays.copyOf(DigitTens, DigitTens.length);
    }

    public static double getDecimalPowerValue(int expValue) {
        if (expValue < POSITIVE_DECIMAL_POWER.length) {
            return POSITIVE_DECIMAL_POWER[expValue];
        }
        return Math.pow(10.0, expValue);
    }

    public static double getNegativeDecimalPowerValue(int expValue) {
        int index = -expValue;
        if (index < NEGATIVE_DECIMAL_POWER.length) {
            return NEGATIVE_DECIMAL_POWER[index];
        }
        return Math.pow(10.0, expValue);
    }

    public static int stringSize(long value) {
        int i = 1;
        if (value < 0L) {
            ++i;
            value = -value;
        }
        for (long val : LONG_VALUES_FOR_STRING) {
            if (value < val) {
                return i;
            }
            ++i;
        }
        return 19;
    }

    static int stringSize(long value, int min) {
        for (int i = min; i < LONG_VALUES_FOR_STRING.length; ++i) {
            if (value >= LONG_VALUES_FOR_STRING[i]) continue;
            return i + 1;
        }
        return 19;
    }

    public static int digitDecimal(int ch) {
        switch (ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return ch - 48;
            }
        }
        return -1;
    }

    public static int parseIntWithin5(char[] buf, int fromIndex, int n) throws NumberFormatException {
        switch (n) {
            case 1: {
                return NumberUtils.parseInt1(buf, fromIndex);
            }
            case 2: {
                return NumberUtils.parseInt2(buf, fromIndex);
            }
            case 3: {
                return NumberUtils.parseInt3(buf, fromIndex);
            }
            case 4: {
                return NumberUtils.parseInt4(buf, fromIndex);
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, n) + "\"");
    }

    public static int parseIntWithin5(byte[] bytes, int fromIndex, int n) throws NumberFormatException {
        switch (n) {
            case 1: {
                return NumberUtils.parseInt1(bytes[fromIndex]);
            }
            case 2: {
                return NumberUtils.parseInt2(bytes[fromIndex++], (int)bytes[fromIndex]);
            }
            case 3: {
                return NumberUtils.parseInt3(bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex]);
            }
            case 4: {
                return NumberUtils.parseInt4(bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex]);
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(bytes, fromIndex, n) + "\"");
    }

    public static int parseInt4(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf[fromIndex++], buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static int parseInt4(byte[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf[fromIndex++], buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static int parseInt4(int c1, int c2, int c3, int c4) {
        int v4;
        int v3;
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2)) | (v3 = NumberUtils.digitDecimal(c3)) | (v4 = NumberUtils.digitDecimal(c4))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2, (char)c3, (char)c4}) + "\"");
        }
        return v1 * 1000 + v2 * 100 + v3 * 10 + v4;
    }

    public static int parseInt3(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt3(buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static int parseInt3(int c1, int c2, int c3) throws NumberFormatException {
        int v3;
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2)) | (v3 = NumberUtils.digitDecimal(c3))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2, (char)c3}) + "\"");
        }
        return v1 * 100 + v2 * 10 + v3;
    }

    public static int parseInt2(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf[fromIndex++], (int)buf[fromIndex]);
    }

    public static int parseInt2(byte[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf[fromIndex++], (int)buf[fromIndex]);
    }

    public static int parseInt2(int c1, int c2) throws NumberFormatException {
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2}) + "\"");
        }
        return v1 * 10 + v2;
    }

    public static int parseInt1(char[] buf, int fromIndex) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(buf[fromIndex]);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, 1) + "\"");
        }
        return v1;
    }

    public static int parseInt1(byte[] buf, int fromIndex) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(buf[fromIndex]);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, 1) + "\"");
        }
        return v1;
    }

    public static int parseInt1(int ch) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(ch);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + ch + "\"");
        }
        return v1;
    }

    public static String toHexString16(long value) {
        char[] chars = new char[16];
        for (int i = 15; i > -1; --i) {
            int val = (int)(value & 0xFL);
            chars[i] = HEX_DIGITS[val];
            value >>= 4;
        }
        return new String(chars);
    }

    public static int writeUUIDMostSignificantBits(long mostSigBits, char[] buf, int offset) {
        int val;
        int i;
        int index = offset + 18;
        for (i = 3; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 3; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 7; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        return 18;
    }

    public static int writeUUIDLeastSignificantBits(long leastSigBits, char[] buf, int offset) {
        int val;
        int i;
        buf[offset] = 45;
        int index = offset + 18;
        for (i = 11; i > -1; --i) {
            val = (int)(leastSigBits & 0xFL);
            buf[--index] = HEX_DIGITS[val];
            leastSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 3; i > -1; --i) {
            val = (int)(leastSigBits & 0xFL);
            buf[--index] = HEX_DIGITS[val];
            leastSigBits >>= 4;
        }
        return 18;
    }

    public static int writeUUIDMostSignificantBits(long mostSigBits, byte[] buf, int offset) {
        int val;
        int i;
        int index = offset + 18;
        for (i = 3; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 3; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 7; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        return 18;
    }

    public static int writeUUIDLeastSignificantBits(long leastSigBits, byte[] buf, int offset) {
        int val;
        int i;
        buf[offset] = 45;
        int index = offset + 18;
        for (i = 11; i > -1; --i) {
            val = (int)(leastSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            leastSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 3; i > -1; --i) {
            val = (int)(leastSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            leastSigBits >>= 4;
        }
        return 18;
    }

    public static int writeDouble(double doubleValue, char[] buf, int off) {
        long longVal;
        int rn;
        boolean sign;
        int beginIndex = off;
        if (Double.isNaN(doubleValue) || doubleValue == Double.POSITIVE_INFINITY || doubleValue == Double.NEGATIVE_INFINITY) {
            buf[off++] = 110;
            buf[off++] = 117;
            buf[off++] = 108;
            buf[off++] = 108;
            return off - beginIndex;
        }
        if (doubleValue == 0.0) {
            long bits = Double.doubleToLongBits(doubleValue);
            if (bits == Long.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            buf[off++] = 45;
            doubleValue = -doubleValue;
        }
        if (doubleValue == (double)((long)doubleValue)) {
            return NumberUtils.writeDecimal((long)doubleValue, buf, beginIndex, off);
        }
        long bits = Double.doubleToRawLongBits(doubleValue);
        long exp2Bits = bits >> 52 & 0xFFFL;
        int e2 = (int)exp2Bits - 1023;
        if (exp2Bits == 0L) {
            e2 -= Long.numberOfLeadingZeros(bits) - 12;
        } else {
            int e2mantissa = e2 - 52;
            if (e2mantissa < 0) {
                long val5;
                long mantissa = bits & 0xFFFFFFFFFFFFFL;
                int trailZeros = Long.numberOfTrailingZeros(mantissa = 0x10000000000000L | mantissa);
                int em = -trailZeros - e2mantissa;
                if (em < POW5_LONG_VALUES.length && 1L << trailZeros + 10 > (val5 = POW5_LONG_VALUES[em])) {
                    long longVal2 = (mantissa >> trailZeros) * val5;
                    int e10 = NumberUtils.stringSize((long)doubleValue) - 1;
                    int digitCnt = NumberUtils.stringSize(longVal2, e10 + 1);
                    return NumberUtils.writeDecimal(longVal2, digitCnt, e10, buf, beginIndex, off);
                }
            }
        }
        int stringSize = 16;
        int e10 = (int)((double)e2 / 3.321928094887362 + (e2 > 0 ? 0.5 : -0.5));
        if (e10 >= 0) {
            if (doubleValue > POSITIVE_DECIMAL_POWER[e10 + 1]) {
                ++e10;
            } else if (doubleValue < POSITIVE_DECIMAL_POWER[e10]) {
                --e10;
            }
        } else if (doubleValue > NEGATIVE_DECIMAL_POWER[-e10 - 1]) {
            ++e10;
        } else if (doubleValue < NEGATIVE_DECIMAL_POWER[-e10]) {
            --e10;
        }
        if (e10 > 0) {
            if (doubleValue == POSITIVE_DECIMAL_POWER[e10]) {
                char[] chars = POSITIVE_DECIMAL_POWER_CHARS[e10];
                System.arraycopy(chars, 0, buf, off, chars.length);
                return (off += chars.length) - beginIndex;
            }
        } else if (doubleValue == NEGATIVE_DECIMAL_POWER[-e10]) {
            char[] chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10];
            System.arraycopy(chars, 0, buf, off, chars.length);
            return (off += chars.length) - beginIndex;
        }
        if ((rn = 17 - e10) >= 0) {
            if (rn > 308) {
                double smallVal = NEGATIVE_DECIMAL_POWER[-e10];
                longVal = (long)(doubleValue * 1.0E17 / smallVal);
            } else {
                longVal = (long)(doubleValue * POSITIVE_DECIMAL_POWER[rn]);
            }
        } else {
            longVal = (long)(doubleValue / POSITIVE_DECIMAL_POWER[-rn]);
        }
        int digit = (int)(longVal % 100L);
        longVal = longVal / 100L + (long)(digit >= 50 ? 1 : 0);
        return NumberUtils.writeDecimal(longVal, stringSize, e10, buf, beginIndex, off);
    }

    public static int writeFloat(float floatValue, char[] buf, int off) {
        int rn;
        boolean sign;
        int beginIndex = off;
        if (Float.isNaN(floatValue) || floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) {
            buf[off++] = 110;
            buf[off++] = 117;
            buf[off++] = 108;
            buf[off++] = 108;
            return off - beginIndex;
        }
        if (floatValue == 0.0f) {
            int bits = Float.floatToIntBits(floatValue);
            if (bits == Integer.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        boolean bl = sign = floatValue < 0.0f;
        if (sign) {
            buf[off++] = 45;
            floatValue = -floatValue;
        }
        if (floatValue == (float)((long)floatValue)) {
            return NumberUtils.writeDecimal((long)floatValue, buf, beginIndex, off);
        }
        int bits = Float.floatToRawIntBits(floatValue);
        int exp2Bits = bits >> 23 & 0x1FF;
        int e2 = exp2Bits - 127;
        if (exp2Bits == 0) {
            e2 -= Integer.numberOfLeadingZeros(bits) - 9;
        } else {
            int e2mantissa = e2 - 23;
            if (e2mantissa < 0) {
                long val5;
                int mantissa = bits & 0x7FFFFF;
                int trailZeros = Integer.numberOfTrailingZeros(mantissa = 0x800000 | mantissa);
                int em = -trailZeros - e2mantissa;
                if (em < POW5_LONG_VALUES.length && 1L << trailZeros + 10 > (val5 = POW5_LONG_VALUES[em])) {
                    long longVal = (long)(mantissa >> trailZeros) * val5;
                    int e10 = NumberUtils.stringSize((long)floatValue) - 1;
                    int digitCnt = NumberUtils.stringSize(longVal, e10 + 1);
                    return NumberUtils.writeDecimal(longVal, digitCnt, e10, buf, beginIndex, off);
                }
            }
        }
        int digitCnt = 7;
        int e10 = (int)((double)e2 / 3.321928094887362 + (e2 > 0 ? 0.5 : -0.5));
        if (e10 >= 0) {
            if ((double)floatValue > POSITIVE_DECIMAL_POWER[e10 + 1]) {
                ++e10;
            } else if ((double)floatValue < POSITIVE_DECIMAL_POWER[e10]) {
                --e10;
            }
        } else if ((double)floatValue > NEGATIVE_DECIMAL_POWER[-e10 - 1]) {
            ++e10;
        } else if ((double)floatValue < NEGATIVE_DECIMAL_POWER[-e10]) {
            --e10;
        }
        if (e10 > 0) {
            if ((double)floatValue == POSITIVE_DECIMAL_POWER[e10]) {
                char[] chars = POSITIVE_DECIMAL_POWER_CHARS[e10];
                System.arraycopy(chars, 0, buf, off, chars.length);
                return (off += chars.length) - beginIndex;
            }
        } else if ((double)floatValue == NEGATIVE_DECIMAL_POWER[-e10]) {
            char[] chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10];
            System.arraycopy(chars, 0, buf, off, chars.length);
            return (off += chars.length) - beginIndex;
        }
        long value = (rn = 8 - e10) >= 0 ? (long)((int)((double)floatValue * POSITIVE_DECIMAL_POWER[rn])) : (long)((int)((double)floatValue / POSITIVE_DECIMAL_POWER[-rn]));
        int digit = (int)(value % 100L);
        value = value / 100L + (long)(digit >= 50 ? 1 : 0);
        return NumberUtils.writeDecimal(value, digitCnt, e10, buf, beginIndex, off);
    }

    static int writeDecimal(long val, char[] buf, int beginIndex, int off) {
        if (val < 10000000L) {
            off += NumberUtils.writePositiveLong(val, buf, off);
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        int e = 0;
        while (val % 100L == 0L) {
            e += 2;
            val /= 100L;
        }
        if (val % 10L == 0L) {
            ++e;
            val /= 10L;
        }
        off += NumberUtils.writePositiveLong(val, buf, off);
        buf[off++] = 46;
        buf[off++] = 48;
        if (e > 0) {
            buf[off++] = 69;
            if (e > 9) {
                buf[off++] = DigitTens[e];
            }
            buf[off++] = DigitOnes[e];
        }
        return off - beginIndex;
    }

    private static int writeDecimal(long value, int digitCnt, int e10, char[] buf, int beginIndex, int off) {
        boolean useScientific;
        while (value % 100L == 0L) {
            value /= 100L;
            if ((digitCnt -= 2) != 1) continue;
        }
        if (value % 10L == 0L && value > 0L) {
            --digitCnt;
            value /= 10L;
        }
        boolean bl = useScientific = e10 < -3 || e10 >= 7;
        if (useScientific) {
            if (digitCnt == 1) {
                buf[off++] = (char)(value + 48L);
                buf[off++] = 46;
                buf[off++] = 48;
            } else {
                int pos = digitCnt - 2;
                long tl = LONG_VALUES_FOR_STRING[pos];
                int fd = (int)(value / tl);
                buf[off++] = (char)(fd + 48);
                buf[off++] = 46;
                long pointAfter = value - (long)fd * tl;
                while (--pos > -1 && pointAfter < LONG_VALUES_FOR_STRING[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong(pointAfter, buf, off);
            }
            buf[off++] = 69;
            if (e10 < 0) {
                buf[off++] = 45;
                e10 = -e10;
            }
            if (e10 > 99) {
                int n = e10 / 100;
                buf[off++] = (char)(n + 48);
                buf[off++] = DigitTens[e10 -= n * 100];
                buf[off++] = DigitOnes[e10];
            } else {
                if (e10 > 9) {
                    buf[off++] = DigitTens[e10];
                }
                buf[off++] = DigitOnes[e10];
            }
        } else if (e10 < 0) {
            buf[off++] = 48;
            buf[off++] = 46;
            if (e10 == -2) {
                buf[off++] = 48;
            } else if (e10 == -3) {
                buf[off++] = 48;
                buf[off++] = 48;
            }
            off += NumberUtils.writePositiveLong(value, buf, off);
        } else {
            int decimalPointPos = digitCnt - 1 - e10;
            if (decimalPointPos > 0) {
                int pos = decimalPointPos - 1;
                long tl = LONG_VALUES_FOR_STRING[pos];
                int pointBefore = (int)(value / tl);
                off += NumberUtils.writePositiveLong((long)pointBefore, buf, off);
                buf[off++] = 46;
                long pointAfter = value - (long)pointBefore * tl;
                while (--pos > -1 && pointAfter < LONG_VALUES_FOR_STRING[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong(pointAfter, buf, off);
            } else {
                off += NumberUtils.writePositiveLong(value, buf, off);
                int zeroCnt = -decimalPointPos;
                if (zeroCnt > 0) {
                    for (int i = 0; i < zeroCnt; ++i) {
                        buf[off++] = 48;
                    }
                }
                buf[off++] = 46;
                buf[off++] = 48;
            }
        }
        return off - beginIndex;
    }

    public static int writeDouble(double doubleValue, byte[] buf, int off) {
        long longVal;
        int rn;
        boolean sign;
        int beginIndex = off;
        if (Double.isNaN(doubleValue) || doubleValue == Double.POSITIVE_INFINITY || doubleValue == Double.NEGATIVE_INFINITY) {
            buf[off++] = 110;
            buf[off++] = 117;
            buf[off++] = 108;
            buf[off++] = 108;
            return off - beginIndex;
        }
        if (doubleValue == 0.0) {
            long bits = Double.doubleToLongBits(doubleValue);
            if (bits == Long.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            buf[off++] = 45;
            doubleValue = -doubleValue;
        }
        if (doubleValue == (double)((long)doubleValue)) {
            return NumberUtils.writeDecimal((long)doubleValue, buf, beginIndex, off);
        }
        long bits = Double.doubleToRawLongBits(doubleValue);
        long exp2Bits = bits >> 52 & 0xFFFL;
        int e2 = (int)exp2Bits - 1023;
        if (exp2Bits == 0L) {
            e2 -= Long.numberOfLeadingZeros(bits) - 12;
        } else {
            int e2mantissa = e2 - 52;
            if (e2mantissa < 0) {
                long val5;
                long mantissa = bits & 0xFFFFFFFFFFFFFL;
                int trailZeros = Long.numberOfTrailingZeros(mantissa = 0x10000000000000L | mantissa);
                int em = -trailZeros - e2mantissa;
                if (em < POW5_LONG_VALUES.length && 1L << trailZeros + 10 > (val5 = POW5_LONG_VALUES[em])) {
                    long longVal2 = (mantissa >> trailZeros) * val5;
                    int e10 = NumberUtils.stringSize((long)doubleValue) - 1;
                    int digitCnt = NumberUtils.stringSize(longVal2, e10 + 1);
                    return NumberUtils.writeDecimal(longVal2, digitCnt, e10, buf, beginIndex, off);
                }
            }
        }
        int stringSize = 16;
        int e10 = (int)((double)e2 / 3.321928094887362 + (e2 > 0 ? 0.5 : -0.5));
        if (e10 >= 0) {
            if (doubleValue > POSITIVE_DECIMAL_POWER[e10 + 1]) {
                ++e10;
            } else if (doubleValue < POSITIVE_DECIMAL_POWER[e10]) {
                --e10;
            }
        } else if (doubleValue > NEGATIVE_DECIMAL_POWER[-e10 - 1]) {
            ++e10;
        } else if (doubleValue < NEGATIVE_DECIMAL_POWER[-e10]) {
            --e10;
        }
        if (e10 > 0) {
            if (doubleValue == POSITIVE_DECIMAL_POWER[e10]) {
                char[] chars = POSITIVE_DECIMAL_POWER_CHARS[e10];
                System.arraycopy(chars, 0, buf, off, chars.length);
                return (off += chars.length) - beginIndex;
            }
        } else if (doubleValue == NEGATIVE_DECIMAL_POWER[-e10]) {
            char[] chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10];
            System.arraycopy(chars, 0, buf, off, chars.length);
            return (off += chars.length) - beginIndex;
        }
        if ((rn = 17 - e10) >= 0) {
            if (rn > 308) {
                double smallVal = NEGATIVE_DECIMAL_POWER[-e10];
                longVal = (long)(doubleValue * 1.0E17 / smallVal);
            } else {
                longVal = (long)(doubleValue * POSITIVE_DECIMAL_POWER[rn]);
            }
        } else {
            longVal = (long)(doubleValue / POSITIVE_DECIMAL_POWER[-rn]);
        }
        int digit = (int)(longVal % 100L);
        longVal = longVal / 100L + (long)(digit >= 50 ? 1 : 0);
        return NumberUtils.writeDecimal(longVal, stringSize, e10, buf, beginIndex, off);
    }

    public static int writeFloat(float floatValue, byte[] buf, int off) {
        int rn;
        boolean sign;
        int beginIndex = off;
        if (Float.isNaN(floatValue) || floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) {
            buf[off++] = 110;
            buf[off++] = 117;
            buf[off++] = 108;
            buf[off++] = 108;
            return off - beginIndex;
        }
        if (floatValue == 0.0f) {
            int bits = Float.floatToIntBits(floatValue);
            if (bits == Integer.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        boolean bl = sign = floatValue < 0.0f;
        if (sign) {
            buf[off++] = 45;
            floatValue = -floatValue;
        }
        if (floatValue == (float)((long)floatValue)) {
            return NumberUtils.writeDecimal((long)floatValue, buf, beginIndex, off);
        }
        int bits = Float.floatToRawIntBits(floatValue);
        int exp2Bits = bits >> 23 & 0x1FF;
        int e2 = exp2Bits - 127;
        if (exp2Bits == 0) {
            e2 -= Integer.numberOfLeadingZeros(bits) - 9;
        } else {
            int e2mantissa = e2 - 23;
            if (e2mantissa < 0) {
                long val5;
                int mantissa = bits & 0x7FFFFF;
                int trailZeros = Integer.numberOfTrailingZeros(mantissa = 0x800000 | mantissa);
                int em = -trailZeros - e2mantissa;
                if (em < POW5_LONG_VALUES.length && 1L << trailZeros + 10 > (val5 = POW5_LONG_VALUES[em])) {
                    long longVal = (long)(mantissa >> trailZeros) * val5;
                    int e10 = NumberUtils.stringSize((long)floatValue) - 1;
                    int digitCnt = NumberUtils.stringSize(longVal, e10 + 1);
                    return NumberUtils.writeDecimal(longVal, digitCnt, e10, buf, beginIndex, off);
                }
            }
        }
        int digitCnt = 7;
        int e10 = (int)((double)e2 / 3.321928094887362 + (e2 > 0 ? 0.5 : -0.5));
        if (e10 >= 0) {
            if ((double)floatValue > POSITIVE_DECIMAL_POWER[e10 + 1]) {
                ++e10;
            } else if ((double)floatValue < POSITIVE_DECIMAL_POWER[e10]) {
                --e10;
            }
        } else if ((double)floatValue > NEGATIVE_DECIMAL_POWER[-e10 - 1]) {
            ++e10;
        } else if ((double)floatValue < NEGATIVE_DECIMAL_POWER[-e10]) {
            --e10;
        }
        if (e10 > 0) {
            if ((double)floatValue == POSITIVE_DECIMAL_POWER[e10]) {
                char[] chars = POSITIVE_DECIMAL_POWER_CHARS[e10];
                System.arraycopy(chars, 0, buf, off, chars.length);
                return (off += chars.length) - beginIndex;
            }
        } else if ((double)floatValue == NEGATIVE_DECIMAL_POWER[-e10]) {
            char[] chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10];
            System.arraycopy(chars, 0, buf, off, chars.length);
            return (off += chars.length) - beginIndex;
        }
        long value = (rn = 8 - e10) >= 0 ? (long)((int)((double)floatValue * POSITIVE_DECIMAL_POWER[rn])) : (long)((int)((double)floatValue / POSITIVE_DECIMAL_POWER[-rn]));
        int digit = (int)(value % 100L);
        value = value / 100L + (long)(digit >= 50 ? 1 : 0);
        return NumberUtils.writeDecimal(value, digitCnt, e10, buf, beginIndex, off);
    }

    static int writeDecimal(long val, byte[] buf, int beginIndex, int off) {
        if (val < 10000000L) {
            off += NumberUtils.writePositiveLong(val, buf, off);
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        int e = 0;
        while (val % 100L == 0L) {
            e += 2;
            val /= 100L;
        }
        if (val % 10L == 0L) {
            ++e;
            val /= 10L;
        }
        off += NumberUtils.writePositiveLong(val, buf, off);
        buf[off++] = 46;
        buf[off++] = 48;
        if (e > 0) {
            buf[off++] = 69;
            if (e > 9) {
                buf[off++] = (byte)DigitTens[e];
            }
            buf[off++] = (byte)DigitOnes[e];
        }
        return off - beginIndex;
    }

    private static int writeDecimal(long value, int digitCnt, int e10, byte[] buf, int beginIndex, int off) {
        boolean useScientific;
        while (value % 100L == 0L) {
            value /= 100L;
            if ((digitCnt -= 2) != 1) continue;
        }
        if (value % 10L == 0L && value > 0L) {
            --digitCnt;
            value /= 10L;
        }
        boolean bl = useScientific = e10 < -3 || e10 >= 7;
        if (useScientific) {
            if (digitCnt == 1) {
                buf[off++] = (byte)(value + 48L);
                buf[off++] = 46;
                buf[off++] = 48;
            } else {
                int pos = digitCnt - 2;
                long tl = LONG_VALUES_FOR_STRING[pos];
                int fd = (int)(value / tl);
                buf[off++] = (byte)(fd + 48);
                buf[off++] = 46;
                long pointAfter = value - (long)fd * tl;
                while (--pos > -1 && pointAfter < LONG_VALUES_FOR_STRING[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong(pointAfter, buf, off);
            }
            buf[off++] = 69;
            if (e10 < 0) {
                buf[off++] = 45;
                e10 = -e10;
            }
            if (e10 > 99) {
                int n = e10 / 100;
                buf[off++] = (byte)(n + 48);
                buf[off++] = (byte)DigitTens[e10 -= n * 100];
                buf[off++] = (byte)DigitOnes[e10];
            } else {
                if (e10 > 9) {
                    buf[off++] = (byte)DigitTens[e10];
                }
                buf[off++] = (byte)DigitOnes[e10];
            }
        } else if (e10 < 0) {
            buf[off++] = 48;
            buf[off++] = 46;
            if (e10 == -2) {
                buf[off++] = 48;
            } else if (e10 == -3) {
                buf[off++] = 48;
                buf[off++] = 48;
            }
            off += NumberUtils.writePositiveLong(value, buf, off);
        } else {
            int decimalPointPos = digitCnt - 1 - e10;
            if (decimalPointPos > 0) {
                int pos = decimalPointPos - 1;
                long tl = LONG_VALUES_FOR_STRING[pos];
                int pointBefore = (int)(value / tl);
                off += NumberUtils.writePositiveLong((long)pointBefore, buf, off);
                buf[off++] = 46;
                long pointAfter = value - (long)pointBefore * tl;
                while (--pos > -1 && pointAfter < LONG_VALUES_FOR_STRING[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong(pointAfter, buf, off);
            } else {
                off += NumberUtils.writePositiveLong(value, buf, off);
                int zeroCnt = -decimalPointPos;
                if (zeroCnt > 0) {
                    for (int i = 0; i < zeroCnt; ++i) {
                        buf[off++] = 48;
                    }
                }
                buf[off++] = 46;
                buf[off++] = 48;
            }
        }
        return off - beginIndex;
    }

    public static int writeBigInteger(BigInteger val, char[] chars, int off) {
        int beginIndex = off;
        if (val.signum() == -1) {
            chars[off++] = 45;
            val = val.negate();
        }
        if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
            long value = val.longValue();
            off += NumberUtils.writePositiveLong(value, chars, off);
            return off - beginIndex;
        }
        int bigLength = val.bitLength();
        int[] values = new int[bigLength / 31];
        int len = 0;
        while (true) {
            BigInteger[] bigIntegers = val.divideAndRemainder(BI_TO_DECIMAL_BASE);
            int rem = bigIntegers[1].intValue();
            val = bigIntegers[0];
            if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
                long headNum = val.longValue();
                off += NumberUtils.writePositiveLong(headNum, chars, off);
                int pos = 8;
                while (--pos > -1 && (long)rem < LONG_VALUES_FOR_STRING[pos]) {
                    chars[off++] = 48;
                }
                off += NumberUtils.writePositiveLong((long)rem, chars, off);
                for (int j = len - 1; j > -1; --j) {
                    int value = values[j];
                    pos = 8;
                    while (--pos > -1 && (long)value < LONG_VALUES_FOR_STRING[pos]) {
                        chars[off++] = 48;
                    }
                    off += NumberUtils.writePositiveLong((long)value, chars, off);
                }
                return off - beginIndex;
            }
            values[len++] = rem;
        }
    }

    public static int writeBigInteger(BigInteger val, byte[] buf, int off) {
        int beginIndex = off;
        if (val.signum() == -1) {
            buf[off++] = 45;
            val = val.negate();
        }
        if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
            long value = val.longValue();
            off += NumberUtils.writePositiveLong(value, buf, off);
            return off - beginIndex;
        }
        int bigLength = val.bitLength();
        int[] values = new int[bigLength / 31];
        int len = 0;
        while (true) {
            BigInteger[] bigIntegers = val.divideAndRemainder(BI_TO_DECIMAL_BASE);
            int rem = bigIntegers[1].intValue();
            val = bigIntegers[0];
            if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
                long headNum = val.longValue();
                off += NumberUtils.writePositiveLong(headNum, buf, off);
                int pos = 8;
                while (--pos > -1 && (long)rem < LONG_VALUES_FOR_STRING[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong((long)rem, buf, off);
                for (int j = len - 1; j > -1; --j) {
                    int value = values[j];
                    pos = 8;
                    while (--pos > -1 && (long)value < LONG_VALUES_FOR_STRING[pos]) {
                        buf[off++] = 48;
                    }
                    off += NumberUtils.writePositiveLong((long)value, buf, off);
                }
                return off - beginIndex;
            }
            values[len++] = rem;
        }
    }

    public static void writePositiveLong(long val, Appendable appendable) throws IOException {
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            return;
        }
        long numValue = val;
        val = numValue / 100L;
        int v1 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v2 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v3 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v4 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v5 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v6 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v6]);
            appendable.append(DigitOnes[v6]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v7 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v7]);
            appendable.append(DigitOnes[v7]);
            appendable.append(DigitTens[v6]);
            appendable.append(DigitOnes[v6]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v8 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v8]);
            appendable.append(DigitOnes[v8]);
            appendable.append(DigitTens[v7]);
            appendable.append(DigitOnes[v7]);
            appendable.append(DigitTens[v6]);
            appendable.append(DigitOnes[v6]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v9 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v9]);
            appendable.append(DigitOnes[v9]);
            appendable.append(DigitTens[v8]);
            appendable.append(DigitOnes[v8]);
            appendable.append(DigitTens[v7]);
            appendable.append(DigitOnes[v7]);
            appendable.append(DigitTens[v6]);
            appendable.append(DigitOnes[v6]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
        }
    }

    static int writeThreeDigits(int val, char[] chars, int off) {
        if (val < 10) {
            chars[off] = DigitOnes[val];
            return 1;
        }
        if (val < 100) {
            chars[off++] = DigitTens[val];
            chars[off] = DigitOnes[val];
            return 2;
        }
        int v = val / 100;
        int v1 = val - v * 100;
        chars[off++] = DigitOnes[v];
        chars[off++] = DigitTens[v1];
        chars[off] = DigitOnes[v1];
        return 3;
    }

    static int writeThreeDigits(int val, byte[] buf, int off) {
        if (val < 10) {
            buf[off] = (byte)DigitOnes[val];
            return 1;
        }
        if (val < 100) {
            buf[off++] = (byte)DigitTens[val];
            buf[off] = (byte)DigitOnes[val];
            return 2;
        }
        int v = val / 100;
        int v1 = val - v * 100;
        buf[off++] = (byte)DigitOnes[v];
        buf[off++] = (byte)DigitTens[v1];
        buf[off] = (byte)DigitOnes[v1];
        return 3;
    }

    public static int writeFourDigits(int val, char[] chars, int off) {
        UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[val]);
        return 4;
    }

    public static int writeFourDigits(int val, byte[] buf, int off) {
        UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[val]);
        return 4;
    }

    public static int writeTwoDigits(int val, char[] chars, int off) {
        UnsafeHelper.putInt(chars, off, TWO_DIGITS_32_BITS[val]);
        return 2;
    }

    public static int writeTwoDigits(int val, byte[] buf, int off) {
        UnsafeHelper.putShort(buf, off, TWO_DIGITS_16_BITS[val]);
        return 2;
    }

    public static int writeTwoDigitsAndPreSuffix(int val, char pre, char suff, char[] chars, int off) {
        long longVal = EnvUtils.BIG_ENDIAN ? (long)pre << 48 | (long)TWO_DIGITS_32_BITS[val] << 16 | (long)suff : (long)suff << 48 | (long)TWO_DIGITS_32_BITS[val] << 16 | (long)pre;
        UnsafeHelper.putLong(chars, off, longVal);
        return 4;
    }

    public static int writeTwoDigitsAndPreSuffix(int val, char pre, char suff, byte[] chars, int off) {
        int intVal = EnvUtils.BIG_ENDIAN ? pre << 24 | TWO_DIGITS_16_BITS[val] << 8 | suff : suff << 24 | TWO_DIGITS_16_BITS[val] << 8 | pre;
        UnsafeHelper.putInt(chars, off, intVal);
        return 4;
    }

    public static int writePositiveLong(long val, char[] chars, int off) {
        int beginIndex = off;
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            return off - beginIndex;
        }
        long numValue = val;
        val = numValue / 10000L;
        int v1 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v2 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v3 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v3]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v4 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v4]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v3]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        return off - beginIndex;
    }

    public static int writePositiveLong(long val, byte[] buf, int off) {
        int beginIndex = off;
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            return off - beginIndex;
        }
        long numValue = val;
        val = numValue / 10000L;
        int v1 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v2 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v2]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v3 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v3]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v2]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v4 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v4]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v3]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v2]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
            return off - beginIndex;
        }
        return off - beginIndex;
    }

    public static int hex(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return c - 48;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return c - 97 + 10;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return c - 65 + 10;
            }
        }
        throw new IllegalArgumentException("invalid hex char " + (char)c);
    }

    static {
        int len = POSITIVE_DECIMAL_POWER.length;
        for (int i = 0; i < len; ++i) {
            String positive = "1.0E" + i;
            String negative = "1.0E-" + i;
            NumberUtils.POSITIVE_DECIMAL_POWER[i] = Double.valueOf("1.0E" + i);
            NumberUtils.NEGATIVE_DECIMAL_POWER[i] = Double.valueOf("1.0E-" + i);
            NumberUtils.POSITIVE_DECIMAL_POWER_CHARS[i] = positive.toCharArray();
            NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS[i] = negative.toCharArray();
        }
        NumberUtils.NEGATIVE_DECIMAL_POWER[NumberUtils.NEGATIVE_DECIMAL_POWER.length - 1] = Double.MIN_VALUE;
        NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS[NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS.length - 1] = "4.9E-324".toCharArray();
        long val = 1L;
        for (int i = 0; i < POW5_LONG_VALUES.length; ++i) {
            NumberUtils.POW5_LONG_VALUES[i] = val;
            val *= 5L;
        }
        for (long d1 = 0L; d1 < 10L; ++d1) {
            for (long d2 = 0L; d2 < 10L; ++d2) {
                int intVal32;
                long intVal64;
                if (EnvUtils.BIG_ENDIAN) {
                    intVal64 = d1 + 48L << 16 | d2 + 48L;
                    intVal32 = (int)d1 + 48 << 8 | (int)d2 + 48;
                } else {
                    intVal64 = d2 + 48L << 16 | d1 + 48L;
                    intVal32 = (int)d2 + 48 << 8 | (int)d1 + 48;
                }
                int k = (int)(d1 * 10L + d2);
                NumberUtils.TWO_DIGITS_32_BITS[k] = (int)intVal64;
                NumberUtils.TWO_DIGITS_16_BITS[k] = (short)intVal32;
                for (long d3 = 0L; d3 < 10L; ++d3) {
                    for (long d4 = 0L; d4 < 10L; ++d4) {
                        int int32;
                        long int64;
                        if (EnvUtils.BIG_ENDIAN) {
                            int64 = intVal64 << 32 | d3 + 48L << 16 | d4 + 48L;
                            int32 = intVal32 << 16 | (int)d3 + 48 << 8 | (int)d4 + 48;
                        } else {
                            int64 = d4 + 48L << 48 | d3 + 48L << 32 | intVal64;
                            int32 = (int)d4 + 48 << 24 | (int)d3 + 48 << 16 | intVal32;
                        }
                        int index = (int)(d1 * 1000L + d2 * 100L + d3 * 10L + d4);
                        NumberUtils.FOUR_DIGITS_64_BITS[index] = int64;
                        NumberUtils.FOUR_DIGITS_32_BITS[index] = int32;
                    }
                }
            }
        }
    }
}

